/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.search;

import io.meeds.social.core.profileproperty.storage.CachedProfileSettingStorage;
import io.meeds.social.translation.service.TranslationService;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;
import org.exoplatform.commons.search.domain.Document;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.jpa.search.ProfileIndexingServiceConnector;
import org.exoplatform.social.core.jpa.storage.dao.ConnectionDAO;
import org.exoplatform.social.core.jpa.storage.dao.IdentityDAO;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.IdentityManagerImpl;
import org.exoplatform.social.core.profileproperty.ProfilePropertyService;
import org.exoplatform.social.core.profileproperty.model.ProfilePropertyOption;
import org.exoplatform.social.core.profileproperty.model.ProfilePropertySetting;
import org.exoplatform.social.core.test.AbstractCoreTest;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ProfileIndexingServiceConnectorTest
extends AbstractCoreTest {
    private IdentityManager identityManager;
    private Identity userIdentity;
    @Mock
    private ConnectionDAO connectionDAO;
    @Mock
    private IdentityDAO identityDAO;
    private ProfilePropertyService profilePropertyService;
    private ProfileIndexingServiceConnector profileIndexingServiceConnector;
    private TranslationService translationService;
    private UserACL userACL;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.identityManager = (IdentityManager)this.getService(IdentityManagerImpl.class);
        this.profilePropertyService = this.getService(ProfilePropertyService.class);
        this.translationService = this.getService(TranslationService.class);
        this.userACL = this.getService(UserACL.class);
        this.getService(CachedProfileSettingStorage.class).clearCaches();
        InitParams initParams = new InitParams();
        PropertiesParam params = new PropertiesParam();
        params.setName("constructor.params");
        params.setProperty("index_alias", "profile_alias");
        params.setProperty("index_current", "profile_v2");
        initParams.addParam((Object)params);
        this.userIdentity = this.identityManager.getOrCreateIdentity("organization", "root");
        Profile profile = this.userIdentity.getProfile();
        profile.setProperty("profession", (Object)"Developer");
        this.identityManager.updateProfile(profile, true);
        this.profileIndexingServiceConnector = new ProfileIndexingServiceConnector(initParams, this.identityManager, this.identityDAO, this.connectionDAO, this.profilePropertyService, this.translationService, this.userACL);
    }

    @Test
    public void testUpdate() {
        Document document = this.profileIndexingServiceConnector.update(this.userIdentity.getId());
        ProfileIndexingServiceConnectorTest.assertEquals((String)"Developer", (String)((String)document.getFields().get("profession")));
        this.profilePropertyService.hidePropertySetting(Long.parseLong(this.userIdentity.getId()), this.profilePropertyService.getProfileSettingByName("profession").getId().longValue());
        document = this.profileIndexingServiceConnector.update(this.userIdentity.getId());
        ProfileIndexingServiceConnectorTest.assertEquals((String)"hidden", (String)((String)document.getFields().get("profession")));
    }

    @Test
    public void testIndexDropdownPropertyOptionValue() throws Exception {
        ProfilePropertySetting dropdownListPropertySetting = this.createProfileSettingDropdownInstance("propDropdownTest");
        ProfilePropertySetting dropdownPropertySetting = this.profilePropertyService.createPropertySetting(dropdownListPropertySetting);
        HashMap<Locale, String> labels = new HashMap<Locale, String>();
        labels.put(Locale.US, "option en");
        labels.put(Locale.FRANCE, "option fr");
        this.userIdentity = this.identityManager.getOrCreateIdentity("organization", "root");
        Profile profile = this.userIdentity.getProfile();
        profile.setProperty("propDropdownTest", (Object)((ProfilePropertyOption)dropdownPropertySetting.getPropertyOptions().getFirst()).getId());
        this.identityManager.updateProfile(profile, true);
        Document document = this.profileIndexingServiceConnector.update(this.userIdentity.getId());
        ProfileIndexingServiceConnectorTest.assertEquals((String)"option", (String)((String)document.getFields().get("propDropdownTest")));
        this.translationService.saveTranslationLabels("propertySettingOption", ((ProfilePropertyOption)dropdownPropertySetting.getPropertyOptions().getFirst()).getId().longValue(), "optionValue", labels);
        document = this.profileIndexingServiceConnector.update(this.userIdentity.getId());
        ProfileIndexingServiceConnectorTest.assertEquals((String)"option-option fr-option en", (String)((String)document.getFields().get("propDropdownTest")));
    }

    private ProfilePropertySetting createProfileSettingDropdownInstance(String propertyName) {
        ProfilePropertySetting profilePropertySetting = new ProfilePropertySetting();
        profilePropertySetting.setActive(true);
        profilePropertySetting.setEditable(true);
        profilePropertySetting.setVisible(true);
        profilePropertySetting.setPropertyName(propertyName);
        profilePropertySetting.setGroupSynchronized(false);
        profilePropertySetting.setMultiValued(false);
        profilePropertySetting.setPropertyType("text");
        profilePropertySetting.setParentId(Long.valueOf(0L));
        profilePropertySetting.setOrder(Long.valueOf(0L));
        profilePropertySetting.setDropdownList(true);
        List<ProfilePropertyOption> profilePropertyOptions = Stream.generate(ProfilePropertyOption::new).limit(2L).peek(option -> option.setValue("option")).toList();
        profilePropertySetting.setPropertyOptions(profilePropertyOptions);
        return profilePropertySetting;
    }
}

