/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.binding.spi;

import java.util.Date;
import java.util.List;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.social.core.binding.model.GroupSpaceBinding;
import org.exoplatform.social.core.binding.model.GroupSpaceBindingQueue;
import org.exoplatform.social.core.binding.model.GroupSpaceBindingReportAction;
import org.exoplatform.social.core.binding.model.GroupSpaceBindingReportUser;
import org.exoplatform.social.core.binding.model.UserSpaceBinding;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.jpa.storage.SpaceStorage;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.storage.api.GroupSpaceBindingStorage;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.core.test.AbstractCoreTest;

public class RDBMSGroupSpaceBindingStorageTest
extends AbstractCoreTest {
    private SpaceStorage spaceStorage;
    private IdentityStorage identityStorage;
    private GroupSpaceBindingStorage groupSpaceBindingStorage;
    private Identity demo;
    private Identity mary;
    private Identity jame;
    private Identity root;
    private Identity john;
    private String spaceId;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.spaceStorage = (SpaceStorage)this.getContainer().getComponentInstanceOfType(SpaceStorage.class);
        this.identityStorage = (IdentityStorage)this.getContainer().getComponentInstanceOfType(IdentityStorage.class);
        this.groupSpaceBindingStorage = (GroupSpaceBindingStorage)this.getContainer().getComponentInstanceOfType(GroupSpaceBindingStorage.class);
        this.root = new Identity("organization", "root");
        this.john = new Identity("organization", "john");
        this.demo = new Identity("organization", "demo");
        this.mary = new Identity("organization", "mary");
        this.jame = new Identity("organization", "jame");
        this.identityStorage.saveIdentity(this.root);
        this.identityStorage.saveIdentity(this.john);
        this.identityStorage.saveIdentity(this.demo);
        this.identityStorage.saveIdentity(this.mary);
        this.identityStorage.saveIdentity(this.jame);
        Space space = this.getSpaceInstance(1);
        this.spaceStorage.saveSpace(space, true);
        this.spaceId = this.spaceStorage.getSpaceByPrettyName("myspacetestbinding1").getId();
    }

    @Override
    protected void tearDown() throws Exception {
        this.deleteAllBindings();
        super.tearDown();
    }

    protected void deleteAllBindings() {
        this.groupSpaceBindingStorage.findAllGroupSpaceBindingReportUser().stream().forEach(groupSpaceBindingReportUser -> this.groupSpaceBindingStorage.deleteGroupBindingReportUser(groupSpaceBindingReportUser.getId()));
        this.groupSpaceBindingStorage.findAllGroupSpaceBindingReportAction().stream().forEach(groupSpaceBindingReport -> this.groupSpaceBindingStorage.deleteGroupBindingReport(groupSpaceBindingReport.getId()));
        this.groupSpaceBindingStorage.findAllUserSpaceBinding().stream().forEach(userSpaceBinding -> this.groupSpaceBindingStorage.deleteUserBinding(userSpaceBinding.getId()));
        this.groupSpaceBindingStorage.findAllGroupSpaceBindingQueue().stream().forEach(binding -> this.groupSpaceBindingStorage.deleteGroupBindingQueue(binding.getId()));
        this.groupSpaceBindingStorage.findAllGroupSpaceBinding().stream().forEach(binding -> {
            RequestLifeCycle.restartTransaction();
            this.groupSpaceBindingStorage.deleteGroupBinding(binding.getId());
        });
    }

    private Space getSpaceInstance(int number) {
        Space space = new Space();
        space.setDisplayName("myspacetestbinding" + number);
        space.setPrettyName(space.getDisplayName());
        space.setRegistration("open");
        space.setDescription("add new space " + number);
        space.setVisibility("public");
        space.setGroupId("/spaces/space" + number);
        String[] managers = new String[]{"demo"};
        String[] members = new String[]{"john", "root"};
        String[] invitedUsers = new String[]{"mary"};
        String[] pendingUsers = new String[]{"jame"};
        space.setInvitedUsers(invitedUsers);
        space.setPendingUsers(pendingUsers);
        space.setManagers(managers);
        space.setMembers(members);
        space.setUrl(space.getPrettyName());
        return space;
    }

    private GroupSpaceBinding getGroupSpaceBindingInstance(String spaceId, String group) {
        GroupSpaceBinding groupSpaceBinding = new GroupSpaceBinding();
        groupSpaceBinding.setSpaceId(spaceId);
        groupSpaceBinding.setGroup(group);
        return groupSpaceBinding;
    }

    private GroupSpaceBindingReportAction getGroupSpaceBindingReportActionInstance(long groupSpaceBindingId, String group, String action, long spaceId) {
        GroupSpaceBindingReportAction groupSpaceBindingReportAction = new GroupSpaceBindingReportAction();
        groupSpaceBindingReportAction.setSpaceId(spaceId);
        groupSpaceBindingReportAction.setGroup(group);
        groupSpaceBindingReportAction.setAction(action);
        groupSpaceBindingReportAction.setGroupSpaceBindingId(groupSpaceBindingId);
        return groupSpaceBindingReportAction;
    }

    private GroupSpaceBindingReportUser getGroupSpaceBindingReportUserInstance(String action, GroupSpaceBindingReportAction groupSpaceBindingReportAction, boolean stillInSpace, boolean wasPresentBefore, String username) {
        GroupSpaceBindingReportUser groupSpaceBindingReportUser = new GroupSpaceBindingReportUser();
        groupSpaceBindingReportUser.setAction(action);
        groupSpaceBindingReportUser.setGroupSpaceBindingReportAction(groupSpaceBindingReportAction);
        groupSpaceBindingReportUser.setDate(new Date());
        groupSpaceBindingReportUser.setStillInSpace(stillInSpace);
        groupSpaceBindingReportUser.setWasPresentBefore(wasPresentBefore);
        groupSpaceBindingReportUser.setUsername(username);
        return groupSpaceBindingReportUser;
    }

    private GroupSpaceBindingQueue getGroupSpaceBindingQueueInstance(GroupSpaceBinding groupSpaceBinding, String action) {
        GroupSpaceBindingQueue groupSpaceBindingQueue = new GroupSpaceBindingQueue();
        groupSpaceBindingQueue.setGroupSpaceBinding(groupSpaceBinding);
        groupSpaceBindingQueue.setAction(action);
        return groupSpaceBindingQueue;
    }

    private UserSpaceBinding getUserBindingInstance(String userName, GroupSpaceBinding groupSpaceBinding) {
        UserSpaceBinding userSpaceBinding = new UserSpaceBinding();
        userSpaceBinding.setUser(userName);
        userSpaceBinding.setGroupBinding(groupSpaceBinding);
        return userSpaceBinding;
    }

    public void testFindSpaceBindings() throws Exception {
        int totalBindings = 5;
        for (int i = 1; i <= totalBindings; ++i) {
            GroupSpaceBinding groupSpaceBinding = this.getGroupSpaceBindingInstance(this.spaceId, "/platform/administrators");
            this.groupSpaceBindingStorage.saveGroupSpaceBinding(groupSpaceBinding);
        }
        RDBMSGroupSpaceBindingStorageTest.assertEquals((String)("groupSpaceBindingStorage.findGroupSpaceBindingsBySpace(" + this.spaceId + ",'member') must return: " + totalBindings), (int)totalBindings, (int)this.groupSpaceBindingStorage.findGroupSpaceBindingsBySpace(this.spaceId).size());
    }

    public void testFindUserBindings() throws Exception {
        int totalBindings = 5;
        GroupSpaceBinding groupSpaceBinding = this.getGroupSpaceBindingInstance(this.spaceId, "/platform/administrators");
        groupSpaceBinding = this.groupSpaceBindingStorage.saveGroupSpaceBinding(groupSpaceBinding);
        for (int i = 1; i <= totalBindings; ++i) {
            UserSpaceBinding userSpaceBinding = this.getUserBindingInstance("john" + i, groupSpaceBinding);
            this.groupSpaceBindingStorage.saveUserBinding(userSpaceBinding);
        }
        RDBMSGroupSpaceBindingStorageTest.assertEquals((String)("groupSpaceBindingStorage.findUserSpaceBindingsBySpace(" + this.spaceId + ",'john') must return: 1"), (int)1, (int)this.groupSpaceBindingStorage.findUserSpaceBindingsBySpace(this.spaceId, "john1").size());
    }

    public void testSaveGroupBinding() throws Exception {
        GroupSpaceBinding groupSpaceBinding = this.getGroupSpaceBindingInstance(this.spaceId, "/platform/administrators");
        this.groupSpaceBindingStorage.saveGroupSpaceBinding(groupSpaceBinding);
        RDBMSGroupSpaceBindingStorageTest.assertEquals((String)("groupSpaceBindingStorage.findGroupSpaceBindingsBySpace(" + this.spaceId + ",'member') must return after creation: 1"), (int)1, (int)this.groupSpaceBindingStorage.findGroupSpaceBindingsBySpace(this.spaceId).size());
    }

    public void testSaveGroupBindingQueue() throws Exception {
        GroupSpaceBinding groupSpaceBinding = this.getGroupSpaceBindingInstance(this.spaceId, "/platform/administrators");
        groupSpaceBinding = this.groupSpaceBindingStorage.saveGroupSpaceBinding(groupSpaceBinding);
        GroupSpaceBindingQueue groupSpaceBindingQueue = new GroupSpaceBindingQueue(groupSpaceBinding, GroupSpaceBindingQueue.ACTION_CREATE);
        groupSpaceBindingQueue = this.groupSpaceBindingStorage.createGroupSpaceBindingQueue(groupSpaceBindingQueue);
        RDBMSGroupSpaceBindingStorageTest.assertEquals((String)"groupSpaceBindingStorage.findFirstGroupSpaceBindingQueue() must return after creation: 1", (long)groupSpaceBindingQueue.getId(), (long)this.groupSpaceBindingStorage.findFirstGroupSpaceBindingQueue().getId());
    }

    public void testSaveUserBinding() throws Exception {
        GroupSpaceBinding groupSpaceBinding = this.getGroupSpaceBindingInstance(this.spaceId, "/platform/administrators");
        groupSpaceBinding = this.groupSpaceBindingStorage.saveGroupSpaceBinding(groupSpaceBinding);
        UserSpaceBinding userSpaceBinding = this.getUserBindingInstance("john", groupSpaceBinding);
        userSpaceBinding = this.groupSpaceBindingStorage.saveUserBinding(userSpaceBinding);
        RDBMSGroupSpaceBindingStorageTest.assertEquals((String)("groupSpaceBindingStorage.findUserBindingsbyMember(" + this.spaceId + ",'member') must return after creation: 1"), (int)1, (int)this.groupSpaceBindingStorage.findUserSpaceBindingsBySpace(this.spaceId, "john").size());
        RDBMSGroupSpaceBindingStorageTest.assertEquals((String)("Invalid group binding :" + userSpaceBinding.getGroupBinding().getGroup()), (String)userSpaceBinding.getGroupBinding().getGroup(), (String)"/platform/administrators");
    }

    public void testDeleteGroupBinding() throws Exception {
        GroupSpaceBinding groupSpaceBinding = this.getGroupSpaceBindingInstance(this.spaceId, "/platform/administrators");
        groupSpaceBinding = this.groupSpaceBindingStorage.saveGroupSpaceBinding(groupSpaceBinding);
        this.groupSpaceBindingStorage.deleteGroupBinding(groupSpaceBinding.getId());
        RDBMSGroupSpaceBindingStorageTest.assertEquals((String)("groupSpaceBindingStorage.findGroupSpaceBindingsBySpace(" + groupSpaceBinding.getId() + ") must return after deletion: 0"), (int)0, (int)this.groupSpaceBindingStorage.findGroupSpaceBindingsBySpace(this.spaceId).size());
    }

    public void testDeleteUserBinding() throws Exception {
        GroupSpaceBinding groupSpaceBinding = this.getGroupSpaceBindingInstance(this.spaceId, "/platform/administrators");
        groupSpaceBinding = this.groupSpaceBindingStorage.saveGroupSpaceBinding(groupSpaceBinding);
        UserSpaceBinding userSpaceBinding = this.getUserBindingInstance("john", groupSpaceBinding);
        userSpaceBinding = this.groupSpaceBindingStorage.saveUserBinding(userSpaceBinding);
        this.groupSpaceBindingStorage.deleteUserBinding(userSpaceBinding.getId());
        RDBMSGroupSpaceBindingStorageTest.assertEquals((String)("groupSpaceBindingStorage.findUserBindingsbyMember(" + this.spaceId + ",'john') must return after deletion: 0"), (int)0, (int)this.groupSpaceBindingStorage.findUserSpaceBindingsBySpace(this.spaceId, "john").size());
    }

    public void testDeleteAllUserBindings() throws Exception {
        GroupSpaceBinding groupSpaceBinding = this.getGroupSpaceBindingInstance(this.spaceId, "/platform/administrators");
        groupSpaceBinding = this.groupSpaceBindingStorage.saveGroupSpaceBinding(groupSpaceBinding);
        UserSpaceBinding userSpaceBinding1 = this.getUserBindingInstance("john", groupSpaceBinding);
        this.groupSpaceBindingStorage.saveUserBinding(userSpaceBinding1);
        UserSpaceBinding userSpaceBinding2 = this.getUserBindingInstance("john", groupSpaceBinding);
        this.groupSpaceBindingStorage.saveUserBinding(userSpaceBinding2);
        UserSpaceBinding userSpaceBinding3 = this.getUserBindingInstance("mary", groupSpaceBinding);
        this.groupSpaceBindingStorage.saveUserBinding(userSpaceBinding3);
        this.groupSpaceBindingStorage.deleteAllUserBindings("john");
        RDBMSGroupSpaceBindingStorageTest.assertEquals((String)("groupSpaceBindingStorage.findUserBindingsbyMember(" + this.spaceId + ",'john') must return after deletion: 0"), (int)0, (int)this.groupSpaceBindingStorage.findUserSpaceBindingsBySpace(this.spaceId, "john").size());
        RDBMSGroupSpaceBindingStorageTest.assertEquals((String)("groupSpaceBindingStorage.findUserBindingsbyMember(" + this.spaceId + ",'mary') must return after deletion: 1"), (int)1, (int)this.groupSpaceBindingStorage.findUserSpaceBindingsBySpace(this.spaceId, "mary").size());
    }

    public void testHasUserBindings() throws Exception {
        GroupSpaceBinding groupSpaceBinding = this.getGroupSpaceBindingInstance(this.spaceId, "/platform/administrators");
        groupSpaceBinding = this.groupSpaceBindingStorage.saveGroupSpaceBinding(groupSpaceBinding);
        UserSpaceBinding userSpaceBinding = this.getUserBindingInstance("john", groupSpaceBinding);
        this.groupSpaceBindingStorage.saveUserBinding(userSpaceBinding);
        RDBMSGroupSpaceBindingStorageTest.assertEquals((String)("groupSpaceBindingStorage.findUserSpaceBindingsBySpace(" + this.spaceId + ",'john') must return true "), (boolean)true, (this.groupSpaceBindingStorage.findUserSpaceBindingsBySpace(this.spaceId, "john").size() > 0 ? 1 : 0) != 0);
        RDBMSGroupSpaceBindingStorageTest.assertEquals((String)("groupSpaceBindingStorage.findUserSpaceBindingsBySpace(" + this.spaceId + ",'mary') must return false "), (boolean)false, (this.groupSpaceBindingStorage.findUserSpaceBindingsBySpace(this.spaceId, "mary").size() > 0 ? 1 : 0) != 0);
    }

    public void testCountUserBindings() throws Exception {
        GroupSpaceBinding groupSpaceBinding = this.getGroupSpaceBindingInstance(this.spaceId, "/platform/administrators");
        groupSpaceBinding = this.groupSpaceBindingStorage.saveGroupSpaceBinding(groupSpaceBinding);
        UserSpaceBinding userSpaceBinding = this.getUserBindingInstance("john", groupSpaceBinding);
        this.groupSpaceBindingStorage.saveUserBinding(userSpaceBinding);
        RDBMSGroupSpaceBindingStorageTest.assertEquals((String)("groupSpaceBindingStorage.countUserBindings(" + this.spaceId + ",'john') must return 1 "), (long)1L, (long)this.groupSpaceBindingStorage.countUserBindings(this.spaceId, "john"));
        RDBMSGroupSpaceBindingStorageTest.assertEquals((String)("groupSpaceBindingStorage.countUserBindings(" + this.spaceId + ",'mary') must return 0 "), (long)0L, (long)this.groupSpaceBindingStorage.countUserBindings(this.spaceId, "mary"));
    }

    public void testfindUserAllBindingsbyGroupMembership() throws Exception {
        UserSpaceBinding userSpaceBinding;
        int i;
        int totalBindings = 5;
        GroupSpaceBinding groupSpaceBinding = this.getGroupSpaceBindingInstance(this.spaceId, "/platform/administrators");
        groupSpaceBinding = this.groupSpaceBindingStorage.saveGroupSpaceBinding(groupSpaceBinding);
        GroupSpaceBinding groupSpaceBinding1 = this.getGroupSpaceBindingInstance(this.spaceId, "/platform/users");
        groupSpaceBinding1 = this.groupSpaceBindingStorage.saveGroupSpaceBinding(groupSpaceBinding1);
        for (i = 1; i <= totalBindings; ++i) {
            userSpaceBinding = this.getUserBindingInstance("john" + i, groupSpaceBinding);
            this.groupSpaceBindingStorage.saveUserBinding(userSpaceBinding);
        }
        for (i = 1; i <= totalBindings; ++i) {
            userSpaceBinding = this.getUserBindingInstance("john" + i, groupSpaceBinding1);
            this.groupSpaceBindingStorage.saveUserBinding(userSpaceBinding);
        }
        RDBMSGroupSpaceBindingStorageTest.assertEquals((int)totalBindings, (int)this.groupSpaceBindingStorage.findUserAllBindingsByGroupBinding(groupSpaceBinding).size());
    }

    public void testfindUserSpaceBindingsByGroup() throws Exception {
        int totalBindings = 5;
        GroupSpaceBinding groupSpaceBinding = this.getGroupSpaceBindingInstance(this.spaceId, "/platform/administrators");
        groupSpaceBinding = this.groupSpaceBindingStorage.saveGroupSpaceBinding(groupSpaceBinding);
        GroupSpaceBinding groupSpaceBinding1 = this.getGroupSpaceBindingInstance(this.spaceId, "/platform/users");
        groupSpaceBinding1 = this.groupSpaceBindingStorage.saveGroupSpaceBinding(groupSpaceBinding1);
        for (int i = 1; i <= totalBindings; ++i) {
            UserSpaceBinding userSpaceBinding = this.getUserBindingInstance("john" + i, groupSpaceBinding);
            this.groupSpaceBindingStorage.saveUserBinding(userSpaceBinding);
        }
        RDBMSGroupSpaceBindingStorageTest.assertEquals((String)("findUserAllBindingsbyGroupMembership('/platform/administrators','Any') must return: " + totalBindings), (int)1, (int)this.groupSpaceBindingStorage.findUserSpaceBindingsByGroup("/platform/administrators", "john1").size());
        RDBMSGroupSpaceBindingStorageTest.assertEquals((String)"findUserAllBindingsbyGroupMembership('/platform/administrators','Any') must return: 0", (int)0, (int)this.groupSpaceBindingStorage.findUserSpaceBindingsByGroup("/platform/users", "john1").size());
    }

    public void testCountUserBindingsBySpace() throws Exception {
        GroupSpaceBinding groupSpaceBinding = this.getGroupSpaceBindingInstance(this.spaceId, "/platform/administrators");
        groupSpaceBinding = this.groupSpaceBindingStorage.saveGroupSpaceBinding(groupSpaceBinding);
        GroupSpaceBinding groupSpaceBinding2 = this.getGroupSpaceBindingInstance(this.spaceId, "/platform/developers");
        groupSpaceBinding2 = this.groupSpaceBindingStorage.saveGroupSpaceBinding(groupSpaceBinding2);
        UserSpaceBinding userSpaceBinding = this.getUserBindingInstance("john", groupSpaceBinding);
        this.groupSpaceBindingStorage.saveUserBinding(userSpaceBinding);
        UserSpaceBinding userSpaceBinding2 = this.getUserBindingInstance("mary", groupSpaceBinding);
        this.groupSpaceBindingStorage.saveUserBinding(userSpaceBinding2);
        UserSpaceBinding userSpaceBinding3 = this.getUserBindingInstance("john", groupSpaceBinding2);
        this.groupSpaceBindingStorage.saveUserBinding(userSpaceBinding3);
        RDBMSGroupSpaceBindingStorageTest.assertEquals((String)("groupSpaceBindingStorage.countBoundUsers(" + this.spaceId + ") must return 2 "), (long)2L, (long)this.groupSpaceBindingStorage.countBoundUsers(this.spaceId));
    }

    public void testFindGroupSpaceBindingsByGroup() {
        int totalBindings = 5;
        for (int i = 1; i <= totalBindings; ++i) {
            GroupSpaceBinding groupSpaceBinding = this.getGroupSpaceBindingInstance(this.spaceId, "/platform/administrators");
            this.groupSpaceBindingStorage.saveGroupSpaceBinding(groupSpaceBinding);
        }
        RDBMSGroupSpaceBindingStorageTest.assertEquals((int)totalBindings, (int)this.groupSpaceBindingStorage.findGroupSpaceBindingsByGroup("/platform/administrators").size());
    }

    public void testFindUserSpaceBindingsByUser() {
        UserSpaceBinding userSpaceBinding;
        int i;
        int totalBindings = 5;
        GroupSpaceBinding groupSpaceBinding = this.getGroupSpaceBindingInstance(this.spaceId, "/platform/administrators");
        groupSpaceBinding = this.groupSpaceBindingStorage.saveGroupSpaceBinding(groupSpaceBinding);
        for (i = 1; i <= totalBindings; ++i) {
            userSpaceBinding = this.getUserBindingInstance("john" + i, groupSpaceBinding);
            this.groupSpaceBindingStorage.saveUserBinding(userSpaceBinding);
        }
        for (i = 1; i <= totalBindings; ++i) {
            userSpaceBinding = this.getUserBindingInstance("mary" + i, groupSpaceBinding);
            this.groupSpaceBindingStorage.saveUserBinding(userSpaceBinding);
        }
        RDBMSGroupSpaceBindingStorageTest.assertEquals((int)1, (int)this.groupSpaceBindingStorage.findUserSpaceBindingsByUser("john1").size());
    }

    public void testfindGroupSpaceBindingReportsForCSV() throws Exception {
        GroupSpaceBinding groupSpaceBinding = this.getGroupSpaceBindingInstance(this.spaceId, "/platform/administrators");
        groupSpaceBinding = this.groupSpaceBindingStorage.saveGroupSpaceBinding(groupSpaceBinding);
        GroupSpaceBindingReportAction createActionReport = this.getGroupSpaceBindingReportActionInstance(groupSpaceBinding.getId(), groupSpaceBinding.getGroup(), "ADD", Long.parseLong(this.spaceId));
        createActionReport = this.groupSpaceBindingStorage.saveGroupSpaceBindingReport(createActionReport);
        int totalReports = 5;
        for (int i = 1; i <= totalReports; ++i) {
            GroupSpaceBindingReportUser reportUser = this.getGroupSpaceBindingReportUserInstance("ADD_USER", createActionReport, false, false, "user" + i);
            this.groupSpaceBindingStorage.saveGroupSpaceBindingReportUser(reportUser);
        }
        Space space2 = this.getSpaceInstance(2);
        this.spaceStorage.saveSpace(space2, true);
        space2 = this.spaceStorage.getSpaceByPrettyName(space2.getPrettyName());
        GroupSpaceBinding groupSpaceBinding2 = this.getGroupSpaceBindingInstance(this.spaceId, "/platform/administrators");
        groupSpaceBinding2 = this.groupSpaceBindingStorage.saveGroupSpaceBinding(groupSpaceBinding2);
        GroupSpaceBindingReportAction createActionReport2 = this.getGroupSpaceBindingReportActionInstance(groupSpaceBinding2.getId(), groupSpaceBinding2.getGroup(), "ADD", Long.parseLong(space2.getId()));
        createActionReport2 = this.groupSpaceBindingStorage.saveGroupSpaceBindingReport(createActionReport2);
        for (int i = 1; i <= totalReports; ++i) {
            GroupSpaceBindingReportUser reportUser = this.getGroupSpaceBindingReportUserInstance("ADD_USER", createActionReport2, false, false, "user" + i);
            this.groupSpaceBindingStorage.saveGroupSpaceBindingReportUser(reportUser);
        }
        RDBMSGroupSpaceBindingStorageTest.assertEquals((int)totalReports, (int)this.groupSpaceBindingStorage.findReportsForCsv(Long.parseLong(this.spaceId), groupSpaceBinding.getId(), "/platform/administrators", "ADD").size());
    }

    public void testSaveSameUserBinding() {
        GroupSpaceBinding groupSpaceBinding = this.getGroupSpaceBindingInstance(this.spaceId, "/platform/administrators");
        groupSpaceBinding = this.groupSpaceBindingStorage.saveGroupSpaceBinding(groupSpaceBinding);
        UserSpaceBinding userSpaceBinding = this.getUserBindingInstance("john", groupSpaceBinding);
        userSpaceBinding = this.groupSpaceBindingStorage.saveUserBinding(userSpaceBinding);
        UserSpaceBinding userSpaceBinding2 = this.getUserBindingInstance("john", groupSpaceBinding);
        userSpaceBinding2 = this.groupSpaceBindingStorage.saveUserBinding(userSpaceBinding2);
        RDBMSGroupSpaceBindingStorageTest.assertEquals((int)1, (int)this.groupSpaceBindingStorage.findUserSpaceBindingsBySpace(this.spaceId, "john").size());
        RDBMSGroupSpaceBindingStorageTest.assertTrue((userSpaceBinding.getId() == userSpaceBinding2.getId() ? 1 : 0) != 0);
    }

    public void testGetGroupSpaceBindingReportOperations() {
        GroupSpaceBindingReportUser reportUser;
        int i;
        GroupSpaceBinding groupSpaceBinding = this.getGroupSpaceBindingInstance(this.spaceId, "/platform/administrators");
        groupSpaceBinding = this.groupSpaceBindingStorage.saveGroupSpaceBinding(groupSpaceBinding);
        GroupSpaceBindingReportAction createActionReport = this.getGroupSpaceBindingReportActionInstance(groupSpaceBinding.getId(), groupSpaceBinding.getGroup(), "ADD", Long.parseLong(this.spaceId));
        createActionReport = this.groupSpaceBindingStorage.saveGroupSpaceBindingReport(createActionReport);
        int totalReports = 5;
        for (int i2 = 1; i2 <= totalReports; ++i2) {
            GroupSpaceBindingReportUser reportUser2 = this.getGroupSpaceBindingReportUserInstance("ADD_USER", createActionReport, false, false, "user" + i2);
            this.groupSpaceBindingStorage.saveGroupSpaceBindingReportUser(reportUser2);
        }
        GroupSpaceBindingReportAction createSyncReport = this.getGroupSpaceBindingReportActionInstance(1L, "/platform/administrators", "SYNCHRONIZE", Long.parseLong(this.spaceId));
        createSyncReport = this.groupSpaceBindingStorage.saveGroupSpaceBindingReport(createSyncReport);
        for (i = 1; i <= totalReports; ++i) {
            reportUser = this.getGroupSpaceBindingReportUserInstance("ADD_USER", createSyncReport, false, false, "user" + i);
            this.groupSpaceBindingStorage.saveGroupSpaceBindingReportUser(reportUser);
        }
        for (i = 1; i <= totalReports; ++i) {
            reportUser = this.getGroupSpaceBindingReportUserInstance("REMOVE_USER", createSyncReport, false, false, "user" + i);
            this.groupSpaceBindingStorage.saveGroupSpaceBindingReportUser(reportUser);
        }
        GroupSpaceBindingReportAction createRemoveReport = this.getGroupSpaceBindingReportActionInstance(1L, "/platform/administrators", "REMOVE", Long.parseLong(this.spaceId));
        createRemoveReport = this.groupSpaceBindingStorage.saveGroupSpaceBindingReport(createRemoveReport);
        for (int i3 = 1; i3 <= totalReports; ++i3) {
            GroupSpaceBindingReportUser reportUser3 = this.getGroupSpaceBindingReportUserInstance("REMOVE_USER", createRemoveReport, false, false, "user" + i3);
            this.groupSpaceBindingStorage.saveGroupSpaceBindingReportUser(reportUser3);
        }
        List reports = this.groupSpaceBindingStorage.getGroupSpaceBindingReportOperations();
        RDBMSGroupSpaceBindingStorageTest.assertEquals((long)5L, (long)reports.stream().filter(groupSpaceBindingOperationReport -> groupSpaceBindingOperationReport.getAction().equals("ADD")).findFirst().get().getAddedUsers());
        RDBMSGroupSpaceBindingStorageTest.assertEquals((long)0L, (long)reports.stream().filter(groupSpaceBindingOperationReport -> groupSpaceBindingOperationReport.getAction().equals("ADD")).findFirst().get().getRemovedUsers());
        RDBMSGroupSpaceBindingStorageTest.assertEquals((long)5L, (long)reports.stream().filter(groupSpaceBindingOperationReport -> groupSpaceBindingOperationReport.getAction().equals("SYNCHRONIZE")).findFirst().get().getAddedUsers());
        RDBMSGroupSpaceBindingStorageTest.assertEquals((long)5L, (long)reports.stream().filter(groupSpaceBindingOperationReport -> groupSpaceBindingOperationReport.getAction().equals("SYNCHRONIZE")).findFirst().get().getRemovedUsers());
        RDBMSGroupSpaceBindingStorageTest.assertEquals((long)0L, (long)reports.stream().filter(groupSpaceBindingOperationReport -> groupSpaceBindingOperationReport.getAction().equals("REMOVE")).findFirst().get().getAddedUsers());
        RDBMSGroupSpaceBindingStorageTest.assertEquals((long)5L, (long)reports.stream().filter(groupSpaceBindingOperationReport -> groupSpaceBindingOperationReport.getAction().equals("REMOVE")).findFirst().get().getRemovedUsers());
    }

    public void testGetGroupSpaceBindingsFromQueueByAction() {
        GroupSpaceBinding groupSpaceBinding = this.getGroupSpaceBindingInstance(this.spaceId, "/platform/administrators");
        groupSpaceBinding = this.groupSpaceBindingStorage.saveGroupSpaceBinding(groupSpaceBinding);
        GroupSpaceBindingQueue groupSpaceBindingQueue = new GroupSpaceBindingQueue(groupSpaceBinding, GroupSpaceBindingQueue.ACTION_CREATE);
        this.groupSpaceBindingStorage.createGroupSpaceBindingQueue(groupSpaceBindingQueue);
        GroupSpaceBinding groupSpaceBinding2 = this.getGroupSpaceBindingInstance(this.spaceId, "/platform/administrators");
        groupSpaceBinding2 = this.groupSpaceBindingStorage.saveGroupSpaceBinding(groupSpaceBinding2);
        GroupSpaceBindingQueue groupSpaceBindingQueue2 = new GroupSpaceBindingQueue(groupSpaceBinding2, GroupSpaceBindingQueue.ACTION_CREATE);
        this.groupSpaceBindingStorage.createGroupSpaceBindingQueue(groupSpaceBindingQueue2);
        GroupSpaceBinding groupSpaceBinding3 = this.getGroupSpaceBindingInstance(this.spaceId, "/platform/administrators");
        groupSpaceBinding3 = this.groupSpaceBindingStorage.saveGroupSpaceBinding(groupSpaceBinding3);
        GroupSpaceBindingQueue groupSpaceBindingQueue3 = new GroupSpaceBindingQueue(groupSpaceBinding3, GroupSpaceBindingQueue.ACTION_REMOVE);
        this.groupSpaceBindingStorage.createGroupSpaceBindingQueue(groupSpaceBindingQueue3);
        RDBMSGroupSpaceBindingStorageTest.assertEquals((int)1, (int)this.groupSpaceBindingStorage.getGroupSpaceBindingsFromQueueByAction(GroupSpaceBindingQueue.ACTION_REMOVE).size());
        RDBMSGroupSpaceBindingStorageTest.assertEquals((int)2, (int)this.groupSpaceBindingStorage.getGroupSpaceBindingsFromQueueByAction(GroupSpaceBindingQueue.ACTION_CREATE).size());
    }

    public void testSaveGroupSpaceBindingReport() {
        GroupSpaceBinding groupSpaceBinding = this.getGroupSpaceBindingInstance(this.spaceId, "/platform/administrators");
        groupSpaceBinding = this.groupSpaceBindingStorage.saveGroupSpaceBinding(groupSpaceBinding);
        GroupSpaceBindingReportAction createActionReport = this.getGroupSpaceBindingReportActionInstance(groupSpaceBinding.getId(), "/platform/administrators", "ADD", Long.parseLong(this.spaceId));
        this.groupSpaceBindingStorage.saveGroupSpaceBindingReport(createActionReport);
        RDBMSGroupSpaceBindingStorageTest.assertNotNull((Object)this.groupSpaceBindingStorage.findGroupSpaceBindingReportAction(groupSpaceBinding.getId(), "ADD"));
    }

    public void testUpdateGroupSpaceBindingReportAction() {
        GroupSpaceBinding groupSpaceBinding = this.getGroupSpaceBindingInstance(this.spaceId, "/platform/administrators");
        groupSpaceBinding = this.groupSpaceBindingStorage.saveGroupSpaceBinding(groupSpaceBinding);
        GroupSpaceBindingReportAction createActionReport = this.getGroupSpaceBindingReportActionInstance(groupSpaceBinding.getId(), "/platform/administrators", "ADD", Long.parseLong(this.spaceId));
        this.groupSpaceBindingStorage.saveGroupSpaceBindingReport(createActionReport);
        Date endDate = new Date();
        GroupSpaceBindingReportAction actionReport = this.groupSpaceBindingStorage.findGroupSpaceBindingReportAction(groupSpaceBinding.getId(), "ADD");
        actionReport.setEndDate(endDate);
        this.groupSpaceBindingStorage.updateGroupSpaceBindingReportAction(actionReport);
        GroupSpaceBindingReportAction resultActionReport = this.groupSpaceBindingStorage.findGroupSpaceBindingReportAction(groupSpaceBinding.getId(), "ADD");
        RDBMSGroupSpaceBindingStorageTest.assertEquals((int)0, (int)resultActionReport.getEndDate().compareTo(endDate));
    }
}

