/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.search;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.exoplatform.commons.search.es.client.ElasticSearchingClient;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.jpa.search.ProfileSearchConnector;
import org.exoplatform.social.core.manager.IdentityManagerImpl;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.profileproperty.ProfilePropertyService;
import org.exoplatform.social.core.profileproperty.model.ProfilePropertySetting;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.search.Sorting;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ProfileSearchConnectorTest {
    private ProfileSearchConnector profileSearchConnector;
    @Mock
    private ProfilePropertyService profilePropertyService;
    private static final MockedStatic<CommonsUtils> COMMONS_UTILS = Mockito.mockStatic(CommonsUtils.class);

    @Test
    public void testSearch() {
        ElasticSearchingClient elasticSearchClient = (ElasticSearchingClient)Mockito.mock(ElasticSearchingClient.class);
        IdentityManagerImpl identityManager = (IdentityManagerImpl)Mockito.mock(IdentityManagerImpl.class);
        this.profileSearchConnector = new ProfileSearchConnector(this.getInitParams(), elasticSearchClient, this.profilePropertyService);
        ProfileFilter filter = new ProfileFilter();
        Identity identity1 = new Identity("test", "usernameee");
        String index = "profile_alias";
        String query = "{\n   \"from\" : 0, \"size\" : 10,\n   \"sort\": {\"lastName.raw\": {\"order\": \"ASC\"}}\n,\n\"query\" : {\n      \"constant_score\" : {\n        \"filter\" : {\n          \"bool\" :{\n      \"must\": [\n      {\n        \"query_string\" : {\n          \"query\" : \"null\",\n          \"fields\" : [\"connections\"]\n        }\n      }\n      ]\n     } \n   } \n  }\n }\n,\"_source\": false\n,\"fields\": [\"_id\"]\n}\n";
        long offset = 0L;
        long limit = 10L;
        Mockito.when((Object)elasticSearchClient.sendRequest(query, index)).thenReturn((Object)"{\"took\":39,\"timed_out\":false,\"_shards\":{\"total\":5,\"successful\":5,\"skipped\":0,\"failed\":0},\"hits\":{\"total\":{\"value\":1,\"relation\":\"eq\"},\"max_score\":null,\"hits\":[{\"_index\":\"profile_v2\",\"_type\":\"_doc\",\"_id\":\"6\",\"_score\":null,\"fields\":{\"userName\":[\"test\"]},\"sort\":[\"test\"]}]}}");
        COMMONS_UTILS.when(() -> CommonsUtils.getService((Class)((Class)Mockito.any()))).thenReturn((Object)identityManager);
        Identity identity = new Identity("username", "test");
        Relationship.Type type = Relationship.Type.CONFIRMED;
        List result = this.profileSearchConnector.search(identity, filter, type, offset, limit);
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Test
    public void testSearchWithEmail() throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        ElasticSearchingClient elasticSearchClient = (ElasticSearchingClient)Mockito.mock(ElasticSearchingClient.class);
        IdentityManagerImpl identityManager = (IdentityManagerImpl)Mockito.mock(IdentityManagerImpl.class);
        Identity identity1 = new Identity("test", "test");
        Identity identity2 = new Identity("test2", "test2");
        this.profileSearchConnector = new ProfileSearchConnector(this.getInitParams(), elasticSearchClient, this.profilePropertyService);
        ProfileFilter filter = new ProfileFilter();
        Sorting sorting = new Sorting(Sorting.SortBy.FIRSTNAME, Sorting.OrderBy.DESC);
        HashMap<String, String> profileSettings = new HashMap<String, String>();
        ArrayList<Identity> excludedIdentityList = new ArrayList<Identity>();
        excludedIdentityList.add(identity1);
        excludedIdentityList.add(identity2);
        profileSettings.put("test", "test");
        filter.setSearchEmail(true);
        filter.setSearchUserName(true);
        filter.setName("te-s t");
        filter.setEnabled(true);
        filter.setConnected(Boolean.valueOf(true));
        filter.setSorting(sorting);
        filter.setUserType("internal");
        filter.setEnrollmentStatus("notEnrolled");
        filter.setProfileSettings(profileSettings);
        filter.setExcludedIdentityList(excludedIdentityList);
        String index = "profile_alias";
        String query = "{\n   \"from\" : 0, \"size\" : 10,\n   \"sort\": {\"firstName.raw\": {\"order\": \"DESC\"}}\n,\n\"query\" : {\n      \"constant_score\" : {\n        \"filter\" : {\n          \"bool\" :{\n      \"must\": [\n      {\n        \"bool\": {\n          \"should\": [\n                  {\n                    \"term\": {\n                      \"external\": false\n                    }\n                  },\n                  {\n                    \"bool\": {\n                      \"must_not\": {\n                        \"exists\": {\n                          \"field\": \"external\"\n                        }\n                      }\n                    }\n                  }          ],\n          \"minimum_should_match\" : 1\n        }\n      },\n      {\n        \"bool\": {\n          \"should\": [\n                  {\n                    \"bool\": {\n                      \"must\": {\n                        \"exists\": {\n                          \"field\": \"lastLoginTime\"\n                        }\n                      }\n                    }\n                  }          ],\n          \"minimum_should_match\" : 1\n        }\n      },\n      {\n        \"bool\": {\n          \"should\": [\n                  {\n                    \"bool\": {\n                      \"must_not\": [{\n                        \"exists\": {\n                          \"field\": \"enrollmentDate\"\n                          }\n                        },\n                      {\n                        \"exists\": {\n                          \"field\": \"lastLoginTime\"\n                        }\n                      }],\n                      \"must\": {\n                       \"term\": {\n                         \"external\": false\n                         }\n                      }\n                    }\n                  }          ],\n          \"minimum_should_match\" : 1\n        }\n      }      ]\n      ,\n      \"must_not\": [\n      {\n          \"ids\" : {\n             \"values\" : [\"null\",\"null\"]\n          }\n        }\n      ]\n      ,\n      \"filter\": [\n      {          \"query_string\": {\n            \"query\": \"( name.whitespace:*te-s* OR email:*te-s* OR userName:*te-s*) AND ( name.whitespace:*t* OR email:*t* OR userName:*t*)\"\n          }\n      }\n      ]\n     } \n   } \n  }\n }\n,\"_source\": false\n,\"fields\": [\"_id\"]\n}\n";
        long offset = 0L;
        long limit = 10L;
        Mockito.when((Object)elasticSearchClient.sendRequest(query, index)).thenReturn((Object)"{\"took\":39,\"timed_out\":false,\"_shards\":{\"total\":5,\"successful\":5,\"skipped\":0,\"failed\":0},\"hits\":{\"total\":{\"value\":1,\"relation\":\"eq\"},\"max_score\":null,\"hits\":[{\"_index\":\"profile_v2\",\"_type\":\"_doc\",\"_id\":\"6\",\"_score\":null,\"fields\":{\"userName\":[\"test\"]},\"sort\":[\"test\"]}]}}");
        COMMONS_UTILS.when(() -> CommonsUtils.getService((Class)((Class)Mockito.any()))).thenReturn((Object)identityManager);
        List result = this.profileSearchConnector.search(null, filter, null, offset, limit);
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Test
    public void testSearchWithNameOrUsername() throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        ElasticSearchingClient elasticSearchClient = (ElasticSearchingClient)Mockito.mock(ElasticSearchingClient.class);
        this.profileSearchConnector = new ProfileSearchConnector(this.getInitParams(), elasticSearchClient, this.profilePropertyService);
        IdentityManagerImpl identityManager = (IdentityManagerImpl)Mockito.mock(IdentityManagerImpl.class);
        ProfileFilter filter = new ProfileFilter();
        Sorting sorting = new Sorting(Sorting.SortBy.DATE, Sorting.OrderBy.DESC);
        HashMap<String, String> profileSettings = new HashMap<String, String>();
        ArrayList<Identity> excludedIdentityList = new ArrayList<Identity>();
        Identity identity1 = new Identity("test", "test");
        Identity identity2 = new Identity("test2", "test2");
        excludedIdentityList.add(identity1);
        excludedIdentityList.add(identity2);
        profileSettings.put("test", "test");
        filter.setSearchEmail(false);
        filter.setSearchUserName(false);
        filter.setName("\\\"te-s t\\\"");
        filter.setEnabled(true);
        filter.setConnected(Boolean.valueOf(true));
        filter.setSorting(sorting);
        filter.setUserType("external");
        filter.setEnrollmentStatus("noEnrollmentPossible");
        filter.setProfileSettings(profileSettings);
        filter.setExcludedIdentityList(excludedIdentityList);
        filter.setRemoteIds(Collections.singletonList("test"));
        String index = "profile_alias";
        String query = "{\n   \"from\" : 0, \"size\" : 10,\n   \"sort\": {\"lastUpdatedDate\": {\"order\": \"DESC\"}}\n,\n\"query\" : {\n      \"constant_score\" : {\n        \"filter\" : {\n          \"bool\" :{\n      \"must\": [\n      {\n        \"bool\": {\n          \"should\": [\n                  {\n                    \"term\": {\n                      \"external\": true\n                    }\n                  }          ],\n          \"minimum_should_match\" : 1\n        }\n      },\n      {\n        \"bool\": {\n          \"should\": [\n                  {\n                    \"bool\": {\n                      \"must\": {\n                        \"exists\": {\n                          \"field\": \"lastLoginTime\"\n                        }\n                      }\n                    }\n                  }          ],\n          \"minimum_should_match\" : 1\n        }\n      },\n      {\n        \"bool\": {\n          \"should\": [\n                  {\n                    \"bool\": {\n                      \"must_not\": {\n                        \"exists\": {\n                          \"field\": \"enrollmentDate\"\n                          }\n                        },\n                      \"must\": {\n                        \"exists\": {\n                          \"field\": \"lastLoginTime\"\n                        }\n                      }\n                    }\n                  },\n                  {\n                    \"term\": {\n                      \"external\": true\n                    }\n                  }          ],\n          \"minimum_should_match\" : 1\n        }\n      },\n      {\n        \"terms\" :{\n          \"userName\" : [\"test\"]\n        } \n      }\n      ]\n      ,\n      \"must_not\": [\n      {\n          \"ids\" : {\n             \"values\" : [\"null\",\"null\"]\n          }\n        }\n      ]\n      ,\n      \"filter\": [\n      {          \"query_string\": {\n            \"query\": \"( name.whitespace:*\\\"te-s*) AND ( name.whitespace:*t\\\"*)\"\n          }\n      }\n      ]\n     } \n   } \n  }\n }\n,\"_source\": false\n,\"fields\": [\"_id\"]\n}\n";
        Mockito.when((Object)elasticSearchClient.sendRequest(query, index)).thenReturn((Object)"{\"took\":39,\"timed_out\":false,\"_shards\":{\"total\":5,\"successful\":5,\"skipped\":0,\"failed\":0},\"hits\":{\"total\":{\"value\":1,\"relation\":\"eq\"},\"max_score\":null,\"hits\":[{\"_index\":\"profile_v2\",\"_type\":\"_doc\",\"_id\":\"6\",\"_score\":null,\"fields\":{\"userName\":[\"test\"]},\"sort\":[\"test\"]}]}}");
        COMMONS_UTILS.when(() -> CommonsUtils.getService((Class)((Class)Mockito.any()))).thenReturn((Object)identityManager);
        long offset = 0L;
        long limit = 10L;
        List result = this.profileSearchConnector.search(null, filter, null, offset, limit);
        Assert.assertEquals((long)1L, (long)result.size());
        filter.setEnrollmentStatus("enrolled");
        query = "{\n   \"from\" : 0, \"size\" : 10,\n   \"sort\": {\"lastUpdatedDate\": {\"order\": \"DESC\"}}\n,\n\"query\" : {\n      \"constant_score\" : {\n        \"filter\" : {\n          \"bool\" :{\n      \"must\": [\n      {\n        \"bool\": {\n          \"should\": [\n                  {\n                    \"term\": {\n                      \"external\": true\n                    }\n                  }          ],\n          \"minimum_should_match\" : 1\n        }\n      },\n      {\n        \"bool\": {\n          \"should\": [\n                  {\n                    \"bool\": {\n                      \"must\": {\n                        \"exists\": {\n                          \"field\": \"lastLoginTime\"\n                        }\n                      }\n                    }\n                  }          ],\n          \"minimum_should_match\" : 1\n        }\n      },\n      {\n        \"bool\": {\n          \"should\": [\n                  {\n                    \"bool\": {\n                      \"must\": {\n                        \"exists\": {\n                          \"field\": \"enrollmentDate\"\n                        }\n                      }\n                    }\n                  }          ],\n          \"minimum_should_match\" : 1\n        }\n      },\n      {\n        \"terms\" :{\n          \"userName\" : [\"test\"]\n        } \n      }\n      ]\n      ,\n      \"must_not\": [\n      {\n          \"ids\" : {\n             \"values\" : [\"null\",\"null\"]\n          }\n        }\n      ]\n      ,\n      \"filter\": [\n      {          \"query_string\": {\n            \"query\": \"( name.whitespace:*\\\"te-s*) AND ( name.whitespace:*t\\\"*)\"\n          }\n      }\n      ]\n     } \n   } \n  }\n }\n,\"_source\": false\n,\"fields\": [\"_id\"]\n}\n";
        Mockito.when((Object)elasticSearchClient.sendRequest(query, index)).thenReturn((Object)"{\"took\":39,\"timed_out\":false,\"_shards\":{\"total\":5,\"successful\":5,\"skipped\":0,\"failed\":0},\"hits\":{\"total\":{\"value\":1,\"relation\":\"eq\"},\"max_score\":null,\"hits\":[{\"_index\":\"profile_v2\",\"_type\":\"_doc\",\"_id\":\"6\",\"_score\":null,\"fields\":{\"userName\":[\"test\"]},\"sort\":[\"test\"]}]}}");
        result = this.profileSearchConnector.search(null, filter, null, offset, limit);
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Test
    public void testSearchWithProfileSetting() throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        ElasticSearchingClient elasticSearchClient = (ElasticSearchingClient)Mockito.mock(ElasticSearchingClient.class);
        this.profileSearchConnector = new ProfileSearchConnector(this.getInitParams(), elasticSearchClient, this.profilePropertyService);
        IdentityManagerImpl identityManager = (IdentityManagerImpl)Mockito.mock(IdentityManagerImpl.class);
        ProfileFilter filter = new ProfileFilter();
        Sorting sorting = new Sorting(Sorting.SortBy.DATE, Sorting.OrderBy.DESC);
        ProfilePropertySetting profilePropertySetting = (ProfilePropertySetting)Mockito.mock(ProfilePropertySetting.class);
        Mockito.lenient().when((Object)profilePropertySetting.getPropertyName()).thenReturn((Object)"testProperty");
        Mockito.when((Object)this.profilePropertyService.getProfileSettingByName("testProperty")).thenReturn((Object)profilePropertySetting);
        HashMap<String, String> profileSettings = new HashMap<String, String>();
        ArrayList<Identity> excludedIdentityList = new ArrayList<Identity>();
        Identity identity1 = new Identity("test", "test");
        Identity identity2 = new Identity("test2", "test2");
        excludedIdentityList.add(identity1);
        excludedIdentityList.add(identity2);
        profileSettings.put("testProperty", "valueProperty");
        filter.setSearchEmail(false);
        filter.setSearchUserName(false);
        filter.setName("\\\"te-s t\\\"");
        filter.setEnabled(true);
        filter.setConnected(Boolean.valueOf(true));
        filter.setSorting(sorting);
        filter.setUserType("external");
        filter.setEnrollmentStatus("noEnrollmentPossible");
        filter.setProfileSettings(profileSettings);
        filter.setExcludedIdentityList(excludedIdentityList);
        filter.setRemoteIds(Collections.singletonList("test"));
        String index = "profile_alias";
        String query = "{\n   \"from\" : 0, \"size\" : 10,\n   \"sort\": {\"lastUpdatedDate\": {\"order\": \"DESC\"}}\n,\n\"query\" : {\n      \"constant_score\" : {\n        \"filter\" : {\n          \"bool\" :{\n      \"must\": [\n      {\n        \"bool\": {\n          \"should\": [\n                  {\n                    \"term\": {\n                      \"external\": true\n                    }\n                  }          ],\n          \"minimum_should_match\" : 1\n        }\n      },\n      {\n        \"bool\": {\n          \"should\": [\n                  {\n                    \"bool\": {\n                      \"must\": {\n                        \"exists\": {\n                          \"field\": \"lastLoginTime\"\n                        }\n                      }\n                    }\n                  }          ],\n          \"minimum_should_match\" : 1\n        }\n      },\n      {\n        \"bool\": {\n          \"should\": [\n                  {\n                    \"bool\": {\n                      \"must_not\": {\n                        \"exists\": {\n                          \"field\": \"enrollmentDate\"\n                          }\n                        },\n                      \"must\": {\n                        \"exists\": {\n                          \"field\": \"lastLoginTime\"\n                        }\n                      }\n                    }\n                  },\n                  {\n                    \"term\": {\n                      \"external\": true\n                    }\n                  }          ],\n          \"minimum_should_match\" : 1\n        }\n      },\n      {\n        \"terms\" :{\n          \"userName\" : [\"test\"]\n        } \n      }\n      ]\n      ,\n      \"must_not\": [\n      {\n          \"ids\" : {\n             \"values\" : [\"null\",\"null\"]\n          }\n        }\n      ]\n      ,\n      \"filter\": [\n      {          \"query_string\": {\n            \"query\": \"( name.whitespace:*\\\"te-s*) AND ( name.whitespace:*t\\\"*)\"\n          }\n      }\n,\n  {\n    \"match_phrase\": {\n      \"testProperty\": \"valueProperty\"\n    }\n }\n      ]\n     } \n   } \n  }\n }\n,\"_source\": false\n,\"fields\": [\"_id\"]\n}\n";
        Mockito.when((Object)elasticSearchClient.sendRequest(query, index)).thenReturn((Object)"{\"took\":39,\"timed_out\":false,\"_shards\":{\"total\":5,\"successful\":5,\"skipped\":0,\"failed\":0},\"hits\":{\"total\":{\"value\":1,\"relation\":\"eq\"},\"max_score\":null,\"hits\":[{\"_index\":\"profile_v2\",\"_type\":\"_doc\",\"_id\":\"6\",\"_score\":null,\"fields\":{\"userName\":[\"test\"]},\"sort\":[\"test\"]}]}}");
        COMMONS_UTILS.when(() -> CommonsUtils.getService((Class)((Class)Mockito.any()))).thenReturn((Object)identityManager);
        long offset = 0L;
        long limit = 10L;
        List result = this.profileSearchConnector.search(null, filter, null, offset, limit);
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Test
    public void testSearchWithProfileSettingWithSpacedValue() throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        ElasticSearchingClient elasticSearchClient = (ElasticSearchingClient)Mockito.mock(ElasticSearchingClient.class);
        this.profileSearchConnector = new ProfileSearchConnector(this.getInitParams(), elasticSearchClient, this.profilePropertyService);
        IdentityManagerImpl identityManager = (IdentityManagerImpl)Mockito.mock(IdentityManagerImpl.class);
        ProfileFilter filter = new ProfileFilter();
        Sorting sorting = new Sorting(Sorting.SortBy.DATE, Sorting.OrderBy.DESC);
        ProfilePropertySetting profilePropertySetting = (ProfilePropertySetting)Mockito.mock(ProfilePropertySetting.class);
        Mockito.lenient().when((Object)profilePropertySetting.getPropertyName()).thenReturn((Object)"testProperty");
        Mockito.when((Object)this.profilePropertyService.getProfileSettingByName("testProperty")).thenReturn((Object)profilePropertySetting);
        HashMap<String, String> profileSettings = new HashMap<String, String>();
        ArrayList<Identity> excludedIdentityList = new ArrayList<Identity>();
        Identity identity1 = new Identity("test", "test");
        Identity identity2 = new Identity("test2", "test2");
        excludedIdentityList.add(identity1);
        excludedIdentityList.add(identity2);
        profileSettings.put("testProperty", "value of test Property");
        filter.setSearchEmail(false);
        filter.setSearchUserName(false);
        filter.setName("\\\"te-s t\\\"");
        filter.setEnabled(true);
        filter.setConnected(Boolean.valueOf(true));
        filter.setSorting(sorting);
        filter.setUserType("external");
        filter.setEnrollmentStatus("noEnrollmentPossible");
        filter.setProfileSettings(profileSettings);
        filter.setExcludedIdentityList(excludedIdentityList);
        filter.setRemoteIds(Collections.singletonList("test"));
        String index = "profile_alias";
        String query = "{\n   \"from\" : 0, \"size\" : 10,\n   \"sort\": {\"lastUpdatedDate\": {\"order\": \"DESC\"}}\n,\n\"query\" : {\n      \"constant_score\" : {\n        \"filter\" : {\n          \"bool\" :{\n      \"must\": [\n      {\n        \"bool\": {\n          \"should\": [\n                  {\n                    \"term\": {\n                      \"external\": true\n                    }\n                  }          ],\n          \"minimum_should_match\" : 1\n        }\n      },\n      {\n        \"bool\": {\n          \"should\": [\n                  {\n                    \"bool\": {\n                      \"must\": {\n                        \"exists\": {\n                          \"field\": \"lastLoginTime\"\n                        }\n                      }\n                    }\n                  }          ],\n          \"minimum_should_match\" : 1\n        }\n      },\n      {\n        \"bool\": {\n          \"should\": [\n                  {\n                    \"bool\": {\n                      \"must_not\": {\n                        \"exists\": {\n                          \"field\": \"enrollmentDate\"\n                          }\n                        },\n                      \"must\": {\n                        \"exists\": {\n                          \"field\": \"lastLoginTime\"\n                        }\n                      }\n                    }\n                  },\n                  {\n                    \"term\": {\n                      \"external\": true\n                    }\n                  }          ],\n          \"minimum_should_match\" : 1\n        }\n      },\n      {\n        \"terms\" :{\n          \"userName\" : [\"test\"]\n        } \n      }\n      ]\n      ,\n      \"must_not\": [\n      {\n          \"ids\" : {\n             \"values\" : [\"null\",\"null\"]\n          }\n        }\n      ]\n      ,\n      \"filter\": [\n      {          \"query_string\": {\n            \"query\": \"( name.whitespace:*\\\"te-s*) AND ( name.whitespace:*t\\\"*)\"\n          }\n      }\n,\n  {\n    \"query_string\": {\n      \"query\": \" testProperty.whitespace:*value* AND  testProperty.whitespace:*of* AND  testProperty.whitespace:*test* AND  testProperty.whitespace:*Property*\"\n    }\n }\n      ]\n     } \n   } \n  }\n }\n,\"_source\": false\n,\"fields\": [\"_id\"]\n}\n";
        Mockito.when((Object)elasticSearchClient.sendRequest(query, index)).thenReturn((Object)"{\"took\":39,\"timed_out\":false,\"_shards\":{\"total\":5,\"successful\":5,\"skipped\":0,\"failed\":0},\"hits\":{\"total\":{\"value\":1,\"relation\":\"eq\"},\"max_score\":null,\"hits\":[{\"_index\":\"profile_v2\",\"_type\":\"_doc\",\"_id\":\"6\",\"_score\":null,\"fields\":{\"userName\":[\"test\"]},\"sort\":[\"test\"]}]}}");
        COMMONS_UTILS.when(() -> CommonsUtils.getService((Class)((Class)Mockito.any()))).thenReturn((Object)identityManager);
        long offset = 0L;
        long limit = 10L;
        List result = this.profileSearchConnector.search(null, filter, null, offset, limit);
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Test
    public void testSearchWithProfileSettingAndSpecialChars() throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        ElasticSearchingClient elasticSearchClient = (ElasticSearchingClient)Mockito.mock(ElasticSearchingClient.class);
        this.profileSearchConnector = new ProfileSearchConnector(this.getInitParams(), elasticSearchClient, this.profilePropertyService);
        IdentityManagerImpl identityManager = (IdentityManagerImpl)Mockito.mock(IdentityManagerImpl.class);
        ProfileFilter filter = new ProfileFilter();
        Sorting sorting = new Sorting(Sorting.SortBy.DATE, Sorting.OrderBy.DESC);
        ProfilePropertySetting profilePropertySetting = (ProfilePropertySetting)Mockito.mock(ProfilePropertySetting.class);
        Mockito.lenient().when((Object)profilePropertySetting.getPropertyName()).thenReturn((Object)"testProperty");
        Mockito.when((Object)this.profilePropertyService.getProfileSettingByName("testProperty")).thenReturn((Object)profilePropertySetting);
        HashMap<String, String> profileSettings = new HashMap<String, String>();
        ArrayList<Identity> excludedIdentityList = new ArrayList<Identity>();
        Identity identity1 = new Identity("test", "test");
        Identity identity2 = new Identity("test2", "test2");
        excludedIdentityList.add(identity1);
        excludedIdentityList.add(identity2);
        profileSettings.put("testProperty", "value+ -=&&||of><!(){} test[]^\"~*? Property:\\/");
        filter.setSearchEmail(false);
        filter.setSearchUserName(false);
        filter.setName("\\\"te-s t\\\"");
        filter.setEnabled(true);
        filter.setConnected(Boolean.valueOf(true));
        filter.setSorting(sorting);
        filter.setUserType("external");
        filter.setEnrollmentStatus("noEnrollmentPossible");
        filter.setProfileSettings(profileSettings);
        filter.setExcludedIdentityList(excludedIdentityList);
        filter.setRemoteIds(Collections.singletonList("test"));
        String index = "profile_alias";
        String query = "{\n   \"from\" : 0, \"size\" : 10,\n   \"sort\": {\"lastUpdatedDate\": {\"order\": \"DESC\"}}\n,\n\"query\" : {\n      \"constant_score\" : {\n        \"filter\" : {\n          \"bool\" :{\n      \"must\": [\n      {\n        \"bool\": {\n          \"should\": [\n                  {\n                    \"term\": {\n                      \"external\": true\n                    }\n                  }          ],\n          \"minimum_should_match\" : 1\n        }\n      },\n      {\n        \"bool\": {\n          \"should\": [\n                  {\n                    \"bool\": {\n                      \"must\": {\n                        \"exists\": {\n                          \"field\": \"lastLoginTime\"\n                        }\n                      }\n                    }\n                  }          ],\n          \"minimum_should_match\" : 1\n        }\n      },\n      {\n        \"bool\": {\n          \"should\": [\n                  {\n                    \"bool\": {\n                      \"must_not\": {\n                        \"exists\": {\n                          \"field\": \"enrollmentDate\"\n                          }\n                        },\n                      \"must\": {\n                        \"exists\": {\n                          \"field\": \"lastLoginTime\"\n                        }\n                      }\n                    }\n                  },\n                  {\n                    \"term\": {\n                      \"external\": true\n                    }\n                  }          ],\n          \"minimum_should_match\" : 1\n        }\n      },\n      {\n        \"terms\" :{\n          \"userName\" : [\"test\"]\n        } \n      }\n      ]\n      ,\n      \"must_not\": [\n      {\n          \"ids\" : {\n             \"values\" : [\"null\",\"null\"]\n          }\n        }\n      ]\n      ,\n      \"filter\": [\n      {          \"query_string\": {\n            \"query\": \"( name.whitespace:*\\\"te-s*) AND ( name.whitespace:*t\\\"*)\"\n          }\n      }\n,\n  {\n    \"query_string\": {\n      \"query\": \" testProperty.whitespace:*value* AND  testProperty.whitespace:*of* AND  testProperty.whitespace:*test* AND  testProperty.whitespace:*Property*\"\n    }\n }\n      ]\n     } \n   } \n  }\n }\n,\"_source\": false\n,\"fields\": [\"_id\"]\n}\n";
        Mockito.when((Object)elasticSearchClient.sendRequest(query, index)).thenReturn((Object)"{\"took\":39,\"timed_out\":false,\"_shards\":{\"total\":5,\"successful\":5,\"skipped\":0,\"failed\":0},\"hits\":{\"total\":{\"value\":1,\"relation\":\"eq\"},\"max_score\":null,\"hits\":[{\"_index\":\"profile_v2\",\"_type\":\"_doc\",\"_id\":\"6\",\"_score\":null,\"fields\":{\"userName\":[\"test\"]},\"sort\":[\"test\"]}]}}");
        COMMONS_UTILS.when(() -> CommonsUtils.getService((Class)((Class)Mockito.any()))).thenReturn((Object)identityManager);
        long offset = 0L;
        long limit = 10L;
        List result = this.profileSearchConnector.search(null, filter, null, offset, limit);
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Test
    public void testCount() throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        ElasticSearchingClient elasticSearchClient = (ElasticSearchingClient)Mockito.mock(ElasticSearchingClient.class);
        this.profileSearchConnector = new ProfileSearchConnector(this.getInitParams(), elasticSearchClient, this.profilePropertyService);
        ProfileFilter filter = new ProfileFilter();
        Sorting sorting = new Sorting(Sorting.SortBy.DATE, Sorting.OrderBy.DESC);
        HashMap<String, String> profileSettings = new HashMap<String, String>();
        ArrayList<Identity> excludedIdentityList = new ArrayList<Identity>();
        Identity identity1 = new Identity("test1", "test1");
        Identity identity2 = new Identity("test2", "test2");
        excludedIdentityList.add(identity1);
        excludedIdentityList.add(identity2);
        profileSettings.put("test", "test");
        filter.setSearchEmail(false);
        filter.setSearchUserName(false);
        filter.setName("\\\"te-s t\\\"");
        filter.setEnabled(true);
        filter.setConnected(Boolean.valueOf(true));
        filter.setSorting(sorting);
        filter.setUserType("external");
        filter.setEnrollmentStatus("noEnrollmentPossible");
        filter.setProfileSettings(profileSettings);
        filter.setExcludedIdentityList(excludedIdentityList);
        filter.setRemoteIds(Collections.singletonList("test"));
        String index = "profile_alias";
        String query = "{\n   \"from\" : 0, \"size\" : 1,\n   \"sort\": {\"lastUpdatedDate\": {\"order\": \"DESC\"}}\n,\n\"query\" : {\n      \"constant_score\" : {\n        \"filter\" : {\n          \"bool\" :{\n      \"must\": [\n      {\n        \"bool\": {\n          \"should\": [\n                  {\n                    \"term\": {\n                      \"external\": true\n                    }\n                  }          ],\n          \"minimum_should_match\" : 1\n        }\n      },\n      {\n        \"bool\": {\n          \"should\": [\n                  {\n                    \"bool\": {\n                      \"must\": {\n                        \"exists\": {\n                          \"field\": \"lastLoginTime\"\n                        }\n                      }\n                    }\n                  }          ],\n          \"minimum_should_match\" : 1\n        }\n      },\n      {\n        \"bool\": {\n          \"should\": [\n                  {\n                    \"bool\": {\n                      \"must_not\": {\n                        \"exists\": {\n                          \"field\": \"enrollmentDate\"\n                          }\n                        },\n                      \"must\": {\n                        \"exists\": {\n                          \"field\": \"lastLoginTime\"\n                        }\n                      }\n                    }\n                  },\n                  {\n                    \"term\": {\n                      \"external\": true\n                    }\n                  }          ],\n          \"minimum_should_match\" : 1\n        }\n      },\n      {\n        \"terms\" :{\n          \"userName\" : [\"test\"]\n        } \n      }\n      ]\n      ,\n      \"must_not\": [\n      {\n          \"ids\" : {\n             \"values\" : [\"null\",\"null\"]\n          }\n        }\n      ]\n      ,\n      \"filter\": [\n      {          \"query_string\": {\n            \"query\": \"( name.whitespace:*\\\"te-s*) AND ( name.whitespace:*t\\\"*)\"\n          }\n      }\n      ]\n     } \n   } \n  }\n }\n,\"_source\": false\n,\"fields\": [\"_id\"]\n}\n";
        Mockito.when((Object)elasticSearchClient.sendRequest(query, index)).thenReturn((Object)"{\"took\":39,\"timed_out\":false,\"_shards\":{\"total\":5,\"successful\":5,\"skipped\":0,\"failed\":0},\"hits\":{\"total\":{\"value\":1,\"relation\":\"eq\"},\"max_score\":null,\"hits\":[{\"_index\":\"profile_v2\",\"_type\":\"_doc\",\"_id\":\"6\",\"_score\":null,\"fields\":{\"userName\":[\"test\"]},\"sort\":[\"test\"]}]}}");
        int result = this.profileSearchConnector.count(null, filter, null);
        Assert.assertEquals((long)1L, (long)result);
    }

    @Test
    public void testSearchWithSpace() {
        ElasticSearchingClient elasticSearchClient = (ElasticSearchingClient)Mockito.mock(ElasticSearchingClient.class);
        this.profileSearchConnector = new ProfileSearchConnector(this.getInitParams(), elasticSearchClient, this.profilePropertyService);
        IdentityManagerImpl identityManager = (IdentityManagerImpl)Mockito.mock(IdentityManagerImpl.class);
        ProfileFilter filter = new ProfileFilter();
        filter.setSearchEmail(false);
        filter.setSearchUserName(false);
        filter.setName("\\\"aaa\\\"");
        filter.setEnabled(true);
        filter.setUserType("internal");
        filter.setSpaceIdentityIds(Arrays.asList("5"));
        filter.setEnrollmentStatus("noEnrollmentPossible");
        String index = "profile_alias";
        String expectedQuery = "{\n   \"from\" : 0, \"size\" : 10,\n   \"sort\": {\"lastName.raw\": {\"order\": \"ASC\"}}\n,\n\"query\" : {\n      \"constant_score\" : {\n        \"filter\" : {\n          \"bool\" :{\n      \"must\": [\n      {\n        \"terms\": {\n          \"permissions\": [\n5\n          ]\n        }\n      },\n      {\n        \"bool\": {\n          \"should\": [\n                  {\n                    \"term\": {\n                      \"external\": false\n                    }\n                  },\n                  {\n                    \"bool\": {\n                      \"must_not\": {\n                        \"exists\": {\n                          \"field\": \"external\"\n                        }\n                      }\n                    }\n                  }          ],\n          \"minimum_should_match\" : 1\n        }\n      },\n      {\n        \"bool\": {\n          \"should\": [\n                  {\n                    \"bool\": {\n                      \"must_not\": {\n                        \"exists\": {\n                          \"field\": \"enrollmentDate\"\n                          }\n                        },\n                      \"must\": {\n                        \"exists\": {\n                          \"field\": \"lastLoginTime\"\n                        }\n                      }\n                    }\n                  },\n                  {\n                    \"term\": {\n                      \"external\": true\n                    }\n                  }          ],\n          \"minimum_should_match\" : 1\n        }\n      }      ]\n      ,\n      \"filter\": [\n      {          \"query_string\": {\n            \"query\": \"name.whitespace:*\\\"aaa\\\"*\"\n          }\n      }\n      ]\n     } \n   } \n  }\n }\n,\"_source\": false\n,\"fields\": [\"_id\"]\n}\n";
        Mockito.when((Object)elasticSearchClient.sendRequest(expectedQuery, index)).thenReturn((Object)"{\"took\":39,\"timed_out\":false,\"_shards\":{\"total\":5,\"successful\":5,\"skipped\":0,\"failed\":0},\"hits\":{\"total\":{\"value\":1,\"relation\":\"eq\"},\"max_score\":null,\"hits\":[{\"_index\":\"profile_v2\",\"_type\":\"_doc\",\"_id\":\"6\",\"_score\":null,\"fields\":{\"userName\":[\"aaa\"]},\"sort\":[\"aaa\"]}]}}");
        COMMONS_UTILS.when(() -> CommonsUtils.getService((Class)((Class)Mockito.any()))).thenReturn((Object)identityManager);
        long offset = 0L;
        long limit = 10L;
        List result = this.profileSearchConnector.search(null, filter, null, offset, limit);
        Assert.assertEquals((long)1L, (long)result.size());
    }

    private String buildAdvancedFilterQuery(ProfileFilter filter) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = this.profileSearchConnector.getClass().getDeclaredMethod("buildAdvancedFilterExpression", ProfileFilter.class);
        method.setAccessible(true);
        return (String)method.invoke((Object)this.profileSearchConnector, filter);
    }

    private InitParams getInitParams() {
        InitParams params = new InitParams();
        PropertiesParam constructorParams = new PropertiesParam();
        constructorParams.setName("constructor.params");
        constructorParams.setProperty("searchType", "profile_alias");
        constructorParams.setProperty("displayName", "profile_alias");
        constructorParams.setProperty("index", "profile_alias");
        constructorParams.setProperty("type", "profile_alias");
        constructorParams.setProperty("searchFields", "name");
        params.addParam((Object)constructorParams);
        return params;
    }
}

