/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.processor;

import java.util.LinkedHashMap;
import java.util.Map;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.processor.MentionsProcessor;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.test.AbstractCoreTest;

public class MentionsProcessorTest
extends AbstractCoreTest {
    private IdentityManager identityManager;
    private UserPortalConfigService userPortalConfigService;
    private Identity rootIdentity;
    private Identity johnIdentity;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.identityManager = (IdentityManager)PortalContainer.getInstance().getComponentInstanceOfType(IdentityManager.class);
        this.userPortalConfigService = (UserPortalConfigService)PortalContainer.getInstance().getComponentInstanceOfType(UserPortalConfigService.class);
        MentionsProcessorTest.assertNotNull((String)"identityManager must not be null", (Object)this.identityManager);
        this.rootIdentity = this.identityManager.getOrCreateIdentity("organization", "root");
        this.johnIdentity = this.identityManager.getOrCreateIdentity("organization", "john");
        MentionsProcessorTest.assertNotNull((String)"rootIdentity.getId() must not be null", (Object)this.rootIdentity.getId());
        MentionsProcessorTest.assertNotNull((String)"johnIdentity.getId() must not be null", (Object)this.johnIdentity.getId());
    }

    @Override
    public void tearDown() throws Exception {
        this.identityManager.deleteIdentity(this.rootIdentity);
        this.identityManager.deleteIdentity(this.johnIdentity);
        super.tearDown();
    }

    public void testSubstituteUsernames() throws Exception {
        MentionsProcessorTest.assertTrue((boolean)true);
        MentionsProcessor processor = (MentionsProcessor)this.getContainer().getComponentInstanceOfType(MentionsProcessor.class);
        MentionsProcessorTest.assertNotNull((String)"prococessor must not be null", (Object)processor);
        ExoSocialActivityImpl activity = null;
        processor.processActivity(activity);
        MentionsProcessorTest.assertNull((String)"returned activity must be null", activity);
        activity = new ExoSocialActivityImpl();
        processor.processActivity((ExoSocialActivity)activity);
        MentionsProcessorTest.assertNull((Object)activity.getTitle());
        MentionsProcessorTest.assertNull((Object)activity.getBody());
        String root = "root";
        String john = "john";
        String rootLink = LinkProvider.getProfileLink((String)root, (String)this.userPortalConfigService.getMetaPortal());
        String johnLink = LinkProvider.getProfileLink((String)john, (String)this.userPortalConfigService.getMetaPortal());
        activity.setTitle("single @root substitution");
        processor.processActivity((ExoSocialActivity)activity);
        MentionsProcessorTest.assertEquals((String)"Single substitution : ", (String)activity.getTitle(), (String)("single " + rootLink + " substitution"));
        MentionsProcessorTest.assertNull((Object)activity.getBody());
        activity.setTitle("@root and @john title");
        activity.setBody("body with @root and @john");
        processor.processActivity((ExoSocialActivity)activity);
        MentionsProcessorTest.assertEquals((String)"Multiple substitution : ", (String)activity.getTitle(), (String)(rootLink + " and " + johnLink + " title"));
        MentionsProcessorTest.assertEquals((String)activity.getBody(), (String)("body with " + rootLink + " and " + johnLink));
        activity.setTitle("@root and @wrong_username title");
        activity.setBody("body with @root and @wrong_username");
        processor.processActivity((ExoSocialActivity)activity);
        MentionsProcessorTest.assertEquals((String)activity.getTitle(), (String)(rootLink + " and @wrong_username title"));
        MentionsProcessorTest.assertEquals((String)activity.getBody(), (String)("body with " + rootLink + " and @wrong_username"));
    }

    public void testProcessActivityWithTemplateParam() throws Exception {
        MentionsProcessor processor = (MentionsProcessor)this.getContainer().getComponentInstanceOfType(MentionsProcessor.class);
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        String sample = "this is a <strong> tag to keep</strong>";
        activity.setTitle(sample);
        activity.setBody(sample);
        String keysToProcess = "a|b|c";
        Map templateParams = new LinkedHashMap<String, String>();
        templateParams.put("a", "@root and @john");
        templateParams.put("b", "@john");
        templateParams.put("d", "@mary");
        templateParams.put("registeredKeysForProcessor", keysToProcess);
        activity.setTemplateParams(templateParams);
        processor.processActivity((ExoSocialActivity)activity);
        templateParams = activity.getTemplateParams();
        MentionsProcessorTest.assertEquals((String)(LinkProvider.getProfileLink((String)"root", (String)this.userPortalConfigService.getMetaPortal()) + " and " + LinkProvider.getProfileLink((String)"john", (String)this.userPortalConfigService.getMetaPortal())), (String)((String)templateParams.get("a")));
        MentionsProcessorTest.assertEquals((String)LinkProvider.getProfileLink((String)"john", (String)this.userPortalConfigService.getMetaPortal()), (String)((String)templateParams.get("b")));
        MentionsProcessorTest.assertEquals((String)"@mary", (String)((String)templateParams.get("d")));
    }
}

