/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.listeners;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.social.common.Utils;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.profile.ProfileLifeCycleEvent;
import org.exoplatform.social.core.profile.ProfileListenerPlugin;
import org.exoplatform.social.core.profileproperty.ProfilePropertyService;
import org.exoplatform.social.core.profileproperty.model.ProfilePropertyOption;
import org.exoplatform.social.core.profileproperty.model.ProfilePropertySetting;

@Asynchronous
public class GroupSynchronizationSocialProfileListener
extends ProfileListenerPlugin {
    private static final Log LOG = ExoLogger.getLogger(GroupSynchronizationSocialProfileListener.class);
    private static final String PROFILE_GROUP_NAME = "profile";
    private static final String MEMBER = "member";
    private final ProfilePropertyService profilePropertyService;
    private final OrganizationService organizationService;

    public GroupSynchronizationSocialProfileListener(ProfilePropertyService profilePropertyService, OrganizationService organizationService) {
        this.profilePropertyService = profilePropertyService;
        this.organizationService = organizationService;
    }

    public void avatarUpdated(ProfileLifeCycleEvent event) {
        this.profileUpdated(event);
    }

    public void bannerUpdated(ProfileLifeCycleEvent event) {
        this.profileUpdated(event);
    }

    public void contactSectionUpdated(ProfileLifeCycleEvent event) {
        this.profileUpdated(event);
    }

    public void experienceSectionUpdated(ProfileLifeCycleEvent event) {
        this.profileUpdated(event);
    }

    public void createProfile(ProfileLifeCycleEvent event) {
        this.profileUpdated(event);
    }

    private void profileUpdated(ProfileLifeCycleEvent profileLifeCycleEvent) {
        Profile profile = profileLifeCycleEvent.getProfile();
        try {
            User user = this.organizationService.getUserHandler().findUserByName(profile.getIdentity().getRemoteId());
            this.synchronizePropertyGroups(profileLifeCycleEvent.getProfile(), user);
        }
        catch (Exception e) {
            LOG.error("Error while synchronizing profile property of user {} to groups", new Object[]{profile.getIdentity().getRemoteId(), e});
        }
    }

    private void synchronizePropertyGroups(Profile profile, User user) {
        long startTimeUser = System.currentTimeMillis();
        try {
            Group profileGroup = this.getOrCreateGroup(PROFILE_GROUP_NAME, null);
            List<String> synchronizedProperties = this.profilePropertyService.getSynchronizedPropertySettings().stream().filter(ProfilePropertySetting::isActive).map(ProfilePropertySetting::getPropertyName).toList();
            Set properties = profile.getProperties().entrySet();
            Set<Map.Entry> propertiesToSynchronize = properties.stream().filter(property -> synchronizedProperties.contains(property.getKey())).collect(Collectors.toSet());
            propertiesToSynchronize.forEach(property -> this.synchronizeProperty((Map.Entry<String, Object>)property, profileGroup, user));
        }
        catch (Exception e) {
            LOG.error("Error while trying to add / create profile group {} for user ", new Object[]{PROFILE_GROUP_NAME, user.getUserName(), e});
        }
        LOG.debug("User {} groups synchronized from profile in {} ms", new Object[]{user.getUserName(), System.currentTimeMillis() - startTimeUser});
    }

    private void synchronizeProperty(Map.Entry<String, Object> property, Group profileGroup, User user) {
        LOG.debug("Syncrhonize property {} for user {}", new Object[]{property.getKey(), user.getUserName()});
        String propertyName = property.getKey();
        ArrayList<String> propertyValues = new ArrayList<String>();
        if (property.getValue() instanceof String) {
            if (!((String)property.getValue()).isEmpty()) {
                propertyValues.add((String)property.getValue());
            }
        } else {
            ((List)property.getValue()).stream().forEach(val -> val.entrySet().stream().filter(entry -> ((String)entry.getKey()).equals("value")).forEach(entry -> propertyValues.add((String)entry.getValue())));
        }
        try {
            Group newPropertyNameGroup = this.getOrCreateGroup(propertyName, profileGroup);
            long startTimeRemoveUserFromGroups = System.currentTimeMillis();
            this.removeUserFromExistingPropertyGroup(newPropertyNameGroup, user, propertyValues);
            LOG.debug("User {} check-remove from groups ({}) in {} ms", new Object[]{user.getUserName(), newPropertyNameGroup.getId(), System.currentTimeMillis() - startTimeRemoveUserFromGroups});
            for (String propValueName : propertyValues) {
                try {
                    Group newPropertyValueGroup = this.getOrCreateGroup(propValueName, newPropertyNameGroup);
                    long startTimeAddUserInGroups = System.currentTimeMillis();
                    this.addUserToGroup(newPropertyValueGroup, user);
                    LOG.debug("User {} check-add in group ({}/{}) in {} ms", new Object[]{user.getUserName(), newPropertyNameGroup.getId(), propValueName, System.currentTimeMillis() - startTimeAddUserInGroups});
                }
                catch (Exception e) {
                    LOG.error("Error while adding property value group {} under property Group {}", new Object[]{propValueName, newPropertyNameGroup != null ? newPropertyNameGroup.getId() : "/", e});
                }
            }
        }
        catch (Exception e) {
            LOG.error("Error while adding property group {} under profile Group {}", new Object[]{propertyName, profileGroup != null ? profileGroup.getId() : "/", e});
        }
    }

    private Group getGroup(String groupId) throws Exception {
        GroupHandler groupHandler = this.organizationService.getGroupHandler();
        return groupHandler.findGroupById(groupId);
    }

    private Group getOrCreateGroup(String groupName, Group parentGroup) throws Exception {
        String groupLabel = groupName;
        Group group = this.getGroup(this.buildGroupId(parentGroup, groupName = Utils.cleanString((String)groupName)));
        if (group != null) {
            group.setLabel(this.getGroupLabel(groupLabel, parentGroup, groupName));
            return group;
        }
        GroupHandler groupHandler = this.organizationService.getGroupHandler();
        Group newGroup = groupHandler.createGroupInstance();
        newGroup.setGroupName(groupName.toLowerCase());
        newGroup.setLabel(this.getGroupLabel(groupLabel, parentGroup, groupName));
        newGroup.setDescription(groupName + " group");
        groupHandler.addChild(parentGroup, newGroup, true);
        return this.getGroup(this.buildGroupId(parentGroup, groupName));
    }

    private String getGroupLabel(String groupLabel, Group parentGroup, String groupName) {
        String parentId;
        String profileGroup;
        if (parentGroup != null && (profileGroup = "/profile").equals(parentId = parentGroup.getParentId())) {
            String propertyName = parentGroup.getGroupName();
            ProfilePropertySetting profileSetting = this.profilePropertyService.getProfileSettingByName(propertyName);
            if (profileSetting.isDropdownList()) {
                for (ProfilePropertyOption option : profileSetting.getPropertyOptions()) {
                    if (option.getId() != Long.parseLong(groupName)) continue;
                    return option.getValue();
                }
            }
            return StringUtils.capitalize((String)groupLabel);
        }
        return StringUtils.capitalize((String)groupLabel);
    }

    private void addUserToGroup(Group group, User user) throws Exception {
        if (group == null) {
            return;
        }
        try {
            MembershipType membershipType = this.organizationService.getMembershipTypeHandler().findMembershipType(MEMBER);
            if (this.organizationService.getMembershipHandler().findMembershipByUserGroupAndType(user.getUserName(), group.getId(), MEMBER) == null) {
                this.organizationService.getMembershipHandler().linkMembership(user, group, membershipType, true);
                LOG.debug("Add user {} in group {}", new Object[]{user.getUserName(), group.getId()});
            }
        }
        catch (Exception e) {
            LOG.error("Error while adding user {} to Group {}", new Object[]{user.getUserName(), group.getId(), e});
            throw e;
        }
    }

    private void removeUserFromExistingPropertyGroup(Group group, User user, List<String> newPropertyValues) throws Exception {
        List<String> newCleanedPropertyValues = new ArrayList<String>(newPropertyValues);
        newCleanedPropertyValues = newCleanedPropertyValues.stream().map(Utils::cleanString).toList();
        MembershipHandler memberShipHandler = this.organizationService.getMembershipHandler();
        long startTimeGetMemberships = System.currentTimeMillis();
        Collection memberships = memberShipHandler.findMembershipsByUser(user.getUserName());
        LOG.debug("Find {} memberships for user {} in {} ms", new Object[]{memberships.size(), user.getUserName(), System.currentTimeMillis() - startTimeGetMemberships});
        for (Membership membership : memberships) {
            if (!membership.getGroupId().startsWith(group.getId())) continue;
            String[] splittedMembership = membership.getGroupId().split("/");
            String groupName = splittedMembership[splittedMembership.length - 1];
            if (!newCleanedPropertyValues.contains(groupName)) {
                long startTimeRemoveGroup = System.currentTimeMillis();
                memberShipHandler.removeMembership(membership.getId(), true);
                LOG.debug("Remove user {} from group {} in {} ms", new Object[]{user.getUserName(), membership.getGroupId(), System.currentTimeMillis() - startTimeRemoveGroup});
                continue;
            }
            LOG.debug("User {} is already in group {}, do nothing", new Object[]{user.getUserName(), membership.getGroupId()});
        }
    }

    private String buildGroupId(Group parentGroup, String groupName) {
        if (parentGroup == null) {
            return "/" + groupName.toLowerCase();
        }
        return parentGroup.getId() + "/" + groupName.toLowerCase();
    }
}

