/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.cms.service;

import io.meeds.portal.permlink.model.PermanentLinkObject;
import io.meeds.portal.permlink.plugin.PermanentLinkPlugin;
import io.meeds.portal.permlink.service.PermanentLinkService;
import io.meeds.portal.plugin.AclPlugin;
import io.meeds.social.AbstractSpringConfigurationTest;
import io.meeds.social.cms.model.ContentLink;
import io.meeds.social.cms.model.ContentLinkExtension;
import io.meeds.social.cms.model.ContentLinkIdentifier;
import io.meeds.social.cms.model.ContentLinkSearchResult;
import io.meeds.social.cms.model.ContentObject;
import io.meeds.social.cms.model.ContentObjectIdentifier;
import io.meeds.social.cms.plugin.ContentLinkPlugin;
import io.meeds.social.cms.service.ContentLinkPluginService;
import io.meeds.social.cms.service.ContentLinkService;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.security.Identity;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

public class ContentLinkServiceTest
extends AbstractSpringConfigurationTest {
    private static final String TEST_USER = "user";
    private static final String LINK_OBJECT_TYPE = "linkTest";
    private static final ContentLinkExtension EXTENSION = new ContentLinkExtension("linkTest", "test.link.title", "fa-icon", "command");
    private static final String LINK_OBJECT_ID = "linkId";
    private static final String CONTENT_TYPE = "contentTest";
    private static final String CONTENT_ID1 = "contentId1";
    private static final String CONTENT_ID2 = "contentId2";
    private static final String FIELD_NAME1 = "fieldName1";
    private static final String FIELD_NAME2 = "fieldName2";
    @Autowired
    private ContentLinkPluginService contentLinkPluginService;
    @Autowired
    private ContentLinkService contentLinkService;
    @Autowired
    private PermanentLinkService permanentLinkService;
    @Autowired
    private UserACL userAcl;
    private ContentLinkPlugin contentLinkPlugin;
    private boolean hasLinkPermission;
    private boolean hasContentPermission;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        if (this.contentLinkPlugin == null) {
            this.contentLinkPlugin = new ContentLinkPlugin(this){

                public ContentLinkExtension getExtension() {
                    return EXTENSION;
                }

                public String getContentTitle(String objectId, Locale locale) {
                    return "Title" + objectId;
                }

                public List<ContentLinkSearchResult> search(String keyword, Identity identity, Locale locale, int offset, int limit) {
                    return Collections.emptyList();
                }
            };
            this.contentLinkPluginService.addPlugin(this.contentLinkPlugin);
            this.permanentLinkService.addPlugin(new PermanentLinkPlugin(){

                public String getObjectType() {
                    return EXTENSION.getObjectType();
                }

                public String getDirectAccessUrl(PermanentLinkObject object) throws ObjectNotFoundException {
                    return "/uri/" + object.getObjectId();
                }

                public boolean canAccess(PermanentLinkObject object, Identity identity) throws ObjectNotFoundException {
                    return ContentLinkServiceTest.this.hasLinkPermission;
                }
            });
            this.userAcl.addAclPlugin(new AclPlugin(){

                public String getObjectType() {
                    return ContentLinkServiceTest.LINK_OBJECT_TYPE;
                }

                public boolean hasPermission(String objectId, String permissionType, Identity identity) {
                    return ContentLinkServiceTest.this.hasLinkPermission;
                }
            });
            this.userAcl.addAclPlugin(new AclPlugin(){

                public String getObjectType() {
                    return ContentLinkServiceTest.CONTENT_TYPE;
                }

                public boolean hasPermission(String objectId, String permissionType, Identity identity) {
                    return ContentLinkServiceTest.this.hasContentPermission;
                }
            });
        }
        this.contentLinkService.deleteLinks((ContentObjectIdentifier)new ContentObject(CONTENT_TYPE, CONTENT_ID1));
    }

    @Test
    public void testSaveLinks() {
        this.hasContentPermission = false;
        Assert.assertThrows(IllegalAccessException.class, () -> this.contentLinkService.saveLinks(new ContentObject(CONTENT_TYPE, CONTENT_ID1), Collections.emptyList(), TEST_USER));
        this.hasContentPermission = true;
        this.contentLinkService.saveLinks(new ContentObject(CONTENT_TYPE, CONTENT_ID1), Collections.emptyList(), TEST_USER);
        this.hasLinkPermission = false;
        List<ContentObjectIdentifier> links = Collections.singletonList(new ContentObjectIdentifier(LINK_OBJECT_TYPE, LINK_OBJECT_ID));
        Assert.assertThrows(IllegalAccessException.class, () -> this.contentLinkService.saveLinks(new ContentObject(CONTENT_TYPE, CONTENT_ID1), links, TEST_USER));
        this.hasLinkPermission = true;
        this.contentLinkService.saveLinks(new ContentObject(CONTENT_TYPE, CONTENT_ID1), links, TEST_USER);
    }

    @Test
    public void testGetLinks() {
        this.hasContentPermission = false;
        Assert.assertThrows(IllegalAccessException.class, () -> this.contentLinkService.getLinks(new ContentObject(CONTENT_TYPE, CONTENT_ID1), Locale.ENGLISH, TEST_USER));
        this.hasContentPermission = true;
        this.hasLinkPermission = true;
        List<ContentObjectIdentifier> links = Collections.singletonList(new ContentObjectIdentifier(LINK_OBJECT_TYPE, LINK_OBJECT_ID));
        this.contentLinkService.saveLinks(new ContentObject(CONTENT_TYPE, CONTENT_ID1, FIELD_NAME1), links, TEST_USER);
        this.contentLinkService.saveLinks(new ContentObject(CONTENT_TYPE, CONTENT_ID1, FIELD_NAME2), links, TEST_USER);
        this.contentLinkService.saveLinks(new ContentObject(CONTENT_TYPE, CONTENT_ID2), links, TEST_USER);
        List contentLinks = this.contentLinkService.getLinks(new ContentObject(CONTENT_TYPE, CONTENT_ID1), Locale.ENGLISH, TEST_USER);
        Assert.assertNotNull((Object)contentLinks);
        Assert.assertEquals((long)2L, (long)contentLinks.size());
        contentLinks = this.contentLinkService.getLinks(new ContentObject(CONTENT_TYPE, CONTENT_ID2), Locale.ENGLISH, TEST_USER);
        Assert.assertNotNull((Object)contentLinks);
        Assert.assertEquals((long)1L, (long)contentLinks.size());
        contentLinks = this.contentLinkService.getLinks(new ContentObject(CONTENT_TYPE, "NotExisting"), Locale.ENGLISH, TEST_USER);
        Assert.assertNotNull((Object)contentLinks);
        Assert.assertTrue((boolean)contentLinks.isEmpty());
    }

    @Test
    public void testGetLink() {
        this.hasContentPermission = false;
        Assert.assertThrows(IllegalAccessException.class, () -> this.contentLinkService.getLink(new ContentLinkIdentifier(LINK_OBJECT_TYPE, CONTENT_ID1, Locale.ENGLISH), TEST_USER));
        this.hasLinkPermission = true;
        ContentLink link = this.contentLinkService.getLink(new ContentLinkIdentifier(LINK_OBJECT_TYPE, CONTENT_ID1, Locale.ENGLISH), TEST_USER);
        Assert.assertNotNull((Object)link);
        Assert.assertEquals((Object)"TitlecontentId1", (Object)link.getTitle());
        Assert.assertEquals((Object)"/uri/contentId1", (Object)link.getUri());
    }
}

