/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.manager;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.test.AbstractCoreTest;

public class RelationshipManagerTest
extends AbstractCoreTest {
    private RelationshipManager relationshipManager;
    private Identity rootIdentity;
    private Identity johnIdentity;
    private Identity maryIdentity;
    private Identity demoIdentity;
    private Identity ghostIdentity;
    private Identity paulIdentity;
    private List<Relationship> tearDownRelationshipList;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.tearDownRelationshipList = new ArrayList<Relationship>();
        this.relationshipManager = (RelationshipManager)this.getContainer().getComponentInstanceOfType(RelationshipManager.class);
        RelationshipManagerTest.assertNotNull((String)"relationshipManager must not be null", (Object)this.relationshipManager);
        RelationshipManagerTest.assertNotNull((String)"identityManager must not be null", (Object)this.identityManager);
        this.rootIdentity = this.createOrUpdateIdentity("root");
        this.johnIdentity = this.createOrUpdateIdentity("john");
        this.maryIdentity = this.createOrUpdateIdentity("mary");
        this.demoIdentity = this.createOrUpdateIdentity("demo");
        this.ghostIdentity = this.createOrUpdateIdentity("ghost");
        this.paulIdentity = this.createOrUpdateIdentity("paul");
    }

    @Override
    protected void tearDown() throws Exception {
        for (Relationship relationship : this.tearDownRelationshipList) {
            this.relationshipManager.remove(relationship);
        }
        this.identityManager.deleteIdentity(this.rootIdentity);
        this.identityManager.deleteIdentity(this.johnIdentity);
        this.identityManager.deleteIdentity(this.maryIdentity);
        this.identityManager.deleteIdentity(this.demoIdentity);
        this.identityManager.deleteIdentity(this.ghostIdentity);
        this.identityManager.deleteIdentity(this.paulIdentity);
        super.tearDown();
    }

    public void testGetAll() throws Exception {
        this.relationshipManager.invite(this.johnIdentity, this.demoIdentity);
        List senderRelationships = this.relationshipManager.getAll(this.johnIdentity);
        List receiverRelationships = this.relationshipManager.getAll(this.demoIdentity);
        RelationshipManagerTest.assertEquals((int)1, (int)senderRelationships.size());
        RelationshipManagerTest.assertEquals((int)1, (int)receiverRelationships.size());
        this.tearDownRelationshipList.addAll(senderRelationships);
    }

    public void testGetAllWithListIdentities() throws Exception {
        ArrayList<Identity> listIdentities = new ArrayList<Identity>();
        listIdentities.add(this.rootIdentity);
        listIdentities.add(this.demoIdentity);
        listIdentities.add(this.johnIdentity);
        listIdentities.add(this.maryIdentity);
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Relationship maryToRootRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.rootIdentity);
        Relationship rootToJohnRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        List rootRelationships = this.relationshipManager.getAll(this.rootIdentity, listIdentities);
        RelationshipManagerTest.assertNotNull((String)"rootRelationships must not be null", (Object)rootRelationships);
        RelationshipManagerTest.assertEquals((String)"rootRelationships.size() must return: 3", (int)3, (int)rootRelationships.size());
        List maryRelationships = this.relationshipManager.getAll(this.maryIdentity, listIdentities);
        RelationshipManagerTest.assertNotNull((String)"maryRelationships must not be null", (Object)maryRelationships);
        RelationshipManagerTest.assertEquals((String)"maryRelationships.size() mut return: 1", (int)1, (int)maryRelationships.size());
        List johnRelationships = this.relationshipManager.getAll(this.johnIdentity, listIdentities);
        RelationshipManagerTest.assertNotNull((String)"johnRelationships must not be null", (Object)johnRelationships);
        RelationshipManagerTest.assertEquals((String)"johnRelationships.size() mut return: 1", (int)1, (int)johnRelationships.size());
        this.tearDownRelationshipList.add(rootToDemoRelationship);
        this.tearDownRelationshipList.add(maryToRootRelationship);
        this.tearDownRelationshipList.add(rootToJohnRelationship);
    }

    public void testGetAllWithTypeAndListIdentities() throws Exception {
        ArrayList<Identity> listIdentities = new ArrayList<Identity>();
        listIdentities.add(this.rootIdentity);
        listIdentities.add(this.demoIdentity);
        listIdentities.add(this.johnIdentity);
        listIdentities.add(this.maryIdentity);
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Relationship maryToRootRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.rootIdentity);
        Relationship rootToJohnRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        List rootPendingRelationships = this.relationshipManager.getAll(this.rootIdentity, Relationship.Type.PENDING, listIdentities);
        RelationshipManagerTest.assertNotNull((String)"rootPendingRelationships must not be null", (Object)rootPendingRelationships);
        RelationshipManagerTest.assertEquals((String)"rootPendingRelationships.size() must return: 3", (int)3, (int)rootPendingRelationships.size());
        List maryPendingRelationships = this.relationshipManager.getAll(this.maryIdentity, Relationship.Type.PENDING, listIdentities);
        RelationshipManagerTest.assertNotNull((String)"maryPendingRelationships must not be null", (Object)maryPendingRelationships);
        RelationshipManagerTest.assertEquals((String)"maryPendingRelationships.size() mut return: 1", (int)1, (int)maryPendingRelationships.size());
        List johnPendingRelationships = this.relationshipManager.getAll(this.maryIdentity, Relationship.Type.PENDING, listIdentities);
        RelationshipManagerTest.assertNotNull((String)"johnPendingRelationships must not be null", (Object)johnPendingRelationships);
        RelationshipManagerTest.assertEquals((String)"johnPendingRelationships.size() mut return: 1", (int)1, (int)johnPendingRelationships.size());
        this.relationshipManager.confirm(this.demoIdentity, this.rootIdentity);
        List rootConfirmedRelationships = this.relationshipManager.getAll(this.rootIdentity, Relationship.Type.CONFIRMED, listIdentities);
        RelationshipManagerTest.assertNotNull((String)"rootConfirmedRelationships must not be null", (Object)rootConfirmedRelationships);
        RelationshipManagerTest.assertEquals((String)"rootConfirmedRelationships.size() must return: 1", (int)1, (int)rootConfirmedRelationships.size());
        this.tearDownRelationshipList.add(rootToDemoRelationship);
        this.tearDownRelationshipList.add(maryToRootRelationship);
        this.tearDownRelationshipList.add(rootToJohnRelationship);
    }

    public void testGet() throws Exception {
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Relationship maryToRootRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.rootIdentity);
        Relationship rootToJohnRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        rootToDemoRelationship = this.relationshipManager.get(this.rootIdentity, this.demoIdentity);
        RelationshipManagerTest.assertNotNull((String)"rootToDemoRelationship must not be null", (Object)rootToDemoRelationship);
        RelationshipManagerTest.assertEquals((String)("rootToDemoRelationship.getSender() must return: " + String.valueOf(this.rootIdentity)), (Object)this.rootIdentity, (Object)rootToDemoRelationship.getSender());
        RelationshipManagerTest.assertEquals((String)("rootToDemoRelationship.getReceiver() must return: " + String.valueOf(this.demoIdentity)), (Object)this.demoIdentity, (Object)rootToDemoRelationship.getReceiver());
        RelationshipManagerTest.assertEquals((String)("rootToDemoRelationship.getStatus() must return: " + String.valueOf(Relationship.Type.PENDING)), (Object)Relationship.Type.PENDING, (Object)rootToDemoRelationship.getStatus());
        this.relationshipManager.confirm(this.johnIdentity, this.rootIdentity);
        rootToJohnRelationship = this.relationshipManager.get(this.johnIdentity, this.rootIdentity);
        RelationshipManagerTest.assertEquals((String)"rootToJohnRelationship.getStatus() must return: ", (Object)Relationship.Type.CONFIRMED, (Object)rootToJohnRelationship.getStatus());
        this.tearDownRelationshipList.add(rootToDemoRelationship);
        this.tearDownRelationshipList.add(maryToRootRelationship);
        this.tearDownRelationshipList.add(rootToJohnRelationship);
    }

    public void testGetWithRelationshipId() throws Exception {
        Relationship relationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        Thread.sleep(1L);
        String relationshipId = relationship.getId();
        RelationshipManagerTest.assertNotNull((Object)relationshipId);
        this.relationshipManager.confirm(this.johnIdentity, this.rootIdentity);
        relationship = this.relationshipManager.get(relationship.getId());
        RelationshipManagerTest.assertNotNull((String)"relationship must not be null", (Object)relationship);
        RelationshipManagerTest.assertEquals((String)("relationship.getStatus() must return: " + String.valueOf(Relationship.Type.CONFIRMED)), (Object)Relationship.Type.CONFIRMED, (Object)relationship.getStatus());
        this.relationshipManager.delete(relationship);
        relationship = this.relationshipManager.get(this.rootIdentity, this.johnIdentity);
        RelationshipManagerTest.assertNull((String)"relationship must be null", (Object)relationship);
        relationship = this.relationshipManager.get(relationshipId);
        RelationshipManagerTest.assertNull((String)"relationship must be null", (Object)relationship);
    }

    public void testInviteToConnect() throws Exception {
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Relationship maryToRootRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.rootIdentity);
        Relationship rootToJohnRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        rootToDemoRelationship = this.relationshipManager.get(this.rootIdentity, this.demoIdentity);
        RelationshipManagerTest.assertNotNull((String)"rootToDemoRelationship must not be null", (Object)rootToDemoRelationship);
        RelationshipManagerTest.assertEquals((String)("rootToDemoRelationship.getStatus() must return: " + String.valueOf(Relationship.Type.PENDING)), (Object)Relationship.Type.PENDING, (Object)rootToDemoRelationship.getStatus());
        maryToRootRelationship = this.relationshipManager.get(this.maryIdentity, this.rootIdentity);
        RelationshipManagerTest.assertNotNull((String)"maryToRootRelationship must not be null", (Object)maryToRootRelationship);
        RelationshipManagerTest.assertEquals((String)("maryToRootRelationship.getStatus() must return: " + String.valueOf(Relationship.Type.PENDING)), (Object)Relationship.Type.PENDING, (Object)maryToRootRelationship.getStatus());
        rootToJohnRelationship = this.relationshipManager.get(this.johnIdentity, this.rootIdentity);
        RelationshipManagerTest.assertNotNull((String)"rootToJohnRelationship must not be null", (Object)rootToJohnRelationship);
        RelationshipManagerTest.assertEquals((String)("rootToJohnRelationship.getStatus() must return: " + String.valueOf(Relationship.Type.PENDING)), (Object)Relationship.Type.PENDING, (Object)rootToJohnRelationship.getStatus());
        this.tearDownRelationshipList.add(rootToDemoRelationship);
        this.tearDownRelationshipList.add(maryToRootRelationship);
        this.tearDownRelationshipList.add(rootToJohnRelationship);
    }

    public void testDupdicateInviteToConnect() throws Exception {
        Relationship relationship1 = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Relationship relationship2 = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        RelationshipManagerTest.assertEquals((String)"relationShip1 and relationShip2 must be the same", (String)relationship1.getId(), (String)relationship2.getId());
        this.tearDownRelationshipList.add(relationship1);
    }

    public void testDupdicateInviteToConnectWithConfirmedRelationShip() throws Exception {
        Relationship relationship1 = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        RelationshipManagerTest.assertEquals((String)"RelationShip status must be PENDING", (Object)Relationship.Type.PENDING, (Object)relationship1.getStatus());
        this.relationshipManager.confirm(this.rootIdentity, this.demoIdentity);
        relationship1 = this.relationshipManager.get(this.rootIdentity, this.demoIdentity);
        RelationshipManagerTest.assertEquals((String)"RelationShip status must be CONFIRMED", (Object)Relationship.Type.CONFIRMED, (Object)relationship1.getStatus());
        Relationship relationship2 = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        RelationshipManagerTest.assertEquals((String)"RelationShip status must be CONFIRMED", (Object)Relationship.Type.CONFIRMED, (Object)relationship2.getStatus());
        RelationshipManagerTest.assertEquals((String)"relationShip1 and relationShip2 must be the same", (String)relationship1.getId(), (String)relationship2.getId());
        this.tearDownRelationshipList.add(relationship1);
    }

    public void testConfirmWithIdentity() throws Exception {
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Thread.sleep(1L);
        Relationship maryToRootRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.rootIdentity);
        Thread.sleep(1L);
        Relationship rootToJohnRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        Thread.sleep(1L);
        rootToJohnRelationship = this.relationshipManager.get(rootToJohnRelationship.getId());
        this.relationshipManager.confirm(this.rootIdentity, this.demoIdentity);
        rootToDemoRelationship = this.relationshipManager.get(this.rootIdentity, this.demoIdentity);
        RelationshipManagerTest.assertNotNull((String)"rootToDemoRelationship must not be null", (Object)rootToDemoRelationship);
        RelationshipManagerTest.assertEquals((String)("rootToDemoRelationship.getStatus() must return: " + String.valueOf(Relationship.Type.CONFIRMED)), (Object)Relationship.Type.CONFIRMED, (Object)rootToDemoRelationship.getStatus());
        this.relationshipManager.confirm(this.maryIdentity, this.rootIdentity);
        maryToRootRelationship = this.relationshipManager.get(this.maryIdentity, this.rootIdentity);
        RelationshipManagerTest.assertNotNull((String)"maryToRootRelationship must not be null", (Object)maryToRootRelationship);
        RelationshipManagerTest.assertNotNull((String)"maryToRootRelationship must not be null", (Object)maryToRootRelationship.getStatus());
        RelationshipManagerTest.assertEquals((String)("maryToRootRelationship.getStatus() must return: " + String.valueOf(Relationship.Type.CONFIRMED)), (Object)Relationship.Type.CONFIRMED, (Object)maryToRootRelationship.getStatus());
        this.relationshipManager.confirm(this.rootIdentity, this.johnIdentity);
        rootToJohnRelationship = this.relationshipManager.get(this.johnIdentity, this.rootIdentity);
        RelationshipManagerTest.assertNotNull((String)"rootToJohnRelationship must not be null", (Object)rootToJohnRelationship);
        RelationshipManagerTest.assertEquals((String)("rootToJohnRelationship.getStatus() must return: " + String.valueOf(Relationship.Type.CONFIRMED)), (Object)Relationship.Type.CONFIRMED, (Object)rootToJohnRelationship.getStatus());
        this.tearDownRelationshipList.add(rootToDemoRelationship);
        this.tearDownRelationshipList.add(maryToRootRelationship);
        this.tearDownRelationshipList.add(rootToJohnRelationship);
    }

    public void testDeny() throws Exception {
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Relationship maryToRootRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.rootIdentity);
        Relationship rootToJohnRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        this.relationshipManager.confirm(this.johnIdentity, this.rootIdentity);
        this.relationshipManager.deny(this.johnIdentity, this.rootIdentity);
        RelationshipManagerTest.assertNull((Object)this.relationshipManager.get(rootToJohnRelationship.getId()));
        this.relationshipManager.deny(this.demoIdentity, this.rootIdentity);
        rootToDemoRelationship = this.relationshipManager.get(this.rootIdentity, this.demoIdentity);
        RelationshipManagerTest.assertNull((String)"rootToDemoRelationship must be null", (Object)rootToDemoRelationship);
        this.relationshipManager.deny(this.maryIdentity, this.rootIdentity);
        maryToRootRelationship = this.relationshipManager.get(this.maryIdentity, this.rootIdentity);
        RelationshipManagerTest.assertNull((String)"maryToRootRelationship must be null", (Object)maryToRootRelationship);
        this.relationshipManager.deny(this.rootIdentity, this.johnIdentity);
        rootToJohnRelationship = this.relationshipManager.get(this.rootIdentity, this.johnIdentity);
        RelationshipManagerTest.assertNull((String)"rootToJohnRelationship must be null", (Object)rootToJohnRelationship);
    }

    public void testGetIncomingWithListAccess() throws Exception {
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Relationship maryToDemoRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.demoIdentity);
        Relationship johnToDemoRelationship = this.relationshipManager.inviteToConnect(this.johnIdentity, this.demoIdentity);
        ListAccess demoIncoming = this.relationshipManager.getIncomingWithListAccess(this.demoIdentity);
        RelationshipManagerTest.assertNotNull((String)"demoIncoming must not be null", (Object)demoIncoming);
        RelationshipManagerTest.assertEquals((String)"demoIncoming.getSize() must return: 3", (int)3, (int)demoIncoming.getSize());
        ListAccess rootIncoming = this.relationshipManager.getIncomingWithListAccess(this.rootIdentity);
        RelationshipManagerTest.assertNotNull((String)"rootIncoming must not be null", (Object)rootIncoming);
        RelationshipManagerTest.assertEquals((String)"rootIncoming.getSize() must return: 0", (int)0, (int)rootIncoming.getSize());
        ListAccess maryIncoming = this.relationshipManager.getIncomingWithListAccess(this.maryIdentity);
        RelationshipManagerTest.assertNotNull((String)"maryIncoming must not be null", (Object)maryIncoming);
        RelationshipManagerTest.assertEquals((String)"maryIncoming.getSize() must return: 0", (int)0, (int)maryIncoming.getSize());
        this.tearDownRelationshipList.add(rootToDemoRelationship);
        this.tearDownRelationshipList.add(maryToDemoRelationship);
        this.tearDownRelationshipList.add(johnToDemoRelationship);
    }

    public void testGetOutgoing() throws Exception {
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Relationship rootToMaryRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.maryIdentity);
        Relationship maryToDemoRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.demoIdentity);
        Relationship demoToJohnRelationship = this.relationshipManager.inviteToConnect(this.demoIdentity, this.johnIdentity);
        ListAccess rootOutgoing = this.relationshipManager.getOutgoing(this.rootIdentity);
        RelationshipManagerTest.assertNotNull((String)"rootOutgoing must not be null", (Object)rootOutgoing);
        RelationshipManagerTest.assertEquals((String)"rootOutgoing.getSize() must return: 2", (int)2, (int)rootOutgoing.getSize());
        ListAccess maryOutgoing = this.relationshipManager.getOutgoing(this.maryIdentity);
        RelationshipManagerTest.assertNotNull((String)"maryOutgoing must not be null", (Object)maryOutgoing);
        RelationshipManagerTest.assertEquals((String)"maryOutgoing.getSize() must return: 1", (int)1, (int)maryOutgoing.getSize());
        ListAccess demoOutgoing = this.relationshipManager.getOutgoing(this.demoIdentity);
        RelationshipManagerTest.assertNotNull((String)"demoOutgoing must not be null", (Object)demoOutgoing);
        RelationshipManagerTest.assertEquals((String)"demoOutgoing.getSize() must return: 1", (int)1, (int)demoOutgoing.getSize());
        this.tearDownRelationshipList.add(rootToDemoRelationship);
        this.tearDownRelationshipList.add(maryToDemoRelationship);
        this.tearDownRelationshipList.add(demoToJohnRelationship);
        this.tearDownRelationshipList.add(rootToMaryRelationship);
    }

    public void testGetStatus() throws Exception {
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Relationship maryToRootRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.rootIdentity);
        Relationship rootToJohnRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        rootToDemoRelationship = this.relationshipManager.get(this.rootIdentity, this.demoIdentity);
        RelationshipManagerTest.assertNotNull((String)"rootToDemoRelationship must not be null", (Object)rootToDemoRelationship);
        RelationshipManagerTest.assertEquals((String)("rootToDemoRelationship.getStatus() must return: " + String.valueOf(Relationship.Type.PENDING)), (Object)Relationship.Type.PENDING, (Object)rootToDemoRelationship.getStatus());
        RelationshipManagerTest.assertEquals((String)("relationshipManager.getStatus(rootIdentity, demoIdentity) must return: " + String.valueOf(Relationship.Type.PENDING)), (Object)Relationship.Type.PENDING, (Object)this.relationshipManager.getStatus(this.rootIdentity, this.demoIdentity));
        maryToRootRelationship = this.relationshipManager.get(this.maryIdentity, this.rootIdentity);
        RelationshipManagerTest.assertNotNull((String)"maryToRootRelationship must not be null", (Object)maryToRootRelationship);
        RelationshipManagerTest.assertEquals((String)("maryToRootRelationship.getStatus() must return: " + String.valueOf(Relationship.Type.PENDING)), (Object)Relationship.Type.PENDING, (Object)maryToRootRelationship.getStatus());
        RelationshipManagerTest.assertEquals((String)("relationshipManager.getStatus(maryIdentity, rootIdentity) must return: " + String.valueOf(Relationship.Type.PENDING)), (Object)Relationship.Type.PENDING, (Object)this.relationshipManager.getStatus(this.maryIdentity, this.rootIdentity));
        rootToJohnRelationship = this.relationshipManager.get(this.johnIdentity, this.rootIdentity);
        RelationshipManagerTest.assertNotNull((String)"rootToJohnRelationship must not be null", (Object)rootToJohnRelationship);
        RelationshipManagerTest.assertEquals((String)("rootToJohnRelationship.getStatus() must return: " + String.valueOf(Relationship.Type.PENDING)), (Object)Relationship.Type.PENDING, (Object)rootToJohnRelationship.getStatus());
        RelationshipManagerTest.assertEquals((String)("relationshipManager.getStatus(rootIdentity, johnIdentity) must return: " + String.valueOf(Relationship.Type.PENDING)), (Object)Relationship.Type.PENDING, (Object)this.relationshipManager.getStatus(this.rootIdentity, this.johnIdentity));
        this.tearDownRelationshipList.add(rootToDemoRelationship);
        this.tearDownRelationshipList.add(maryToRootRelationship);
        this.tearDownRelationshipList.add(rootToJohnRelationship);
    }

    public void testGetAllWithListAccess() throws Exception {
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Relationship maryToRootRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.rootIdentity);
        Relationship rootToJohnRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        ListAccess rootRelationships = this.relationshipManager.getAllWithListAccess(this.rootIdentity);
        RelationshipManagerTest.assertNotNull((String)"rootRelationships must not be null", (Object)rootRelationships);
        RelationshipManagerTest.assertEquals((String)"rootRelationships.getSize() must return: 3", (int)3, (int)rootRelationships.getSize());
        ListAccess demoRelationships = this.relationshipManager.getAllWithListAccess(this.demoIdentity);
        RelationshipManagerTest.assertNotNull((String)"demoRelationships must not be null", (Object)demoRelationships);
        RelationshipManagerTest.assertEquals((String)"demoRelationships.getSize() must return: 1", (int)1, (int)demoRelationships.getSize());
        ListAccess johnRelationships = this.relationshipManager.getAllWithListAccess(this.johnIdentity);
        RelationshipManagerTest.assertNotNull((String)"johnRelationships must not be null", (Object)johnRelationships);
        RelationshipManagerTest.assertEquals((String)"johnRelationships.getSize() must return: 1", (int)1, (int)johnRelationships.getSize());
        this.tearDownRelationshipList.add(rootToDemoRelationship);
        this.tearDownRelationshipList.add(maryToRootRelationship);
        this.tearDownRelationshipList.add(rootToJohnRelationship);
    }

    public void testGetRelationshipById() throws Exception {
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        rootToDemoRelationship = this.relationshipManager.getRelationshipById(rootToDemoRelationship.getId());
        RelationshipManagerTest.assertNotNull((String)"rootToDemoRelationship must not be null", (Object)rootToDemoRelationship);
        RelationshipManagerTest.assertEquals((String)("rootToDemoRelationship.getSender() must return: " + String.valueOf(this.rootIdentity)), (Object)this.rootIdentity, (Object)rootToDemoRelationship.getSender());
        RelationshipManagerTest.assertEquals((String)("rootToDemoRelationship.getReceiver() must return: " + String.valueOf(this.demoIdentity)), (Object)this.demoIdentity, (Object)rootToDemoRelationship.getReceiver());
        this.tearDownRelationshipList.add(rootToDemoRelationship);
    }

    public void testDenyWithRelationship() throws Exception {
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Relationship maryToRootRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.rootIdentity);
        Relationship rootToJohnRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        this.relationshipManager.deny(rootToDemoRelationship);
        rootToDemoRelationship = this.relationshipManager.get(this.rootIdentity, this.demoIdentity);
        RelationshipManagerTest.assertNull((String)"rootToDemoRelationship must be null", (Object)rootToDemoRelationship);
        this.relationshipManager.deny(maryToRootRelationship);
        maryToRootRelationship = this.relationshipManager.get(this.maryIdentity, this.rootIdentity);
        RelationshipManagerTest.assertNull((String)"maryToRootRelationship must be null", (Object)maryToRootRelationship);
        this.relationshipManager.deny(rootToJohnRelationship);
        rootToJohnRelationship = this.relationshipManager.get(this.rootIdentity, this.johnIdentity);
        RelationshipManagerTest.assertNull((String)"rootToJohnRelationship must be null", (Object)rootToJohnRelationship);
    }

    public void testGetPendingRelationships() throws Exception {
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Relationship maryToRootRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.rootIdentity);
        Relationship rootToJohnRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        List rootPendingRelationships = this.relationshipManager.getPendingRelationships(this.rootIdentity);
        RelationshipManagerTest.assertNotNull((String)"rootPendingRelationships must not be null", (Object)rootPendingRelationships);
        RelationshipManagerTest.assertEquals((String)"rootPendingRelationships.size() must return: 2", (int)2, (int)rootPendingRelationships.size());
        List maryPendingRelationships = this.relationshipManager.getPendingRelationships(this.maryIdentity);
        RelationshipManagerTest.assertNotNull((String)"maryPendingRelationships must not be null", (Object)maryPendingRelationships);
        RelationshipManagerTest.assertEquals((String)"maryPendingRelationships.size() must return: 1", (int)1, (int)maryPendingRelationships.size());
        List demoPendingRelationships = this.relationshipManager.getPendingRelationships(this.demoIdentity);
        RelationshipManagerTest.assertNotNull((String)"demoPendingRelationships must not be null", (Object)demoPendingRelationships);
        RelationshipManagerTest.assertEquals((String)"demoPendingRelationships.size() must return: 0", (int)0, (int)demoPendingRelationships.size());
        List johnPendingRelationships = this.relationshipManager.getPendingRelationships(this.johnIdentity);
        RelationshipManagerTest.assertNotNull((String)"johnPendingRelationships must not be null", (Object)johnPendingRelationships);
        RelationshipManagerTest.assertEquals((String)"johnPendingRelationships.size() must return: 0", (int)0, (int)johnPendingRelationships.size());
        this.tearDownRelationshipList.add(rootToDemoRelationship);
        this.tearDownRelationshipList.add(maryToRootRelationship);
        this.tearDownRelationshipList.add(rootToJohnRelationship);
    }

    public void testGetPendingRelationshipWithSentOrReceived() throws Exception {
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Relationship maryToRootRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.rootIdentity);
        Relationship rootToJohnRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        List rootPendingRelationships = this.relationshipManager.getPendingRelationships(this.rootIdentity, true);
        RelationshipManagerTest.assertNotNull((String)"rootPendingRelationships must not be null", (Object)rootPendingRelationships);
        RelationshipManagerTest.assertEquals((String)"rootPendingRelationships.size() must return: 3", (int)3, (int)rootPendingRelationships.size());
        List maryPendingRelationships = this.relationshipManager.getPendingRelationships(this.maryIdentity, true);
        RelationshipManagerTest.assertNotNull((String)"maryPendingRelationships must not be null", (Object)maryPendingRelationships);
        RelationshipManagerTest.assertEquals((String)"maryPendingRelationships.size() must return: 1", (int)1, (int)maryPendingRelationships.size());
        List demoPendingRelationships = this.relationshipManager.getPendingRelationships(this.demoIdentity, true);
        RelationshipManagerTest.assertNotNull((String)"demoPendingRelationships must not be null", (Object)demoPendingRelationships);
        RelationshipManagerTest.assertEquals((String)"demoPendingRelationships.size() must return: 1", (int)1, (int)demoPendingRelationships.size());
        List johnPendingRelationships = this.relationshipManager.getPendingRelationships(this.johnIdentity, true);
        RelationshipManagerTest.assertNotNull((String)"johnPendingRelationships must not be null", (Object)johnPendingRelationships);
        RelationshipManagerTest.assertEquals((String)"johnPendingRelationships.size() must return: 1", (int)1, (int)johnPendingRelationships.size());
        this.tearDownRelationshipList.add(rootToDemoRelationship);
        this.tearDownRelationshipList.add(maryToRootRelationship);
        this.tearDownRelationshipList.add(rootToJohnRelationship);
    }

    public void testGetPendingRealtionshipWithListIdentities() throws Exception {
        ArrayList<Identity> identities = new ArrayList<Identity>();
        identities.add(this.rootIdentity);
        identities.add(this.demoIdentity);
        identities.add(this.johnIdentity);
        identities.add(this.maryIdentity);
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Relationship maryToRootRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.rootIdentity);
        Relationship rootToJohnRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        List rootPendingRelationships = this.relationshipManager.getPendingRelationships(this.rootIdentity, identities, true);
        RelationshipManagerTest.assertNotNull((String)"rootPendingRelationships must not be null", (Object)rootPendingRelationships);
        RelationshipManagerTest.assertEquals((String)"rootPendingRelationships.size() must return: 3", (int)3, (int)rootPendingRelationships.size());
        List maryPendingRelationships = this.relationshipManager.getPendingRelationships(this.maryIdentity, identities, true);
        RelationshipManagerTest.assertNotNull((String)"maryPendingRelationships must not be null", (Object)maryPendingRelationships);
        RelationshipManagerTest.assertEquals((String)"maryPendingRelationships.size() must return: 1", (int)1, (int)maryPendingRelationships.size());
        List demoPendingRelationships = this.relationshipManager.getPendingRelationships(this.demoIdentity, identities, true);
        RelationshipManagerTest.assertNotNull((String)"demoPendingRelationships must not be null", (Object)demoPendingRelationships);
        RelationshipManagerTest.assertEquals((String)"demoPendingRelationships.size() must return: 1", (int)1, (int)demoPendingRelationships.size());
        List johnPendingRelationships = this.relationshipManager.getPendingRelationships(this.johnIdentity, identities, true);
        RelationshipManagerTest.assertNotNull((String)"johnPendingRelationships must not be null", (Object)johnPendingRelationships);
        RelationshipManagerTest.assertEquals((String)"johnPendingRelationships.size() must return: 1", (int)1, (int)johnPendingRelationships.size());
        this.tearDownRelationshipList.add(rootToDemoRelationship);
        this.tearDownRelationshipList.add(maryToRootRelationship);
        this.tearDownRelationshipList.add(rootToJohnRelationship);
    }

    public void testGetContactsWithListIdentities() throws Exception {
        ArrayList<Identity> identities = new ArrayList<Identity>();
        identities.add(this.rootIdentity);
        identities.add(this.demoIdentity);
        identities.add(this.johnIdentity);
        identities.add(this.maryIdentity);
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Relationship maryToRootRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.rootIdentity);
        Relationship rootToJohnRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        this.relationshipManager.confirm(this.rootIdentity, this.demoIdentity);
        this.relationshipManager.confirm(this.maryIdentity, this.rootIdentity);
        this.relationshipManager.confirm(this.rootIdentity, this.johnIdentity);
        List rootContacts = this.relationshipManager.getContacts(this.rootIdentity, identities);
        RelationshipManagerTest.assertNotNull((String)"rootContacts must not be null", (Object)rootContacts);
        RelationshipManagerTest.assertEquals((String)"rootContacts.size() must return: 3", (int)3, (int)rootContacts.size());
        List demoContacts = this.relationshipManager.getContacts(this.demoIdentity, identities);
        RelationshipManagerTest.assertNotNull((String)"demoContacts must not be null", (Object)demoContacts);
        RelationshipManagerTest.assertEquals((String)"demoContacts.size() must return: 1", (int)1, (int)demoContacts.size());
        List maryContacts = this.relationshipManager.getContacts(this.maryIdentity, identities);
        RelationshipManagerTest.assertNotNull((String)"maryContacts must not be null", (Object)maryContacts);
        RelationshipManagerTest.assertEquals((String)"maryContacts.size() must return: 1", (int)1, (int)maryContacts.size());
        List johnContacts = this.relationshipManager.getContacts(this.johnIdentity, identities);
        RelationshipManagerTest.assertNotNull((String)"johnContacts must not be null", (Object)johnContacts);
        RelationshipManagerTest.assertEquals((String)"johnContacts.size() must return: 1", (int)1, (int)johnContacts.size());
        this.tearDownRelationshipList.add(rootToDemoRelationship);
        this.tearDownRelationshipList.add(maryToRootRelationship);
        this.tearDownRelationshipList.add(rootToJohnRelationship);
    }

    public void testGetContacts() throws Exception {
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Relationship maryToRootRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.rootIdentity);
        Relationship rootToJohnRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        this.relationshipManager.confirm(this.rootIdentity, this.demoIdentity);
        this.relationshipManager.confirm(this.maryIdentity, this.rootIdentity);
        this.relationshipManager.confirm(this.rootIdentity, this.johnIdentity);
        List rootContacts = this.relationshipManager.getContacts(this.rootIdentity);
        RelationshipManagerTest.assertNotNull((String)"rootContacts must not be null", (Object)rootContacts);
        RelationshipManagerTest.assertEquals((String)"rootContacts.size() must return: 3", (int)3, (int)rootContacts.size());
        List demoContacts = this.relationshipManager.getContacts(this.demoIdentity);
        RelationshipManagerTest.assertNotNull((String)"demoContacts must not be null", (Object)demoContacts);
        RelationshipManagerTest.assertEquals((String)"demoContacts.size() must return: 1", (int)1, (int)demoContacts.size());
        List maryContacts = this.relationshipManager.getContacts(this.maryIdentity);
        RelationshipManagerTest.assertNotNull((String)"maryContacts must not be null", (Object)maryContacts);
        RelationshipManagerTest.assertEquals((String)"maryContacts.size() must return: 1", (int)1, (int)maryContacts.size());
        List johnContacts = this.relationshipManager.getContacts(this.johnIdentity);
        RelationshipManagerTest.assertNotNull((String)"johnContacts must not be null", (Object)johnContacts);
        RelationshipManagerTest.assertEquals((String)"johnContacts.size() must return: 1", (int)1, (int)johnContacts.size());
        this.tearDownRelationshipList.add(rootToDemoRelationship);
        this.tearDownRelationshipList.add(maryToRootRelationship);
        this.tearDownRelationshipList.add(rootToJohnRelationship);
    }

    public void testGetAllRelationships() throws Exception {
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Relationship maryToRootRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.rootIdentity);
        Relationship rootToJohnRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        List rootRelationships = this.relationshipManager.getAllRelationships(this.rootIdentity);
        RelationshipManagerTest.assertNotNull((String)"rootRelationships must not be null", (Object)rootRelationships);
        RelationshipManagerTest.assertEquals((String)"rootRelationships.size() must return: 3", (int)3, (int)rootRelationships.size());
        List maryRelationships = this.relationshipManager.getAllRelationships(this.maryIdentity);
        RelationshipManagerTest.assertNotNull((String)"maryRelationships must not be null", (Object)maryRelationships);
        RelationshipManagerTest.assertEquals((String)"maryRelationships.size() must return: 1", (int)1, (int)maryRelationships.size());
        List demoRelationships = this.relationshipManager.getAllRelationships(this.demoIdentity);
        RelationshipManagerTest.assertNotNull((String)"demoRelationships must not be null", (Object)demoRelationships);
        RelationshipManagerTest.assertEquals((String)"demoRelationships.size() must return: 1", (int)1, (int)demoRelationships.size());
        List johnRelationships = this.relationshipManager.getAllRelationships(this.johnIdentity);
        RelationshipManagerTest.assertNotNull((String)"johnRelationships must not be null", (Object)johnRelationships);
        RelationshipManagerTest.assertEquals((String)"johnRelationships.size() must return: 1", (int)1, (int)johnRelationships.size());
        this.tearDownRelationshipList.add(rootToDemoRelationship);
        this.tearDownRelationshipList.add(maryToRootRelationship);
        this.tearDownRelationshipList.add(rootToJohnRelationship);
    }

    public void testGetRelationshipsByIdentityId() throws Exception {
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Relationship maryToRootRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.rootIdentity);
        Relationship rootToJohnRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        List rootRelationships = this.relationshipManager.getRelationshipsByIdentityId(this.rootIdentity.getId());
        RelationshipManagerTest.assertNotNull((String)"rootRelationships must not be null", (Object)rootRelationships);
        RelationshipManagerTest.assertEquals((String)"rootRelationships.size() must return: 3", (int)3, (int)rootRelationships.size());
        this.tearDownRelationshipList.add(rootToDemoRelationship);
        this.tearDownRelationshipList.add(maryToRootRelationship);
        this.tearDownRelationshipList.add(rootToJohnRelationship);
    }

    public void testGetIdentities() throws Exception {
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Relationship maryToRootRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.rootIdentity);
        Relationship rootToJohnRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        this.relationshipManager.confirm(this.rootIdentity, this.demoIdentity);
        this.relationshipManager.confirm(this.maryIdentity, this.rootIdentity);
        this.relationshipManager.confirm(this.rootIdentity, this.johnIdentity);
        List rootConnections = this.relationshipManager.getIdentities(this.rootIdentity);
        RelationshipManagerTest.assertNotNull((String)"rootConnections must not be null", (Object)rootConnections);
        RelationshipManagerTest.assertEquals((String)"rootConnections.size() must return: 3", (int)3, (int)rootConnections.size());
        this.tearDownRelationshipList.add(rootToDemoRelationship);
        this.tearDownRelationshipList.add(maryToRootRelationship);
        this.tearDownRelationshipList.add(rootToJohnRelationship);
    }

    public void testGetRelationship() throws Exception {
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        rootToDemoRelationship = this.relationshipManager.getRelationship(this.rootIdentity, this.demoIdentity);
        RelationshipManagerTest.assertNotNull((String)"rootToDemoRelationship must not be null", (Object)rootToDemoRelationship);
        RelationshipManagerTest.assertEquals((String)("rootToDemoRelationship.getStatus() must return: " + String.valueOf(Relationship.Type.PENDING)), (Object)Relationship.Type.PENDING, (Object)rootToDemoRelationship.getStatus());
        this.relationshipManager.confirm(this.rootIdentity, this.demoIdentity);
        rootToDemoRelationship = this.relationshipManager.getRelationship(this.rootIdentity, this.demoIdentity);
        RelationshipManagerTest.assertNotNull((String)"rootToDemoRelationship must not be null", (Object)rootToDemoRelationship);
        RelationshipManagerTest.assertEquals((String)("rootToDemoRelationship.getStatus() must return: " + String.valueOf(Relationship.Type.CONFIRMED)), (Object)Relationship.Type.CONFIRMED, (Object)rootToDemoRelationship.getStatus());
        this.tearDownRelationshipList.add(rootToDemoRelationship);
    }

    public void testFindRelationships() throws Exception {
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Relationship maryToRootRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.rootIdentity);
        Relationship rootToJohnRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        List rootRelationships = this.relationshipManager.findRelationships(this.rootIdentity, Relationship.Type.PENDING);
        RelationshipManagerTest.assertNotNull((String)"rootRelationships must not be null", (Object)rootRelationships);
        RelationshipManagerTest.assertEquals((String)"rootRelationships.size() must return: 3", (int)3, (int)rootRelationships.size());
        this.relationshipManager.confirm(this.rootIdentity, this.demoIdentity);
        rootRelationships = this.relationshipManager.findRelationships(this.rootIdentity, Relationship.Type.CONFIRMED);
        RelationshipManagerTest.assertNotNull((String)"rootRelationships must not be null", (Object)rootRelationships);
        RelationshipManagerTest.assertEquals((String)"rootRelationships.size() must return: 1", (int)1, (int)rootRelationships.size());
        this.tearDownRelationshipList.add(rootToDemoRelationship);
        this.tearDownRelationshipList.add(maryToRootRelationship);
        this.tearDownRelationshipList.add(rootToJohnRelationship);
    }

    public void testGetRelationshipStatus() throws Exception {
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        RelationshipManagerTest.assertEquals((String)("relationshipManager.getRelationshipStatus(rootToDemoRelationship, rootIdentity) must return: " + String.valueOf(Relationship.Type.PENDING)), (Object)Relationship.Type.PENDING, (Object)this.relationshipManager.getRelationshipStatus(rootToDemoRelationship, this.rootIdentity));
        this.relationshipManager.confirm(this.rootIdentity, this.demoIdentity);
        rootToDemoRelationship = this.relationshipManager.get(this.rootIdentity, this.demoIdentity);
        RelationshipManagerTest.assertEquals((String)("relationshipManager.getRelationshipStatus(rootToDemoRelationship, rootIdentity) must return: " + String.valueOf(Relationship.Type.PENDING)), (Object)Relationship.Type.CONFIRMED, (Object)this.relationshipManager.getRelationshipStatus(rootToDemoRelationship, this.rootIdentity));
        this.tearDownRelationshipList.add(rootToDemoRelationship);
    }

    public void testGetConnectionStatus() throws Exception {
        Relationship rootToDemoRelationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        RelationshipManagerTest.assertEquals((String)("relationshipManager.getConnectionStatus(rootIdentity, demoIdentity) must return: " + String.valueOf(Relationship.Type.PENDING)), (Object)Relationship.Type.PENDING, (Object)this.relationshipManager.getConnectionStatus(this.rootIdentity, this.demoIdentity));
        this.relationshipManager.confirm(this.rootIdentity, this.demoIdentity);
        RelationshipManagerTest.assertEquals((String)("relationshipManager.getConnectionStatus(rootIdentity, demoIdentity) must return: " + String.valueOf(Relationship.Type.CONFIRMED)), (Object)Relationship.Type.CONFIRMED, (Object)this.relationshipManager.getConnectionStatus(this.rootIdentity, this.demoIdentity));
        this.tearDownRelationshipList.add(rootToDemoRelationship);
    }

    public void testIntiveAndGetByRelationshipId() throws Exception {
        Relationship invitedRelationship = this.relationshipManager.invite(this.johnIdentity, this.maryIdentity);
        Relationship foundRelationship = this.relationshipManager.get(invitedRelationship.getId());
        RelationshipManagerTest.assertNotNull((String)"foundRelationship must not be null", (Object)foundRelationship);
        RelationshipManagerTest.assertNotNull((String)"foundRelationship.getId() must not be null", (Object)foundRelationship.getId());
        RelationshipManagerTest.assertEquals((String)foundRelationship.getId(), (String)invitedRelationship.getId());
        this.tearDownRelationshipList.add(invitedRelationship);
    }

    public void testGetPendingWithIdentity() throws Exception {
        Relationship johnDemoRelationship = this.relationshipManager.invite(this.johnIdentity, this.demoIdentity);
        Relationship johnMaryRelationship = this.relationshipManager.invite(this.johnIdentity, this.maryIdentity);
        Relationship johnRootRelationship = this.relationshipManager.invite(this.johnIdentity, this.rootIdentity);
        List foundListRelationships = this.relationshipManager.getPending(this.johnIdentity);
        RelationshipManagerTest.assertNotNull((String)"foundListRelationships must not be null", (Object)foundListRelationships);
        RelationshipManagerTest.assertEquals((int)3, (int)foundListRelationships.size());
        this.tearDownRelationshipList.add(johnDemoRelationship);
        this.tearDownRelationshipList.add(johnMaryRelationship);
        this.tearDownRelationshipList.add(johnRootRelationship);
    }

    public void testGetPendingAndIncoming() throws Exception {
        Relationship johnDemoRelationship = this.relationshipManager.invite(this.johnIdentity, this.demoIdentity);
        Relationship johnMaryRelationship = this.relationshipManager.invite(this.johnIdentity, this.maryIdentity);
        Relationship johnRootRelationship = this.relationshipManager.invite(this.johnIdentity, this.rootIdentity);
        List listPendingRelationship = this.relationshipManager.getPending(this.johnIdentity);
        RelationshipManagerTest.assertNotNull((String)"listRelationshipConfirm must not be null", (Object)listPendingRelationship);
        RelationshipManagerTest.assertEquals((int)3, (int)listPendingRelationship.size());
        List listMaryRequireValidationRelationship = this.relationshipManager.getIncoming(this.maryIdentity);
        RelationshipManagerTest.assertEquals((int)1, (int)listMaryRequireValidationRelationship.size());
        this.tearDownRelationshipList.add(johnDemoRelationship);
        this.tearDownRelationshipList.add(johnMaryRelationship);
        this.tearDownRelationshipList.add(johnRootRelationship);
    }

    public void testGetPendingAndIncomingWithListIdentities() throws Exception {
        Relationship johnDemoRelationship = this.relationshipManager.invite(this.johnIdentity, this.demoIdentity);
        Relationship johnMaryRelationship = this.relationshipManager.invite(this.johnIdentity, this.maryIdentity);
        Relationship johnRootRelationship = this.relationshipManager.invite(this.johnIdentity, this.rootIdentity);
        Relationship maryDemoRelationship = this.relationshipManager.invite(this.maryIdentity, this.demoIdentity);
        Thread.sleep(5L);
        this.restartTransaction();
        ArrayList<Identity> listIdentities = new ArrayList<Identity>();
        listIdentities.add(this.demoIdentity);
        listIdentities.add(this.maryIdentity);
        listIdentities.add(this.johnIdentity);
        listIdentities.add(this.rootIdentity);
        List listRelationshipConfirm = this.relationshipManager.getPending(this.johnIdentity, listIdentities);
        RelationshipManagerTest.assertEquals((int)3, (int)listRelationshipConfirm.size());
        List listRelationshipNotConfirm = this.relationshipManager.getIncoming(this.demoIdentity, listIdentities);
        RelationshipManagerTest.assertEquals((int)2, (int)listRelationshipNotConfirm.size());
        this.tearDownRelationshipList.add(johnDemoRelationship);
        this.tearDownRelationshipList.add(johnMaryRelationship);
        this.tearDownRelationshipList.add(johnRootRelationship);
        this.tearDownRelationshipList.add(maryDemoRelationship);
    }

    public void testGetConfirmedWithIdentity() throws Exception {
        List johnContacts = this.relationshipManager.getConfirmed(this.johnIdentity);
        RelationshipManagerTest.assertNotNull((String)"johnContacts must not be null", (Object)johnContacts);
        RelationshipManagerTest.assertEquals((String)"johnContacts.size() must be 0", (int)0, (int)johnContacts.size());
        Relationship johnDemoRelationship = this.relationshipManager.invite(this.johnIdentity, this.demoIdentity);
        Relationship johnMaryRelationship = this.relationshipManager.invite(this.johnIdentity, this.maryIdentity);
        Relationship johnRootRelationship = this.relationshipManager.invite(this.johnIdentity, this.rootIdentity);
        this.relationshipManager.confirm(johnDemoRelationship);
        this.relationshipManager.confirm(johnMaryRelationship);
        this.relationshipManager.confirm(johnRootRelationship);
        List contactsList = this.relationshipManager.getConfirmed(this.johnIdentity);
        RelationshipManagerTest.assertEquals((int)3, (int)contactsList.size());
        this.tearDownRelationshipList.add(johnDemoRelationship);
        this.tearDownRelationshipList.add(johnMaryRelationship);
        this.tearDownRelationshipList.add(johnRootRelationship);
    }

    public void testGetConfirmedWithIdentityAndListIdentity() throws Exception {
        Relationship johnDemoRelationship = this.relationshipManager.invite(this.johnIdentity, this.demoIdentity);
        Relationship johnMaryRelationship = this.relationshipManager.invite(this.johnIdentity, this.maryIdentity);
        Relationship johnRootRelationship = this.relationshipManager.invite(this.johnIdentity, this.rootIdentity);
        this.relationshipManager.confirm(johnDemoRelationship);
        this.relationshipManager.confirm(johnMaryRelationship);
        this.relationshipManager.confirm(johnRootRelationship);
        ArrayList<Identity> listIdentities = new ArrayList<Identity>();
        listIdentities.add(this.demoIdentity);
        listIdentities.add(this.maryIdentity);
        listIdentities.add(this.johnIdentity);
        listIdentities.add(this.rootIdentity);
        List contactsList = this.relationshipManager.getConfirmed(this.johnIdentity, listIdentities);
        RelationshipManagerTest.assertEquals((int)3, (int)contactsList.size());
        this.tearDownRelationshipList.add(johnDemoRelationship);
        this.tearDownRelationshipList.add(johnMaryRelationship);
        this.tearDownRelationshipList.add(johnRootRelationship);
    }

    public void testInviteRelationship() throws Exception {
        Relationship relationship = this.relationshipManager.invite(this.johnIdentity, this.maryIdentity);
        RelationshipManagerTest.assertNotNull((Object)relationship.getId());
        RelationshipManagerTest.assertEquals((Object)Relationship.Type.PENDING, (Object)relationship.getStatus());
        List senderRelationships = this.relationshipManager.getAll(this.johnIdentity);
        List receiverRelationships = this.relationshipManager.getAll(this.maryIdentity);
        RelationshipManagerTest.assertEquals((int)1, (int)senderRelationships.size());
        RelationshipManagerTest.assertEquals((int)1, (int)receiverRelationships.size());
        this.tearDownRelationshipList.addAll(senderRelationships);
    }

    public void testConfirm() throws Exception {
        Relationship relationship = this.relationshipManager.invite(this.johnIdentity, this.demoIdentity);
        this.relationshipManager.confirm(relationship);
        relationship = this.relationshipManager.get(this.johnIdentity, this.demoIdentity);
        RelationshipManagerTest.assertNotNull((Object)relationship.getId());
        RelationshipManagerTest.assertEquals((Object)Relationship.Type.CONFIRMED, (Object)relationship.getStatus());
        List senderRelationships = this.relationshipManager.getAll(this.johnIdentity);
        List receiverRelationships = this.relationshipManager.getAll(this.demoIdentity);
        RelationshipManagerTest.assertEquals((int)1, (int)senderRelationships.size());
        RelationshipManagerTest.assertEquals((int)1, (int)receiverRelationships.size());
        this.tearDownRelationshipList.addAll(senderRelationships);
    }

    public void testDelete() throws Exception {
        Relationship relationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        this.relationshipManager.confirm(this.johnIdentity, this.rootIdentity);
        this.relationshipManager.delete(relationship);
        relationship = this.relationshipManager.get(this.rootIdentity, this.johnIdentity);
        RelationshipManagerTest.assertNull((String)"relationship must be null", (Object)relationship);
    }

    public void testRemove() throws Exception {
        Relationship relationship = this.relationshipManager.invite(this.rootIdentity, this.johnIdentity);
        this.relationshipManager.confirm(relationship);
        this.relationshipManager.remove(relationship);
        relationship = this.relationshipManager.get(this.rootIdentity, this.johnIdentity);
        RelationshipManagerTest.assertNull((String)"relationship must be null", (Object)relationship);
    }

    public void testGetPending() throws Exception {
        Relationship rootDemo = this.relationshipManager.invite(this.rootIdentity, this.demoIdentity);
        RelationshipManagerTest.assertNotNull((String)"rootDemo.getId() must not be null", (Object)rootDemo.getId());
        Relationship rootJohn = this.relationshipManager.invite(this.rootIdentity, this.johnIdentity);
        RelationshipManagerTest.assertNotNull((String)"rootJohn.getId() must not be null", (Object)rootJohn.getId());
        Relationship rootMary = this.relationshipManager.invite(this.rootIdentity, this.maryIdentity);
        RelationshipManagerTest.assertNotNull((String)"rootMary.getId() must not be null", (Object)rootMary.getId());
        Relationship demoMary = this.relationshipManager.invite(this.demoIdentity, this.maryIdentity);
        RelationshipManagerTest.assertNotNull((String)"demoMary.getId() must not be null", (Object)demoMary.getId());
        Relationship demoJohn = this.relationshipManager.invite(this.demoIdentity, this.johnIdentity);
        RelationshipManagerTest.assertNotNull((String)"demoJohn.getId() must not be null", (Object)demoJohn.getId());
        Relationship johnDemo = this.relationshipManager.invite(this.johnIdentity, this.demoIdentity);
        RelationshipManagerTest.assertNotNull((String)"johnDemo.getId() must not be null", (Object)johnDemo.getId());
        List rootRelationships = this.relationshipManager.getPending(this.rootIdentity);
        List demoRelationships = this.relationshipManager.getPending(this.demoIdentity);
        List johnRelationships = this.relationshipManager.getPending(this.johnIdentity);
        RelationshipManagerTest.assertEquals((int)3, (int)rootRelationships.size());
        RelationshipManagerTest.assertEquals((int)2, (int)demoRelationships.size());
        RelationshipManagerTest.assertEquals((int)0, (int)johnRelationships.size());
        this.tearDownRelationshipList.add(rootDemo);
        this.tearDownRelationshipList.add(rootJohn);
        this.tearDownRelationshipList.add(rootMary);
        this.tearDownRelationshipList.add(demoMary);
        this.tearDownRelationshipList.add(demoJohn);
    }

    public void testSavedCached() throws Exception {
        Relationship rootDemo = this.relationshipManager.get(this.rootIdentity, this.demoIdentity);
        RelationshipManagerTest.assertNull((String)"rootDemo must be null", (Object)rootDemo);
        Relationship rootDemo2 = this.relationshipManager.get(this.demoIdentity, this.rootIdentity);
        RelationshipManagerTest.assertNull((String)"rootDemo must be null", (Object)rootDemo2);
        Relationship.Type rootDemoStatus = this.relationshipManager.getStatus(this.demoIdentity, this.rootIdentity);
        RelationshipManagerTest.assertNull((String)"rootDemoStatus must be null", (Object)rootDemoStatus);
        rootDemo = this.relationshipManager.invite(this.rootIdentity, this.demoIdentity);
        RelationshipManagerTest.assertNotNull((String)"rootDemo.getId() must not be null", (Object)rootDemo.getId());
        RelationshipManagerTest.assertEquals((Object)rootDemo.getStatus(), (Object)Relationship.Type.PENDING);
        this.tearDownRelationshipList.add(rootDemo);
        Relationship rootMary = this.relationshipManager.get(this.rootIdentity, this.maryIdentity);
        Relationship.Type rootMaryStatus = this.relationshipManager.getStatus(this.maryIdentity, this.rootIdentity);
        RelationshipManagerTest.assertNull((String)"rootMary must be null", (Object)rootMary);
        RelationshipManagerTest.assertNull((String)"rootMaryStatus must be null", (Object)rootMaryStatus);
        rootMary = this.relationshipManager.invite(this.rootIdentity, this.maryIdentity);
        RelationshipManagerTest.assertNotNull((String)"rootMary.getId() must not be null", (Object)rootMary.getId());
        RelationshipManagerTest.assertEquals((Object)Relationship.Type.PENDING, (Object)rootMary.getStatus());
        this.tearDownRelationshipList.add(rootMary);
        Relationship rootJohn = this.relationshipManager.get(this.rootIdentity, this.johnIdentity);
        RelationshipManagerTest.assertNull((String)"rootJohn must be null", (Object)rootJohn);
        RelationshipManagerTest.assertNull((String)"rootMaryStatus must be null", (Object)rootMaryStatus);
        rootJohn = this.relationshipManager.invite(this.rootIdentity, this.johnIdentity);
        RelationshipManagerTest.assertNotNull((String)"rootJohn.getId() must not be null", (Object)rootJohn.getId());
        RelationshipManagerTest.assertEquals((Object)Relationship.Type.PENDING, (Object)rootJohn.getStatus());
        this.tearDownRelationshipList.add(rootJohn);
        Relationship demoMary = this.relationshipManager.get(this.demoIdentity, this.maryIdentity);
        Relationship.Type demoMaryStatus = this.relationshipManager.getStatus(this.maryIdentity, this.demoIdentity);
        RelationshipManagerTest.assertNull((String)"demoMary must be null", (Object)demoMary);
        RelationshipManagerTest.assertNull((String)"demoMaryStatus must be null", (Object)demoMaryStatus);
        demoMary = this.relationshipManager.invite(this.demoIdentity, this.maryIdentity);
        RelationshipManagerTest.assertNotNull((String)"demoMary.getId() must not be null", (Object)demoMary.getId());
        RelationshipManagerTest.assertEquals((Object)Relationship.Type.PENDING, (Object)demoMary.getStatus());
        this.tearDownRelationshipList.add(demoMary);
    }

    public void testGetLastConnections() throws Exception {
        Relationship maryToGhostRelationship = this.relationshipManager.inviteToConnect(this.ghostIdentity, this.maryIdentity);
        this.relationshipManager.confirm(this.maryIdentity, this.ghostIdentity);
        Thread.sleep(1L);
        Relationship maryToDemoRelationship = this.relationshipManager.inviteToConnect(this.demoIdentity, this.maryIdentity);
        this.relationshipManager.confirm(this.maryIdentity, this.demoIdentity);
        Thread.sleep(1L);
        Relationship paulToMaryRelationship = this.relationshipManager.inviteToConnect(this.paulIdentity, this.maryIdentity);
        this.relationshipManager.confirm(this.maryIdentity, this.paulIdentity);
        List identities = this.relationshipManager.getLastConnections(this.maryIdentity, 10);
        RelationshipManagerTest.assertEquals((int)3, (int)identities.size());
        RelationshipManagerTest.assertEquals((String)this.paulIdentity.getRemoteId(), (String)((Identity)identities.get(0)).getRemoteId());
        RelationshipManagerTest.assertEquals((String)this.demoIdentity.getRemoteId(), (String)((Identity)identities.get(1)).getRemoteId());
        RelationshipManagerTest.assertEquals((String)this.ghostIdentity.getRemoteId(), (String)((Identity)identities.get(2)).getRemoteId());
        Thread.sleep(1L);
        Relationship johnToMaryRelationship = this.relationshipManager.inviteToConnect(this.maryIdentity, this.johnIdentity);
        this.relationshipManager.confirm(this.johnIdentity, this.maryIdentity);
        identities = this.relationshipManager.getLastConnections(this.maryIdentity, 10);
        RelationshipManagerTest.assertEquals((int)4, (int)identities.size());
        RelationshipManagerTest.assertEquals((String)this.johnIdentity.getRemoteId(), (String)((Identity)identities.get(0)).getRemoteId());
        this.tearDownRelationshipList.add(maryToGhostRelationship);
        this.tearDownRelationshipList.add(maryToDemoRelationship);
        this.tearDownRelationshipList.add(paulToMaryRelationship);
        this.tearDownRelationshipList.add(johnToMaryRelationship);
    }
}

