/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.manager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.container.xml.ValuesParam;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.common.RealtimeListAccess;
import org.exoplatform.social.core.ActivityTypePlugin;
import org.exoplatform.social.core.activity.ActivityFilter;
import org.exoplatform.social.core.activity.ActivityStreamType;
import org.exoplatform.social.core.activity.ActivitySystemTypePlugin;
import org.exoplatform.social.core.activity.model.ActivityShareAction;
import org.exoplatform.social.core.activity.model.ActivityStream;
import org.exoplatform.social.core.activity.model.ActivityStreamImpl;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.jpa.search.ProfileSearchConnector;
import org.exoplatform.social.core.jpa.storage.RDBMSIdentityStorageImpl;
import org.exoplatform.social.core.jpa.storage.SpaceStorage;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.ActivityManagerImpl;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.ActivityStorageException;
import org.exoplatform.social.core.storage.api.ActivityStorage;
import org.exoplatform.social.core.storage.cache.CachedActivityStorage;
import org.exoplatform.social.core.storage.cache.CachedIdentityStorage;
import org.exoplatform.social.core.test.AbstractCoreTest;
import org.exoplatform.social.metadata.favorite.FavoriteService;
import org.exoplatform.social.metadata.favorite.model.Favorite;
import org.junit.Assert;
import org.mockito.Mockito;

public class ActivityManagerTest
extends AbstractCoreTest {
    private static final Log LOG = ExoLogger.getLogger(ActivityManagerTest.class);
    private SpaceStorage spaceStorage;
    private ActivityManager activityManager;
    private RelationshipManager relationshipManager;
    private ActivityStorage activityStorage;
    private UserACL userACL;
    private ProfileSearchConnector mockProfileSearch = (ProfileSearchConnector)Mockito.mock(ProfileSearchConnector.class);
    private org.exoplatform.social.core.identity.model.Identity rootIdentity;
    private org.exoplatform.social.core.identity.model.Identity johnIdentity;
    private org.exoplatform.social.core.identity.model.Identity maryIdentity;
    private org.exoplatform.social.core.identity.model.Identity demoIdentity;
    private org.exoplatform.social.core.identity.model.Identity ghostIdentity;
    private org.exoplatform.social.core.identity.model.Identity raulIdentity;
    private org.exoplatform.social.core.identity.model.Identity jamesIdentity;
    private org.exoplatform.social.core.identity.model.Identity paulIdentity;
    private org.exoplatform.social.core.identity.model.Identity jameIdentity;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.identityManager = (IdentityManager)this.getContainer().getComponentInstanceOfType(IdentityManager.class);
        this.activityManager = (ActivityManager)this.getContainer().getComponentInstanceOfType(ActivityManager.class);
        this.relationshipManager = (RelationshipManager)this.getContainer().getComponentInstanceOfType(RelationshipManager.class);
        this.activityStorage = (ActivityStorage)this.getContainer().getComponentInstanceOfType(ActivityStorage.class);
        this.userACL = (UserACL)this.getContainer().getComponentInstanceOfType(UserACL.class);
        this.spaceService = (SpaceService)this.getContainer().getComponentInstanceOfType(SpaceService.class);
        this.spaceStorage = this.getService(SpaceStorage.class);
        CachedIdentityStorage identityStorage = this.getService(CachedIdentityStorage.class);
        ((RDBMSIdentityStorageImpl)identityStorage.getStorage()).setProfileSearchConnector(this.mockProfileSearch);
        this.rootIdentity = this.identityManager.getOrCreateIdentity("organization", "root");
        this.johnIdentity = this.identityManager.getOrCreateIdentity("organization", "john");
        this.maryIdentity = this.identityManager.getOrCreateIdentity("organization", "mary");
        this.demoIdentity = this.identityManager.getOrCreateIdentity("organization", "demo");
        this.ghostIdentity = this.identityManager.getOrCreateIdentity("organization", "ghost");
        this.raulIdentity = this.identityManager.getOrCreateIdentity("organization", "raul");
        this.jamesIdentity = this.identityManager.getOrCreateIdentity("organization", "james");
        this.paulIdentity = this.identityManager.getOrCreateIdentity("organization", "paul");
        this.rootIdentity = this.createIdentity("root");
        this.johnIdentity = this.createIdentity("john");
        this.maryIdentity = this.createIdentity("mary");
        this.demoIdentity = this.createIdentity("demo");
        this.ghostIdentity = this.createIdentity("ghost");
        this.raulIdentity = this.createIdentity("raul");
        this.jameIdentity = this.createIdentity("jame");
        this.paulIdentity = this.createIdentity("paul");
        PropertyManager.setProperty((String)"exo.activity-type.cs-calendar:spaces.enabled", (String)"false");
        PropertyManager.setProperty((String)"exo.activity-type.MY_ACTIVITY.enabled", (String)"false");
        ((ActivityManagerImpl)this.activityManager).initActivityTypes();
    }

    public void testSaveActivityNoReturn() {
        String activityTitle = "activity title";
        String userId = this.johnIdentity.getId();
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        LinkedHashMap<String, String> templateParams = new LinkedHashMap<String, String>();
        templateParams.put("key1", "value 1");
        templateParams.put("key2", "value 2");
        templateParams.put("key3", "value 3");
        activity.setTemplateParams(templateParams);
        activity.setTitle(activityTitle);
        activity.setUserId(userId);
        activity.isHidden(false);
        activity.isLocked(true);
        this.activityManager.saveActivityNoReturn(this.johnIdentity, (ExoSocialActivity)activity);
        activity = this.activityManager.getActivity(activity.getId());
        ActivityManagerTest.assertNotNull((String)"activity must not be null", (Object)activity);
        ActivityManagerTest.assertEquals((String)("activity.getTitle() must return: " + activityTitle), (String)activityTitle, (String)activity.getTitle());
        ActivityManagerTest.assertEquals((String)("activity.getUserId() must return: " + userId), (String)userId, (String)activity.getUserId());
        Map gotTemplateParams = activity.getTemplateParams();
        ArrayList values = new ArrayList(gotTemplateParams.values());
        ActivityManagerTest.assertEquals((String)"value 1", (String)((String)values.get(0)));
        ActivityManagerTest.assertEquals((String)"value 2", (String)((String)values.get(1)));
        ActivityManagerTest.assertEquals((String)"value 3", (String)((String)values.get(2)));
        ActivityManagerTest.assertTrue((boolean)activity.isLocked());
        ActivityManagerTest.assertFalse((boolean)activity.isHidden());
    }

    public void testSaveActivitiesNoReturnNotStreamOwner() {
        String activityTitle = "activity title";
        String userId = this.johnIdentity.getId();
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle(activityTitle);
        activity.setUserId(userId);
        this.activityManager.saveActivityNoReturn((ExoSocialActivity)activity);
        activity = this.activityManager.getActivity(activity.getId());
        ActivityManagerTest.assertNotNull((String)"activity must not be null", (Object)activity);
        ActivityManagerTest.assertEquals((String)("activity.getTitle() must return: " + activityTitle), (String)activityTitle, (String)activity.getTitle());
        ActivityManagerTest.assertEquals((String)("activity.getUserId() must return: " + userId), (String)userId, (String)activity.getUserId());
    }

    public void testShouldNotEditActivityWhenHasJoinedComment() throws Exception {
        Identity identity = new Identity("root");
        String activityTitle = "activity title";
        String userId = this.rootIdentity.getId();
        ExoSocialActivity activity = this.createActivity();
        activity.setTitle(activityTitle);
        activity.setUserId(userId);
        this.activityManager.saveActivityNoReturn(activity);
        activity = this.activityManager.getActivity(activity.getId());
        ExoSocialActivity comment = this.createComment(activity, "exosocial:spaces", "has_joined");
        boolean isEditable = this.activityManager.isActivityEditable(comment, identity);
        ActivityManagerTest.assertFalse((boolean)isEditable);
        this.activityManager.deleteComment(activity, comment);
        this.activityManager.deleteActivity(activity);
    }

    public void testShouldNotEditActivityWhenSpaceDescriptionEditedComment() throws Exception {
        Identity identity = new Identity("root");
        String activityTitle = "activity title";
        String userId = this.rootIdentity.getId();
        ExoSocialActivity activity = this.createActivity();
        activity.setTitle(activityTitle);
        activity.setUserId(userId);
        this.activityManager.saveActivityNoReturn(activity);
        activity = this.activityManager.getActivity(activity.getId());
        ExoSocialActivity comment = this.createComment(activity, "exosocial:spaces", "space_description_edited");
        boolean isEditable = this.activityManager.isActivityEditable(comment, identity);
        ActivityManagerTest.assertFalse((boolean)isEditable);
        this.activityManager.deleteComment(activity, comment);
        this.activityManager.deleteActivity(activity);
    }

    public void testShouldEditActivityWhenPostComment() throws Exception {
        Identity identity = new Identity("root");
        String activityTitle = "activity title";
        String userId = this.rootIdentity.getId();
        ExoSocialActivity activity = this.createActivity();
        activity.setTitle(activityTitle);
        activity.setUserId(userId);
        this.activityManager.saveActivityNoReturn(activity);
        activity = this.activityManager.getActivity(activity.getId());
        ExoSocialActivity comment = this.createComment(activity, "exosocial:spaces", "text comment");
        boolean isEditable = this.activityManager.isActivityEditable(comment, identity);
        ActivityManagerTest.assertTrue((boolean)isEditable);
        this.activityManager.deleteComment(activity, comment);
        this.activityManager.deleteActivity(activity);
    }

    public void testShouldNotEditActivityWhenWikiSpacePostedComment() throws Exception {
        Identity identity = new Identity("root");
        String activityTitle = "activity title";
        String userId = this.rootIdentity.getId();
        ExoSocialActivity activity = this.createActivity();
        activity.setTitle(activityTitle);
        activity.setUserId(userId);
        this.activityManager.saveActivityNoReturn(activity);
        activity = this.activityManager.getActivity(activity.getId());
        InitParams params = new InitParams();
        ValuesParam param = new ValuesParam();
        param.setName("system.types");
        param.setValues(Collections.singletonList("ks-wiki:spaces"));
        params.addParameter((Parameter)param);
        ActivitySystemTypePlugin plugin = new ActivitySystemTypePlugin(params);
        this.activityManager.addSystemActivityDefinition(plugin);
        ExoSocialActivity comment = this.createComment(activity, "ks-wiki:spaces", "text comment");
        boolean isEditable = this.activityManager.isActivityEditable(comment, identity);
        ActivityManagerTest.assertFalse((boolean)isEditable);
        this.activityManager.deleteComment(activity, comment);
        this.activityManager.deleteActivity(activity);
    }

    public void testCanPostOnStream() throws Exception {
        Identity rootACLIdentity = new Identity("root");
        Identity johnACLIdentity = new Identity("john", Collections.singleton(new MembershipEntry("/platform/administrators", "*")));
        Identity demoACLIdentity = new Identity("demo");
        Identity jamesACLIdentity = new Identity("james");
        Identity maryACLIdentity = new Identity("mary");
        ConversationState.setCurrent((ConversationState)new ConversationState(demoACLIdentity));
        InitParams params = new InitParams();
        ValueParam param = new ValueParam();
        param.setName("userStreamComposer.enabled");
        params.addParameter((Parameter)param);
        param.setValue("false");
        ActivityManagerImpl activityManager = new ActivityManagerImpl(this.activityStorage, this.identityManager, this.spaceService, this.userACL, params);
        ActivityManagerTest.assertFalse((boolean)activityManager.isEnableUserComposer());
        ActivityManagerTest.assertFalse((boolean)activityManager.canPostActivityInStream(demoACLIdentity, this.demoIdentity));
        ActivityManagerTest.assertFalse((boolean)activityManager.canPostActivityInStream(rootACLIdentity, this.rootIdentity));
        ActivityManagerTest.assertFalse((boolean)activityManager.canPostActivityInStream(rootACLIdentity, this.demoIdentity));
        param.setValue("true");
        activityManager = new ActivityManagerImpl(this.activityStorage, this.identityManager, this.spaceService, this.userACL, params);
        ActivityManagerTest.assertTrue((boolean)activityManager.isEnableUserComposer());
        ActivityManagerTest.assertTrue((boolean)activityManager.canPostActivityInStream(demoACLIdentity, this.demoIdentity));
        ActivityManagerTest.assertFalse((boolean)activityManager.canPostActivityInStream(rootACLIdentity, this.demoIdentity));
        Space space = this.createSpace("spaceTest", "demo", "james");
        org.exoplatform.social.core.identity.model.Identity spaceIdentity = new org.exoplatform.social.core.identity.model.Identity("space", space.getPrettyName());
        ActivityManagerTest.assertTrue((boolean)activityManager.canPostActivityInStream(rootACLIdentity, spaceIdentity));
        ActivityManagerTest.assertTrue((boolean)activityManager.canPostActivityInStream(johnACLIdentity, spaceIdentity));
        ActivityManagerTest.assertTrue((boolean)activityManager.canPostActivityInStream(demoACLIdentity, spaceIdentity));
        ActivityManagerTest.assertTrue((boolean)activityManager.canPostActivityInStream(jamesACLIdentity, spaceIdentity));
        ActivityManagerTest.assertFalse((boolean)activityManager.canPostActivityInStream(maryACLIdentity, spaceIdentity));
        space.setMembers(new String[]{"demo", "james", "mary"});
        space.setRedactors(new String[]{"james"});
        this.spaceService.updateSpace(space);
        ActivityManagerTest.assertTrue((boolean)activityManager.canPostActivityInStream(rootACLIdentity, spaceIdentity));
        ActivityManagerTest.assertTrue((boolean)activityManager.canPostActivityInStream(johnACLIdentity, spaceIdentity));
        ActivityManagerTest.assertTrue((boolean)activityManager.canPostActivityInStream(demoACLIdentity, spaceIdentity));
        ActivityManagerTest.assertTrue((boolean)activityManager.canPostActivityInStream(jamesACLIdentity, spaceIdentity));
        ActivityManagerTest.assertFalse((boolean)activityManager.canPostActivityInStream(maryACLIdentity, spaceIdentity));
    }

    public void testShareActivity() throws Exception {
        Space originalSpace = this.createSpace("OriginalSpace", "john", "john", "demo");
        ExoSocialActivityImpl originalActivity = new ExoSocialActivityImpl();
        originalActivity.setTitle("Test original Activity");
        originalActivity.setUserId(this.johnIdentity.getId());
        org.exoplatform.social.core.identity.model.Identity spaceIdentity = this.identityManager.getOrCreateSpaceIdentity(originalSpace.getPrettyName());
        this.activityManager.saveActivityNoReturn(spaceIdentity, (ExoSocialActivity)originalActivity);
        originalActivity = this.activityManager.getActivity(originalActivity.getId());
        ActivityManagerTest.assertTrue((boolean)CollectionUtils.isEmpty((Collection)originalActivity.getShareActions()));
        Space targetSpace = this.createSpace("TargetSpace", "james", "demo");
        String shareMessage = "share Message";
        String type = "sharedActivityTest";
        Identity johnSecurityIdentity = new Identity("john");
        Identity demoSecurityIdentity = new Identity("demo");
        Identity jamesSecurityIdentity = new Identity("james");
        Identity marySecurityIdentity = new Identity("mary");
        ExoSocialActivityImpl shareActivityTemplate = new ExoSocialActivityImpl();
        shareActivityTemplate.setTitle(shareMessage);
        shareActivityTemplate.setType(type);
        try {
            this.activityManager.shareActivity((ExoSocialActivity)shareActivityTemplate, originalActivity.getId(), Arrays.asList(targetSpace.getPrettyName()), marySecurityIdentity);
            ActivityManagerTest.fail((String)"Mary is not member of target space");
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        try {
            this.activityManager.shareActivity((ExoSocialActivity)shareActivityTemplate, "25556", Arrays.asList(targetSpace.getPrettyName()), demoSecurityIdentity);
            ActivityManagerTest.fail((String)"Activity id shouldn't be found");
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
        try {
            this.activityManager.shareActivity((ExoSocialActivity)shareActivityTemplate, originalActivity.getId(), Arrays.asList(targetSpace.getPrettyName()), jamesSecurityIdentity);
            ActivityManagerTest.fail((String)"James shouldn't be able to access original activity");
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        try {
            this.activityManager.shareActivity((ExoSocialActivity)shareActivityTemplate, originalActivity.getId(), Arrays.asList("5496632"), demoSecurityIdentity);
            ActivityManagerTest.fail((String)"Fake space pretty name shouldn't be found");
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
        try {
            this.activityManager.shareActivity((ExoSocialActivity)shareActivityTemplate, originalActivity.getId(), Arrays.asList("5496632"), demoSecurityIdentity);
            ActivityManagerTest.fail((String)"Fake space pretty name shouldn't be found");
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
        try {
            this.activityManager.shareActivity((ExoSocialActivity)shareActivityTemplate, null, Arrays.asList("5496632"), demoSecurityIdentity);
            ActivityManagerTest.fail((String)"Activity id should be mandatory");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.activityManager.shareActivity((ExoSocialActivity)shareActivityTemplate, originalActivity.getId(), new ArrayList(), demoSecurityIdentity);
            ActivityManagerTest.fail((String)"Spaces should be mandatory");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.activityManager.shareActivity((ExoSocialActivity)shareActivityTemplate, originalActivity.getId(), Arrays.asList("5496632"), null);
            ActivityManagerTest.fail((String)"User identity is mandatory");
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        originalActivity = this.activityManager.getActivity(originalActivity.getId());
        ActivityManagerTest.assertTrue((boolean)CollectionUtils.isEmpty((Collection)originalActivity.getShareActions()));
        List sharedActivities = this.activityManager.shareActivity((ExoSocialActivity)shareActivityTemplate, originalActivity.getId(), Arrays.asList(targetSpace.getPrettyName()), demoSecurityIdentity);
        ActivityManagerTest.assertNotNull((Object)sharedActivities);
        ActivityManagerTest.assertEquals((int)1, (int)sharedActivities.size());
        ExoSocialActivity sharedactivity = (ExoSocialActivity)sharedActivities.get(0);
        ActivityManagerTest.assertNotNull((Object)sharedactivity);
        ActivityManagerTest.assertNotNull((Object)sharedactivity.getId());
        ActivityManagerTest.assertNotNull((Object)sharedactivity.getTitle());
        ActivityManagerTest.assertEquals((String)type, (String)sharedactivity.getType());
        ActivityManagerTest.assertEquals((String)shareMessage, (String)sharedactivity.getTitle());
        ActivityManagerTest.assertEquals((String)targetSpace.getPrettyName(), (String)sharedactivity.getStreamOwner());
        ActivityManagerTest.assertNotNull((Object)sharedactivity.getTemplateParams());
        ActivityManagerTest.assertEquals((String)originalActivity.getId(), (String)((String)sharedactivity.getTemplateParams().get("originalActivityId")));
        sharedactivity = this.activityManager.getActivity(sharedactivity.getId());
        ActivityManagerTest.assertNotNull((Object)sharedactivity.getTitle());
        ActivityManagerTest.assertEquals((String)type, (String)sharedactivity.getType());
        ActivityManagerTest.assertEquals((String)shareMessage, (String)sharedactivity.getTitle());
        ActivityManagerTest.assertEquals((String)targetSpace.getPrettyName(), (String)sharedactivity.getStreamOwner());
        ActivityManagerTest.assertNotNull((Object)sharedactivity.getTemplateParams());
        ActivityManagerTest.assertEquals((String)originalActivity.getId(), (String)((String)sharedactivity.getTemplateParams().get("originalActivityId")));
        originalActivity = this.activityManager.getActivity(originalActivity.getId());
        Set shareActions = originalActivity.getShareActions();
        ActivityManagerTest.assertTrue((boolean)CollectionUtils.isNotEmpty((Collection)shareActions));
        ActivityManagerTest.assertEquals((int)1, (int)shareActions.size());
        ActivityShareAction shareAction = (ActivityShareAction)shareActions.iterator().next();
        ActivityManagerTest.assertEquals((String)originalActivity.getId(), (String)String.valueOf(shareAction.getActivityId()));
        ActivityManagerTest.assertEquals((String)this.demoIdentity.getId(), (String)String.valueOf(shareAction.getUserIdentityId()));
        ActivityManagerTest.assertEquals((String)shareMessage, (String)String.valueOf(shareAction.getMessage()));
        ActivityManagerTest.assertNotNull((Object)shareAction.getSharedActivityIds());
        ActivityManagerTest.assertEquals((int)1, (int)shareAction.getSharedActivityIds().size());
        ActivityManagerTest.assertEquals((String)sharedactivity.getId(), (String)String.valueOf(shareAction.getSharedActivityIds().iterator().next()));
        ActivityManagerTest.assertNotNull((Object)shareAction.getSpaceIds());
        ActivityManagerTest.assertEquals((int)1, (int)shareAction.getSpaceIds().size());
        ActivityManagerTest.assertEquals((String)targetSpace.getId(), (String)String.valueOf(shareAction.getSpaceIds().iterator().next()));
        sharedActivities = this.activityManager.shareActivity(null, originalActivity.getId(), Arrays.asList(targetSpace.getPrettyName()), demoSecurityIdentity);
        ActivityManagerTest.assertNotNull((Object)sharedActivities);
        ActivityManagerTest.assertEquals((int)1, (int)sharedActivities.size());
        this.spaceService.updateSpace(targetSpace);
        this.spaceService.addRedactor(targetSpace, "james");
        try {
            this.activityManager.shareActivity((ExoSocialActivity)shareActivityTemplate, originalActivity.getId(), Arrays.asList(targetSpace.getPrettyName()), demoSecurityIdentity);
            ActivityManagerTest.fail((String)"Demo is not redactor of target space anymore");
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        targetSpace.setRedactors(new String[]{"james", "demo"});
        this.spaceService.updateSpace(targetSpace);
        sharedActivities = this.activityManager.shareActivity(null, originalActivity.getId(), Arrays.asList(targetSpace.getPrettyName()), demoSecurityIdentity);
        ActivityManagerTest.assertNotNull((Object)sharedActivities);
        ActivityManagerTest.assertEquals((int)1, (int)sharedActivities.size());
    }

    public void testGetActivity() {
        String activityTitle = "title";
        String userId = this.rootIdentity.getId();
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle(activityTitle);
        activity.setUserId(userId);
        this.activityManager.saveActivityNoReturn(this.rootIdentity, (ExoSocialActivity)activity);
        activity = this.activityManager.getActivity(activity.getId());
        ActivityManagerTest.assertNotNull((String)"activity must not be null", (Object)activity);
        ActivityManagerTest.assertEquals((String)("activity.getTitle() must return: " + activityTitle), (String)activityTitle, (String)activity.getTitle());
        ActivityManagerTest.assertEquals((String)("activity.getUserId() must return: " + userId), (String)userId, (String)activity.getUserId());
    }

    public void testGetParentActivities() {
        this.populateActivityMass(this.demoIdentity, 1);
        RealtimeListAccess activitiesWithListAccess = this.activityManager.getActivitiesWithListAccess(this.demoIdentity);
        ActivityManagerTest.assertNotNull((Object)activitiesWithListAccess);
        ActivityManagerTest.assertTrue((activitiesWithListAccess.getSize() > 0 ? 1 : 0) != 0);
        ExoSocialActivity demoActivity = ((ExoSocialActivity[])activitiesWithListAccess.load(0, 1))[0];
        ActivityManagerTest.assertNotNull((String)"demoActivity must be false", (Object)demoActivity);
        ActivityManagerTest.assertNull((Object)this.activityManager.getParentActivity(demoActivity));
        ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
        comment.setTitle("comment");
        comment.setUserId(this.demoIdentity.getId());
        this.activityManager.saveComment(demoActivity, (ExoSocialActivity)comment);
        ExoSocialActivity gotComment = ((ExoSocialActivity[])this.activityManager.getCommentsWithListAccess(demoActivity).load(0, 1))[0];
        ActivityManagerTest.assertNotNull((String)"gotComment must not be null", (Object)gotComment);
        ExoSocialActivity parentActivity = this.activityManager.getParentActivity(gotComment);
        ActivityManagerTest.assertNotNull((String)"parentActivity must not be null", (Object)parentActivity);
        ActivityManagerTest.assertEquals((String)("parentActivity.getId() must return: " + demoActivity.getId()), (String)demoActivity.getId(), (String)parentActivity.getId());
        ActivityManagerTest.assertEquals((String)("parentActivity.getTitle() must return: " + demoActivity.getTitle()), (String)demoActivity.getTitle(), (String)parentActivity.getTitle());
        ActivityManagerTest.assertEquals((String)("parentActivity.getUserId() must return: " + demoActivity.getUserId()), (String)demoActivity.getUserId(), (String)parentActivity.getUserId());
    }

    public void testUpdateActivities() {
        String activityTitle = "activity title";
        String userId = this.johnIdentity.getId();
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle(activityTitle);
        activity.setUserId(userId);
        this.activityManager.saveActivityNoReturn(this.johnIdentity, (ExoSocialActivity)activity);
        activity = this.activityManager.getActivity(activity.getId());
        ActivityManagerTest.assertNotNull((String)"activity must not be null", (Object)activity);
        ActivityManagerTest.assertEquals((String)("activity.getTitle() must return: " + activityTitle), (String)activityTitle, (String)activity.getTitle());
        ActivityManagerTest.assertEquals((String)("activity.getUserId() must return: " + userId), (String)userId, (String)activity.getUserId());
        String newTitle = "new activity title";
        activity.setTitle(newTitle);
        this.activityManager.updateActivity((ExoSocialActivity)activity);
        activity = this.activityManager.getActivity(activity.getId());
        ActivityManagerTest.assertNotNull((String)"activity must not be null", (Object)activity);
        ActivityManagerTest.assertEquals((String)("activity.getTitle() must return: " + newTitle), (String)newTitle, (String)activity.getTitle());
        ActivityManagerTest.assertEquals((String)("activity.getUserId() must return: " + userId), (String)userId, (String)activity.getUserId());
    }

    public void testDeleteActivities() {
        String activityTitle = "activity title";
        String userId = this.johnIdentity.getId();
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle(activityTitle);
        activity.setUserId(userId);
        this.activityManager.saveActivityNoReturn(this.johnIdentity, (ExoSocialActivity)activity);
        activity = this.activityManager.getActivity(activity.getId());
        ActivityManagerTest.assertNotNull((String)"activity must not be null", (Object)activity);
        ActivityManagerTest.assertEquals((String)("activity.getTitle() must return: " + activityTitle), (String)activityTitle, (String)activity.getTitle());
        ActivityManagerTest.assertEquals((String)("activity.getUserId() must return: " + userId), (String)userId, (String)activity.getUserId());
        this.activityManager.deleteActivity((ExoSocialActivity)activity);
    }

    public void testDeleteActivitiesWithId() {
        String activityTitle = "activity title";
        String userId = this.johnIdentity.getId();
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle(activityTitle);
        activity.setUserId(userId);
        this.activityManager.saveActivityNoReturn(this.johnIdentity, (ExoSocialActivity)activity);
        activity = this.activityManager.getActivity(activity.getId());
        ActivityManagerTest.assertNotNull((String)"activity must not be null", (Object)activity);
        ActivityManagerTest.assertEquals((String)("activity.getTitle() must return: " + activityTitle), (String)activityTitle, (String)activity.getTitle());
        ActivityManagerTest.assertEquals((String)("activity.getUserId() must return: " + userId), (String)userId, (String)activity.getUserId());
        this.activityManager.deleteActivity(activity.getId());
    }

    public void testHideActivity() {
        String activityTitle = "activity title";
        String userId = this.johnIdentity.getId();
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle(activityTitle);
        activity.setUserId(userId);
        this.activityManager.saveActivityNoReturn(this.johnIdentity, (ExoSocialActivity)activity);
        activity = this.activityManager.getActivity(activity.getId());
        ActivityManagerTest.assertNotNull((String)"activity must not be null", (Object)activity);
        RealtimeListAccess activities = this.activityManager.getActivityFeedWithListAccess(this.johnIdentity);
        ActivityManagerTest.assertEquals((int)1, (int)activities.getSize());
        this.activityManager.hideActivity(activity.getId());
        activities = this.activityManager.getActivityFeedWithListAccess(this.johnIdentity);
        ActivityManagerTest.assertEquals((int)0, (int)activities.getSize());
        activity = this.activityManager.getActivity(activity.getId());
        ActivityManagerTest.assertNotNull((String)"Should be able to access activity even when hidden", (Object)activity);
    }

    public void testPinActivity() throws Exception {
        String activityTitle = "activity title";
        String userId = this.johnIdentity.getId();
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle(activityTitle);
        activity.setUserId(userId);
        Space space = this.createSpace("spaceTestPin", "john", new String[0]);
        org.exoplatform.social.core.identity.model.Identity spaceIdentity = this.identityManager.getOrCreateSpaceIdentity(space.getPrettyName());
        this.activityManager.saveActivityNoReturn(spaceIdentity, (ExoSocialActivity)activity);
        this.activityManager.pinActivity(activity.getId(), this.johnIdentity.getId());
        ActivityFilter activityFilter = new ActivityFilter();
        activityFilter.setPinned(true);
        activityFilter.setStreamType(ActivityStreamType.USER_STREAM);
        RealtimeListAccess activitiesListAccess = this.activityManager.getActivitiesByFilterWithListAccess(this.johnIdentity, activityFilter);
        List activities = activitiesListAccess.loadAsList(0, activitiesListAccess.getSize());
        ActivityManagerTest.assertEquals((int)1, (int)activities.size());
        ActivityManagerTest.assertTrue((boolean)((ExoSocialActivity)activities.get(0)).isPinned());
        this.activityManager.unpinActivity(activity.getId());
        activitiesListAccess = this.activityManager.getActivitiesByFilterWithListAccess(this.johnIdentity, activityFilter);
        activities = activitiesListAccess.loadAsList(0, activitiesListAccess.getSize());
        ActivityManagerTest.assertEquals((int)0, (int)activities.size());
    }

    public void testLoadSpaceActivities() {
        String activityTitle = "activity title";
        String userId = this.johnIdentity.getId();
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle(activityTitle);
        activity.setUserId(userId);
        Space space = this.createSpace("spaceTestActivity", "john", "demo");
        org.exoplatform.social.core.identity.model.Identity spaceIdentity = this.identityManager.getOrCreateSpaceIdentity(space.getPrettyName());
        this.activityManager.saveActivityNoReturn(spaceIdentity, (ExoSocialActivity)activity);
        ActivityFilter activityFilter = new ActivityFilter();
        activityFilter.setStreamType(ActivityStreamType.ALL_STREAM);
        RealtimeListAccess activitiesListAccess = this.activityManager.getActivitiesByFilterWithListAccess(this.johnIdentity, activityFilter);
        ActivityManagerTest.assertTrue((activitiesListAccess.getSize() > 0 ? 1 : 0) != 0);
        List activities = activitiesListAccess.loadAsList(0, activitiesListAccess.getSize());
        ActivityManagerTest.assertFalse((boolean)activities.isEmpty());
        List activityIds = activitiesListAccess.loadIdsAsList(0, activitiesListAccess.getSize());
        ActivityManagerTest.assertFalse((boolean)activityIds.isEmpty());
        ActivityManagerTest.assertEquals((String)activity.getId(), (String)((String)activityIds.get(0)));
        ActivityManagerTest.assertEquals((String)activity.getId(), (String)((ExoSocialActivity)activities.get(0)).getId());
    }

    public void testCanActivity() throws Exception {
        String activityTitle = "activity title";
        String userId = this.johnIdentity.getId();
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle(activityTitle);
        activity.setUserId(userId);
        Space space = this.createSpace("spaceTestPin", "john", "demo", "james");
        org.exoplatform.social.core.identity.model.Identity spaceIdentity = this.identityManager.getOrCreateSpaceIdentity(space.getPrettyName());
        this.activityManager.saveActivityNoReturn(spaceIdentity, (ExoSocialActivity)activity);
        boolean maryCanPinActivity = this.activityManager.canPinActivity((ExoSocialActivity)activity, this.maryIdentity);
        boolean demoCanPinActivity = this.activityManager.canPinActivity((ExoSocialActivity)activity, this.demoIdentity);
        boolean jamesCanPinActivity = this.activityManager.canPinActivity((ExoSocialActivity)activity, this.jamesIdentity);
        ActivityManagerTest.assertFalse((boolean)maryCanPinActivity);
        ActivityManagerTest.assertFalse((boolean)demoCanPinActivity);
        ActivityManagerTest.assertFalse((boolean)jamesCanPinActivity);
        String[] managers = new String[]{"mary"};
        String[] redactors = new String[]{"demo"};
        String[] publishers = new String[]{"james"};
        space.setRedactors(redactors);
        space.setManagers(managers);
        space.setPublishers(publishers);
        this.spaceService.updateSpace(space);
        ActivityManagerTest.assertTrue((boolean)this.activityManager.canPinActivity((ExoSocialActivity)activity, this.maryIdentity));
        ActivityManagerTest.assertFalse((boolean)this.activityManager.canPinActivity((ExoSocialActivity)activity, this.demoIdentity));
        ActivityManagerTest.assertTrue((boolean)this.activityManager.canPinActivity((ExoSocialActivity)activity, this.jamesIdentity));
    }

    public void testDeleteComment() {
        ExoSocialActivityImpl demoActivity = new ExoSocialActivityImpl();
        demoActivity.setTitle("demo activity");
        demoActivity.setUserId(demoActivity.getId());
        this.activityManager.saveActivityNoReturn(this.demoIdentity, (ExoSocialActivity)demoActivity);
        ExoSocialActivityImpl maryComment = new ExoSocialActivityImpl();
        maryComment.setTitle("mary comment");
        maryComment.setUserId(this.maryIdentity.getId());
        this.activityManager.saveComment((ExoSocialActivity)demoActivity, (ExoSocialActivity)maryComment);
        this.activityManager.deleteComment((ExoSocialActivity)demoActivity, (ExoSocialActivity)maryComment);
        ActivityManagerTest.assertEquals((String)"activityManager.getComments(demoActivity).size() must return: 0", (int)0, (int)this.activityManager.getCommentsWithListAccess((ExoSocialActivity)demoActivity).getSize());
    }

    public void testGetActivityStreamOwnerIdentity() {
        ExoSocialActivityImpl demoActivity = new ExoSocialActivityImpl();
        demoActivity.setTitle("demo activity");
        demoActivity.setUserId(demoActivity.getId());
        this.activityManager.saveActivityNoReturn(this.demoIdentity, (ExoSocialActivity)demoActivity);
        org.exoplatform.social.core.identity.model.Identity streamOwnerIdentity = this.activityManager.getActivityStreamOwnerIdentity(demoActivity.getId());
        ActivityManagerTest.assertNotNull((Object)streamOwnerIdentity);
        ActivityManagerTest.assertEquals((String)this.demoIdentity.getId(), (String)streamOwnerIdentity.getId());
        ExoSocialActivityImpl maryComment = new ExoSocialActivityImpl();
        maryComment.setTitle("mary comment");
        maryComment.setUserId(this.maryIdentity.getId());
        this.activityManager.saveComment((ExoSocialActivity)demoActivity, (ExoSocialActivity)maryComment);
        streamOwnerIdentity = this.activityManager.getActivityStreamOwnerIdentity(maryComment.getId());
        ActivityManagerTest.assertNotNull((Object)streamOwnerIdentity);
        ActivityManagerTest.assertEquals((String)this.demoIdentity.getId(), (String)streamOwnerIdentity.getId());
    }

    public void testSaveLikes() {
        ExoSocialActivityImpl demoActivity = new ExoSocialActivityImpl();
        demoActivity.setTitle("&\"demo activity");
        demoActivity.setUserId(demoActivity.getId());
        this.activityManager.saveActivityNoReturn(this.demoIdentity, (ExoSocialActivity)demoActivity);
        demoActivity = this.activityManager.getActivity(demoActivity.getId());
        ActivityManagerTest.assertEquals((String)"demoActivity.getLikeIdentityIds() must return: 0", (int)0, (int)demoActivity.getLikeIdentityIds().length);
        this.activityManager.saveLike((ExoSocialActivity)demoActivity, this.johnIdentity);
        demoActivity = this.activityManager.getActivity(demoActivity.getId());
        ActivityManagerTest.assertEquals((String)"demoActivity.getLikeIdentityIds().length must return: 1", (int)1, (int)demoActivity.getLikeIdentityIds().length);
        ActivityManagerTest.assertEquals((String)"&amp;&#34;demo activity", (String)demoActivity.getTitle());
    }

    public void testSaveLikesNotChangeTemplateParam() {
        ExoSocialActivityImpl demoActivity = new ExoSocialActivityImpl();
        demoActivity.setTitle("title");
        demoActivity.setUserId(demoActivity.getId());
        HashMap<String, String> templateParams = new HashMap<String, String>();
        templateParams.put("link", "http://exoplatform.com?test=<script>");
        demoActivity.setTemplateParams(templateParams);
        this.activityManager.saveActivityNoReturn(this.demoIdentity, (ExoSocialActivity)demoActivity);
        demoActivity = this.activityManager.getActivity(demoActivity.getId());
        ActivityManagerTest.assertEquals((String)"demoActivity.getLikeIdentityIds() must return: 0", (int)0, (int)demoActivity.getLikeIdentityIds().length);
        this.activityManager.saveLike((ExoSocialActivity)demoActivity, this.johnIdentity);
        ExoSocialActivity likedActivity = this.activityManager.getActivity(demoActivity.getId());
        ActivityManagerTest.assertEquals((int)1, (int)likedActivity.getLikeIdentityIds().length);
        ActivityManagerTest.assertEquals((String)((String)templateParams.get("link")), (String)((String)likedActivity.getTemplateParams().get("link")));
    }

    public void testDeleteLikes() {
        ExoSocialActivityImpl demoActivity = new ExoSocialActivityImpl();
        demoActivity.setTitle("demo activity");
        demoActivity.setUserId(demoActivity.getId());
        this.activityManager.saveActivityNoReturn(this.demoIdentity, (ExoSocialActivity)demoActivity);
        demoActivity = this.activityManager.getActivity(demoActivity.getId());
        ActivityManagerTest.assertEquals((String)"demoActivity.getLikeIdentityIds() must return: 0", (int)0, (int)demoActivity.getLikeIdentityIds().length);
        this.activityManager.saveLike((ExoSocialActivity)demoActivity, this.johnIdentity);
        demoActivity = this.activityManager.getActivity(demoActivity.getId());
        ActivityManagerTest.assertEquals((String)"demoActivity.getLikeIdentityIds().length must return: 1", (int)1, (int)demoActivity.getLikeIdentityIds().length);
        this.activityManager.deleteLike((ExoSocialActivity)demoActivity, this.johnIdentity);
        demoActivity = this.activityManager.getActivity(demoActivity.getId());
        ActivityManagerTest.assertEquals((String)"demoActivity.getLikeIdentityIds().length must return: 0", (int)0, (int)demoActivity.getLikeIdentityIds().length);
        this.activityManager.deleteLike((ExoSocialActivity)demoActivity, this.maryIdentity);
        demoActivity = this.activityManager.getActivity(demoActivity.getId());
        ActivityManagerTest.assertEquals((String)"demoActivity.getLikeIdentityIds().length must return: 0", (int)0, (int)demoActivity.getLikeIdentityIds().length);
        this.activityManager.deleteLike((ExoSocialActivity)demoActivity, this.rootIdentity);
        demoActivity = this.activityManager.getActivity(demoActivity.getId());
        ActivityManagerTest.assertEquals((String)"demoActivity.getLikeIdentityIds().length must return: 0", (int)0, (int)demoActivity.getLikeIdentityIds().length);
    }

    public void testDeleteLikesNotChangeTemplateParam() {
        ExoSocialActivityImpl demoActivity = new ExoSocialActivityImpl();
        demoActivity.setTitle("title");
        demoActivity.setUserId(demoActivity.getId());
        HashMap<String, String> templateParams = new HashMap<String, String>();
        templateParams.put("link", "http://exoplatform.com?test=<script>");
        demoActivity.setTemplateParams(templateParams);
        this.activityManager.saveActivityNoReturn(this.demoIdentity, (ExoSocialActivity)demoActivity);
        demoActivity = this.activityManager.getActivity(demoActivity.getId());
        this.activityManager.saveLike((ExoSocialActivity)demoActivity, this.johnIdentity);
        ExoSocialActivity likedActivity = this.activityManager.getActivity(demoActivity.getId());
        ActivityManagerTest.assertEquals((int)1, (int)likedActivity.getLikeIdentityIds().length);
        demoActivity = this.activityManager.getActivity(demoActivity.getId());
        this.activityManager.deleteLike((ExoSocialActivity)demoActivity, this.johnIdentity);
        ExoSocialActivity deleteLikeActivity = this.activityManager.getActivity(demoActivity.getId());
        ActivityManagerTest.assertEquals((int)0, (int)deleteLikeActivity.getLikeIdentityIds().length);
        ActivityManagerTest.assertEquals((String)((String)templateParams.get("link")), (String)((String)deleteLikeActivity.getTemplateParams().get("link")));
    }

    public void testGetCommentWithHtmlContent() {
        String htmlString = "<span><strong>foo</strong>bar<script>zed</script></span>";
        String htmlRemovedString = "<strong>foo</strong>bar";
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("blah blah");
        this.activityManager.saveActivityNoReturn(this.rootIdentity, (ExoSocialActivity)activity);
        ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
        comment.setTitle(htmlString);
        comment.setUserId(this.rootIdentity.getId());
        comment.setBody(htmlString);
        this.activityManager.saveComment((ExoSocialActivity)activity, (ExoSocialActivity)comment);
        ActivityManagerTest.assertNotNull((String)"comment.getId() must not be null", (Object)comment.getId());
        List comments = this.activityManager.getCommentsWithListAccess((ExoSocialActivity)activity).loadAsList(0, 1);
        ActivityManagerTest.assertEquals((int)1, (int)comments.size());
        ActivityManagerTest.assertEquals((String)htmlRemovedString.trim(), (String)((ExoSocialActivity)comments.get(0)).getBody().trim());
        ActivityManagerTest.assertEquals((String)htmlRemovedString.trim(), (String)((ExoSocialActivity)comments.get(0)).getTitle().trim());
    }

    public void testGetCommentList() {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("blah blah");
        this.activityManager.saveActivityNoReturn(this.rootIdentity, (ExoSocialActivity)activity);
        ArrayList<ExoSocialActivityImpl> comments = new ArrayList<ExoSocialActivityImpl>();
        for (int i = 0; i < 10; ++i) {
            ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
            comment.setTitle("comment blah blah");
            comment.setUserId(this.rootIdentity.getId());
            this.activityManager.saveComment((ExoSocialActivity)activity, (ExoSocialActivity)comment);
            ActivityManagerTest.assertNotNull((String)"comment.getId() must not be null", (Object)comment.getId());
            comments.add(comment);
        }
        ExoSocialActivity assertActivity = this.activityManager.getActivity(activity.getId());
        String[] commentIds = assertActivity.getReplyToId();
        for (int i = 1; i < commentIds.length; ++i) {
            ActivityManagerTest.assertEquals((String)((ExoSocialActivity)comments.get(i - 1)).getId(), (String)commentIds[i - 1]);
        }
    }

    public void testDeleteCommentWithId() {
        int index1;
        String title = "Activity Title";
        ExoSocialActivityImpl activity1 = new ExoSocialActivityImpl();
        activity1.setUserId(this.demoIdentity.getId());
        activity1.setTitle("Activity Title");
        this.activityManager.saveActivityNoReturn(this.demoIdentity, (ExoSocialActivity)activity1);
        int numberOfComments = 10;
        String commentTitle = "Activity Comment";
        for (int i = 0; i < 10; ++i) {
            ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
            comment.setUserId(this.demoIdentity.getId());
            comment.setTitle("Activity Comment" + i);
            this.activityManager.saveComment((ExoSocialActivity)activity1, (ExoSocialActivity)comment);
        }
        RealtimeListAccess commentsWithListAccess = this.activityManager.getCommentsWithListAccess((ExoSocialActivity)activity1);
        List storedCommentList = commentsWithListAccess.loadAsList(0, commentsWithListAccess.getSize());
        ActivityManagerTest.assertEquals((String)"storedCommentList.size() must return: 10", (int)10, (int)storedCommentList.size());
        int index2 = index1 = new Random().nextInt(9);
        while (index2 == index1) {
            index2 = new Random().nextInt(9);
        }
        ExoSocialActivity tobeDeletedComment1 = (ExoSocialActivity)storedCommentList.get(index1);
        ExoSocialActivity tobeDeletedComment2 = (ExoSocialActivity)storedCommentList.get(index2);
        this.activityManager.deleteComment(activity1.getId(), tobeDeletedComment1.getId());
        this.activityManager.deleteComment(activity1.getId(), tobeDeletedComment2.getId());
        List afterDeletedCommentList = commentsWithListAccess.loadAsList(0, commentsWithListAccess.getSize());
        ActivityManagerTest.assertEquals((String)"afterDeletedCommentList.size() must return: 8", (int)8, (int)afterDeletedCommentList.size());
    }

    public void testDisableActivityType() {
        String activityTitle = "activity title";
        String userId = this.johnIdentity.getId();
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle(activityTitle);
        activity.setUserId(userId);
        activity.setType("cs-calendar:spaces");
        this.activityManager.saveActivityNoReturn(this.johnIdentity, (ExoSocialActivity)activity);
        ActivityManagerTest.assertNull((Object)activity.getId());
        activity.setType("MY_ACTIVITY");
        this.activityManager.saveActivityNoReturn(this.johnIdentity, (ExoSocialActivity)activity);
        ActivityManagerTest.assertNull((Object)activity.getId());
        activity.setType("DEFAULT_ACTIVITY");
        this.activityManager.saveActivityNoReturn(this.johnIdentity, (ExoSocialActivity)activity);
        ActivityManagerTest.assertNotNull((Object)activity.getId());
        activity = this.activityManager.getActivity(activity.getId());
        ActivityManagerTest.assertNotNull((Object)activity);
    }

    public void testCommentOnDisabledActivity() {
        String activityTitle = "disabled activity";
        String commentTitle = "Comment title";
        String userId = this.johnIdentity.getId();
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle(activityTitle);
        activity.setUserId(userId);
        activity.setType("cs-calendar:spaces");
        this.activityManager.saveActivityNoReturn(this.johnIdentity, (ExoSocialActivity)activity);
        ActivityManagerTest.assertNull((Object)activity.getId());
        ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
        comment.setTitle(commentTitle);
        comment.setUserId(this.demoIdentity.getId());
        this.activityManager.saveComment((ExoSocialActivity)activity, (ExoSocialActivity)comment);
        ActivityManagerTest.assertNull((Object)comment.getId());
    }

    public void testCommentWithDisabledCommentActivityType() {
        String activityTitle = "disabled activity";
        String commentTitle = "Comment title";
        String userId = this.johnIdentity.getId();
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle(activityTitle);
        activity.setUserId(userId);
        activity.setType("EnableType");
        this.activityManager.saveActivityNoReturn(this.johnIdentity, (ExoSocialActivity)activity);
        ActivityManagerTest.assertNotNull((Object)activity.getId());
        ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
        comment.setTitle(commentTitle);
        comment.setType("cs-calendar:spaces");
        comment.setUserId(this.demoIdentity.getId());
        this.activityManager.saveComment((ExoSocialActivity)activity, (ExoSocialActivity)comment);
        ActivityManagerTest.assertNull((Object)comment.getId());
    }

    public void testActivityEditable() {
        ActivityStorage storage = (ActivityStorage)Mockito.mock(ActivityStorage.class);
        IdentityManager identityManager = (IdentityManager)Mockito.mock(IdentityManager.class);
        UserACL acl = (UserACL)Mockito.mock(UserACL.class);
        Mockito.when((Object)acl.getAdminGroups()).thenReturn((Object)"/platform/administrators");
        ExoSocialActivity activity = (ExoSocialActivity)Mockito.mock(ExoSocialActivity.class);
        Mockito.when((Object)activity.isComment()).thenReturn((Object)false);
        Mockito.when((Object)activity.getPosterId()).thenReturn((Object)"1");
        ExoSocialActivity comment = (ExoSocialActivity)Mockito.mock(ExoSocialActivity.class);
        Mockito.when((Object)comment.isComment()).thenReturn((Object)true);
        Mockito.when((Object)comment.getPosterId()).thenReturn((Object)"1");
        Identity owner = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)owner.getUserId()).thenReturn((Object)"demo");
        Mockito.when((Object)identityManager.getOrCreateUserIdentity("demo")).thenReturn((Object)new org.exoplatform.social.core.identity.model.Identity("1"));
        Identity admin = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)admin.getUserId()).thenReturn((Object)"john");
        Mockito.when((Object)identityManager.getOrCreateUserIdentity("john")).thenReturn((Object)new org.exoplatform.social.core.identity.model.Identity("2"));
        Mockito.when((Object)admin.getGroups()).thenReturn(new HashSet<String>(Arrays.asList("/platform/administrators")));
        Identity mary = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)mary.getUserId()).thenReturn((Object)"mary");
        Mockito.when((Object)identityManager.getOrCreateUserIdentity("mary")).thenReturn((Object)new org.exoplatform.social.core.identity.model.Identity("3"));
        ActivityManagerImpl manager = new ActivityManagerImpl(storage, identityManager, this.spaceService, this.relationshipManager, acl, null);
        ActivityManagerTest.assertTrue((boolean)manager.isActivityEditable(activity, owner));
        ActivityManagerTest.assertTrue((boolean)manager.isActivityEditable(comment, owner));
        Mockito.when((Object)comment.getType()).thenReturn((Object)"TestActivityType");
        InitParams params = new InitParams();
        ValuesParam param = new ValuesParam();
        param.setName("system.types");
        param.setValues(Collections.singletonList("TestActivityType"));
        params.addParameter((Parameter)param);
        ActivitySystemTypePlugin plugin = new ActivitySystemTypePlugin(params);
        manager.addSystemActivityDefinition(plugin);
        ActivityManagerTest.assertFalse((boolean)manager.isActivityEditable(comment, owner));
        ActivityManagerTest.assertFalse((boolean)manager.isActivityEditable(activity, admin));
        ActivityManagerTest.assertFalse((boolean)manager.isActivityEditable(activity, mary));
        params = (InitParams)Mockito.mock(InitParams.class);
        Mockito.when((Object)params.containsKey((Object)"exo.manager.edit.comment.enabled")).thenReturn((Object)true);
        Mockito.when((Object)params.containsKey((Object)"exo.edit.comment.enabled")).thenReturn((Object)true);
        ValueParam falseVal = new ValueParam();
        falseVal.setValue("false");
        Mockito.when((Object)params.getValueParam("exo.manager.edit.comment.enabled")).thenReturn((Object)falseVal);
        Mockito.when((Object)params.getValueParam("exo.edit.comment.enabled")).thenReturn((Object)falseVal);
        manager = new ActivityManagerImpl(storage, identityManager, this.spaceService, this.relationshipManager, acl, params);
        ActivityManagerTest.assertFalse((boolean)manager.isActivityEditable(comment, admin));
        ActivityManagerTest.assertFalse((boolean)manager.isActivityEditable(comment, owner));
        ActivityManagerTest.assertTrue((boolean)manager.isActivityEditable(activity, owner));
        ActivityManagerTest.assertFalse((boolean)manager.isActivityEditable(activity, admin));
        Mockito.when((Object)params.containsKey((Object)"exo.manager.edit.activity.enabled")).thenReturn((Object)true);
        Mockito.when((Object)params.containsKey((Object)"exo.edit.activity.enabled")).thenReturn((Object)true);
        Mockito.when((Object)params.getValueParam("exo.manager.edit.activity.enabled")).thenReturn((Object)falseVal);
        Mockito.when((Object)params.getValueParam("exo.edit.activity.enabled")).thenReturn((Object)falseVal);
        manager = new ActivityManagerImpl(storage, identityManager, this.spaceService, this.relationshipManager, acl, params);
        ActivityManagerTest.assertFalse((boolean)manager.isActivityEditable(activity, owner));
        ActivityManagerTest.assertFalse((boolean)manager.isActivityEditable(activity, admin));
    }

    public void testActivityViewable() {
        ActivityStorage storage = (ActivityStorage)Mockito.mock(ActivityStorage.class);
        IdentityManager identityManager = (IdentityManager)Mockito.mock(IdentityManager.class);
        RelationshipManager relationshipManager = (RelationshipManager)Mockito.mock(RelationshipManager.class);
        UserACL acl = (UserACL)Mockito.mock(UserACL.class);
        Mockito.when((Object)acl.getAdminGroups()).thenReturn((Object)"/platform/administrators");
        ExoSocialActivity activity = (ExoSocialActivity)Mockito.mock(ExoSocialActivity.class);
        Mockito.when((Object)activity.isComment()).thenReturn((Object)false);
        Mockito.when((Object)activity.getPosterId()).thenReturn((Object)"1");
        ExoSocialActivity comment = (ExoSocialActivity)Mockito.mock(ExoSocialActivity.class);
        Mockito.when((Object)comment.isComment()).thenReturn((Object)true);
        Mockito.when((Object)comment.getPosterId()).thenReturn((Object)"1");
        Mockito.when((Object)identityManager.getIdentity("1")).thenReturn((Object)this.rootIdentity);
        Identity owner = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)owner.getUserId()).thenReturn((Object)"demo");
        Mockito.when((Object)identityManager.getOrCreateUserIdentity("demo")).thenReturn((Object)new org.exoplatform.social.core.identity.model.Identity("1"));
        Identity admin = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)admin.getUserId()).thenReturn((Object)"john");
        Mockito.when((Object)identityManager.getOrCreateUserIdentity("john")).thenReturn((Object)this.johnIdentity);
        Mockito.when((Object)admin.getGroups()).thenReturn(Collections.singleton("/platform/administrators"));
        Mockito.when((Object)admin.getMemberships()).thenReturn(Collections.singleton(new MembershipEntry("/platform/administrators")));
        Mockito.when((Object)admin.isMemberOf(acl.getAdminGroups())).thenReturn((Object)true);
        Identity mary = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)mary.getUserId()).thenReturn((Object)"mary");
        Mockito.when((Object)identityManager.getOrCreateUserIdentity("mary")).thenReturn((Object)this.maryIdentity);
        ActivityManagerImpl manager = new ActivityManagerImpl(storage, identityManager, this.spaceService, relationshipManager, acl, null);
        ActivityManagerTest.assertTrue((boolean)manager.isActivityViewable(activity, owner));
        ActivityManagerTest.assertTrue((boolean)manager.isActivityViewable(comment, owner));
        Mockito.when((Object)comment.getType()).thenReturn((Object)"TestActivityType");
        ActivityManagerTest.assertTrue((boolean)manager.isActivityViewable(comment, owner));
        ActivityManagerTest.assertTrue((boolean)manager.isActivityViewable(activity, admin));
        ActivityManagerTest.assertFalse((boolean)manager.isActivityViewable(activity, mary));
        Mockito.when((Object)relationshipManager.getStatus(this.rootIdentity, this.maryIdentity)).thenReturn((Object)Relationship.Type.CONFIRMED);
        ActivityManagerTest.assertTrue((boolean)manager.isActivityViewable(activity, mary));
    }

    public void testActivityTypePlugin() {
        ActivityStorage storage = (ActivityStorage)Mockito.mock(ActivityStorage.class);
        IdentityManager identityManager = (IdentityManager)Mockito.mock(IdentityManager.class);
        UserACL acl = (UserACL)Mockito.mock(UserACL.class);
        Mockito.when((Object)acl.getAdminGroups()).thenReturn((Object)"/platform/administrators");
        final String specificActivityType = "SpecificActivityType";
        ExoSocialActivity activity = (ExoSocialActivity)Mockito.mock(ExoSocialActivity.class);
        Mockito.when((Object)activity.isComment()).thenReturn((Object)false);
        Mockito.when((Object)activity.getType()).thenReturn((Object)specificActivityType);
        Mockito.when((Object)activity.getPosterId()).thenReturn((Object)"1");
        Mockito.when((Object)activity.getTitle()).thenReturn((Object)"Activity title");
        Identity owner = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)owner.getUserId()).thenReturn((Object)"demo");
        Mockito.when((Object)identityManager.getOrCreateUserIdentity("demo")).thenReturn((Object)new org.exoplatform.social.core.identity.model.Identity("1"));
        ActivityManagerImpl manager = new ActivityManagerImpl(storage, identityManager, this.spaceService, this.relationshipManager, acl, null);
        ActivityManagerTest.assertTrue((boolean)manager.isActivityEditable(activity, owner));
        ActivityManagerTest.assertTrue((boolean)manager.isActivityViewable(activity, owner));
        ActivityManagerTest.assertTrue((boolean)manager.isActivityDeletable(activity, owner));
        ActivityManagerTest.assertEquals((String)"Activity title", (String)manager.getActivityTitle(activity));
        final AtomicBoolean viewwable = new AtomicBoolean(false);
        final AtomicBoolean editable = new AtomicBoolean(false);
        final AtomicBoolean deletable = new AtomicBoolean(false);
        manager.addActivityTypePlugin(new ActivityTypePlugin(this, null){

            public String getActivityType() {
                return specificActivityType;
            }

            public boolean isActivityEditable(ExoSocialActivity activity, Identity userAclIdentity) {
                return editable.get();
            }

            public boolean isActivityDeletable(ExoSocialActivity activity, Identity userAclIdentity) {
                return deletable.get();
            }

            public boolean isActivityViewable(ExoSocialActivity activity, Identity userAclIdentity) {
                return viewwable.get();
            }

            public String getActivityTitle(ExoSocialActivity activity) {
                return "Activity Plugin title";
            }
        });
        ActivityManagerTest.assertFalse((boolean)manager.isActivityEditable(activity, owner));
        editable.set(true);
        ActivityManagerTest.assertTrue((boolean)manager.isActivityEditable(activity, owner));
        ActivityManagerTest.assertFalse((boolean)manager.isActivityViewable(activity, owner));
        viewwable.set(true);
        ActivityManagerTest.assertTrue((boolean)manager.isActivityViewable(activity, owner));
        ActivityManagerTest.assertFalse((boolean)manager.isActivityDeletable(activity, owner));
        deletable.set(true);
        ActivityManagerTest.assertTrue((boolean)manager.isActivityDeletable(activity, owner));
        ActivityManagerTest.assertEquals((String)"Activity Plugin title", (String)manager.getActivityTitle(activity));
    }

    public void testActivityNotificationEnabling() {
        ActivityStorage storage = (ActivityStorage)Mockito.mock(ActivityStorage.class);
        IdentityManager identityManager = (IdentityManager)Mockito.mock(IdentityManager.class);
        RelationshipManager relationshipManager = (RelationshipManager)Mockito.mock(RelationshipManager.class);
        ActivityManagerImpl activityManager = new ActivityManagerImpl(storage, identityManager, this.spaceService, relationshipManager, null, null);
        String activityType = "TestActivityType";
        String activityType2 = "TestActivityType2";
        String activityType3 = "TestActivityType3";
        this.addActivityTypePlugin((ActivityManager)activityManager, activityType, false);
        this.addActivityTypePlugin((ActivityManager)activityManager, activityType2, true);
        ActivityManagerTest.assertFalse((boolean)activityManager.isNotificationEnabled(null));
        ActivityManagerTest.assertFalse((boolean)activityManager.isNotificationEnabled(null, null));
        ExoSocialActivity activity = (ExoSocialActivity)Mockito.mock(ExoSocialActivity.class);
        ActivityManagerTest.assertTrue((boolean)activityManager.isNotificationEnabled(activity));
        ActivityManagerTest.assertTrue((boolean)activityManager.isNotificationEnabled(activity, null));
        Mockito.when((Object)activity.getType()).thenReturn((Object)activityType);
        ActivityManagerTest.assertFalse((boolean)activityManager.isNotificationEnabled(activity, null));
        Mockito.when((Object)activity.getType()).thenReturn((Object)activityType2);
        ActivityManagerTest.assertTrue((boolean)activityManager.isNotificationEnabled(activity, null));
        ActivityManagerTest.assertFalse((boolean)activityManager.isNotificationEnabled(activity, "root3"));
        ActivityManagerTest.assertTrue((boolean)activityManager.isNotificationEnabled(activity, "root2"));
        Mockito.when((Object)activity.getType()).thenReturn((Object)activityType3);
        ActivityManagerTest.assertTrue((boolean)activityManager.isNotificationEnabled(activity, null));
        Mockito.when((Object)activity.isHidden()).thenReturn((Object)true);
        ActivityManagerTest.assertFalse((boolean)activityManager.isNotificationEnabled(activity, null));
    }

    public void testActivityDeletable() {
        ActivityStorage storage = (ActivityStorage)Mockito.mock(ActivityStorage.class);
        IdentityManager identityManager = (IdentityManager)Mockito.mock(IdentityManager.class);
        SpaceService spaceService = (SpaceService)Mockito.mock(SpaceService.class);
        UserACL acl = (UserACL)Mockito.mock(UserACL.class);
        ActivityManagerImpl activityManager = new ActivityManagerImpl(storage, identityManager, spaceService, this.relationshipManager, acl, null);
        Mockito.when((Object)acl.getAdminGroups()).thenReturn((Object)"/platform/administrators");
        Mockito.when((Object)spaceService.isSuperManager((String)Mockito.eq((Object)"john"))).thenReturn((Object)true);
        Mockito.when((Object)spaceService.isSuperManager((String)Mockito.eq((Object)"mary"))).thenReturn((Object)false);
        Mockito.when((Object)spaceService.isSuperManager((String)Mockito.eq((Object)"james"))).thenReturn((Object)false);
        ExoSocialActivity activity = (ExoSocialActivity)Mockito.mock(ExoSocialActivity.class);
        Mockito.when((Object)activity.isComment()).thenReturn((Object)false);
        Mockito.when((Object)activity.getPosterId()).thenReturn((Object)"1");
        ActivityStreamImpl activityStream = new ActivityStreamImpl();
        activityStream.setType(ActivityStream.Type.USER);
        activityStream.setPrettyId("demo");
        Mockito.when((Object)activity.getActivityStream()).thenReturn((Object)activityStream);
        ExoSocialActivity comment = (ExoSocialActivity)Mockito.mock(ExoSocialActivity.class);
        Mockito.when((Object)comment.isComment()).thenReturn((Object)true);
        Mockito.when((Object)comment.getPosterId()).thenReturn((Object)"1");
        Identity owner = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)owner.getUserId()).thenReturn((Object)"demo");
        Mockito.when((Object)identityManager.getOrCreateUserIdentity("demo")).thenReturn((Object)new org.exoplatform.social.core.identity.model.Identity("1"));
        Identity admin = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)admin.getUserId()).thenReturn((Object)"john");
        Mockito.when((Object)identityManager.getOrCreateUserIdentity("john")).thenReturn((Object)new org.exoplatform.social.core.identity.model.Identity("2"));
        Mockito.when((Object)admin.getGroups()).thenReturn(new HashSet<String>(Arrays.asList("/platform/administrators")));
        Identity mary = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)mary.getUserId()).thenReturn((Object)"mary");
        Mockito.when((Object)identityManager.getOrCreateUserIdentity("mary")).thenReturn((Object)new org.exoplatform.social.core.identity.model.Identity("3"));
        Identity james = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)james.getUserId()).thenReturn((Object)"james");
        Mockito.when((Object)identityManager.getOrCreateUserIdentity("james")).thenReturn((Object)new org.exoplatform.social.core.identity.model.Identity("4"));
        ActivityManagerTest.assertTrue((boolean)activityManager.isActivityDeletable(activity, owner));
        ActivityManagerTest.assertTrue((boolean)activityManager.isActivityDeletable(comment, owner));
        ActivityManagerTest.assertTrue((boolean)activityManager.isActivityDeletable(activity, admin));
        ActivityManagerTest.assertFalse((boolean)activityManager.isActivityDeletable(activity, mary));
        ActivityManagerTest.assertFalse((boolean)activityManager.isActivityDeletable(comment, mary));
        activityStream.setType(ActivityStream.Type.SPACE);
        activityStream.setPrettyId("demo_space");
        Space space = new Space();
        Mockito.when((Object)spaceService.getSpaceByPrettyName("demo_space")).thenReturn((Object)space);
        Mockito.when((Object)spaceService.canManageSpace(space, "john")).thenReturn((Object)true);
        Mockito.when((Object)spaceService.canManageSpace(space, "mary")).thenReturn((Object)true);
        Mockito.when((Object)spaceService.canManageSpace(space, "james")).thenReturn((Object)false);
        ActivityManagerTest.assertTrue((boolean)activityManager.isActivityDeletable(activity, owner));
        ActivityManagerTest.assertTrue((boolean)activityManager.isActivityDeletable(activity, mary));
        ActivityManagerTest.assertTrue((boolean)activityManager.isActivityDeletable(activity, admin));
        ActivityManagerTest.assertFalse((boolean)activityManager.isActivityDeletable(activity, james));
        HashMap<String, String> templateParams = new HashMap<String, String>();
        Mockito.when((Object)activity.getTemplateParams()).thenReturn(templateParams);
        templateParams.put("removable", "false");
        ActivityManagerTest.assertFalse((boolean)activityManager.isActivityDeletable(activity, owner));
        ActivityManagerTest.assertTrue((boolean)activityManager.isActivityDeletable(activity, admin));
        ActivityManagerTest.assertTrue((boolean)activityManager.isActivityDeletable(activity, mary));
        ActivityManagerTest.assertFalse((boolean)activityManager.isActivityDeletable(activity, james));
        templateParams.put("removable", "true");
        ActivityManagerTest.assertTrue((boolean)activityManager.isActivityDeletable(activity, owner));
        ActivityManagerTest.assertTrue((boolean)activityManager.isActivityDeletable(activity, admin));
        ActivityManagerTest.assertTrue((boolean)activityManager.isActivityDeletable(activity, mary));
        ActivityManagerTest.assertFalse((boolean)activityManager.isActivityDeletable(activity, james));
    }

    public void testSaveActivitiesNoReturn() throws Exception {
        String activityTitle = "activity title";
        String userId = this.johnIdentity.getId();
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        LinkedHashMap<String, String> templateParams = new LinkedHashMap<String, String>();
        templateParams.put("key1", "value 1");
        templateParams.put("key2", "value 2");
        templateParams.put("key3", "value 3");
        activity.setTemplateParams(templateParams);
        activity.setTitle(activityTitle);
        activity.setUserId(userId);
        activity.isHidden(false);
        activity.isLocked(true);
        this.activityManager.saveActivityNoReturn(this.johnIdentity, (ExoSocialActivity)activity);
        activity = this.activityManager.getActivity(activity.getId());
        ActivityManagerTest.assertNotNull((String)"activity must not be null", (Object)activity);
        ActivityManagerTest.assertEquals((String)("activity.getTitle() must return: " + activityTitle), (String)activityTitle, (String)activity.getTitle());
        ActivityManagerTest.assertEquals((String)("activity.getUserId() must return: " + userId), (String)userId, (String)activity.getUserId());
        Map gotTemplateParams = activity.getTemplateParams();
        ActivityManagerTest.assertEquals((String)"value 1", (String)((String)gotTemplateParams.get("key1")));
        ActivityManagerTest.assertEquals((String)"value 2", (String)((String)gotTemplateParams.get("key2")));
        ActivityManagerTest.assertEquals((String)"value 3", (String)((String)gotTemplateParams.get("key3")));
        ActivityManagerTest.assertTrue((boolean)activity.isLocked());
        ActivityManagerTest.assertFalse((boolean)activity.isHidden());
    }

    public void testSaveActivityNoReturnNotStreamOwner() throws Exception {
        String activityTitle = "activity title";
        String userId = this.johnIdentity.getId();
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle(activityTitle);
        activity.setUserId(userId);
        this.activityManager.saveActivityNoReturn((ExoSocialActivity)activity);
        activity = this.activityManager.getActivity(activity.getId());
        ActivityManagerTest.assertNotNull((String)"activity must not be null", (Object)activity);
        ActivityManagerTest.assertEquals((String)("activity.getTitle() must return: " + activityTitle), (String)activityTitle, (String)activity.getTitle());
        ActivityManagerTest.assertEquals((String)("activity.getUserId() must return: " + userId), (String)userId, (String)activity.getUserId());
    }

    public void testGetParentActivity() {
        this.populateActivityMass(this.demoIdentity, 1);
        ExoSocialActivity demoActivity = ((ExoSocialActivity[])this.activityManager.getActivitiesWithListAccess(this.demoIdentity).load(0, 1))[0];
        ActivityManagerTest.assertNotNull((String)"demoActivity must be false", (Object)demoActivity);
        ActivityManagerTest.assertNull((Object)this.activityManager.getParentActivity(demoActivity));
        ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
        comment.setTitle("comment");
        comment.setUserId(this.demoIdentity.getId());
        this.activityManager.saveComment(demoActivity, (ExoSocialActivity)comment);
        ExoSocialActivity gotComment = ((ExoSocialActivity[])this.activityManager.getCommentsWithListAccess(demoActivity).load(0, 1))[0];
        ActivityManagerTest.assertNotNull((String)"gotComment must not be null", (Object)gotComment);
        ExoSocialActivity parentActivity = this.activityManager.getParentActivity(gotComment);
        ActivityManagerTest.assertNotNull((Object)parentActivity);
        ActivityManagerTest.assertEquals((String)("parentActivity.getId() must return: " + demoActivity.getId()), (String)demoActivity.getId(), (String)parentActivity.getId());
        ActivityManagerTest.assertEquals((String)("parentActivity.getTitle() must return: " + demoActivity.getTitle()), (String)demoActivity.getTitle(), (String)parentActivity.getTitle());
        ActivityManagerTest.assertEquals((String)("parentActivity.getUserId() must return: " + demoActivity.getUserId()), (String)demoActivity.getUserId(), (String)parentActivity.getUserId());
    }

    public void testGetActivitiesByUser() {
        String activityTitle = "title";
        String userId = this.rootIdentity.getId();
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle(activityTitle);
        activity.setUserId(userId);
        this.activityManager.saveActivityNoReturn(this.rootIdentity, (ExoSocialActivity)activity);
        activity = this.activityManager.getActivity(String.valueOf(activity.getId()));
        ActivityManagerTest.assertNotNull((Object)activity);
        ActivityManagerTest.assertEquals((String)activityTitle, (String)activity.getTitle());
        ActivityManagerTest.assertEquals((String)userId, (String)activity.getUserId());
        RealtimeListAccess activities = this.activityManager.getActivitiesWithListAccess(this.rootIdentity);
        ExoSocialActivity[] activitie = (ExoSocialActivity[])activities.load(0, 10);
        ActivityManagerTest.assertEquals((int)1, (int)activitie.length);
        for (int i = 0; i < 20; ++i) {
            activity = new ExoSocialActivityImpl();
            activity.setTitle(activityTitle + " " + i);
            activity.setUserId(userId);
            activity.setCategoryIds(Arrays.asList((long)i + 1L, (long)i + 2L));
            this.activityManager.saveActivityNoReturn(this.rootIdentity, (ExoSocialActivity)activity);
        }
        activities = this.activityManager.getActivitiesWithListAccess(this.rootIdentity);
        ActivityManagerTest.assertEquals((int)20, (int)((ExoSocialActivity[])activities.load(0, 20)).length);
        List<ExoSocialActivity> activityList = Arrays.asList((ExoSocialActivity[])activities.load(0, activities.getSize()));
        ActivityManagerTest.assertEquals((int)21, (int)activityList.size());
    }

    public void testGetActivitiesByUserAndConnectionsAndSpaces() {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("Post activity to 'john' user stream by 'john'");
        activity.setUserId(this.johnIdentity.getId());
        this.activityManager.saveActivityNoReturn(this.johnIdentity, (ExoSocialActivity)activity);
        activity = new ExoSocialActivityImpl();
        activity.setTitle("Post activity to 'mary' user stream by 'demo'");
        activity.setUserId(this.demoIdentity.getId());
        this.activityManager.saveActivityNoReturn(this.maryIdentity, (ExoSocialActivity)activity);
        Space space = this.getSpaceInstance(0);
        this.restartTransaction();
        this.deleteSpaceAutomaticActivities(space);
        ActivityFilter activityFilter = new ActivityFilter();
        activityFilter.setStreamType(ActivityStreamType.ALL_STREAM);
        RealtimeListAccess activities = this.activityManager.getActivitiesByFilterWithListAccess(this.demoIdentity, activityFilter);
        ActivityManagerTest.assertEquals((String)"Demo activity posted to mary stream must be the only activity to return", (int)1, (int)activities.getSize());
        ActivityManagerTest.assertEquals((int)1, (int)activities.loadAsList(0, 100).size());
        ActivityManagerTest.assertEquals((int)1, (int)activities.loadIdsAsList(0, 100).size());
        this.relationshipManager.inviteToConnect(this.demoIdentity, this.johnIdentity);
        this.relationshipManager.confirm(this.demoIdentity, this.johnIdentity);
        this.restartTransaction();
        this.deleteRelationshipAutomaticActivities(this.demoIdentity);
        activities = this.activityManager.getActivitiesByFilterWithListAccess(this.demoIdentity, activityFilter);
        ActivityManagerTest.assertEquals((String)"Demo activity posted to mary stream and john's stream activity must be the only activities to return", (int)2, (int)activities.getSize());
        ActivityManagerTest.assertEquals((int)2, (int)activities.loadAsList(0, 100).size());
        ActivityManagerTest.assertEquals((int)2, (int)activities.loadIdsAsList(0, 100).size());
        org.exoplatform.social.core.identity.model.Identity spaceIdentity = this.identityManager.getOrCreateSpaceIdentity(space.getPrettyName());
        for (int i = 0; i < 10; ++i) {
            activity = new ExoSocialActivityImpl();
            activity.setTitle("Activity Title: " + i);
            activity.setUserId(this.johnIdentity.getId());
            this.activityManager.saveActivityNoReturn(spaceIdentity, (ExoSocialActivity)activity);
        }
        this.restartTransaction();
        activities = this.activityManager.getActivitiesByFilterWithListAccess(this.demoIdentity, activityFilter);
        ActivityManagerTest.assertEquals((int)12, (int)activities.getSize());
        ActivityManagerTest.assertEquals((int)12, (int)activities.loadAsList(0, 100).size());
        ActivityManagerTest.assertEquals((int)12, (int)activities.loadIdsAsList(0, 100).size());
        this.spaceService.removeMember(space, this.demoIdentity.getRemoteId());
        ((CachedActivityStorage)this.activityStorage).clearCache();
        this.restartTransaction();
        activities = this.activityManager.getActivitiesByFilterWithListAccess(this.demoIdentity, activityFilter);
        ActivityManagerTest.assertEquals((int)2, (int)activities.getSize());
        ActivityManagerTest.assertEquals((int)2, (int)activities.loadAsList(0, 100).size());
        ActivityManagerTest.assertEquals((int)2, (int)activities.loadIdsAsList(0, 100).size());
        activities = this.activityManager.getActivitiesByFilterWithListAccess(this.johnIdentity, activityFilter);
        ActivityManagerTest.assertEquals((int)11, (int)activities.getSize());
        ActivityManagerTest.assertEquals((int)11, (int)activities.loadAsList(0, 100).size());
        ActivityManagerTest.assertEquals((int)11, (int)activities.loadIdsAsList(0, 100).size());
        this.relationshipManager.deny(this.demoIdentity, this.johnIdentity);
        activities = this.activityManager.getActivitiesByFilterWithListAccess(this.demoIdentity, activityFilter);
        ActivityManagerTest.assertEquals((int)1, (int)activities.getSize());
        ActivityManagerTest.assertEquals((int)1, (int)activities.loadAsList(0, 100).size());
        ActivityManagerTest.assertEquals((int)1, (int)activities.loadIdsAsList(0, 100).size());
        activities = this.activityManager.getActivitiesByFilterWithListAccess(this.johnIdentity, activityFilter);
        ActivityManagerTest.assertEquals((int)11, (int)activities.getSize());
        ActivityManagerTest.assertEquals((int)11, (int)activities.loadAsList(0, 100).size());
        ActivityManagerTest.assertEquals((int)11, (int)activities.loadIdsAsList(0, 100).size());
    }

    public void testGetActivitiesPostedByUser() {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("Post activity to 'john' user stream by 'john'");
        activity.setUserId(this.johnIdentity.getId());
        this.activityManager.saveActivityNoReturn(this.johnIdentity, (ExoSocialActivity)activity);
        activity = new ExoSocialActivityImpl();
        activity.setTitle("Post activity to 'mary' user stream by 'demo'");
        activity.setUserId(this.demoIdentity.getId());
        this.activityManager.saveActivityNoReturn(this.maryIdentity, (ExoSocialActivity)activity);
        activity = new ExoSocialActivityImpl();
        activity.setTitle("Post activity to own stream");
        activity.setUserId(this.demoIdentity.getId());
        this.activityManager.saveActivityNoReturn(this.demoIdentity, (ExoSocialActivity)activity);
        Space space = this.getSpaceInstance(0);
        this.restartTransaction();
        this.deleteSpaceAutomaticActivities(space);
        ActivityFilter activityFilter = new ActivityFilter();
        activityFilter.setStreamType(ActivityStreamType.USER_STREAM);
        RealtimeListAccess activities = this.activityManager.getActivitiesByFilterWithListAccess(this.demoIdentity, activityFilter);
        ActivityManagerTest.assertEquals((int)2, (int)activities.getSize());
        ActivityManagerTest.assertEquals((int)2, (int)activities.loadAsList(0, 100).size());
        ActivityManagerTest.assertEquals((int)2, (int)activities.loadIdsAsList(0, 100).size());
        this.relationshipManager.inviteToConnect(this.demoIdentity, this.johnIdentity);
        this.relationshipManager.confirm(this.demoIdentity, this.johnIdentity);
        this.restartTransaction();
        this.deleteRelationshipAutomaticActivities(this.demoIdentity);
        activities = this.activityManager.getActivitiesByFilterWithListAccess(this.demoIdentity, activityFilter);
        ActivityManagerTest.assertEquals((int)2, (int)activities.getSize());
        ActivityManagerTest.assertEquals((int)2, (int)activities.loadAsList(0, 100).size());
        ActivityManagerTest.assertEquals((int)2, (int)activities.loadIdsAsList(0, 100).size());
        org.exoplatform.social.core.identity.model.Identity spaceIdentity = this.identityManager.getOrCreateSpaceIdentity(space.getPrettyName());
        for (int i = 0; i < 10; ++i) {
            activity = new ExoSocialActivityImpl();
            activity.setTitle("Activity Title: " + i);
            activity.setUserId(this.demoIdentity.getId());
            this.activityManager.saveActivityNoReturn(spaceIdentity, (ExoSocialActivity)activity);
            activity = new ExoSocialActivityImpl();
            activity.setTitle("Activity Title: " + i);
            activity.setUserId(this.johnIdentity.getId());
            this.activityManager.saveActivityNoReturn(spaceIdentity, (ExoSocialActivity)activity);
        }
        this.restartTransaction();
        activities = this.activityManager.getActivitiesByFilterWithListAccess(this.demoIdentity, activityFilter);
        ActivityManagerTest.assertEquals((int)12, (int)activities.getSize());
        ActivityManagerTest.assertEquals((int)12, (int)activities.loadAsList(0, 100).size());
        ActivityManagerTest.assertEquals((int)12, (int)activities.loadIdsAsList(0, 100).size());
        this.spaceService.removeMember(space, this.demoIdentity.getRemoteId());
        ((CachedActivityStorage)this.activityStorage).clearCache();
        this.restartTransaction();
        activities = this.activityManager.getActivitiesByFilterWithListAccess(this.demoIdentity, activityFilter);
        ActivityManagerTest.assertEquals((int)2, (int)activities.getSize());
        ActivityManagerTest.assertEquals((int)2, (int)activities.loadAsList(0, 100).size());
        ActivityManagerTest.assertEquals((int)2, (int)activities.loadIdsAsList(0, 100).size());
    }

    public void testGetActivitiesBySpace() {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("Post activity to 'john' user stream by 'john'");
        activity.setUserId(this.johnIdentity.getId());
        this.activityManager.saveActivityNoReturn(this.johnIdentity, (ExoSocialActivity)activity);
        activity = new ExoSocialActivityImpl();
        activity.setTitle("Post activity to 'mary' user stream by 'demo'");
        activity.setUserId(this.demoIdentity.getId());
        this.activityManager.saveActivityNoReturn(this.maryIdentity, (ExoSocialActivity)activity);
        activity = new ExoSocialActivityImpl();
        activity.setTitle("Post activity to own stream");
        activity.setUserId(this.demoIdentity.getId());
        this.activityManager.saveActivityNoReturn(this.demoIdentity, (ExoSocialActivity)activity);
        Space space1 = this.getSpaceInstance(0);
        Space space2 = this.getSpaceInstance(1);
        this.restartTransaction();
        org.exoplatform.social.core.identity.model.Identity space1Identity = this.identityManager.getOrCreateSpaceIdentity(space1.getPrettyName());
        org.exoplatform.social.core.identity.model.Identity space2Identity = this.identityManager.getOrCreateSpaceIdentity(space2.getPrettyName());
        this.deleteSpaceAutomaticActivities(space1);
        this.deleteSpaceAutomaticActivities(space2);
        ActivityFilter activityFilter = new ActivityFilter();
        activityFilter.setStreamType(ActivityStreamType.ANY_SPACE_ACTIVITY);
        activityFilter.setSpaceIdentityId(space1Identity.getIdentityId());
        this.relationshipManager.inviteToConnect(this.demoIdentity, this.johnIdentity);
        this.relationshipManager.confirm(this.demoIdentity, this.johnIdentity);
        this.restartTransaction();
        this.deleteRelationshipAutomaticActivities(this.demoIdentity);
        RealtimeListAccess activities = this.activityManager.getActivitiesByFilterWithListAccess(this.demoIdentity, activityFilter);
        ActivityManagerTest.assertEquals((int)0, (int)activities.getSize());
        ActivityManagerTest.assertEquals((int)0, (int)activities.loadAsList(0, 100).size());
        ActivityManagerTest.assertEquals((int)0, (int)activities.loadIdsAsList(0, 100).size());
        for (int i = 0; i < 10; ++i) {
            activity = new ExoSocialActivityImpl();
            activity.setTitle("Activity Title Space 1: " + i);
            activity.setUserId(this.demoIdentity.getId());
            this.activityManager.saveActivityNoReturn(space1Identity, (ExoSocialActivity)activity);
            activity = new ExoSocialActivityImpl();
            activity.setTitle("Activity Title Space 2: " + i);
            activity.setUserId(this.demoIdentity.getId());
            this.activityManager.saveActivityNoReturn(space2Identity, (ExoSocialActivity)activity);
        }
        this.restartTransaction();
        activities = this.activityManager.getActivitiesByFilterWithListAccess(this.demoIdentity, activityFilter);
        ActivityManagerTest.assertEquals((int)10, (int)activities.getSize());
        ActivityManagerTest.assertEquals((int)10, (int)activities.loadAsList(0, 100).size());
        ActivityManagerTest.assertEquals((int)10, (int)activities.loadIdsAsList(0, 100).size());
        this.spaceService.removeMember(space1, this.demoIdentity.getRemoteId());
        ((CachedActivityStorage)this.activityStorage).clearCache();
        this.restartTransaction();
        Assert.assertThrows(IllegalAccessException.class, () -> this.activityManager.getActivitiesByFilterWithListAccess(this.demoIdentity, activityFilter));
    }

    public void testGetActivitiesBySpaceAndUser() {
        int i;
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("Post activity to 'john' user stream by 'john'");
        activity.setUserId(this.johnIdentity.getId());
        this.activityManager.saveActivityNoReturn(this.johnIdentity, (ExoSocialActivity)activity);
        activity = new ExoSocialActivityImpl();
        activity.setTitle("Post activity to 'mary' user stream by 'demo'");
        activity.setUserId(this.demoIdentity.getId());
        this.activityManager.saveActivityNoReturn(this.maryIdentity, (ExoSocialActivity)activity);
        activity = new ExoSocialActivityImpl();
        activity.setTitle("Post activity to own stream");
        activity.setUserId(this.demoIdentity.getId());
        this.activityManager.saveActivityNoReturn(this.demoIdentity, (ExoSocialActivity)activity);
        Space space1 = this.getSpaceInstance(0);
        Space space2 = this.getSpaceInstance(1);
        this.restartTransaction();
        org.exoplatform.social.core.identity.model.Identity space1Identity = this.identityManager.getOrCreateSpaceIdentity(space1.getPrettyName());
        org.exoplatform.social.core.identity.model.Identity space2Identity = this.identityManager.getOrCreateSpaceIdentity(space2.getPrettyName());
        this.deleteSpaceAutomaticActivities(space1);
        this.deleteSpaceAutomaticActivities(space2);
        ActivityFilter spaceActivityFilter = new ActivityFilter();
        spaceActivityFilter.setStreamType(ActivityStreamType.ANY_SPACE_ACTIVITY);
        spaceActivityFilter.setSpaceIdentityId(space1Identity.getIdentityId());
        spaceActivityFilter.setUserId(this.demoIdentity.getIdentityId());
        ActivityFilter userActivityFilter = new ActivityFilter();
        userActivityFilter.setStreamType(ActivityStreamType.USER_STREAM);
        userActivityFilter.setSpaceIdentityId(space1Identity.getIdentityId());
        userActivityFilter.setUserId(this.demoIdentity.getIdentityId());
        this.relationshipManager.inviteToConnect(this.demoIdentity, this.johnIdentity);
        this.relationshipManager.confirm(this.demoIdentity, this.johnIdentity);
        this.restartTransaction();
        this.deleteRelationshipAutomaticActivities(this.demoIdentity);
        RealtimeListAccess activities = this.activityManager.getActivitiesByFilterWithListAccess(this.demoIdentity, spaceActivityFilter);
        ActivityManagerTest.assertEquals((int)0, (int)activities.getSize());
        ActivityManagerTest.assertEquals((int)0, (int)activities.loadAsList(0, 100).size());
        ActivityManagerTest.assertEquals((int)0, (int)activities.loadIdsAsList(0, 100).size());
        activities = this.activityManager.getActivitiesByFilterWithListAccess(this.demoIdentity, userActivityFilter);
        ActivityManagerTest.assertEquals((int)0, (int)activities.getSize());
        ActivityManagerTest.assertEquals((int)0, (int)activities.loadAsList(0, 100).size());
        ActivityManagerTest.assertEquals((int)0, (int)activities.loadIdsAsList(0, 100).size());
        for (i = 0; i < 10; ++i) {
            activity = new ExoSocialActivityImpl();
            activity.setTitle("Activity Title Space 1: " + i);
            activity.setUserId(this.johnIdentity.getId());
            this.activityManager.saveActivityNoReturn(space1Identity, (ExoSocialActivity)activity);
            activity = new ExoSocialActivityImpl();
            activity.setTitle("Activity Title Space 2: " + i);
            activity.setUserId(this.demoIdentity.getId());
            this.activityManager.saveActivityNoReturn(space2Identity, (ExoSocialActivity)activity);
        }
        this.restartTransaction();
        activities = this.activityManager.getActivitiesByFilterWithListAccess(this.demoIdentity, spaceActivityFilter);
        ActivityManagerTest.assertEquals((int)0, (int)activities.getSize());
        ActivityManagerTest.assertEquals((int)0, (int)activities.loadAsList(0, 100).size());
        ActivityManagerTest.assertEquals((int)0, (int)activities.loadIdsAsList(0, 100).size());
        activities = this.activityManager.getActivitiesByFilterWithListAccess(this.demoIdentity, userActivityFilter);
        ActivityManagerTest.assertEquals((int)0, (int)activities.getSize());
        ActivityManagerTest.assertEquals((int)0, (int)activities.loadAsList(0, 100).size());
        ActivityManagerTest.assertEquals((int)0, (int)activities.loadIdsAsList(0, 100).size());
        for (i = 0; i < 10; ++i) {
            activity = new ExoSocialActivityImpl();
            activity.setTitle("Activity Title Space 1: " + i);
            activity.setUserId(this.demoIdentity.getId());
            this.activityManager.saveActivityNoReturn(space1Identity, (ExoSocialActivity)activity);
        }
        this.restartTransaction();
        activities = this.activityManager.getActivitiesByFilterWithListAccess(this.demoIdentity, spaceActivityFilter);
        ActivityManagerTest.assertEquals((int)10, (int)activities.getSize());
        ActivityManagerTest.assertEquals((int)10, (int)activities.loadAsList(0, 100).size());
        ActivityManagerTest.assertEquals((int)10, (int)activities.loadIdsAsList(0, 100).size());
        activities = this.activityManager.getActivitiesByFilterWithListAccess(this.demoIdentity, userActivityFilter);
        ActivityManagerTest.assertEquals((int)10, (int)activities.getSize());
        ActivityManagerTest.assertEquals((int)10, (int)activities.loadAsList(0, 100).size());
        ActivityManagerTest.assertEquals((int)10, (int)activities.loadIdsAsList(0, 100).size());
        this.spaceService.removeMember(space1, this.demoIdentity.getRemoteId());
        ((CachedActivityStorage)this.activityStorage).clearCache();
        this.restartTransaction();
        Assert.assertThrows(IllegalAccessException.class, () -> this.activityManager.getActivitiesByFilterWithListAccess(this.demoIdentity, spaceActivityFilter));
        spaceActivityFilter.setSpaceIdentityId(55896473L);
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.activityManager.getActivitiesByFilterWithListAccess(this.demoIdentity, spaceActivityFilter));
        Assert.assertThrows(IllegalAccessException.class, () -> this.activityManager.getActivitiesByFilterWithListAccess(this.demoIdentity, userActivityFilter));
        userActivityFilter.setSpaceIdentityId(55896473L);
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.activityManager.getActivitiesByFilterWithListAccess(this.demoIdentity, userActivityFilter));
    }

    public void testGetActivitiesWhenManager() {
        Space space = this.getSpaceInstance(0);
        this.restartTransaction();
        org.exoplatform.social.core.identity.model.Identity spaceIdentity = this.identityManager.getOrCreateSpaceIdentity(space.getPrettyName());
        this.deleteSpaceAutomaticActivities(space);
        this.spaceService.removeMember(space, this.johnIdentity.getRemoteId());
        ((CachedActivityStorage)this.activityStorage).clearCache();
        this.restartTransaction();
        ActivityFilter activityFilter = new ActivityFilter();
        activityFilter.setSpaceIdentityId(spaceIdentity.getIdentityId());
        activityFilter.setStreamType(ActivityStreamType.ANY_SPACE_ACTIVITY);
        RealtimeListAccess activities = this.activityManager.getActivitiesByFilterWithListAccess(this.johnIdentity, activityFilter);
        ActivityManagerTest.assertEquals((int)0, (int)activities.getSize());
        ActivityManagerTest.assertEquals((int)0, (int)activities.loadAsList(0, 100).size());
        ActivityManagerTest.assertEquals((int)0, (int)activities.loadIdsAsList(0, 100).size());
        for (int i = 0; i < 10; ++i) {
            ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
            activity.setTitle("Activity Title: " + i);
            activity.setUserId(this.demoIdentity.getId());
            this.activityManager.saveActivityNoReturn(spaceIdentity, (ExoSocialActivity)activity);
            activity = new ExoSocialActivityImpl();
            activity.setTitle("Activity Title: " + i);
            activity.setUserId(this.johnIdentity.getId());
            this.activityManager.saveActivityNoReturn(spaceIdentity, (ExoSocialActivity)activity);
        }
        this.restartTransaction();
        activities = this.activityManager.getActivitiesByFilterWithListAccess(this.demoIdentity, activityFilter);
        ActivityManagerTest.assertEquals((int)20, (int)activities.getSize());
        ActivityManagerTest.assertEquals((int)20, (int)activities.loadAsList(0, 100).size());
        ActivityManagerTest.assertEquals((int)20, (int)activities.loadIdsAsList(0, 100).size());
        activities = this.activityManager.getActivitiesByFilterWithListAccess(this.johnIdentity, activityFilter);
        ActivityManagerTest.assertEquals((int)20, (int)activities.getSize());
        ActivityManagerTest.assertEquals((int)20, (int)activities.loadAsList(0, 100).size());
        ActivityManagerTest.assertEquals((int)20, (int)activities.loadIdsAsList(0, 100).size());
        activityFilter.setSpaceIdentityId(0L);
        activityFilter.setStreamType(ActivityStreamType.ALL_STREAM);
        activities = this.activityManager.getActivitiesByFilterWithListAccess(this.johnIdentity, activityFilter);
        ActivityManagerTest.assertEquals((int)0, (int)activities.getSize());
        ActivityManagerTest.assertEquals((int)0, (int)activities.loadAsList(0, 100).size());
        ActivityManagerTest.assertEquals((int)0, (int)activities.loadIdsAsList(0, 100).size());
        activities = this.activityManager.getActivitiesByFilterWithListAccess(this.demoIdentity, activityFilter);
        ActivityManagerTest.assertEquals((int)20, (int)activities.getSize());
        ActivityManagerTest.assertEquals((int)20, (int)activities.loadAsList(0, 100).size());
        ActivityManagerTest.assertEquals((int)20, (int)activities.loadIdsAsList(0, 100).size());
        activityFilter.setUserId(this.johnIdentity.getIdentityId());
        activityFilter.setStreamType(ActivityStreamType.USER_STREAM);
        activities = this.activityManager.getActivitiesByFilterWithListAccess(this.johnIdentity, activityFilter);
        ActivityManagerTest.assertEquals((int)0, (int)activities.getSize());
        ActivityManagerTest.assertEquals((int)0, (int)activities.loadAsList(0, 100).size());
        ActivityManagerTest.assertEquals((int)0, (int)activities.loadIdsAsList(0, 100).size());
        activities = this.activityManager.getActivitiesByFilterWithListAccess(this.demoIdentity, activityFilter);
        ActivityManagerTest.assertEquals((int)10, (int)activities.getSize());
        ActivityManagerTest.assertEquals((int)10, (int)activities.loadAsList(0, 100).size());
        ActivityManagerTest.assertEquals((int)10, (int)activities.loadIdsAsList(0, 100).size());
    }

    public void testGetActivitiesWithLastCommentedFirst() {
        int i;
        ExoSocialActivityImpl johnActivity = new ExoSocialActivityImpl();
        johnActivity.setTitle("Post activity to 'john' user stream by 'john'");
        johnActivity.setUserId(this.johnIdentity.getId());
        this.activityManager.saveActivityNoReturn(this.johnIdentity, (ExoSocialActivity)johnActivity);
        ExoSocialActivityImpl maryActivity = new ExoSocialActivityImpl();
        maryActivity.setTitle("Post activity to 'mary' user stream by 'demo'");
        maryActivity.setUserId(this.demoIdentity.getId());
        this.activityManager.saveActivityNoReturn(this.maryIdentity, (ExoSocialActivity)maryActivity);
        Space space = this.getSpaceInstance(0);
        this.restartTransaction();
        this.relationshipManager.inviteToConnect(this.demoIdentity, this.johnIdentity);
        this.relationshipManager.confirm(this.demoIdentity, this.johnIdentity);
        this.restartTransaction();
        this.deleteSpaceAutomaticActivities(space);
        this.deleteRelationshipAutomaticActivities(this.demoIdentity);
        this.restartTransaction();
        ArrayList<ExoSocialActivityImpl> spaceActivities = new ArrayList<ExoSocialActivityImpl>();
        org.exoplatform.social.core.identity.model.Identity spaceIdentity = this.identityManager.getOrCreateSpaceIdentity(space.getPrettyName());
        for (int i2 = 0; i2 < 10; ++i2) {
            ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
            activity.setTitle("Activity Title: " + i2);
            activity.setUserId(this.johnIdentity.getId());
            this.activityManager.saveActivityNoReturn(spaceIdentity, (ExoSocialActivity)activity);
            spaceActivities.add(0, activity);
        }
        this.restartTransaction();
        ActivityFilter activityFilter = new ActivityFilter();
        activityFilter.setStreamType(ActivityStreamType.ALL_STREAM);
        RealtimeListAccess activitiesListAccess = this.activityManager.getActivitiesByFilterWithListAccess(this.demoIdentity, activityFilter);
        ActivityManagerTest.assertEquals((int)12, (int)activitiesListAccess.getSize());
        List activities = activitiesListAccess.loadAsList(0, 100);
        ActivityManagerTest.assertEquals((int)12, (int)activities.size());
        List activityIds = activitiesListAccess.loadIdsAsList(0, 100);
        ActivityManagerTest.assertEquals((int)12, (int)activityIds.size());
        for (i = 0; i < activities.size(); ++i) {
            ActivityManagerTest.assertEquals((String)((String)activityIds.get(i)), (String)((ExoSocialActivity)activities.get(i)).getId());
        }
        for (i = 0; i < spaceActivities.size(); ++i) {
            ActivityManagerTest.assertEquals((String)String.format("Activity n\u00b0%s doesn't match", i), (String)((String)activityIds.get(i)), (String)((ExoSocialActivity)spaceActivities.get(i)).getId());
        }
        ActivityManagerTest.assertEquals((String)((String)activityIds.get(10)), (String)maryActivity.getId());
        ActivityManagerTest.assertEquals((String)((String)activityIds.get(11)), (String)johnActivity.getId());
        ExoSocialActivityImpl johnActivityComment = new ExoSocialActivityImpl();
        johnActivityComment.setTitle("John's activity comment");
        johnActivityComment.setUserId(this.rootIdentity.getId());
        this.activityManager.saveComment((ExoSocialActivity)johnActivity, (ExoSocialActivity)johnActivityComment);
        activitiesListAccess = this.activityManager.getActivitiesByFilterWithListAccess(this.demoIdentity, activityFilter);
        ActivityManagerTest.assertEquals((int)12, (int)activitiesListAccess.getSize());
        activities = activitiesListAccess.loadAsList(0, 100);
        ActivityManagerTest.assertEquals((String)johnActivity.getId(), (String)((ExoSocialActivity)activities.get(0)).getId());
        activityIds = activitiesListAccess.loadIdsAsList(0, 100);
        ActivityManagerTest.assertEquals((String)johnActivity.getId(), (String)((String)activityIds.get(0)));
        ExoSocialActivityImpl maryActivityComment = new ExoSocialActivityImpl();
        maryActivityComment.setTitle("Mary's activity comment");
        maryActivityComment.setUserId(this.rootIdentity.getId());
        this.activityManager.saveComment((ExoSocialActivity)maryActivity, (ExoSocialActivity)maryActivityComment);
        activitiesListAccess = this.activityManager.getActivitiesByFilterWithListAccess(this.demoIdentity, activityFilter);
        ActivityManagerTest.assertEquals((int)12, (int)activitiesListAccess.getSize());
        activities = activitiesListAccess.loadAsList(0, 100);
        ActivityManagerTest.assertEquals((String)maryActivity.getId(), (String)((ExoSocialActivity)activities.get(0)).getId());
        activityIds = activitiesListAccess.loadIdsAsList(0, 100);
        ActivityManagerTest.assertEquals((String)maryActivity.getId(), (String)((String)activityIds.get(0)));
    }

    public void testGetActivitiesByCategoryIds() throws ActivityStorageException {
        String activityTitle = "title";
        String userId = this.rootIdentity.getId();
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle(activityTitle);
        activity.setUserId(userId);
        this.activityManager.saveActivityNoReturn(this.rootIdentity, (ExoSocialActivity)activity);
        activity = this.activityManager.getActivity(String.valueOf(activity.getId()));
        ActivityManagerTest.assertNotNull((Object)activity);
        ActivityManagerTest.assertEquals((String)activityTitle, (String)activity.getTitle());
        ActivityManagerTest.assertEquals((String)userId, (String)activity.getUserId());
        RealtimeListAccess activities = this.activityManager.getActivitiesWithListAccess(this.rootIdentity);
        ExoSocialActivity[] activitie = (ExoSocialActivity[])activities.load(0, 10);
        ActivityManagerTest.assertEquals((int)1, (int)activitie.length);
        for (int i = 0; i < 20; ++i) {
            activity = new ExoSocialActivityImpl();
            activity.setTitle(activityTitle + " " + i);
            activity.setUserId(userId);
            activity.setCategoryIds(Arrays.asList((long)i + 1L, (long)i + 2L));
            this.activityManager.saveActivityNoReturn(this.rootIdentity, (ExoSocialActivity)activity);
        }
        activities = this.activityManager.getActivitiesWithListAccess(this.rootIdentity);
        ActivityManagerTest.assertEquals((int)20, (int)((ExoSocialActivity[])activities.load(0, 20)).length);
        List<ExoSocialActivity> activityList = Arrays.asList((ExoSocialActivity[])activities.load(0, activities.getSize()));
        ActivityManagerTest.assertEquals((int)21, (int)activityList.size());
        ActivityFilter activityFilter = new ActivityFilter();
        activityFilter.setStreamType(ActivityStreamType.ALL_STREAM);
        activityFilter.setCategoryIds(Collections.singletonList(2L));
        activities = this.activityManager.getActivitiesByFilterWithListAccess(this.rootIdentity, activityFilter);
        ActivityManagerTest.assertEquals((int)2, (int)activities.getSize());
        activityList = Arrays.asList((ExoSocialActivity[])activities.load(0, 10));
        ActivityManagerTest.assertEquals((int)2, (int)activityList.size());
        ActivityManagerTest.assertNotNull((Object)activityList.get(0).getCategoryIds());
        ActivityManagerTest.assertEquals((int)2, (int)activityList.get(0).getCategoryIds().size());
        ActivityManagerTest.assertTrue((boolean)activityList.get(0).getCategoryIds().contains(2L));
        activityFilter = new ActivityFilter();
        activityFilter.setCategoryIds(Collections.singletonList(2L));
        activityFilter.setExcludedCategoryIds(Collections.singletonList(1L));
        activities = this.activityManager.getActivitiesByFilterWithListAccess(this.rootIdentity, activityFilter);
        ActivityManagerTest.assertEquals((int)1, (int)activities.getSize());
    }

    public void testUpdateActivity() throws Exception {
        String activityTitle = "activity title";
        String userId = this.johnIdentity.getId();
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle(activityTitle);
        activity.setUserId(userId);
        this.activityManager.saveActivityNoReturn(this.johnIdentity, (ExoSocialActivity)activity);
        activity = this.activityManager.getActivity(activity.getId());
        ActivityManagerTest.assertNotNull((String)"activity must not be null", (Object)activity);
        ActivityManagerTest.assertEquals((String)("activity.getTitle() must return: " + activityTitle), (String)activityTitle, (String)activity.getTitle());
        ActivityManagerTest.assertEquals((String)("activity.getUserId() must return: " + userId), (String)userId, (String)activity.getUserId());
        String newTitle = "new activity title";
        activity.setTitle(newTitle);
        this.activityManager.updateActivity((ExoSocialActivity)activity);
        activity = this.activityManager.getActivity(activity.getId());
        ActivityManagerTest.assertNotNull((String)"activity must not be null", (Object)activity);
        ActivityManagerTest.assertEquals((String)("activity.getTitle() must return: " + newTitle), (String)newTitle, (String)activity.getTitle());
        ActivityManagerTest.assertEquals((String)("activity.getUserId() must return: " + userId), (String)userId, (String)activity.getUserId());
    }

    public void testDeleteActivity() throws Exception {
        String activityTitle = "activity title";
        String userId = this.johnIdentity.getId();
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle(activityTitle);
        activity.setUserId(userId);
        this.activityManager.saveActivityNoReturn(this.johnIdentity, (ExoSocialActivity)activity);
        activity = this.activityManager.getActivity(activity.getId());
        ActivityManagerTest.assertNotNull((String)"activity must not be null", (Object)activity);
        ActivityManagerTest.assertEquals((String)("activity.getTitle() must return: " + activityTitle), (String)activityTitle, (String)activity.getTitle());
        ActivityManagerTest.assertEquals((String)("activity.getUserId() must return: " + userId), (String)userId, (String)activity.getUserId());
        this.activityManager.deleteActivity((ExoSocialActivity)activity);
    }

    public void testIsActivityExists() throws Exception {
        String activityTitle = "activity title";
        String userId = this.johnIdentity.getId();
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle(activityTitle);
        activity.setUserId(userId);
        this.activityManager.saveActivityNoReturn(this.johnIdentity, (ExoSocialActivity)activity);
        ActivityManagerTest.assertTrue((boolean)this.activityManager.isActivityExists(activity.getId()));
        activity = this.activityManager.getActivity(activity.getId());
        this.activityManager.deleteActivity((ExoSocialActivity)activity);
        ActivityManagerTest.assertFalse((boolean)this.activityManager.isActivityExists(activity.getId()));
    }

    public void testDeleteActivityWithId() throws Exception {
        String activityTitle = "activity title";
        String userId = this.johnIdentity.getId();
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle(activityTitle);
        activity.setUserId(userId);
        this.activityManager.saveActivityNoReturn(this.johnIdentity, (ExoSocialActivity)activity);
        activity = this.activityManager.getActivity(activity.getId());
        ActivityManagerTest.assertNotNull((String)"activity must not be null", (Object)activity);
        ActivityManagerTest.assertEquals((String)("activity.getTitle() must return: " + activityTitle), (String)activityTitle, (String)activity.getTitle());
        ActivityManagerTest.assertEquals((String)("activity.getUserId() must return: " + userId), (String)userId, (String)activity.getUserId());
        this.activityManager.deleteActivity(activity.getId());
    }

    public void testSaveSubComment() throws Exception {
        String activityTitle = "activity title";
        String userId = this.johnIdentity.getId();
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle(activityTitle);
        activity.setUserId(userId);
        this.activityManager.saveActivityNoReturn(this.johnIdentity, (ExoSocialActivity)activity);
        String commentTitle = "Comment title";
        ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
        comment.setTitle(commentTitle);
        comment.setUserId(this.demoIdentity.getId());
        this.activityManager.saveComment((ExoSocialActivity)activity, (ExoSocialActivity)comment);
        ActivityManagerTest.assertEquals((String)activity.getId(), (String)comment.getParentId());
        ActivityManagerTest.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)comment.getId()));
        ExoSocialActivityImpl subComment = new ExoSocialActivityImpl();
        subComment.setTitle(commentTitle);
        subComment.setUserId(this.maryIdentity.getId());
        subComment.setParentCommentId(comment.getId());
        this.activityManager.saveComment((ExoSocialActivity)activity, (ExoSocialActivity)subComment);
        ActivityManagerTest.assertEquals((String)activity.getId(), (String)subComment.getParentId());
        ActivityManagerTest.assertEquals((String)comment.getId(), (String)subComment.getParentCommentId());
        ActivityManagerTest.assertNotNull((Object)subComment.getId());
        List subComments = this.activityManager.getSubComments((ExoSocialActivity)comment);
        ActivityManagerTest.assertEquals((int)1, (int)subComments.size());
        ActivityManagerTest.assertEquals((String)subComment.getId(), (String)((ExoSocialActivity)subComments.get(0)).getId());
        ExoSocialActivity gotParentActivity = this.activityManager.getParentActivity((ExoSocialActivity)subComment);
        ActivityManagerTest.assertNotNull((Object)gotParentActivity);
        ActivityManagerTest.assertEquals((String)activity.getId(), (String)gotParentActivity.getId());
        String[] replyToIds = gotParentActivity.getReplyToId();
        ActivityManagerTest.assertEquals((int)2, (int)replyToIds.length);
        for (String replyToId : replyToIds) {
            ActivityManagerTest.assertTrue((replyToId.equals(comment.getId()) || replyToId.equals(subComment.getId()) ? 1 : 0) != 0);
        }
    }

    public void testGetCommentsWithListAccess() throws Exception {
        ExoSocialActivityImpl demoActivity = new ExoSocialActivityImpl();
        demoActivity.setTitle("demo activity");
        demoActivity.setUserId(demoActivity.getId());
        this.activityManager.saveActivityNoReturn(this.demoIdentity, (ExoSocialActivity)demoActivity);
        int total = 10;
        for (int i = 0; i < total; ++i) {
            ExoSocialActivityImpl maryComment = new ExoSocialActivityImpl();
            maryComment.setUserId(this.maryIdentity.getId());
            maryComment.setTitle("mary comment");
            this.activityManager.saveComment((ExoSocialActivity)demoActivity, (ExoSocialActivity)maryComment);
        }
        RealtimeListAccess maryComments = this.activityManager.getCommentsWithListAccess((ExoSocialActivity)demoActivity);
        ActivityManagerTest.assertNotNull((String)"maryComments must not be null", (Object)maryComments);
        ActivityManagerTest.assertEquals((String)"maryComments.getSize() must return: 10", (int)total, (int)maryComments.getSize());
    }

    public void testGetCommentsAndSubCommentsWithListAccess() throws Exception {
        ExoSocialActivityImpl demoActivity = new ExoSocialActivityImpl();
        demoActivity.setTitle("demo activity");
        demoActivity.setUserId(demoActivity.getId());
        this.activityManager.saveActivityNoReturn(this.demoIdentity, (ExoSocialActivity)demoActivity);
        int total = 10;
        int totalWithSubComments = total + total * total;
        for (int i = 0; i < total; ++i) {
            ExoSocialActivityImpl maryComment = new ExoSocialActivityImpl();
            maryComment.setUserId(this.maryIdentity.getId());
            maryComment.setTitle("mary comment");
            this.activityManager.saveComment((ExoSocialActivity)demoActivity, (ExoSocialActivity)maryComment);
            for (int j = 0; j < total; ++j) {
                ExoSocialActivityImpl johnComment = new ExoSocialActivityImpl();
                johnComment.setUserId(this.johnIdentity.getId());
                johnComment.setTitle("john comment" + i + j);
                johnComment.setParentCommentId(maryComment.getId());
                this.activityManager.saveComment((ExoSocialActivity)demoActivity, (ExoSocialActivity)johnComment);
            }
        }
        RealtimeListAccess maryComments = this.activityManager.getCommentsWithListAccess((ExoSocialActivity)demoActivity);
        ActivityManagerTest.assertNotNull((String)"maryComments must not be null", (Object)maryComments);
        ActivityManagerTest.assertEquals((String)"maryComments.getSize() must return: 10", (int)total, (int)maryComments.getSize());
        RealtimeListAccess comments = this.activityManager.getCommentsWithListAccess((ExoSocialActivity)demoActivity, true);
        ActivityManagerTest.assertNotNull((String)"comments must not be null", (Object)comments);
        ActivityManagerTest.assertEquals((String)"comments.getSize() must return: 10", (int)total, (int)comments.getSize());
        ExoSocialActivity[] commentsArray = (ExoSocialActivity[])comments.load(0, total);
        ActivityManagerTest.assertEquals((String)"commentsArray.length must return: 110", (int)totalWithSubComments, (int)commentsArray.length);
        int index = 0;
        for (int i = 0; i < total; ++i) {
            ExoSocialActivity maryComment = commentsArray[index++];
            ActivityManagerTest.assertEquals((String)("Title of comment should be 'mary comment', iteration = " + i), (String)"mary comment", (String)maryComment.getTitle());
            for (int j = 0; j < total; ++j) {
                ExoSocialActivity johnComment = commentsArray[index++];
                ActivityManagerTest.assertEquals((String)("Title of comment should be 'john comment " + i + j + "'"), (String)("john comment" + i + j), (String)johnComment.getTitle());
            }
        }
    }

    public void testGetCommentsAndSubCommentsWithListAccessDescending() throws Exception {
        ExoSocialActivityImpl demoActivity = new ExoSocialActivityImpl();
        demoActivity.setTitle("demo activity");
        demoActivity.setUserId(demoActivity.getId());
        this.activityManager.saveActivityNoReturn(this.demoIdentity, (ExoSocialActivity)demoActivity);
        int total = 10;
        int totalWithSubComments = total + total * total;
        for (int i = 0; i < total; ++i) {
            ExoSocialActivityImpl maryComment = new ExoSocialActivityImpl();
            maryComment.setUserId(this.maryIdentity.getId());
            maryComment.setTitle("mary comment");
            this.activityManager.saveComment((ExoSocialActivity)demoActivity, (ExoSocialActivity)maryComment);
            for (int j = 0; j < total; ++j) {
                ExoSocialActivityImpl johnComment = new ExoSocialActivityImpl();
                johnComment.setUserId(this.johnIdentity.getId());
                johnComment.setTitle("john comment" + i + j);
                johnComment.setParentCommentId(maryComment.getId());
                this.activityManager.saveComment((ExoSocialActivity)demoActivity, (ExoSocialActivity)johnComment);
            }
        }
        RealtimeListAccess maryComments = this.activityManager.getCommentsWithListAccess((ExoSocialActivity)demoActivity);
        ActivityManagerTest.assertNotNull((String)"maryComments must not be null", (Object)maryComments);
        ActivityManagerTest.assertEquals((String)"maryComments.getSize() must return: 10", (int)total, (int)maryComments.getSize());
        RealtimeListAccess comments = this.activityManager.getCommentsWithListAccess((ExoSocialActivity)demoActivity, true, true);
        ActivityManagerTest.assertNotNull((String)"comments must not be null", (Object)comments);
        ActivityManagerTest.assertEquals((String)"comments.getSize() must return: 10", (int)total, (int)comments.getSize());
        ExoSocialActivity[] commentsArray = (ExoSocialActivity[])comments.load(0, total);
        ActivityManagerTest.assertEquals((String)"commentsArray.length must return: 110", (int)totalWithSubComments, (int)commentsArray.length);
        int index = 0;
        for (int i = 0; i < total; ++i) {
            ExoSocialActivity maryComment = commentsArray[index++];
            ActivityManagerTest.assertEquals((String)("Title of comment should be 'mary comment', iteration = " + (total - i - 1)), (String)"mary comment", (String)maryComment.getTitle());
            for (int j = 0; j < total; ++j) {
                ExoSocialActivity johnComment = commentsArray[index++];
                ActivityManagerTest.assertEquals((String)("Title of comment should be 'john comment " + (total - i - 1) + j + "'"), (String)("john comment" + (total - i - 1) + j), (String)johnComment.getTitle());
            }
        }
    }

    public void testSaveLike() throws Exception {
        ExoSocialActivityImpl demoActivity = new ExoSocialActivityImpl();
        demoActivity.setTitle("&\"demo activity");
        demoActivity.setUserId(demoActivity.getId());
        this.activityManager.saveActivityNoReturn(this.demoIdentity, (ExoSocialActivity)demoActivity);
        demoActivity = this.activityManager.getActivity(demoActivity.getId());
        ActivityManagerTest.assertEquals((String)"demoActivity.getLikeIdentityIds() must return: 0", (int)0, (int)demoActivity.getLikeIdentityIds().length);
        this.activityManager.saveLike((ExoSocialActivity)demoActivity, this.johnIdentity);
        demoActivity = this.activityManager.getActivity(demoActivity.getId());
        ActivityManagerTest.assertEquals((String)"demoActivity.getLikeIdentityIds().length must return: 1", (int)1, (int)demoActivity.getLikeIdentityIds().length);
        ActivityManagerTest.assertEquals((String)"&amp;&#34;demo activity", (String)demoActivity.getTitle());
    }

    public void testSaveLikeNotChangeTemplateParam() throws Exception {
        ExoSocialActivityImpl demoActivity = new ExoSocialActivityImpl();
        demoActivity.setTitle("title");
        demoActivity.setUserId(demoActivity.getId());
        HashMap<String, String> templateParams = new HashMap<String, String>();
        templateParams.put("link", "http://exoplatform.com?test=<script>");
        demoActivity.setTemplateParams(templateParams);
        this.activityManager.saveActivityNoReturn(this.demoIdentity, (ExoSocialActivity)demoActivity);
        demoActivity = this.activityManager.getActivity(demoActivity.getId());
        ActivityManagerTest.assertEquals((String)"demoActivity.getLikeIdentityIds() must return: 0", (int)0, (int)demoActivity.getLikeIdentityIds().length);
        this.activityManager.saveLike((ExoSocialActivity)demoActivity, this.johnIdentity);
        ExoSocialActivity likedActivity = this.activityManager.getActivity(demoActivity.getId());
        ActivityManagerTest.assertEquals((int)1, (int)likedActivity.getLikeIdentityIds().length);
        ActivityManagerTest.assertEquals((String)((String)templateParams.get("link")), (String)((String)likedActivity.getTemplateParams().get("link")));
    }

    public void testDeleteLike() throws Exception {
        ExoSocialActivityImpl demoActivity = new ExoSocialActivityImpl();
        demoActivity.setTitle("demo activity");
        demoActivity.setUserId(demoActivity.getId());
        this.activityManager.saveActivityNoReturn(this.demoIdentity, (ExoSocialActivity)demoActivity);
        demoActivity = this.activityManager.getActivity(demoActivity.getId());
        ActivityManagerTest.assertEquals((String)"demoActivity.getLikeIdentityIds() must return: 0", (int)0, (int)demoActivity.getLikeIdentityIds().length);
        this.activityManager.saveLike((ExoSocialActivity)demoActivity, this.johnIdentity);
        demoActivity = this.activityManager.getActivity(demoActivity.getId());
        ActivityManagerTest.assertEquals((String)"demoActivity.getLikeIdentityIds().length must return: 1", (int)1, (int)demoActivity.getLikeIdentityIds().length);
        this.activityManager.deleteLike((ExoSocialActivity)demoActivity, this.johnIdentity);
        demoActivity = this.activityManager.getActivity(demoActivity.getId());
        ActivityManagerTest.assertEquals((String)"demoActivity.getLikeIdentityIds().length must return: 0", (int)0, (int)demoActivity.getLikeIdentityIds().length);
        this.activityManager.deleteLike((ExoSocialActivity)demoActivity, this.maryIdentity);
        demoActivity = this.activityManager.getActivity(demoActivity.getId());
        ActivityManagerTest.assertEquals((String)"demoActivity.getLikeIdentityIds().length must return: 0", (int)0, (int)demoActivity.getLikeIdentityIds().length);
        this.activityManager.deleteLike((ExoSocialActivity)demoActivity, this.rootIdentity);
        demoActivity = this.activityManager.getActivity(demoActivity.getId());
        ActivityManagerTest.assertEquals((String)"demoActivity.getLikeIdentityIds().length must return: 0", (int)0, (int)demoActivity.getLikeIdentityIds().length);
    }

    public void testDeleteLikeNotChangeTemplateParam() throws Exception {
        ExoSocialActivityImpl demoActivity = new ExoSocialActivityImpl();
        demoActivity.setTitle("title");
        demoActivity.setUserId(demoActivity.getId());
        HashMap<String, String> templateParams = new HashMap<String, String>();
        templateParams.put("link", "http://exoplatform.com?test=<script>");
        demoActivity.setTemplateParams(templateParams);
        this.activityManager.saveActivityNoReturn(this.demoIdentity, (ExoSocialActivity)demoActivity);
        demoActivity = this.activityManager.getActivity(demoActivity.getId());
        this.activityManager.saveLike((ExoSocialActivity)demoActivity, this.johnIdentity);
        ExoSocialActivity likedActivity = this.activityManager.getActivity(demoActivity.getId());
        ActivityManagerTest.assertEquals((int)1, (int)likedActivity.getLikeIdentityIds().length);
        demoActivity = this.activityManager.getActivity(demoActivity.getId());
        this.activityManager.deleteLike((ExoSocialActivity)demoActivity, this.johnIdentity);
        ExoSocialActivity deleteLikeActivity = this.activityManager.getActivity(demoActivity.getId());
        ActivityManagerTest.assertEquals((int)0, (int)deleteLikeActivity.getLikeIdentityIds().length);
        ActivityManagerTest.assertEquals((String)((String)templateParams.get("link")), (String)((String)deleteLikeActivity.getTemplateParams().get("link")));
    }

    public void testGetActivitiesWithListAccess() throws Exception {
        int total = 10;
        for (int i = 0; i < total; ++i) {
            ExoSocialActivityImpl demoActivity = new ExoSocialActivityImpl();
            demoActivity.setTitle("demo activity");
            demoActivity.setUserId(demoActivity.getId());
            this.activityManager.saveActivityNoReturn(this.demoIdentity, (ExoSocialActivity)demoActivity);
        }
        RealtimeListAccess demoListAccess = this.activityManager.getActivitiesWithListAccess(this.demoIdentity);
        ActivityManagerTest.assertNotNull((String)"demoListAccess must not be null", (Object)demoListAccess);
        ActivityManagerTest.assertEquals((String)"demoListAccess.getSize() must return: 10", (int)10, (int)demoListAccess.getSize());
    }

    public void testGetActivitiesOfUserSpacesWithListAccess() throws Exception {
        Space space = this.getSpaceInstance(0);
        org.exoplatform.social.core.identity.model.Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", space.getPrettyName(), false);
        int totalNumber = 10;
        for (int i = 0; i < totalNumber; ++i) {
            ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
            activity.setTitle("activity title " + i);
            activity.setUserId(this.demoIdentity.getId());
            this.activityManager.saveActivityNoReturn(spaceIdentity, (ExoSocialActivity)activity);
        }
        space = this.spaceService.getSpaceById(space.getId());
        ActivityManagerTest.assertNotNull((String)"space must not be null", (Object)space);
        ActivityManagerTest.assertEquals((String)"space.getDisplayName() must return: my space 0", (String)"my space 0", (String)space.getDisplayName());
        ActivityManagerTest.assertEquals((String)"space.getDescription() must return: add new space 0", (String)"add new space 0", (String)space.getDescription());
        RealtimeListAccess demoActivities = this.activityManager.getActivitiesOfUserSpacesWithListAccess(this.demoIdentity);
        ActivityManagerTest.assertNotNull((String)"demoActivities must not be null", (Object)demoActivities);
        ActivityManagerTest.assertEquals((String)"demoActivities.getSize() must return: 10", (int)10, (int)demoActivities.getSize());
        Space space2 = this.getSpaceInstance(1);
        org.exoplatform.social.core.identity.model.Identity spaceIdentity2 = this.identityManager.getOrCreateIdentity("space", space2.getPrettyName(), false);
        for (int i = 0; i < totalNumber; ++i) {
            ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
            activity.setTitle("activity title " + i);
            activity.setUserId(this.demoIdentity.getId());
            this.activityManager.saveActivityNoReturn(spaceIdentity2, (ExoSocialActivity)activity);
        }
        space2 = this.spaceService.getSpaceById(space2.getId());
        ActivityManagerTest.assertNotNull((String)"space2 must not be null", (Object)space2);
        ActivityManagerTest.assertEquals((String)"space2.getDisplayName() must return: my space 1", (String)"my space 1", (String)space2.getDisplayName());
        ActivityManagerTest.assertEquals((String)"space2.getDescription() must return: add new space 1", (String)"add new space 1", (String)space2.getDescription());
        demoActivities = this.activityManager.getActivitiesOfUserSpacesWithListAccess(this.demoIdentity);
        ActivityManagerTest.assertNotNull((String)"demoActivities must not be null", (Object)demoActivities);
        ActivityManagerTest.assertEquals((String)"demoActivities.getSize() must return: 20", (int)20, (int)demoActivities.getSize());
        demoActivities = this.activityManager.getActivitiesOfUserSpacesWithListAccess(this.maryIdentity);
        ActivityManagerTest.assertNotNull((String)"demoActivities must not be null", (Object)demoActivities);
        ActivityManagerTest.assertEquals((String)"demoActivities.getSize() must return: 0", (int)0, (int)demoActivities.getSize());
    }

    public void testGetActivityFeedWithListAccess() throws Exception {
        this.populateActivityMass(this.demoIdentity, 3);
        this.populateActivityMass(this.maryIdentity, 3);
        this.populateActivityMass(this.johnIdentity, 2);
        Space space = this.getSpaceInstance(0);
        org.exoplatform.social.core.identity.model.Identity spaceIdentity = this.identityManager.getOrCreateSpaceIdentity(space.getPrettyName());
        this.populateActivityMass(spaceIdentity, 5);
        RealtimeListAccess demoActivityFeed = this.activityManager.getActivityFeedWithListAccess(this.demoIdentity);
        ActivityManagerTest.assertEquals((String)"demoActivityFeed.getSize() must be 8", (int)8, (int)demoActivityFeed.getSize());
        ActivityManagerTest.assertEquals((int)8, (int)((ExoSocialActivity[])demoActivityFeed.load(0, 10)).length);
        this.relationshipManager.delete(new Relationship(this.demoIdentity, this.maryIdentity));
        this.restartTransaction();
        this.relationshipManager.inviteToConnect(this.demoIdentity, this.maryIdentity);
        this.restartTransaction();
        ActivityManagerTest.assertEquals((int)8, (int)this.activityManager.getActivityFeedWithListAccess(this.demoIdentity).getSize());
        this.relationshipManager.confirm(this.demoIdentity, this.maryIdentity);
        this.restartTransaction();
        this.populateActivityMass(this.demoIdentity, 1);
        demoActivityFeed = this.activityManager.getActivityFeedWithListAccess(this.demoIdentity);
        ActivityManagerTest.assertEquals((int)14, (int)demoActivityFeed.getSize());
        ActivityManagerTest.assertEquals((int)14, (int)((ExoSocialActivity[])demoActivityFeed.load(0, 15)).length);
        ActivityManagerTest.assertEquals((int)10, (int)((ExoSocialActivity[])demoActivityFeed.load(5, 15)).length);
        RealtimeListAccess maryActivityFeed = this.activityManager.getActivityFeedWithListAccess(this.maryIdentity);
        ActivityManagerTest.assertEquals((int)9, (int)maryActivityFeed.getSize());
        ActivityManagerTest.assertEquals((int)9, (int)((ExoSocialActivity[])maryActivityFeed.load(0, 10)).length);
        this.createActivityToOtherIdentity(this.demoIdentity, spaceIdentity, 5);
        demoActivityFeed = this.activityManager.getActivityFeedWithListAccess(this.demoIdentity);
        ActivityManagerTest.assertEquals((int)19, (int)demoActivityFeed.getSize());
        RealtimeListAccess demoActivitiesSpaceFeed = this.activityManager.getActivitiesOfUserSpacesWithListAccess(this.demoIdentity);
        ActivityManagerTest.assertEquals((int)10, (int)demoActivitiesSpaceFeed.getSize());
        ActivityManagerTest.assertEquals((int)10, (int)((ExoSocialActivity[])demoActivitiesSpaceFeed.load(0, 10)).length);
        maryActivityFeed = this.activityManager.getActivityFeedWithListAccess(this.maryIdentity);
        ActivityManagerTest.assertEquals((int)9, (int)maryActivityFeed.getSize());
        RealtimeListAccess johnSpaceActivitiesFeed = this.activityManager.getActivitiesOfUserSpacesWithListAccess(this.johnIdentity);
        ActivityManagerTest.assertEquals((int)10, (int)johnSpaceActivitiesFeed.getSize());
    }

    public void testGetActivityByStreamTypeWithListAccess() throws ObjectAlreadyExistsException {
        this.populateActivityMass(this.demoIdentity, 1);
        this.populateActivityMass(this.maryIdentity, 2);
        this.populateActivityMass(this.johnIdentity, 3);
        Space space = this.getSpaceInstance(1);
        org.exoplatform.social.core.identity.model.Identity spaceIdentity = this.identityManager.getOrCreateSpaceIdentity(space.getPrettyName());
        this.populateActivityMass(spaceIdentity, 4);
        Space space1 = this.getSpaceInstance(2);
        org.exoplatform.social.core.identity.model.Identity space1Identity = this.identityManager.getOrCreateSpaceIdentity(space1.getPrettyName());
        this.populateActivityMass(space1Identity, 3);
        FavoriteService favoriteService = (FavoriteService)ExoContainerContext.getService(FavoriteService.class);
        Favorite favoriteSpace = new Favorite("space", space.getId(), null, Long.parseLong(this.demoIdentity.getId()));
        favoriteService.createFavorite(favoriteSpace);
        Favorite favoriteActivity = new Favorite("activity", "1", null, Long.parseLong(this.demoIdentity.getId()));
        favoriteService.createFavorite(favoriteActivity);
        ActivityFilter activityFilter = new ActivityFilter();
        activityFilter.setStreamType(ActivityStreamType.USER_STREAM);
        RealtimeListAccess streamTypeActivities = this.activityManager.getActivitiesByFilterWithListAccess(this.demoIdentity, activityFilter);
        ActivityManagerTest.assertEquals((int)1, (int)((ExoSocialActivity[])streamTypeActivities.load(0, 10)).length);
        activityFilter.setStreamType(ActivityStreamType.USER_FAVORITE_STREAM);
        streamTypeActivities = this.activityManager.getActivitiesByFilterWithListAccess(this.demoIdentity, activityFilter);
        ActivityManagerTest.assertEquals((int)1, (int)streamTypeActivities.getSize());
        activityFilter = new ActivityFilter();
        activityFilter.setStreamType(ActivityStreamType.MANAGE_SPACES_STREAM);
        streamTypeActivities = this.activityManager.getActivitiesByFilterWithListAccess(this.demoIdentity, activityFilter);
        ActivityManagerTest.assertEquals((int)7, (int)((ExoSocialActivity[])streamTypeActivities.load(0, 10)).length);
        activityFilter = new ActivityFilter();
        activityFilter.setStreamType(ActivityStreamType.FAVORITE_SPACES_STREAM);
        streamTypeActivities = this.activityManager.getActivitiesByFilterWithListAccess(this.demoIdentity, activityFilter);
        ActivityManagerTest.assertEquals((int)4, (int)((ExoSocialActivity[])streamTypeActivities.load(0, 10)).length);
    }

    public void testLoadMoreActivities() throws Exception {
        this.populateActivityMass(this.demoIdentity, 30);
        RealtimeListAccess demoActivityFeed = this.activityManager.getActivityFeedWithListAccess(this.demoIdentity);
        ActivityManagerTest.assertEquals((int)30, (int)demoActivityFeed.getSize());
        ActivityManagerTest.assertEquals((int)10, (int)((ExoSocialActivity[])demoActivityFeed.load(0, 10)).length);
        ActivityManagerTest.assertEquals((int)20, (int)((ExoSocialActivity[])demoActivityFeed.load(0, 20)).length);
        ActivityManagerTest.assertEquals((int)10, (int)((ExoSocialActivity[])demoActivityFeed.load(20, 10)).length);
        ActivityManagerTest.assertEquals((int)15, (int)((ExoSocialActivity[])demoActivityFeed.load(15, 20)).length);
    }

    public void testGetComments() throws ActivityStorageException {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("blah blah");
        this.activityManager.saveActivityNoReturn(this.rootIdentity, (ExoSocialActivity)activity);
        ArrayList<ExoSocialActivityImpl> comments = new ArrayList<ExoSocialActivityImpl>();
        for (int i = 0; i < 3; ++i) {
            ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
            comment.setTitle("comment " + i);
            comment.setUserId(this.rootIdentity.getId());
            this.activityManager.saveComment((ExoSocialActivity)activity, (ExoSocialActivity)comment);
            ActivityManagerTest.assertNotNull((String)"comment.getId() must not be null", (Object)comment.getId());
            comments.add(comment);
        }
        this.restartTransaction();
        RealtimeListAccess listAccess = this.activityManager.getCommentsWithListAccess((ExoSocialActivity)activity);
        ActivityManagerTest.assertEquals((int)3, (int)listAccess.getSize());
        List listComments = listAccess.loadAsList(0, 5);
        ActivityManagerTest.assertEquals((int)3, (int)listComments.size());
        ActivityManagerTest.assertEquals((String)"comment 0", (String)((ExoSocialActivity)listComments.get(0)).getTitle());
        ActivityManagerTest.assertEquals((String)"comment 1", (String)((ExoSocialActivity)listComments.get(1)).getTitle());
        ActivityManagerTest.assertEquals((String)"comment 2", (String)((ExoSocialActivity)listComments.get(2)).getTitle());
        ExoSocialActivity assertActivity = this.activityManager.getActivity(activity.getId());
        String[] commentIds = assertActivity.getReplyToId();
        for (int i = 1; i < commentIds.length; ++i) {
            ActivityManagerTest.assertEquals((String)((ExoSocialActivity)comments.get(i - 1)).getId(), (String)commentIds[i - 1]);
        }
    }

    public void testGetActivitiesOfConnections() throws Exception {
        this.populateActivityMass(this.johnIdentity, 10);
        RealtimeListAccess demoConnectionActivities = this.activityManager.getActivitiesOfConnectionsWithListAccess(this.demoIdentity);
        ActivityManagerTest.assertEquals((int)0, (int)((ExoSocialActivity[])demoConnectionActivities.load(0, 20)).length);
        ActivityManagerTest.assertEquals((int)0, (int)demoConnectionActivities.getSize());
        this.relationshipManager.inviteToConnect(this.demoIdentity, this.johnIdentity);
        this.relationshipManager.confirm(this.johnIdentity, this.demoIdentity);
        this.restartTransaction();
        this.populateActivityMass(this.johnIdentity, 1);
        demoConnectionActivities = this.activityManager.getActivitiesOfConnectionsWithListAccess(this.demoIdentity);
        ActivityManagerTest.assertEquals((int)12, (int)((ExoSocialActivity[])demoConnectionActivities.load(0, 20)).length);
        ActivityManagerTest.assertEquals((int)12, (int)demoConnectionActivities.getSize());
        this.populateActivityMass(this.maryIdentity, 10);
        this.relationshipManager.inviteToConnect(this.demoIdentity, this.maryIdentity);
        this.relationshipManager.confirm(this.maryIdentity, this.demoIdentity);
        this.restartTransaction();
        this.populateActivityMass(this.maryIdentity, 1);
        demoConnectionActivities = this.activityManager.getActivitiesOfConnectionsWithListAccess(this.demoIdentity);
        ActivityManagerTest.assertEquals((int)24, (int)((ExoSocialActivity[])demoConnectionActivities.load(0, 30)).length);
        ActivityManagerTest.assertEquals((int)24, (int)demoConnectionActivities.getSize());
    }

    public void testGetActivitiesOfConnectionswithOffsetLimit() {
        this.populateActivityMass(this.johnIdentity, 10);
        RealtimeListAccess demoConnectionActivities = this.activityManager.getActivitiesOfConnectionsWithListAccess(this.demoIdentity);
        ActivityManagerTest.assertNotNull((String)"demoConnectionActivities must not be null", (Object)demoConnectionActivities.load(0, 20));
        ActivityManagerTest.assertEquals((String)"demoConnectionActivities.size() must return: 0", (int)0, (int)demoConnectionActivities.getSize());
        Relationship demoJohnRelationship = this.relationshipManager.inviteToConnect(this.demoIdentity, this.johnIdentity);
        this.relationshipManager.confirm(this.demoIdentity, this.johnIdentity);
        this.restartTransaction();
        this.populateActivityMass(this.johnIdentity, 1);
        demoConnectionActivities = this.activityManager.getActivitiesOfConnectionsWithListAccess(this.demoIdentity);
        ActivityManagerTest.assertEquals((int)12, (int)((ExoSocialActivity[])demoConnectionActivities.load(0, 20)).length);
        demoConnectionActivities = this.activityManager.getActivitiesOfConnectionsWithListAccess(this.demoIdentity);
        ActivityManagerTest.assertEquals((int)12, (int)demoConnectionActivities.getSize());
        this.populateActivityMass(this.maryIdentity, 10);
        Relationship demoMaryRelationship = this.relationshipManager.inviteToConnect(this.demoIdentity, this.maryIdentity);
        this.relationshipManager.confirm(this.demoIdentity, this.maryIdentity);
        this.restartTransaction();
        this.populateActivityMass(this.maryIdentity, 1);
        demoConnectionActivities = this.activityManager.getActivitiesOfConnectionsWithListAccess(this.demoIdentity);
        ActivityManagerTest.assertEquals((int)24, (int)((ExoSocialActivity[])demoConnectionActivities.load(0, 30)).length);
        ActivityManagerTest.assertEquals((int)24, (int)demoConnectionActivities.getSize());
        this.relationshipManager.delete(demoJohnRelationship);
        this.relationshipManager.delete(demoMaryRelationship);
    }

    public void testRemoveLikeSubComment() {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("hello");
        activity.setUserId(this.rootIdentity.getId());
        this.activityManager.saveActivityNoReturn(this.rootIdentity, (ExoSocialActivity)activity);
        ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
        comment.setTitle("demo comment");
        comment.setUserId(this.demoIdentity.getId());
        this.activityManager.saveComment((ExoSocialActivity)activity, (ExoSocialActivity)comment);
        ExoSocialActivityImpl commentReply = new ExoSocialActivityImpl();
        commentReply.setTitle("mary comment reply");
        commentReply.setUserId(this.maryIdentity.getId());
        commentReply.setParentCommentId(comment.getId());
        this.activityManager.saveComment((ExoSocialActivity)activity, (ExoSocialActivity)commentReply);
        RealtimeListAccess demoActivities = this.activityManager.getActivityFeedWithListAccess(this.demoIdentity);
        ActivityManagerTest.assertEquals((int)1, (int)demoActivities.getSize());
        ActivityManagerTest.assertEquals((int)1, (int)((ExoSocialActivity[])demoActivities.load(0, 10)).length);
        RealtimeListAccess maryActivities = this.activityManager.getActivityFeedWithListAccess(this.maryIdentity);
        ActivityManagerTest.assertEquals((int)1, (int)maryActivities.getSize());
        ActivityManagerTest.assertEquals((int)1, (int)((ExoSocialActivity[])maryActivities.load(0, 10)).length);
        demoActivities = this.activityManager.getActivitiesWithListAccess(this.demoIdentity);
        ActivityManagerTest.assertEquals((int)1, (int)demoActivities.getSize());
        ActivityManagerTest.assertEquals((int)1, (int)((ExoSocialActivity[])demoActivities.load(0, 10)).length);
        maryActivities = this.activityManager.getActivitiesWithListAccess(this.maryIdentity);
        ActivityManagerTest.assertEquals((int)1, (int)maryActivities.getSize());
        ActivityManagerTest.assertEquals((int)1, (int)((ExoSocialActivity[])maryActivities.load(0, 10)).length);
        RealtimeListAccess johnActivities = this.activityManager.getActivityFeedWithListAccess(this.johnIdentity);
        ActivityManagerTest.assertEquals((int)0, (int)johnActivities.getSize());
        ActivityManagerTest.assertEquals((int)0, (int)((ExoSocialActivity[])johnActivities.load(0, 10)).length);
        this.activityManager.saveLike((ExoSocialActivity)commentReply, this.johnIdentity);
        johnActivities = this.activityManager.getActivityFeedWithListAccess(this.johnIdentity);
        ActivityManagerTest.assertEquals((int)1, (int)johnActivities.getSize());
        ActivityManagerTest.assertEquals((int)1, (int)((ExoSocialActivity[])johnActivities.load(0, 10)).length);
        this.activityManager.deleteLike((ExoSocialActivity)commentReply, this.johnIdentity);
        johnActivities = this.activityManager.getActivitiesWithListAccess(this.johnIdentity);
        ActivityManagerTest.assertEquals((int)0, (int)johnActivities.getSize());
        ActivityManagerTest.assertEquals((int)0, (int)((ExoSocialActivity[])johnActivities.load(0, 10)).length);
    }

    public void testGetActivitiesCount() throws Exception {
        int count = this.activityManager.getActivitiesWithListAccess(this.rootIdentity).getSize();
        ActivityManagerTest.assertEquals((String)"count must be: 0", (int)0, (int)count);
        this.populateActivityMass(this.rootIdentity, 30);
        count = this.activityManager.getActivitiesWithListAccess(this.rootIdentity).getSize();
        ActivityManagerTest.assertEquals((String)"count must be: 30", (int)30, (int)count);
    }

    public void testSaveManyComments() throws Exception {
        ExoSocialActivityImpl demoActivity = new ExoSocialActivityImpl();
        demoActivity.setTitle("demo activity");
        demoActivity.setUserId(demoActivity.getId());
        this.activityManager.saveActivityNoReturn(this.demoIdentity, (ExoSocialActivity)demoActivity);
        ExoSocialActivityImpl comment1 = new ExoSocialActivityImpl();
        comment1.setTitle("john comment 1");
        comment1.setUserId(this.johnIdentity.getId());
        this.activityManager.saveComment((ExoSocialActivity)demoActivity, (ExoSocialActivity)comment1);
        RealtimeListAccess listAccess = this.activityManager.getActivityFeedWithListAccess(this.johnIdentity);
        ActivityManagerTest.assertEquals((int)1, (int)listAccess.getSize());
        ActivityManagerTest.assertEquals((int)1, (int)((ExoSocialActivity[])listAccess.load(0, 10)).length);
        ExoSocialActivityImpl comment2 = new ExoSocialActivityImpl();
        comment2.setTitle("john comment 2");
        comment2.setUserId(this.johnIdentity.getId());
        this.activityManager.saveComment((ExoSocialActivity)demoActivity, (ExoSocialActivity)comment2);
        listAccess = this.activityManager.getActivityFeedWithListAccess(this.johnIdentity);
        ActivityManagerTest.assertEquals((int)1, (int)listAccess.getSize());
        ActivityManagerTest.assertEquals((int)1, (int)((ExoSocialActivity[])listAccess.load(0, 10)).length);
    }

    public void testGetLastIdenties() throws Exception {
        Mockito.when((Object)this.mockProfileSearch.search((org.exoplatform.social.core.identity.model.Identity)Mockito.nullable(org.exoplatform.social.core.identity.model.Identity.class), (ProfileFilter)Mockito.nullable(ProfileFilter.class), (Relationship.Type)Mockito.nullable(Relationship.Type.class), Mockito.anyLong(), Mockito.anyLong())).thenReturn(Arrays.asList(this.paulIdentity.getId())).thenReturn(Arrays.asList(this.paulIdentity.getId())).thenReturn(Arrays.asList(this.paulIdentity.getId(), this.jameIdentity.getId(), this.raulIdentity.getId(), this.ghostIdentity.getId(), this.demoIdentity.getId()));
        List lastIds = this.identityManager.getLastIdentities(1);
        ActivityManagerTest.assertEquals((int)1, (int)lastIds.size());
        org.exoplatform.social.core.identity.model.Identity id1 = (org.exoplatform.social.core.identity.model.Identity)lastIds.get(0);
        lastIds = this.identityManager.getLastIdentities(1);
        ActivityManagerTest.assertEquals((int)1, (int)lastIds.size());
        ActivityManagerTest.assertEquals((Object)id1, lastIds.get(0));
        lastIds = this.identityManager.getLastIdentities(5);
        ActivityManagerTest.assertEquals((int)5, (int)lastIds.size());
        ActivityManagerTest.assertEquals((Object)id1, lastIds.get(0));
        OrganizationService os = (OrganizationService)this.getContainer().getComponentInstanceOfType(OrganizationService.class);
        User user1 = os.getUserHandler().createUserInstance("newId1");
        os.getUserHandler().createUser(user1, false);
        org.exoplatform.social.core.identity.model.Identity newId1 = this.identityManager.getOrCreateIdentity("organization", "newId1", false);
        Mockito.when((Object)this.mockProfileSearch.search((org.exoplatform.social.core.identity.model.Identity)Mockito.nullable(org.exoplatform.social.core.identity.model.Identity.class), (ProfileFilter)Mockito.nullable(ProfileFilter.class), (Relationship.Type)Mockito.nullable(Relationship.Type.class), Mockito.anyLong(), Mockito.anyLong())).thenReturn(Arrays.asList(newId1.getId())).thenReturn(Arrays.asList(this.paulIdentity.getId()));
        lastIds = this.identityManager.getLastIdentities(1);
        ActivityManagerTest.assertEquals((int)1, (int)lastIds.size());
        ActivityManagerTest.assertEquals((Object)newId1, lastIds.get(0));
        this.identityManager.deleteIdentity(newId1);
        ActivityManagerTest.assertTrue((boolean)this.identityManager.getIdentity(newId1.getId(), false).isDeleted());
        lastIds = this.identityManager.getLastIdentities(1);
        ActivityManagerTest.assertEquals((int)1, (int)lastIds.size());
        ActivityManagerTest.assertEquals((Object)id1, lastIds.get(0));
        User user2 = os.getUserHandler().createUserInstance("newId2");
        os.getUserHandler().createUser(user2, false);
        org.exoplatform.social.core.identity.model.Identity newId2 = this.identityManager.getOrCreateIdentity("organization", "newId2", true);
        Mockito.when((Object)this.mockProfileSearch.search((org.exoplatform.social.core.identity.model.Identity)Mockito.nullable(org.exoplatform.social.core.identity.model.Identity.class), (ProfileFilter)Mockito.nullable(ProfileFilter.class), (Relationship.Type)Mockito.nullable(Relationship.Type.class), Mockito.anyLong(), Mockito.anyLong())).thenReturn(Arrays.asList(newId2.getId(), this.paulIdentity.getId(), this.jameIdentity.getId(), this.raulIdentity.getId(), this.ghostIdentity.getId())).thenReturn(Arrays.asList(this.paulIdentity.getId(), this.jameIdentity.getId(), this.raulIdentity.getId(), this.ghostIdentity.getId(), this.demoIdentity.getId()));
        lastIds = this.identityManager.getLastIdentities(5);
        ActivityManagerTest.assertEquals((int)5, (int)lastIds.size());
        ActivityManagerTest.assertEquals((Object)newId2, lastIds.get(0));
        this.identityManager.deleteIdentity(newId2);
        ActivityManagerTest.assertTrue((boolean)this.identityManager.getIdentity(newId2.getId(), true).isDeleted());
        lastIds = this.identityManager.getLastIdentities(5);
        ActivityManagerTest.assertEquals((int)5, (int)lastIds.size());
        ActivityManagerTest.assertEquals((Object)id1, lastIds.get(0));
        newId1 = this.identityManager.getOrCreateIdentity("organization", "newId1", false);
        newId2 = this.identityManager.getOrCreateIdentity("organization", "newId2", true);
        Mockito.when((Object)this.mockProfileSearch.search((org.exoplatform.social.core.identity.model.Identity)Mockito.nullable(org.exoplatform.social.core.identity.model.Identity.class), (ProfileFilter)Mockito.nullable(ProfileFilter.class), (Relationship.Type)Mockito.nullable(Relationship.Type.class), Mockito.anyLong(), Mockito.anyLong())).thenReturn(Arrays.asList(newId2.getId())).thenReturn(Arrays.asList(newId2.getId(), newId1.getId())).thenReturn(Arrays.asList(newId2.getId())).thenReturn(Arrays.asList(newId2.getId(), this.paulIdentity.getId())).thenReturn(Arrays.asList(this.paulIdentity.getId()));
        lastIds = this.identityManager.getLastIdentities(1);
        ActivityManagerTest.assertEquals((int)1, (int)lastIds.size());
        ActivityManagerTest.assertEquals((Object)newId2, lastIds.get(0));
        lastIds = this.identityManager.getLastIdentities(2);
        ActivityManagerTest.assertEquals((int)2, (int)lastIds.size());
        ActivityManagerTest.assertEquals((Object)newId2, lastIds.get(0));
        ActivityManagerTest.assertEquals((Object)newId1, lastIds.get(1));
        this.identityManager.deleteIdentity(newId1);
        os.getUserHandler().removeUser("newId1", false);
        ActivityManagerTest.assertTrue((boolean)this.identityManager.getIdentity(newId1.getId(), true).isDeleted());
        lastIds = this.identityManager.getLastIdentities(1);
        ActivityManagerTest.assertEquals((int)1, (int)lastIds.size());
        ActivityManagerTest.assertEquals((Object)newId2, lastIds.get(0));
        lastIds = this.identityManager.getLastIdentities(2);
        ActivityManagerTest.assertEquals((int)2, (int)lastIds.size());
        ActivityManagerTest.assertEquals((Object)newId2, lastIds.get(0));
        ActivityManagerTest.assertFalse((boolean)newId1.equals(lastIds.get(1)));
        this.identityManager.deleteIdentity(newId2);
        os.getUserHandler().removeUser("newId2", false);
        ActivityManagerTest.assertTrue((boolean)this.identityManager.getIdentity(newId2.getId(), false).isDeleted());
        lastIds = this.identityManager.getLastIdentities(1);
        ActivityManagerTest.assertEquals((int)1, (int)lastIds.size());
        ActivityManagerTest.assertEquals((Object)id1, lastIds.get(0));
    }

    public void testMentionActivity() throws Exception {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("hello");
        activity.setUserId(this.rootIdentity.getId());
        this.activityManager.saveActivityNoReturn(this.rootIdentity, (ExoSocialActivity)activity);
        ExoSocialActivity got = this.activityManager.getActivity(activity.getId());
        ActivityManagerTest.assertEquals((int)0, (int)got.getMentionedIds().length);
        RealtimeListAccess demoActivityFeed = this.activityManager.getActivityFeedWithListAccess(this.demoIdentity);
        ActivityManagerTest.assertEquals((int)0, (int)demoActivityFeed.getSize());
        ActivityManagerTest.assertEquals((int)0, (int)((ExoSocialActivity[])demoActivityFeed.load(0, 10)).length);
        ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
        comment.setTitle("mary mention @demo @john");
        comment.setUserId(this.maryIdentity.getId());
        this.activityManager.saveComment((ExoSocialActivity)activity, (ExoSocialActivity)comment);
        got = this.activityManager.getActivity(activity.getId());
        ActivityManagerTest.assertEquals((int)2, (int)got.getMentionedIds().length);
        demoActivityFeed = this.activityManager.getActivityFeedWithListAccess(this.demoIdentity);
        ActivityManagerTest.assertEquals((int)1, (int)demoActivityFeed.getSize());
        ActivityManagerTest.assertEquals((int)1, (int)((ExoSocialActivity[])demoActivityFeed.load(0, 10)).length);
        this.activityManager.deleteComment((ExoSocialActivity)activity, (ExoSocialActivity)comment);
        got = this.activityManager.getActivity(activity.getId());
        ActivityManagerTest.assertEquals((int)0, (int)got.getMentionedIds().length);
        demoActivityFeed = this.activityManager.getActivityFeedWithListAccess(this.demoIdentity);
        ActivityManagerTest.assertEquals((int)0, (int)demoActivityFeed.getSize());
        ActivityManagerTest.assertEquals((int)0, (int)((ExoSocialActivity[])demoActivityFeed.load(0, 10)).length);
    }

    public void testSpaceRoleMention() throws Exception {
        Space space = this.getSpaceInstance(0);
        org.exoplatform.social.core.identity.model.Identity spaceIdentity = this.identityManager.getOrCreateSpaceIdentity(space.getPrettyName());
        this.restartTransaction();
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("hello @member:" + spaceIdentity.getId());
        activity.setUserId(this.rootIdentity.getId());
        this.activityManager.saveActivityNoReturn(spaceIdentity, (ExoSocialActivity)activity);
        ExoSocialActivity got = this.activityManager.getActivity(activity.getId());
        ActivityManagerTest.assertEquals((int)space.getMembers().length, (int)got.getMentionedIds().length);
        ActivityManagerTest.assertTrue((boolean)StringUtils.containsIgnoreCase((CharSequence)got.getTitle(), (CharSequence)"member"));
        ActivityManagerTest.assertFalse((boolean)StringUtils.containsIgnoreCase((CharSequence)got.getTitle(), (CharSequence)"@member"));
        activity = new ExoSocialActivityImpl();
        activity.setTitle("hello @manager:" + spaceIdentity.getId());
        activity.setUserId(this.rootIdentity.getId());
        this.activityManager.saveActivityNoReturn(spaceIdentity, (ExoSocialActivity)activity);
        got = this.activityManager.getActivity(activity.getId());
        ActivityManagerTest.assertEquals((int)space.getManagers().length, (int)got.getMentionedIds().length);
        ActivityManagerTest.assertTrue((boolean)StringUtils.containsIgnoreCase((CharSequence)got.getTitle(), (CharSequence)"manager"));
        ActivityManagerTest.assertFalse((boolean)StringUtils.containsIgnoreCase((CharSequence)got.getTitle(), (CharSequence)"@manager"));
        activity = new ExoSocialActivityImpl();
        activity.setTitle("hello @publisher:" + spaceIdentity.getId());
        activity.setUserId(this.maryIdentity.getId());
        this.activityManager.saveActivityNoReturn(spaceIdentity, (ExoSocialActivity)activity);
        got = this.activityManager.getActivity(activity.getId());
        ActivityManagerTest.assertEquals((int)space.getPublishers().length, (int)got.getMentionedIds().length);
        ActivityManagerTest.assertEquals((String)this.demoIdentity.getId(), (String)got.getMentionedIds()[0]);
        ActivityManagerTest.assertTrue((boolean)StringUtils.containsIgnoreCase((CharSequence)got.getTitle(), (CharSequence)"publisher"));
        ActivityManagerTest.assertFalse((boolean)StringUtils.containsIgnoreCase((CharSequence)got.getTitle(), (CharSequence)"@publisher"));
        this.spaceService.addRedactor(space, "john");
        activity = new ExoSocialActivityImpl();
        activity.setTitle("hello @redactor:" + spaceIdentity.getId());
        activity.setUserId(this.rootIdentity.getId());
        this.activityManager.saveActivityNoReturn(spaceIdentity, (ExoSocialActivity)activity);
        got = this.activityManager.getActivity(activity.getId());
        ActivityManagerTest.assertEquals((int)space.getRedactors().length, (int)got.getMentionedIds().length);
        ActivityManagerTest.assertEquals((String)this.johnIdentity.getId(), (String)got.getMentionedIds()[0]);
        ActivityManagerTest.assertTrue((boolean)StringUtils.containsIgnoreCase((CharSequence)got.getTitle(), (CharSequence)"redactor"));
        ActivityManagerTest.assertFalse((boolean)StringUtils.containsIgnoreCase((CharSequence)got.getTitle(), (CharSequence)"@redactor"));
    }

    public void testLikeCommentActivity() throws Exception {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("hello");
        activity.setUserId(this.rootIdentity.getId());
        this.activityManager.saveActivityNoReturn(this.rootIdentity, (ExoSocialActivity)activity);
        ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
        comment.setTitle("demo comment");
        comment.setUserId(this.demoIdentity.getId());
        this.activityManager.saveComment((ExoSocialActivity)activity, (ExoSocialActivity)comment);
        RealtimeListAccess demoActivities = this.activityManager.getActivityFeedWithListAccess(this.demoIdentity);
        ActivityManagerTest.assertEquals((int)1, (int)demoActivities.getSize());
        ActivityManagerTest.assertEquals((int)1, (int)((ExoSocialActivity[])demoActivities.load(0, 10)).length);
        demoActivities = this.activityManager.getActivitiesWithListAccess(this.demoIdentity);
        ActivityManagerTest.assertEquals((int)1, (int)demoActivities.getSize());
        ActivityManagerTest.assertEquals((int)1, (int)((ExoSocialActivity[])demoActivities.load(0, 10)).length);
        this.activityManager.saveLike((ExoSocialActivity)comment, this.johnIdentity);
        RealtimeListAccess johnActivities = this.activityManager.getActivityFeedWithListAccess(this.johnIdentity);
        ActivityManagerTest.assertEquals((int)1, (int)johnActivities.getSize());
        ActivityManagerTest.assertEquals((int)1, (int)((ExoSocialActivity[])johnActivities.load(0, 10)).length);
        johnActivities = this.activityManager.getActivitiesWithListAccess(this.johnIdentity);
        ActivityManagerTest.assertEquals((int)1, (int)johnActivities.getSize());
        ActivityManagerTest.assertEquals((int)1, (int)((ExoSocialActivity[])johnActivities.load(0, 10)).length);
    }

    public void testLikeSubCommentActivity() throws Exception {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("hello");
        activity.setUserId(this.rootIdentity.getId());
        this.activityManager.saveActivityNoReturn(this.rootIdentity, (ExoSocialActivity)activity);
        ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
        comment.setTitle("demo comment");
        comment.setUserId(this.demoIdentity.getId());
        this.activityManager.saveComment((ExoSocialActivity)activity, (ExoSocialActivity)comment);
        ExoSocialActivityImpl commentReply = new ExoSocialActivityImpl();
        commentReply.setTitle("mary comment reply");
        commentReply.setUserId(this.maryIdentity.getId());
        commentReply.setParentCommentId(comment.getId());
        this.activityManager.saveComment((ExoSocialActivity)activity, (ExoSocialActivity)commentReply);
        RealtimeListAccess demoActivities = this.activityManager.getActivityFeedWithListAccess(this.demoIdentity);
        ActivityManagerTest.assertEquals((int)1, (int)demoActivities.getSize());
        ActivityManagerTest.assertEquals((int)1, (int)((ExoSocialActivity[])demoActivities.load(0, 10)).length);
        RealtimeListAccess maryActivities = this.activityManager.getActivityFeedWithListAccess(this.maryIdentity);
        ActivityManagerTest.assertEquals((int)1, (int)maryActivities.getSize());
        ActivityManagerTest.assertEquals((int)1, (int)((ExoSocialActivity[])maryActivities.load(0, 10)).length);
        demoActivities = this.activityManager.getActivitiesWithListAccess(this.demoIdentity);
        ActivityManagerTest.assertEquals((int)1, (int)demoActivities.getSize());
        ActivityManagerTest.assertEquals((int)1, (int)((ExoSocialActivity[])demoActivities.load(0, 10)).length);
        maryActivities = this.activityManager.getActivitiesWithListAccess(this.maryIdentity);
        ActivityManagerTest.assertEquals((int)1, (int)maryActivities.getSize());
        ActivityManagerTest.assertEquals((int)1, (int)((ExoSocialActivity[])maryActivities.load(0, 10)).length);
        RealtimeListAccess johnActivities = this.activityManager.getActivityFeedWithListAccess(this.johnIdentity);
        ActivityManagerTest.assertEquals((int)0, (int)johnActivities.getSize());
        ActivityManagerTest.assertEquals((int)0, (int)((ExoSocialActivity[])johnActivities.load(0, 10)).length);
        this.activityManager.saveLike((ExoSocialActivity)commentReply, this.johnIdentity);
        johnActivities = this.activityManager.getActivityFeedWithListAccess(this.johnIdentity);
        ActivityManagerTest.assertEquals((int)1, (int)johnActivities.getSize());
        ActivityManagerTest.assertEquals((int)1, (int)((ExoSocialActivity[])johnActivities.load(0, 10)).length);
    }

    public void testGetActivityCategoryIds() {
        String userId = this.rootIdentity.getId();
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("activityTitle");
        activity.setUserId(userId);
        activity.setCategoryIds(List.of(Long.valueOf(2L)));
        this.activityManager.saveActivityNoReturn(this.rootIdentity, (ExoSocialActivity)activity);
        ActivityManagerTest.assertEquals(List.of(Long.valueOf(2L)), (Object)this.activityManager.getActivityCategoryIds(0L, "root"));
    }

    private void createActivityToOtherIdentity(org.exoplatform.social.core.identity.model.Identity posterIdentity, org.exoplatform.social.core.identity.model.Identity targetIdentity, int number) {
        for (int i = 0; i < number; ++i) {
            ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
            activity.setTitle("title " + i);
            activity.setUserId(posterIdentity.getId());
            try {
                this.activityManager.saveActivityNoReturn(targetIdentity, (ExoSocialActivity)activity);
                continue;
            }
            catch (Exception e) {
                LOG.error((Object)"can not save activity.", (Throwable)e);
            }
        }
    }

    private Space getSpaceInstance(int number) {
        Space space = new Space();
        space.setDisplayName("my space " + number);
        space.setPrettyName(space.getDisplayName());
        space.setRegistration("open");
        space.setDescription("add new space " + number);
        space.setVisibility("public");
        space.setRegistration("validation");
        space.setGroupId("/spaces/" + space.getPrettyName());
        space.setUrl(space.getPrettyName());
        String[] managers = new String[]{"demo", "john"};
        String[] members = new String[]{"raul", "ghost", "demo", "john"};
        String[] publishers = new String[]{"demo"};
        String[] redactors = new String[]{"john"};
        String[] invitedUsers = new String[]{"mary", "paul"};
        String[] pendingUsers = new String[]{"jame"};
        space.setInvitedUsers(invitedUsers);
        space.setPendingUsers(pendingUsers);
        space.setManagers(managers);
        space.setMembers(members);
        space.setRedactors(redactors);
        space.setPublishers(publishers);
        this.spaceStorage.saveSpace(space, true);
        return space;
    }

    private void addActivityTypePlugin(ActivityManager activityManager, String activityType, boolean enabled) {
        InitParams params = new InitParams();
        ValueParam param = new ValueParam();
        param.setName("type");
        param.setValue(activityType);
        params.addParameter((Parameter)param);
        param = new ValueParam();
        param.setName("enableNotification");
        param.setValue(String.valueOf(enabled));
        params.addParameter((Parameter)param);
        activityManager.addActivityTypePlugin(new ActivityTypePlugin(this, params){

            public boolean isEnableNotification(ExoSocialActivity activity, String username) {
                return !StringUtils.equals((CharSequence)username, (CharSequence)"root3") && super.isEnableNotification();
            }
        });
    }

    private void populateActivityMass(org.exoplatform.social.core.identity.model.Identity user, int number) {
        for (int i = 0; i < number; ++i) {
            ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
            activity.setTitle("title " + i);
            activity.setUserId(user.getId());
            try {
                this.activityManager.saveActivityNoReturn(user, (ExoSocialActivity)activity);
                continue;
            }
            catch (Exception e) {
                LOG.error((Object)"can not save activity.", (Throwable)e);
            }
        }
    }

    private ExoSocialActivity createActivity() {
        String activityTitle = "activity title";
        String userId = this.rootIdentity.getId();
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle(activityTitle);
        activity.setUserId(userId);
        this.activityManager.saveActivityNoReturn((ExoSocialActivity)activity);
        return this.activityManager.getActivity(activity.getId());
    }

    private ExoSocialActivity createComment(ExoSocialActivity activity, String type, String titleId) {
        ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
        comment.setUserId(this.rootIdentity.getId());
        comment.setTemplateParams(new HashMap());
        comment.setTitle("comment title");
        comment.setType(type);
        comment.setTitleId(titleId);
        this.activityManager.saveComment(activity, (ExoSocialActivity)comment);
        return this.activityManager.getActivity(comment.getId());
    }

    private Space createSpace(String spaceName, String creator, String ... members) {
        Space space = new Space();
        space.setDisplayName(spaceName);
        space.setPrettyName(spaceName);
        space.setGroupId("/spaces/" + space.getPrettyName());
        space.setRegistration("open");
        space.setDescription("description of space" + spaceName);
        space.setVisibility("private");
        space.setRegistration("open");
        String[] managers = new String[]{creator};
        space.setManagers(managers);
        Space createdSpace = this.spaceService.createSpace(space);
        if (ArrayUtils.isNotEmpty((Object[])members)) {
            Arrays.stream(members).forEach(u -> this.spaceService.addMember(createdSpace, u));
        }
        if (ArrayUtils.isNotEmpty((Object[])createdSpace.getRedactors())) {
            Arrays.stream(createdSpace.getRedactors()).forEach(u -> this.spaceService.removeRedactor(createdSpace, u));
        }
        return createdSpace;
    }

    protected org.exoplatform.social.core.identity.model.Identity createIdentity(String username) {
        org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getOrCreateUserIdentity(username);
        Profile profile = new Profile(identity);
        profile.setProperty("firstName", (Object)username);
        profile.setProperty("lastName", (Object)username);
        identity.setProfile(profile);
        this.identityManager.updateProfile(profile);
        if (identity.isDeleted() || !identity.isEnable()) {
            identity.setDeleted(false);
            identity.setEnable(true);
            this.identityManager.updateIdentity(identity);
        }
        return this.identityManager.getOrCreateUserIdentity(username);
    }

    private void deleteSpaceAutomaticActivities(Space space) {
        org.exoplatform.social.core.identity.model.Identity spaceIdentity = this.identityManager.getOrCreateSpaceIdentity(space.getPrettyName());
        RealtimeListAccess spaceActivitiesListAccess = this.activityManager.getActivitiesOfSpaceWithListAccess(spaceIdentity);
        if (spaceActivitiesListAccess.getSize() > 0) {
            ActivityManagerTest.assertEquals((int)1, (int)spaceActivitiesListAccess.getSize());
            this.activityManager.deleteActivity((String)spaceActivitiesListAccess.loadIdsAsList(0, 1).get(0));
            this.restartTransaction();
        }
    }

    private void deleteRelationshipAutomaticActivities(org.exoplatform.social.core.identity.model.Identity identity) {
        ActivityFilter userActivityFilter = new ActivityFilter();
        userActivityFilter.setStreamType(ActivityStreamType.ALL_STREAM);
        RealtimeListAccess userActivities = this.activityManager.getActivitiesByFilterWithListAccess(identity, userActivityFilter);
        if (userActivities.getSize() > 1) {
            List activityList = userActivities.loadAsList(0, 100);
            activityList.stream().filter(a -> StringUtils.equals((CharSequence)a.getType(), (CharSequence)"USER_ACTIVITIES_FOR_RELATIONSHIP")).forEach(arg_0 -> ((ActivityManager)this.activityManager).deleteActivity(arg_0));
            this.restartTransaction();
        }
    }
}

