/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.metadata.favorite;

import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.jpa.storage.dao.jpa.MetadataDAO;
import org.exoplatform.social.core.metadata.storage.MetadataStorage;
import org.exoplatform.social.core.test.AbstractCoreTest;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.MetadataTypePlugin;
import org.exoplatform.social.metadata.favorite.FavoriteService;
import org.exoplatform.social.metadata.favorite.model.Favorite;
import org.exoplatform.social.metadata.model.MetadataItem;
import org.exoplatform.social.metadata.model.MetadataKey;
import org.exoplatform.social.metadata.model.MetadataObject;
import org.exoplatform.social.metadata.model.MetadataType;
import org.junit.jupiter.api.Assertions;

public class FavoriteServiceTest
extends AbstractCoreTest {
    private Identity johnIdentity;
    private FavoriteService favoriteService;
    private MetadataService metadataService;
    private MetadataType favoriteMetadataType;
    private MetadataType userMetadataType;
    private MetadataDAO metadataDAO;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.metadataService = (MetadataService)this.getContainer().getComponentInstanceOfType(MetadataService.class);
        this.favoriteService = (FavoriteService)this.getContainer().getComponentInstanceOfType(FavoriteService.class);
        this.metadataDAO = (MetadataDAO)this.getContainer().getComponentInstanceOfType(MetadataDAO.class);
        ((MetadataStorage)this.getContainer().getComponentInstanceOfType(MetadataStorage.class)).clearCaches();
        this.favoriteMetadataType = new MetadataType(1L, "favorites");
        this.userMetadataType = new MetadataType(2L, "user");
        if (this.metadataService.getMetadataTypeByName(this.userMetadataType.getName()) == null) {
            MetadataTypePlugin userMetadataTypePlugin = new MetadataTypePlugin(this, this.newParam(1000L, "user")){

                public boolean isAllowMultipleItemsPerObject() {
                    return false;
                }

                public boolean isShareable() {
                    return true;
                }
            };
            this.metadataService.addMetadataTypePlugin(userMetadataTypePlugin);
        }
        this.johnIdentity = this.identityManager.getOrCreateUserIdentity("john");
    }

    @Override
    public void tearDown() throws Exception {
        this.restartTransaction();
        this.identityManager.deleteIdentity(this.johnIdentity);
        this.metadataDAO.deleteAll();
        super.tearDown();
    }

    public void testCreateFavorite() throws Exception {
        String objectType = "type";
        String objectId = "1";
        String parentObjectId = "2";
        long userIdentityId = Long.parseLong(this.johnIdentity.getId());
        long spaceId = 500L;
        Favorite favorite = new Favorite(objectType, objectId, parentObjectId, userIdentityId, spaceId);
        List metadataItemsByObject = this.metadataService.getMetadataItemsByObject((MetadataObject)favorite.getObject());
        FavoriteServiceTest.assertTrue((boolean)CollectionUtils.isEmpty((Collection)metadataItemsByObject));
        this.favoriteService.createFavorite(favorite);
        metadataItemsByObject = this.metadataService.getMetadataItemsByObject((MetadataObject)favorite.getObject());
        FavoriteServiceTest.assertEquals((int)1, (int)metadataItemsByObject.size());
        MetadataItem metadataItem = (MetadataItem)metadataItemsByObject.get(0);
        FavoriteServiceTest.assertEquals((long)userIdentityId, (long)metadataItem.getCreatorId());
        FavoriteServiceTest.assertEquals((String)objectId, (String)metadataItem.getObjectId());
        FavoriteServiceTest.assertEquals((String)objectType, (String)metadataItem.getObjectType());
        FavoriteServiceTest.assertEquals((String)parentObjectId, (String)metadataItem.getParentObjectId());
        Assertions.assertThrows(ObjectAlreadyExistsException.class, () -> this.favoriteService.createFavorite(favorite));
    }

    public void testGetFavoriteItemsByCreator() throws Exception {
        long userIdentityId;
        long audienceId = userIdentityId = Long.parseLong(this.johnIdentity.getId());
        String favoriteType = this.favoriteMetadataType.getName();
        String otherType = this.userMetadataType.getName();
        String objectType = "objectType1";
        this.createNewMetadataItem(favoriteType, "testMetadata1", objectType, "objectId1", "parentObjectId1", userIdentityId, audienceId);
        this.createNewMetadataItem(otherType, "testMetadata2", objectType, "objectId1", "parentObjectId1", userIdentityId, audienceId);
        this.createNewMetadataItem(favoriteType, "testMetadata3", objectType, "objectId1", "parentObjectId1", userIdentityId, audienceId);
        this.createNewMetadataItem(otherType, "testMetadata4", objectType, "objectId1", "parentObjectId1", userIdentityId, audienceId);
        this.createNewMetadataItem(favoriteType, "testMetadata5", objectType, "objectId1", "parentObjectId1", userIdentityId, audienceId);
        this.createNewMetadataItem(otherType, "testMetadata6", objectType, "objectId1", "parentObjectId1", userIdentityId, audienceId);
        List favoriteList = this.favoriteService.getFavoriteItemsByCreator(userIdentityId, 0L, 5L);
        FavoriteServiceTest.assertEquals((int)3, (int)favoriteList.size());
        FavoriteServiceTest.assertEquals((int)3, (int)this.favoriteService.getFavoriteItemsSize(userIdentityId));
        FavoriteServiceTest.assertEquals((int)3, (int)this.favoriteService.getFavoriteItemsSize(objectType, userIdentityId));
        favoriteList = this.favoriteService.getFavoriteItemsByCreator(100L, 0L, 5L);
        FavoriteServiceTest.assertEquals((int)0, (int)favoriteList.size());
    }

    public void testGetFavoriteItemsByCreatorAndType() throws Exception {
        long userIdentityId = Long.parseLong(this.johnIdentity.getId());
        String objectType = "space";
        String otherObjectType = "activite";
        Favorite favorite1 = new Favorite(objectType, "objectId1", null, userIdentityId);
        this.favoriteService.createFavorite(favorite1);
        Thread.sleep(10L);
        Favorite favorite2 = new Favorite(objectType, "objectId2", null, userIdentityId);
        this.favoriteService.createFavorite(favorite2);
        Thread.sleep(10L);
        Favorite favorite3 = new Favorite(otherObjectType, "objectId3", null, userIdentityId);
        this.favoriteService.createFavorite(favorite3);
        Thread.sleep(10L);
        Favorite favorite4 = new Favorite(otherObjectType, "objectId4", null, userIdentityId + 1L);
        this.favoriteService.createFavorite(favorite4);
        List favoritesList = this.favoriteService.getFavoriteItemsByCreatorAndType(objectType, userIdentityId, 2L, 2L);
        FavoriteServiceTest.assertEquals((int)0, (int)favoritesList.size());
        favoritesList = this.favoriteService.getFavoriteItemsByCreatorAndType(objectType, userIdentityId, 0L, 2L);
        FavoriteServiceTest.assertEquals((int)2, (int)favoritesList.size());
        FavoriteServiceTest.assertEquals((String)favorite2.getObjectId(), (String)((MetadataItem)favoritesList.get(0)).getObjectId());
        FavoriteServiceTest.assertEquals((String)favorite1.getObjectId(), (String)((MetadataItem)favoritesList.get(1)).getObjectId());
        FavoriteServiceTest.assertEquals((int)3, (int)this.favoriteService.getFavoriteItemsSize(userIdentityId));
        FavoriteServiceTest.assertEquals((int)2, (int)this.favoriteService.getFavoriteItemsSize(objectType, userIdentityId));
        FavoriteServiceTest.assertEquals((int)1, (int)this.favoriteService.getFavoriteItemsSize(otherObjectType, userIdentityId));
        favoritesList = this.favoriteService.getFavoriteItemsByCreatorAndType("test", userIdentityId, 0L, 3L);
        FavoriteServiceTest.assertEquals((int)0, (int)favoritesList.size());
    }

    public void testSetFavoriteAsLastAccessed() throws Exception {
        long userIdentityId = Long.parseLong(this.johnIdentity.getId());
        String objectType = "space";
        Favorite favorite1 = new Favorite(objectType, "objectId1", null, userIdentityId);
        this.favoriteService.createFavorite(favorite1);
        Thread.sleep(10L);
        Favorite favorite2 = new Favorite(objectType, "objectId2", null, userIdentityId);
        this.favoriteService.createFavorite(favorite2);
        Thread.sleep(10L);
        Favorite favorite3 = new Favorite(objectType, "objectId3", null, userIdentityId);
        this.favoriteService.createFavorite(favorite3);
        Thread.sleep(10L);
        Favorite favorite4 = new Favorite(objectType, "objectId4", null, userIdentityId);
        this.favoriteService.createFavorite(favorite4);
        List favoritesList = this.favoriteService.getFavoriteItemsByCreatorAndType(objectType, userIdentityId, 0L, 10L);
        FavoriteServiceTest.assertEquals((int)4, (int)favoritesList.size());
        FavoriteServiceTest.assertEquals((String)favorite4.getObjectId(), (String)((MetadataItem)favoritesList.get(0)).getObjectId());
        FavoriteServiceTest.assertEquals((String)favorite3.getObjectId(), (String)((MetadataItem)favoritesList.get(1)).getObjectId());
        FavoriteServiceTest.assertEquals((String)favorite2.getObjectId(), (String)((MetadataItem)favoritesList.get(2)).getObjectId());
        FavoriteServiceTest.assertEquals((String)favorite1.getObjectId(), (String)((MetadataItem)favoritesList.get(3)).getObjectId());
        this.favoriteService.setFavoriteAsLastAccessed(favorite4.getObjectType(), favorite4.getObjectId(), userIdentityId);
        Thread.sleep(10L);
        this.favoriteService.setFavoriteAsLastAccessed(favorite3.getObjectType(), favorite3.getObjectId(), userIdentityId);
        Thread.sleep(10L);
        this.favoriteService.setFavoriteAsLastAccessed(favorite2.getObjectType(), favorite2.getObjectId(), userIdentityId);
        Thread.sleep(10L);
        this.favoriteService.setFavoriteAsLastAccessed(favorite1.getObjectType(), favorite1.getObjectId(), userIdentityId);
        favoritesList = this.favoriteService.getFavoriteItemsByCreatorAndType(objectType, userIdentityId, 0L, 10L);
        FavoriteServiceTest.assertEquals((int)4, (int)favoritesList.size());
        FavoriteServiceTest.assertEquals((String)favorite4.getObjectId(), (String)((MetadataItem)favoritesList.get(3)).getObjectId());
        FavoriteServiceTest.assertEquals((String)favorite3.getObjectId(), (String)((MetadataItem)favoritesList.get(2)).getObjectId());
        FavoriteServiceTest.assertEquals((String)favorite2.getObjectId(), (String)((MetadataItem)favoritesList.get(1)).getObjectId());
        FavoriteServiceTest.assertEquals((String)favorite1.getObjectId(), (String)((MetadataItem)favoritesList.get(0)).getObjectId());
    }

    public void testDeleteFavorite() throws Exception {
        String objectType = "type";
        String objectId = "1";
        String parentObjectId = "2";
        long userIdentityId = Long.parseLong(this.johnIdentity.getId());
        long spaceId = 500L;
        Favorite favorite = new Favorite(objectType, objectId, parentObjectId, userIdentityId, spaceId);
        List metadataItemsByObject = this.metadataService.getMetadataItemsByObject((MetadataObject)favorite.getObject());
        FavoriteServiceTest.assertTrue((boolean)CollectionUtils.isEmpty((Collection)metadataItemsByObject));
        this.favoriteService.createFavorite(favorite);
        metadataItemsByObject = this.metadataService.getMetadataItemsByObject((MetadataObject)favorite.getObject());
        FavoriteServiceTest.assertEquals((int)1, (int)metadataItemsByObject.size());
        this.favoriteService.deleteFavorite(favorite);
        metadataItemsByObject = this.metadataService.getMetadataItemsByObject((MetadataObject)favorite.getObject());
        FavoriteServiceTest.assertEquals((int)0, (int)metadataItemsByObject.size());
        try {
            this.favoriteService.deleteFavorite(favorite);
            FavoriteServiceTest.fail();
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
    }

    private MetadataItem createNewMetadataItem(String type, String name, String objectType, String objectId, String parentObjectId, long creatorId, long audienceId) throws Exception {
        MetadataItem metadataItem = new MetadataItem();
        metadataItem.setObjectId(objectId);
        metadataItem.setObjectType(objectType);
        metadataItem.setParentObjectId(parentObjectId);
        return this.metadataService.createMetadataItem(metadataItem.getObject(), new MetadataKey(type, name, audienceId), creatorId);
    }

    private InitParams newParam(long id, String name) {
        InitParams params = new InitParams();
        MetadataType metadataType = new MetadataType(id, name);
        ObjectParameter parameter = new ObjectParameter();
        parameter.setName("metadataType");
        parameter.setObject((Object)metadataType);
        params.addParameter((Parameter)parameter);
        return params;
    }
}

