/**
 * This file is part of the Meeds project (https://meeds.io/).
 *
 * Copyright (C) 2020 - 2025 Meeds Association contact@meeds.io
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package org.exoplatform.social.core.profile.settings;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class UserProfileSettingsService {

  /** The Constant LOG. */
  private static final Log            LOG        = ExoLogger.getLogger(UserProfileSettingsService.class);

  /** The im types map. */
  protected final Map<String, IMType> imTypesMap = new HashMap<>();

  /**
   * Instantiates a new user profile settings service.
   */
  public UserProfileSettingsService() {
  }

  /**
   * Adds the IM type.
   *
   * @param imType the IM type
   */
  public void addIMType(IMType imType) {
    IMType prev = imTypesMap.put(imType.getId(), imType);
    if (prev != null) {
      LOG.info("IM type '" + imType.getId() + "' redefined from '" + prev + "' to '" + imType + "'");
    }
  }

  /**
   * Adds the IM types plugin.
   *
   * @param plugin the plugin
   */
  public void addIMTypesPlugin(IMTypesPlugin plugin) {
    for (IMType imt : plugin.getTypes()) {
      addIMType(imt);
    }
  }

  /**
   * Gets the IM types.
   *
   * @return the IM types
   */
  public Collection<IMType> getIMTypes() {
    return Collections.unmodifiableCollection(imTypesMap.values());
  }

  /**
   * Gets the IM type.
   *
   * @param id the id
   * @return the IM type
   */
  public IMType getIMType(String id) {
    return imTypesMap.get(id);
  }

}
