/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.storage;

import org.exoplatform.social.core.jpa.storage.dao.jpa.ProfileLabelDAO;
import org.exoplatform.social.core.jpa.test.AbstractCoreTest;
import org.exoplatform.social.core.model.ProfileLabel;
import org.exoplatform.social.core.profilelabel.storage.ProfileLabelStorage;

public class ProfileLabelStorageTest
extends AbstractCoreTest {
    private final String objectId = "1";
    private final String objectType = "testObject";
    private ProfileLabelStorage profileLabelStorage;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.profileLabelStorage = (ProfileLabelStorage)this.getContainer().getComponentInstanceOfType(ProfileLabelStorage.class);
        ProfileLabelStorageTest.assertNotNull((Object)this.profileLabelStorage);
    }

    public void testSaveLabel() {
        ProfileLabel profileLabel = this.createLabel("test profileLabel fr", "fr");
        this.profileLabelStorage.saveLabel(profileLabel, true);
        profileLabel = this.profileLabelStorage.findLabelByObjectTypeAndObjectIdAndLang("testObject", "1", "fr");
        ProfileLabelStorageTest.assertNotNull((Object)profileLabel.getId());
    }

    public void testDeleteLabel() {
        ProfileLabel profileLabel = this.createLabel("test profileLabel fr", "fr");
        this.profileLabelStorage.saveLabel(profileLabel, true);
        profileLabel = this.profileLabelStorage.findLabelByObjectTypeAndObjectIdAndLang("testObject", "1", "fr");
        ProfileLabelStorageTest.assertNotNull((Object)profileLabel.getId());
        this.profileLabelStorage.deleteLabel(profileLabel.getId());
        profileLabel = this.profileLabelStorage.findLabelByObjectTypeAndObjectIdAndLang("testObject", "1", "fr");
        ProfileLabelStorageTest.assertNull((Object)profileLabel);
    }

    public void testupdateLabel() {
        ProfileLabel profileLabel = this.createLabel("test profileLabel fr", "fr");
        this.profileLabelStorage.saveLabel(profileLabel, true);
        profileLabel = this.profileLabelStorage.findLabelByObjectTypeAndObjectIdAndLang("testObject", "1", "fr");
        ProfileLabelStorageTest.assertEquals((String)"test profileLabel fr", (String)profileLabel.getLabel());
        profileLabel.setLabel("test profileLabel fr 2");
        this.profileLabelStorage.saveLabel(profileLabel, false);
        profileLabel = this.profileLabelStorage.findLabelByObjectTypeAndObjectIdAndLang("testObject", "1", "fr");
        ProfileLabelStorageTest.assertEquals((String)"test profileLabel fr 2", (String)profileLabel.getLabel());
    }

    public void testGetLabels() {
        ProfileLabelStorageTest.assertEquals((int)0, (int)this.profileLabelStorage.findLabelByObjectTypeAndObjectId("testObject", "1").size());
        ProfileLabel profileLabel1 = this.createLabel("test label fr", "fr");
        ProfileLabel profileLabel2 = this.createLabel("test label en", "en");
        ProfileLabel profileLabel3 = this.createLabel("test label it", "it");
        ProfileLabel profileLabel4 = this.createLabel("test label de", "de");
        ProfileLabel profileLabel5 = this.createLabel("test label ar", "ar");
        this.profileLabelStorage.saveLabel(profileLabel1, true);
        this.profileLabelStorage.saveLabel(profileLabel2, true);
        this.profileLabelStorage.saveLabel(profileLabel3, true);
        this.profileLabelStorage.saveLabel(profileLabel4, true);
        this.profileLabelStorage.saveLabel(profileLabel5, true);
        ProfileLabelStorageTest.assertEquals((int)5, (int)this.profileLabelStorage.findLabelByObjectTypeAndObjectId("testObject", "1").size());
    }

    @Override
    protected void tearDown() throws Exception {
        this.deleteAllLabels();
        super.tearDown();
    }

    private ProfileLabel createLabel(String labelValue, String lang) {
        ProfileLabel profileLabel = new ProfileLabel();
        profileLabel.setLanguage(lang);
        profileLabel.setObjectType("testObject");
        profileLabel.setObjectId("1");
        profileLabel.setLabel(labelValue);
        return profileLabel;
    }

    protected void deleteAllLabels() throws Exception {
        ProfileLabelDAO labelDAO = this.getService(ProfileLabelDAO.class);
        labelDAO.deleteAll();
    }
}

