/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.space.spi;

import io.meeds.social.search.SpaceSearchConnector;
import io.meeds.social.space.constant.SpaceRegistration;
import io.meeds.social.space.constant.SpaceVisibility;
import io.meeds.social.space.service.SpaceServiceImpl;
import io.meeds.social.space.template.model.SpaceTemplate;
import io.meeds.social.space.template.service.SpaceTemplateService;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.social.core.jpa.storage.SpaceStorage;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.SpaceFilter;
import org.exoplatform.social.core.space.SpaceLifecycle;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.storage.api.GroupSpaceBindingStorage;
import org.exoplatform.web.security.security.CookieTokenService;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class SpaceServiceMockTest {
    @Mock
    private SpaceStorage spaceStorage;
    @Mock
    private SpaceSearchConnector spaceSearchConnector;
    @Mock
    private GroupSpaceBindingStorage groupSpaceBindingStorage;
    @Mock
    private IdentityManager identityManager;
    @Mock
    private UserACL userAcl;
    @Mock
    private ResourceBundleService resourceBundleService;
    @Mock
    private LocaleConfigService localeConfigService;
    @Mock
    private OrganizationService organizationService;
    @Mock
    private SpaceTemplateService spaceTemplateService;
    @Mock
    private FileService fileService;
    @Mock
    private CookieTokenService cookieTokenService;
    @Mock
    private SpaceLifecycle spaceLifeCycle;
    @Mock
    ExoContainer container;
    @InjectMocks
    private SpaceServiceImpl spaceService;

    @Test
    public void testCreateSubspace() throws Exception {
        SpaceTemplate parentTemplate = (SpaceTemplate)Mockito.mock(SpaceTemplate.class);
        long parentTemplateId = 1L;
        long notAllowedTemplateId = 4L;
        Mockito.when((Object)parentTemplate.getId()).thenReturn((Object)parentTemplateId);
        ArrayList<String> allowedSubspaceTemplates = new ArrayList<String>();
        allowedSubspaceTemplates.add("2:1");
        allowedSubspaceTemplates.add("3:2");
        int globalLimit = 2;
        Mockito.when((Object)parentTemplate.getAllowedSubspaceTemplates()).thenReturn(allowedSubspaceTemplates);
        Mockito.when((Object)parentTemplate.getSubspacesMaxLimit()).thenReturn((Object)globalLimit);
        Space parentSpace = (Space)Mockito.mock(Space.class);
        Mockito.when((Object)parentSpace.getSpaceId()).thenReturn((Object)1L);
        Mockito.when((Object)parentSpace.getDisplayName()).thenReturn((Object)"parentSpace");
        Mockito.when((Object)parentSpace.getTemplateId()).thenReturn((Object)parentTemplateId);
        Space subSpace = (Space)Mockito.mock(Space.class);
        Mockito.when((Object)subSpace.getId()).thenReturn((Object)"2");
        Mockito.when((Object)subSpace.getDisplayName()).thenReturn((Object)"subSpace");
        Mockito.when((Object)subSpace.getTemplateId()).thenReturn((Object)notAllowedTemplateId);
        String notAllowedUserName = "notAllowedUserName";
        String userName = "userName";
        try (MockedStatic mockedCtx = Mockito.mockStatic(ExoContainerContext.class);
             MockedStatic mockedUtils = Mockito.mockStatic(SpaceUtils.class);){
            mockedCtx.when(() -> ExoContainerContext.getService(SpaceTemplateService.class)).thenReturn((Object)this.spaceTemplateService);
            Mockito.when((Object)this.spaceTemplateService.canCreateSpace(subSpace.getTemplateId(), notAllowedUserName)).thenReturn((Object)false);
            Exception exception = (Exception)Assert.assertThrows(SpaceException.class, () -> this.spaceService.createSpace(subSpace, notAllowedUserName, null, parentSpace.getSpaceId()));
            Assert.assertEquals((Object)String.format("User %s isn't allowed to create space with template %s", notAllowedUserName, subSpace.getTemplateId()), (Object)exception.getMessage());
            Mockito.when((Object)this.spaceTemplateService.canCreateSpace(ArgumentMatchers.anyLong(), (String)ArgumentMatchers.any())).thenReturn((Object)true);
            Mockito.when((Object)this.spaceStorage.getSpaceById(parentSpace.getSpaceId())).thenReturn((Object)parentSpace);
            Mockito.when((Object)parentSpace.getMembers()).thenReturn((Object)new String[]{userName});
            Mockito.when((Object)this.spaceTemplateService.getSpaceTemplate(parentSpace.getTemplateId())).thenReturn((Object)parentTemplate);
            SpaceFilter filter = new SpaceFilter();
            filter.setParentSpaceId(parentSpace.getSpaceId());
            Mockito.when((Object)this.spaceStorage.getAllSpacesByFilterCount(filter)).thenReturn((Object)0);
            exception = (Exception)Assert.assertThrows(SpaceException.class, () -> this.spaceService.createSpace(subSpace, userName, null, parentSpace.getSpaceId()));
            Assert.assertEquals((Object)"Subspace template '%s' is not allowed under parent template '%s'".formatted(subSpace.getTemplateId(), parentTemplate.getId()), (Object)exception.getMessage());
            long allowedSubspaceTemplateId = 2L;
            filter.setTemplateIds(List.of(Long.valueOf(allowedSubspaceTemplateId)));
            Mockito.when((Object)this.spaceStorage.getAllSpacesByFilterCount(filter)).thenReturn((Object)1);
            Mockito.when((Object)subSpace.getTemplateId()).thenReturn((Object)allowedSubspaceTemplateId);
            exception = (Exception)Assert.assertThrows(SpaceException.class, () -> this.spaceService.createSpace(subSpace, userName, null, parentSpace.getSpaceId()));
            Assert.assertEquals((Object)"Cannot create more subspaces of template '%s' (max %d reached under '%s')".formatted(subSpace.getTemplateId(), 1, parentSpace.getDisplayName()), (Object)exception.getMessage());
            filter.setTemplateIds(null);
            Mockito.when((Object)this.spaceStorage.getAllSpacesByFilterCount(filter)).thenReturn((Object)globalLimit).thenReturn((Object)1);
            exception = (Exception)Assert.assertThrows(SpaceException.class, () -> this.spaceService.createSpace(subSpace, userName, null, parentSpace.getSpaceId()));
            Assert.assertEquals((Object)"Cannot create more subspaces under '%s' (max %d reached)".formatted(parentSpace.getDisplayName(), globalLimit), (Object)exception.getMessage());
            filter.setTemplateIds(List.of(Long.valueOf(allowedSubspaceTemplateId)));
            Mockito.when((Object)this.spaceStorage.getAllSpacesByFilterCount(filter)).thenReturn((Object)0);
            SpaceTemplate spaceTemplate = (SpaceTemplate)Mockito.mock(SpaceTemplate.class);
            Mockito.when((Object)spaceTemplate.isEnabled()).thenReturn((Object)true);
            Mockito.when((Object)spaceTemplate.isDeleted()).thenReturn((Object)false);
            Mockito.when((Object)spaceTemplate.getSpaceDefaultRegistration()).thenReturn((Object)SpaceRegistration.OPEN);
            Mockito.when((Object)spaceTemplate.getSpaceDefaultVisibility()).thenReturn((Object)SpaceVisibility.PUBLIC);
            mockedUtils.when(() -> SpaceUtils.createGroup((String)ArgumentMatchers.anyString(), (String)ArgumentMatchers.anyString(), (String)ArgumentMatchers.anyString())).thenReturn((Object)"/spaces/subspace");
            Mockito.when((Object)this.spaceTemplateService.getSpaceTemplate(subSpace.getTemplateId())).thenReturn((Object)spaceTemplate);
            Mockito.when((Object)this.spaceStorage.saveSpace((Space)ArgumentMatchers.any(Space.class), Long.valueOf(ArgumentMatchers.anyLong()), ArgumentMatchers.anyBoolean())).thenReturn((Object)subSpace);
            this.spaceService.createSpace(subSpace, userName, null, parentSpace.getSpaceId());
            ((SpaceTemplateService)Mockito.verify((Object)this.spaceTemplateService, (VerificationMode)Mockito.times((int)1))).getSpaceTemplate(subSpace.getTemplateId());
            ((SpaceStorage)Mockito.verify((Object)this.spaceStorage, (VerificationMode)Mockito.times((int)1))).saveSpace((Space)ArgumentMatchers.any(Space.class), Long.valueOf(ArgumentMatchers.anyLong()), ArgumentMatchers.anyBoolean());
        }
    }

    @Test
    public void testGetSpacesByParentSpaceId() throws Exception {
        long parentSpaceId = 1L;
        int count = 2;
        Space space1 = new Space();
        space1.setId(10L);
        space1.setParentSpaceId(Long.valueOf(parentSpaceId));
        Space space2 = new Space();
        space2.setId(11L);
        space2.setParentSpaceId(Long.valueOf(parentSpaceId));
        List<Space> spaces = List.of(space1, space2);
        Mockito.when((Object)this.spaceStorage.getAllSpacesByFilterCount((SpaceFilter)ArgumentMatchers.any(SpaceFilter.class))).thenReturn((Object)spaces.size());
        SpaceFilter filter = new SpaceFilter();
        filter.setParentSpaceId(parentSpaceId);
        ListAccess result = this.spaceService.getAllSpacesByFilter(filter);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)count, (long)result.getSize());
        ((SpaceStorage)Mockito.verify((Object)this.spaceStorage, (VerificationMode)Mockito.times((int)1))).getAllSpacesByFilterCount((SpaceFilter)ArgumentMatchers.any(SpaceFilter.class));
    }
}

