/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.notification.rest;

import io.meeds.social.notification.rest.model.ChannelActivationChoice;
import io.meeds.social.notification.rest.model.EmailDigestChoice;
import io.meeds.social.notification.rest.model.UserNotificationSettings;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.notification.channel.AbstractChannel;
import org.exoplatform.commons.api.notification.channel.ChannelManager;
import org.exoplatform.commons.api.notification.model.GroupProvider;
import org.exoplatform.commons.api.notification.model.PluginInfo;
import org.exoplatform.commons.api.notification.model.UserSetting;
import org.exoplatform.commons.api.notification.plugin.config.PluginConfig;
import org.exoplatform.commons.api.notification.service.setting.PluginSettingService;
import org.exoplatform.commons.api.notification.service.setting.UserSettingService;
import org.exoplatform.portal.application.localization.LocalizationFilter;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.rest.http.PATCH;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;

@Path(value="notifications/settings")
@Tag(name="notifications/settings", description="Managing users notifications settings")
public class NotificationSettingsRestService
implements ResourceContainer {
    private static final String NOTIFICATION_LABEL_CHANNEL_DEFAULT = "UINotification.label.channel.default";
    private static final String MAIN_RESOURCE_BUNDLE_NAME = "locale.portlet.UserNotificationPortlet";
    private static final Log LOG = ExoLogger.getLogger(NotificationSettingsRestService.class);
    private static final String DAILY = "Daily";
    private static final String WEEKLY = "Weekly";
    private static final String NEVER = "Never";
    private ResourceBundleService resourceBundleService;
    private PluginSettingService pluginSettingService;
    private ChannelManager channelManager;
    private UserSettingService userSettingService;
    private UserACL userACL;

    public NotificationSettingsRestService(ResourceBundleService resourceBundleService, PluginSettingService pluginSettingService, ChannelManager channelManager, UserSettingService userSettingService, UserACL userACL) {
        this.resourceBundleService = resourceBundleService;
        this.pluginSettingService = pluginSettingService;
        this.channelManager = channelManager;
        this.userSettingService = userSettingService;
        this.userACL = userACL;
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @Operation(summary="Get default notification settings", description="Get default notification settings", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled")})
    public Response getSettings() {
        UserSetting setting = this.userSettingService.getDefaultSettings();
        UserNotificationSettings notificationSettings = this.mapToRestModel(setting, false);
        notificationSettings.setSenderName(this.pluginSettingService.getEmailSenderName());
        notificationSettings.setSenderEmail(this.pluginSettingService.getEmailSenderEmail());
        return Response.ok((Object)notificationSettings).build();
    }

    @PATCH
    @RolesAllowed(value={"administrators"})
    @Operation(summary="Change enablement status of Channel for all users", description="Change enablement status of Channel for all users", method="PATCH")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled")})
    public Response saveEmailSender(@Parameter(description="Company name", required=true) @FormParam(value="name") String name, @Parameter(description="Company email", required=true) @FormParam(value="email") String email) {
        try {
            this.pluginSettingService.saveEmailSender(name, email);
            return Response.noContent().build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="{id}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Gets all notification settings of a user", description="Gets all notification settings of a user", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getSettings(@Parameter(description="User name that will be used to retrieve its settings. If current user is and administrator, it will be able to retrieve settings of all users", required=true) @PathParam(value="id") String username) {
        boolean isAdmin = this.userACL.isSuperUser() || this.userACL.isUserInGroup(this.userACL.getAdminGroups());
        boolean isSameUser = ConversationState.getCurrent().getIdentity().getUserId().equals(username);
        if (!isAdmin && !isSameUser) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        UserSetting setting = this.userSettingService.get(username);
        UserNotificationSettings notificationSettings = this.mapToRestModel(setting, true);
        return Response.ok((Object)notificationSettings).build();
    }

    @PATCH
    @Path(value="plugin/{pluginId}")
    @RolesAllowed(value={"administrators"})
    @Operation(summary="Change enablement status of Channel for all users", description="Change enablement status of Channel for all users", method="PATCH")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled")})
    public Response savePluginSetting(@Parameter(description="Notification plugin Id", required=true) @PathParam(value="pluginId") String pluginId, @Parameter(description="Notification digest to use for corresponding plugin Id", required=true) @FormParam(value="channels") String channels) {
        String[] channelsArray = StringUtils.split((String)channels, (char)',');
        Map<String, String> channelsStatus = Arrays.stream(channelsArray).collect(Collectors.toMap(channelStatus -> StringUtils.split((String)channelStatus, (String)"=")[0], channelStatus -> StringUtils.split((String)channelStatus, (String)"=")[1]));
        for (Map.Entry<String, String> channelByStatus : channelsStatus.entrySet()) {
            String channelId = channelByStatus.getKey();
            boolean channelActive = Boolean.parseBoolean(channelByStatus.getValue());
            this.pluginSettingService.saveActivePlugin(channelId, pluginId, channelActive);
        }
        return Response.noContent().build();
    }

    @PATCH
    @Path(value="{id}/plugin/{pluginId}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Change enablement status of Channel for a user", description="Change enablement status of Channel for a user", method="PATCH")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response savePluginSetting(@Parameter(description="User name that will be used to save its settings.", required=true) @PathParam(value="id") String username, @Parameter(description="Notification plugin Id", required=true) @PathParam(value="pluginId") String pluginId, @Parameter(description="Notification digest to use for corresponding plugin Id", required=true) @FormParam(value="channels") String channels, @Parameter(description="Notification digest to use for corresponding plugin Id", required=true) @FormParam(value="digest") String digest) {
        boolean isAdmin = this.userACL.isSuperUser() || this.userACL.isUserInGroup(this.userACL.getAdminGroups());
        boolean isSameUser = ConversationState.getCurrent().getIdentity().getUserId().equals(username);
        if (!isAdmin && !isSameUser) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            UserSetting setting = this.userSettingService.get(username);
            if (WEEKLY.equals(digest)) {
                setting.addPlugin(pluginId, UserSetting.FREQUENCY.WEEKLY);
            } else if (DAILY.equals(digest)) {
                setting.addPlugin(pluginId, UserSetting.FREQUENCY.DAILY);
            } else {
                setting.removePlugin(pluginId, UserSetting.FREQUENCY.WEEKLY);
                setting.removePlugin(pluginId, UserSetting.FREQUENCY.DAILY);
            }
            String[] channelsArray = StringUtils.split((String)channels, (char)',');
            Map<String, String> channelsStatus = Arrays.stream(channelsArray).collect(Collectors.toMap(channelStatus -> StringUtils.split((String)channelStatus, (String)"=")[0], channelStatus -> StringUtils.split((String)channelStatus, (String)"=")[1]));
            for (Map.Entry<String, String> channelByStatus : channelsStatus.entrySet()) {
                if (Boolean.parseBoolean(channelByStatus.getValue())) {
                    setting.addChannelPlugin(channelByStatus.getKey(), pluginId);
                    continue;
                }
                setting.removeChannelPlugin(channelByStatus.getKey(), pluginId);
            }
            this.userSettingService.save(setting);
        }
        catch (Exception e) {
            return Response.serverError().entity((Object)("Exception in switching state of plugin " + pluginId + ". " + e.toString())).build();
        }
        return Response.noContent().build();
    }

    @PATCH
    @Path(value="channel/{channelId}")
    @RolesAllowed(value={"administrators"})
    @Operation(summary="Change enablement status of Channel for all users", description="Change enablement status of Channel for all users", method="PATCH")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled")})
    public Response saveChannelStatus(@Parameter(description="Channel Id like MAIL_CHANNEL, WEB_CHANNEL...", required=true) @PathParam(value="channelId") String channelId, @Parameter(description="Enable/disable a channel", required=true) @FormParam(value="enable") boolean enable) {
        this.pluginSettingService.saveChannelStatus(channelId, enable);
        return Response.noContent().build();
    }

    @PATCH
    @Path(value="{id}/spaces/{spaceId}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Change enablement status of Channel for a user", description="Change enablement status of Channel for a user", method="PATCH")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response saveSpaceMuteStatus(@Parameter(description="User name that will be used to save its settings.", required=true) @PathParam(value="id") String username, @Parameter(description="Space technical identifier", required=true) @PathParam(value="spaceId") long spaceId, @Parameter(description="Enable/disable a channel", required=true) @FormParam(value="enable") boolean enable) {
        boolean isAdmin = this.userACL.isSuperUser() || this.userACL.isUserInGroup(this.userACL.getAdminGroups());
        boolean isSameUser = ConversationState.getCurrent().getIdentity().getUserId().equals(username);
        if (!isAdmin && !isSameUser) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        UserSetting setting = this.userSettingService.get(username);
        if (enable) {
            setting.removeMutedSpace(spaceId);
        } else {
            setting.addMutedSpace(spaceId);
        }
        this.userSettingService.save(setting);
        return Response.noContent().build();
    }

    @PATCH
    @Path(value="{id}/channel/{channelId}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Change enablement status of Channel for a user", description="Change enablement status of Channel for a user", method="PATCH")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response saveActiveStatus(@Parameter(description="User name that will be used to save its settings.", required=true) @PathParam(value="id") String username, @Parameter(description="Channel Id like MAIL_CHANNEL, WEB_CHANNEL...", required=true) @PathParam(value="channelId") String channelId, @Parameter(description="Enable/disable a channel", required=true) @FormParam(value="enable") boolean enable) {
        boolean isAdmin = this.userACL.isSuperUser() || this.userACL.isUserInGroup(this.userACL.getAdminGroups());
        boolean isSameUser = ConversationState.getCurrent().getIdentity().getUserId().equals(username);
        if (!isAdmin && !isSameUser) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            UserSetting setting = this.userSettingService.get(username);
            if (enable) {
                setting.setChannelActive(channelId);
            } else {
                setting.removeChannelActive(channelId);
            }
            this.userSettingService.save(setting);
        }
        catch (Exception e) {
            return Response.serverError().entity((Object)("Exception in switching state of provider " + channelId + ". " + e.toString())).build();
        }
        return Response.noContent().build();
    }

    private Map<String, String> buildDigestDescriptions(Context context) {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put(DAILY, context.appRes("UINotification.description.Daily"));
        options.put(WEEKLY, context.appRes("UINotification.description.Weekly"));
        return options;
    }

    private Map<String, String> buildDigestLabels(Context context) {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put(DAILY, context.appRes("UINotification.label.Daily"));
        options.put(WEEKLY, context.appRes("UINotification.label.Weekly"));
        options.put(NEVER, context.appRes("UINotification.label.Never"));
        return options;
    }

    private List<String> getChannels(boolean activeChannelsOnly) {
        ArrayList<String> channels = new ArrayList<String>();
        for (AbstractChannel channel : this.channelManager.getChannels()) {
            String channelId = channel.getId();
            if (activeChannelsOnly && !this.pluginSettingService.isChannelActive(channelId)) continue;
            channels.add(channelId);
        }
        return channels;
    }

    private Map<String, Boolean> computeChannelStatuses(UserSetting setting, List<String> channels) {
        HashMap<String, Boolean> channelStatus = new HashMap<String, Boolean>();
        for (String channelId : channels) {
            channelStatus.put(channelId, setting != null && setting.isChannelGloballyActive(channelId));
        }
        return channelStatus;
    }

    private boolean computeChoices(UserSetting userSetting, List<String> channels, List<GroupProvider> groups, Map<String, Boolean> channelStatus, List<EmailDigestChoice> emailDigestChoices, List<ChannelActivationChoice> channelCheckBoxList) {
        boolean hasActivePlugin = false;
        for (GroupProvider groupProvider : groups) {
            for (PluginInfo pluginInfo : groupProvider.getPluginInfos()) {
                String pluginId = pluginInfo.getType();
                for (String channelId : channels) {
                    hasActivePlugin = true;
                    boolean isChannelActive = channelStatus.get(channelId) != false && this.pluginSettingService.isActive(channelId, pluginId) && userSetting.isChannelGloballyActive(channelId);
                    channelCheckBoxList.add(new ChannelActivationChoice(channelId, pluginId, this.pluginSettingService.isAllowed(channelId, pluginId), isChannelActive && userSetting.isActive(channelId, pluginId), isChannelActive));
                    if (!"MAIL_CHANNEL".equals(channelId)) continue;
                    emailDigestChoices.add(new EmailDigestChoice(channelId, pluginId, this.getValue(userSetting, pluginId), isChannelActive));
                }
            }
        }
        return hasActivePlugin;
    }

    private String getValue(UserSetting setting, String pluginId) {
        if (setting != null && setting.isInWeekly(pluginId)) {
            return WEEKLY;
        }
        if (setting != null && setting.isInDaily(pluginId)) {
            return DAILY;
        }
        return NEVER;
    }

    private UserNotificationSettings mapToRestModel(UserSetting setting, boolean activeChannelsOnly) {
        Locale userLocale = LocalizationFilter.getCurrentLocale();
        if (userLocale == null) {
            userLocale = Locale.ENGLISH;
        }
        Object[] sharedResourceBundles = this.resourceBundleService.getSharedResourceBundleNames();
        String[] resourceBundles = (String[])ArrayUtils.insert((int)0, (Object[])sharedResourceBundles, (Object[])new String[]{MAIN_RESOURCE_BUNDLE_NAME});
        ResourceBundle resourceBundle = this.resourceBundleService.getResourceBundle(resourceBundles, userLocale);
        Context context = new Context(resourceBundle, userLocale);
        List<String> channels = this.getChannels(activeChannelsOnly);
        Map<String, Boolean> channelStatus = this.computeChannelStatuses(setting, channels);
        List groups = this.pluginSettingService.getGroupPlugins();
        Map<String, String> groupsLabels = groups.stream().collect(Collectors.toMap(GroupProvider::getGroupId, group -> context.pluginRes(group.getResourceBundleKey(), group.getGroupId())));
        Map<String, String> pluginLabels = groups.stream().flatMap(group -> group.getPluginInfos().stream()).collect(Collectors.toMap(PluginInfo::getType, plugin -> context.pluginRes("UINotification.title." + plugin.getType(), plugin.getType())));
        Map<String, String> channelLabels = channels.stream().collect(Collectors.toMap(Function.identity(), channel -> {
            String channelKey = context.getChannelKey((String)channel);
            String key = "UINotification.label.channel-" + channelKey;
            if (resourceBundle != null && resourceBundle.containsKey(key)) {
                return resourceBundle.getString(key);
            }
            if (resourceBundle != null && resourceBundle.containsKey(NOTIFICATION_LABEL_CHANNEL_DEFAULT)) {
                return resourceBundle.getString(NOTIFICATION_LABEL_CHANNEL_DEFAULT).replace("{0}", channelKey);
            }
            return channelKey;
        }));
        Map<String, String> channelDescriptions = channels.stream().collect(Collectors.toMap(Function.identity(), channel -> {
            String channelKey = context.getChannelKey((String)channel);
            String key = "UINotification.description.channel-" + channelKey;
            if (resourceBundle != null && resourceBundle.containsKey(key)) {
                return resourceBundle.getString(key);
            }
            if (resourceBundle != null && resourceBundle.containsKey("UINotification.description.channel.default")) {
                return resourceBundle.getString("UINotification.description.channel.default").replace("{0}", channelKey);
            }
            return "";
        }));
        Map<String, String> digestLabels = this.buildDigestLabels(context);
        Map<String, String> digestDescriptions = this.buildDigestDescriptions(context);
        ArrayList<EmailDigestChoice> emailDigestChoices = new ArrayList<EmailDigestChoice>();
        ArrayList<ChannelActivationChoice> channelCheckBoxList = new ArrayList<ChannelActivationChoice>();
        boolean hasActivePlugin = this.computeChoices(setting, channels, groups, channelStatus, emailDigestChoices, channelCheckBoxList);
        return new UserNotificationSettings(groups, groupsLabels, pluginLabels, channelLabels, channelDescriptions, digestLabels, digestDescriptions, hasActivePlugin, emailDigestChoices, channelCheckBoxList, channelStatus, channels, setting.getMutedSpaces());
    }

    public class Context {
        ResourceBundle resourceBundle;
        Locale userLocale;

        public Context(ResourceBundle resourceBundle, Locale userLocale) {
            this.resourceBundle = resourceBundle;
            this.userLocale = userLocale;
        }

        public String appRes(String key) {
            try {
                return this.resourceBundle.getString(key).replace("'", "&#39;").replace("\"", "&#34;");
            }
            catch (MissingResourceException e) {
                if (key.indexOf("checkbox-") > -1) {
                    return this.appRes("UINotification.label.checkbox.default").replace("{0}", this.capitalizeFirstLetter(key.split("-")[1]));
                }
                if (key.indexOf("channel-") > -1) {
                    return this.appRes(NotificationSettingsRestService.NOTIFICATION_LABEL_CHANNEL_DEFAULT).replace("{0}", this.capitalizeFirstLetter(key.split("-")[1]));
                }
            }
            catch (Exception e) {
                LOG.debug((Object)("Error when get resource bundle key " + key), (Throwable)e);
            }
            return this.capitalizeFirstLetter(key.substring(key.lastIndexOf(46) + 1));
        }

        private String getBundlePath(String id, String key) {
            PluginConfig pluginConfig = NotificationSettingsRestService.this.pluginSettingService.getPluginConfig(id);
            if (pluginConfig != null) {
                return pluginConfig.getBundlePath();
            }
            List groups = NotificationSettingsRestService.this.pluginSettingService.getGroupPlugins();
            for (GroupProvider groupProvider : groups) {
                List pluginInfos = groupProvider.getPluginInfos();
                if (!groupProvider.getGroupId().equals(id) || pluginInfos == null || pluginInfos.isEmpty()) continue;
                for (PluginInfo pluginInfo : pluginInfos) {
                    ResourceBundle resBundle;
                    if (!StringUtils.isNotBlank((CharSequence)pluginInfo.getBundlePath()) || (resBundle = NotificationSettingsRestService.this.resourceBundleService.getResourceBundle(pluginInfo.getBundlePath(), this.userLocale)) == null || !resBundle.containsKey(key)) continue;
                    return pluginInfo.getBundlePath();
                }
            }
            PluginConfig defaultPluginConfig = NotificationSettingsRestService.this.pluginSettingService.getPluginConfig("DigestDailyPlugin");
            return defaultPluginConfig == null ? null : defaultPluginConfig.getBundlePath();
        }

        public String pluginRes(String key, String id) {
            String path = this.getBundlePath(id, key);
            ResourceBundle pluginResourceBundle = StringUtils.isBlank((CharSequence)path) ? null : NotificationSettingsRestService.this.resourceBundleService.getResourceBundle(path, this.userLocale);
            return pluginResourceBundle != null && pluginResourceBundle.containsKey(key) ? pluginResourceBundle.getString(key) : id;
        }

        public String getChannelKey(String channelId) {
            return channelId.replace("_CHANNEL", "").toLowerCase();
        }

        public String capitalizeFirstLetter(String original) {
            return original.length() <= 1 ? original : original.substring(0, 1).toUpperCase() + original.substring(1);
        }
    }
}

