/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.notification.service;

import io.meeds.social.html.model.HtmlTransformerContext;
import io.meeds.social.html.utils.HtmlUtils;
import java.util.Locale;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.template.TemplateContentTransformerService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.cache.CacheService;
import org.springframework.stereotype.Service;

@Service
public class MailTemplateContentTransformerService
extends TemplateContentTransformerService {
    private static final String RELATIVE_PATH_LINK_PATTERN = "href=\"/";
    private static final String RELATIVE_PATH_LINK_REPLACEMENT = "href=\"%s/";
    private String relativePathLinkReplacement = String.format("href=\"%s/", CommonsUtils.getCurrentDomain());

    public MailTemplateContentTransformerService(CacheService cacheService) {
        super(cacheService);
    }

    public String processGroovy(TemplateContext ctx) {
        String html = super.processGroovy(ctx);
        return this.transform(html, ctx);
    }

    public String processDigest(TemplateContext ctx) {
        String digest = super.processDigest(ctx);
        return this.transform(digest, ctx);
    }

    protected String transform(String value, TemplateContext ctx) {
        if (value == null) {
            return null;
        }
        Locale locale = LocaleUtils.toLocale((String)ctx.getLanguage());
        if ((value = HtmlUtils.transform((String)StringEscapeUtils.unescapeHtml4((String)value), (HtmlTransformerContext)new HtmlTransformerContext(true, locale))).contains(RELATIVE_PATH_LINK_PATTERN)) {
            value = value.replace(RELATIVE_PATH_LINK_PATTERN, this.relativePathLinkReplacement);
        }
        return value;
    }
}

