/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.channel.template;

import java.io.StringWriter;
import java.util.Arrays;
import java.util.List;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.channel.AbstractChannel;
import org.exoplatform.commons.api.notification.channel.ChannelManager;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.model.UserSetting;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.notification.AbstractPluginTest;

public class PostActivityMailBuilderTest
extends AbstractPluginTest {
    private ChannelManager manager;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.manager = this.getService(ChannelManager.class);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Override
    public AbstractTemplateBuilder getTemplateBuilder() {
        AbstractChannel channel = this.manager.getChannel(ChannelKey.key((String)"MAIL_CHANNEL"));
        PostActivityMailBuilderTest.assertTrue((channel != null ? 1 : 0) != 0);
        PostActivityMailBuilderTest.assertTrue((boolean)channel.hasTemplateBuilder(PluginKey.key((String)"PostActivityPlugin")));
        return channel.getTemplateBuilder(PluginKey.key((String)"PostActivityPlugin"));
    }

    @Override
    public BaseNotificationPlugin getPlugin() {
        return this.pluginService.getPlugin(PluginKey.key((String)"PostActivityPlugin"));
    }

    public void testSimpleCase() throws Exception {
        this.makeActivity(this.demoIdentity, "demo post activity on activity stream of root");
        List<NotificationInfo> list = this.assertMadeMailDigestNotifications(this.rootIdentity.getRemoteId(), 1);
        NotificationInfo postActivityNotification = list.get(0);
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.setNotificationInfo(postActivityNotification.setTo("root"));
        MessageInfo info = this.buildMessageInfo(ctx);
        this.assertSubject(info, this.getFullName("demo") + " posted on your activity stream");
        this.assertBody(info, "New post on your activity stream");
        this.assertBody(info, "demo post activity on activity stream of root");
    }

    public void testDigest() throws Exception {
        UserSetting rootSetting = new UserSetting();
        rootSetting.setUserId(this.rootIdentity.getRemoteId());
        rootSetting.setDailyPlugins(Arrays.asList(this.getPlugin().getId()));
        this.userSettingService.save(rootSetting);
        Identity ghostIdentity = this.identityManager.getOrCreateUserIdentity("ghost");
        this.notificationService.clearAll();
        this.makeActivity(this.demoIdentity, "demo post activity on activity stream of root");
        this.makeActivity(this.maryIdentity, "mary post activity on activity stream of root");
        this.makeActivity(this.johnIdentity, "john post activity on activity stream of root");
        this.makeActivity(ghostIdentity, "ghost post activity on activity stream of root");
        this.assertMadeMailDigestNotifications(4);
        List<NotificationInfo> list = this.assertMadeMailDigestNotifications(this.rootIdentity.getRemoteId(), 4);
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        list.set(0, list.get(0).setTo(this.rootIdentity.getRemoteId()));
        ctx.setNotificationInfos(list);
        StringWriter writer = new StringWriter();
        this.buildDigest(ctx, writer);
        this.assertDigest(writer, this.getFullName("demo") + ", " + this.getFullName("mary") + ", " + this.getFullName("john") + " and 1 others posted on your activity stream.");
        this.tearDownIdentityList.add(ghostIdentity);
    }

    public void testDigestWithSameUser() throws Exception {
        this.makeActivity(this.demoIdentity, "demo post activity on activity stream of root");
        this.makeActivity(this.demoIdentity, "mary post activity on activity stream of root");
        this.makeActivity(this.johnIdentity, "john post activity on activity stream of root");
        this.assertMadeMailDigestNotifications(3);
        List<NotificationInfo> list = this.assertMadeMailDigestNotifications(this.rootIdentity.getRemoteId(), 3);
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        list.set(0, list.get(0).setTo(this.rootIdentity.getRemoteId()));
        ctx.setNotificationInfos(list);
        StringWriter writer = new StringWriter();
        this.buildDigest(ctx, writer);
        this.assertDigest(writer, this.getFullName("demo") + ", " + this.getFullName("john") + " posted on your activity stream.");
    }

    public void testDigestWithDeletedActivity() throws Exception {
        ExoSocialActivity demoActivity = this.makeActivity(this.demoIdentity, "demo post activity on activity stream of root");
        this.makeActivity(this.johnIdentity, "john post activity on activity stream of root");
        this.assertMadeMailDigestNotifications(2);
        List<NotificationInfo> list = this.assertMadeMailDigestNotifications(this.rootIdentity.getRemoteId(), 2);
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        list.set(0, list.get(0).setTo(this.rootIdentity.getRemoteId()));
        ctx.setNotificationInfos(list);
        this.activityManager.deleteActivity(demoActivity);
        this.tearDownActivityList.remove(demoActivity);
        StringWriter writer = new StringWriter();
        this.buildDigest(ctx, writer);
        this.assertDigest(writer, this.getFullName("john") + " posted on your activity stream.");
    }
}

