/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.channel.template;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.channel.AbstractChannel;
import org.exoplatform.commons.api.notification.channel.ChannelManager;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.notification.AbstractPluginTest;

public class ActivityCommentReplyMailBuilderTest
extends AbstractPluginTest {
    private static final String ACTIVITY_TITLE = "my activity title post today.";
    private static final String COMMENT_TITLE = "my comment title add today.";
    private static final String SUB_COMMENT_TITLE = "my comment reply title add today.";
    private ChannelManager manager;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.manager = this.getService(ChannelManager.class);
    }

    @Override
    public AbstractTemplateBuilder getTemplateBuilder() {
        AbstractChannel channel = this.manager.getChannel(ChannelKey.key((String)"MAIL_CHANNEL"));
        ActivityCommentReplyMailBuilderTest.assertTrue((channel != null ? 1 : 0) != 0);
        ActivityCommentReplyMailBuilderTest.assertTrue((boolean)channel.hasTemplateBuilder(PluginKey.key((String)"ActivityReplyToCommentPlugin")));
        return channel.getTemplateBuilder(PluginKey.key((String)"ActivityReplyToCommentPlugin"));
    }

    @Override
    public BaseNotificationPlugin getPlugin() {
        return this.pluginService.getPlugin(PluginKey.key((String)"ActivityReplyToCommentPlugin"));
    }

    public void testSimpleCase() throws Exception {
        ExoSocialActivity activity = this.makeActivity(this.maryIdentity, ACTIVITY_TITLE);
        this.assertMadeMailDigestNotifications(1);
        this.notificationService.clearAll();
        ExoSocialActivity comment = this.makeComment(activity, this.rootIdentity, COMMENT_TITLE);
        this.makeCommentReply(activity, this.demoIdentity, SUB_COMMENT_TITLE, comment.getId());
        this.restartTransaction();
        List<NotificationInfo> list = this.assertMadeMailDigestNotifications(this.rootIdentity.getRemoteId(), 1);
        NotificationInfo commentReplyNotification = list.get(0);
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.setNotificationInfo(commentReplyNotification.setTo(this.demoIdentity.getRemoteId()));
        MessageInfo info = this.buildMessageInfo(ctx);
        this.assertSubject(info, this.demoIdentity.getProfile().getFullName() + " has replied to one of your comments");
        this.assertBody(info, ACTIVITY_TITLE);
        this.assertBody(info, "New reply on your comment");
    }

    public void testDigest() throws Exception {
        ExoSocialActivity maryActivity = this.makeActivity(this.maryIdentity, ACTIVITY_TITLE);
        this.assertMadeMailDigestNotifications(1);
        this.notificationService.clearAll();
        ArrayList<NotificationInfo> toRoot = new ArrayList<NotificationInfo>();
        ExoSocialActivity comment = this.makeComment(maryActivity, this.rootIdentity, "root add comment");
        this.makeCommentReply(maryActivity, this.demoIdentity, "demo add reply", comment.getId());
        this.restartTransaction();
        List<NotificationInfo> list1 = this.assertMadeMailDigestNotifications(this.rootIdentity.getRemoteId(), 1);
        toRoot.add(list1.get(0));
        this.notificationService.clearAll();
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        toRoot.set(0, ((NotificationInfo)toRoot.get(0)).setTo(this.rootIdentity.getRemoteId()));
        ctx.setNotificationInfos(toRoot);
        StringWriter writer = new StringWriter();
        this.buildDigest(ctx, writer);
        this.assertDigest(writer, this.getFullName("demo") + " has replied to your comment: my activity title post today.demo add reply");
    }
}

