/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.oauth.social;

import io.meeds.oauth.exception.OAuthException;
import io.meeds.oauth.exception.OAuthExceptionCode;
import io.meeds.oauth.social.FacebookPrincipal;
import io.meeds.oauth.social.FacebookRequest;
import io.meeds.oauth.utils.HttpResponseContext;
import io.meeds.oauth.utils.OAuthUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FacebookProcessor {
    private static Log log = ExoLogger.getLogger(FacebookProcessor.class);
    protected boolean trace = log.isTraceEnabled();
    protected String clientID;
    protected String clientSecret;
    protected String scope;
    protected String returnURL;

    public FacebookProcessor(String clientID, String clientSecret, String scope, String returnURL) {
        this.clientID = clientID;
        this.clientSecret = clientSecret;
        this.scope = scope;
        this.returnURL = returnURL;
    }

    public boolean initialInteraction(HttpServletRequest request, HttpServletResponse response, String verificationState) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("redirect_uri", this.returnURL);
        params.put("client_id", this.clientID);
        params.put("state", verificationState);
        if (this.scope != null) {
            params.put("scope", this.scope);
        }
        String location = "https://www.facebook.com/dialog/oauth" + "?" + OAuthUtils.createQueryString(params);
        if (this.trace) {
            log.trace((Object)("Redirect:" + location));
        }
        response.sendRedirect(location);
        return false;
    }

    public String getAccessToken(HttpServletRequest request, HttpServletResponse response) throws OAuthException {
        String authorizationCode = request.getParameter("code");
        if (authorizationCode == null) {
            log.error((Object)"Authorization code parameter not found");
            this.handleCodeRequestError(request, response);
            return null;
        }
        String stateFromSession = (String)request.getSession().getAttribute("_verificationState");
        String stateFromRequest = request.getParameter("state");
        if (stateFromSession == null || stateFromRequest == null || !stateFromSession.equals(stateFromRequest)) {
            throw new OAuthException(OAuthExceptionCode.INVALID_STATE, "Validation of state parameter failed. stateFromSession=" + stateFromSession + ", stateFromRequest=" + stateFromRequest);
        }
        String accessToken = (String)new FacebookRequest<String>(){

            @Override
            protected URL createURL(String authorizationCode) throws IOException {
                return FacebookProcessor.this.sendAccessTokenRequest(authorizationCode);
            }

            @Override
            protected String parseResponse(String httpResponse) throws JSONException {
                JSONObject json = new JSONObject(httpResponse);
                String accessToken = json.getString("access_token");
                String expires = json.getString("expires_in");
                if (FacebookProcessor.this.trace) {
                    log.trace((Object)("Access Token=" + accessToken + " :: Expires=" + expires));
                }
                return accessToken;
            }
        }.executeRequest(authorizationCode);
        return accessToken;
    }

    protected URL sendAccessTokenRequest(String authorizationCode) throws IOException {
        String returnUri = this.returnURL;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("redirect_uri", returnUri);
        params.put("client_id", this.clientID);
        params.put("client_secret", this.clientSecret);
        params.put("code", authorizationCode);
        String location = "https://graph.facebook.com/oauth/access_token" + "?" + OAuthUtils.createQueryString(params);
        if (this.trace) {
            log.trace((Object)("AccessToken Request=" + location));
        }
        return new URL(location);
    }

    public Set<String> getScopes(String accessToken) {
        Set scopes = (Set)new FacebookRequest<Set<String>>(){

            @Override
            protected URL createURL(String accessToken) throws IOException {
                String urlString = "https://graph.facebook.com/me" + "/permissions" + "?access_token=" + URLEncoder.encode(accessToken, "UTF-8");
                if (FacebookProcessor.this.trace) {
                    log.trace((Object)("Read info about available scopes:" + urlString));
                }
                return new URL(urlString);
            }

            @Override
            protected Set<String> parseResponse(String httpResponse) throws JSONException {
                String[] names;
                JSONObject jsonObject = new JSONObject(httpResponse);
                JSONArray json = jsonObject.getJSONArray("data");
                if (json != null && (jsonObject = json.optJSONObject(0)) != null && (names = JSONObject.getNames((JSONObject)jsonObject)) != null) {
                    HashSet<String> scopes = new HashSet<String>();
                    for (String name : names) {
                        scopes.add(name);
                    }
                    return scopes;
                }
                return new HashSet<String>();
            }
        }.executeRequest(accessToken);
        return scopes;
    }

    public FacebookPrincipal getPrincipal(String accessToken) {
        FacebookPrincipal facebookPrincipal = (FacebookPrincipal)new FacebookRequest<FacebookPrincipal>(){
            private String accessToken;

            @Override
            protected URL createURL(String accessToken) throws IOException {
                String urlString = "https://graph.facebook.com/me" + "?access_token=" + URLEncoder.encode(accessToken, "UTF-8");
                if (FacebookProcessor.this.trace) {
                    log.trace((Object)("Profile read:" + urlString));
                }
                this.accessToken = accessToken;
                return new URL(urlString);
            }

            @Override
            protected FacebookPrincipal parseResponse(String httpResponse) throws JSONException {
                JSONObject jsonObject = new JSONObject(httpResponse);
                FacebookPrincipal facebookPrincipal = new FacebookPrincipal();
                facebookPrincipal.setAccessToken(this.accessToken);
                facebookPrincipal.setId(jsonObject.getString("id"));
                facebookPrincipal.setName(jsonObject.optString("name"));
                facebookPrincipal.setUsername(jsonObject.optString("username"));
                facebookPrincipal.setFirstName(jsonObject.optString("first_name"));
                facebookPrincipal.setLastName(jsonObject.optString("last_name"));
                facebookPrincipal.setGender(jsonObject.optString("gender"));
                facebookPrincipal.setTimezone(jsonObject.optString("timezone"));
                facebookPrincipal.setLocale(jsonObject.optString("locale"));
                facebookPrincipal.setEmail(jsonObject.optString("email"));
                facebookPrincipal.setJsonObject(jsonObject);
                if (facebookPrincipal.getUsername() == null || facebookPrincipal.getUsername().length() == 0) {
                    facebookPrincipal.setUsername(facebookPrincipal.getId());
                }
                return facebookPrincipal;
            }
        }.executeRequest(accessToken);
        return facebookPrincipal;
    }

    public String getUserAvatarURL(String accessToken) {
        return (String)new FacebookRequest<String>(){

            @Override
            protected URL createURL(String accessToken) throws IOException {
                String urlString = "https://graph.facebook.com/me" + "/picture?type=large&format=json&redirect=false" + "&access_token=" + URLEncoder.encode(accessToken, "UTF-8");
                if (FacebookProcessor.this.trace) {
                    log.trace((Object)("Profile read:" + urlString));
                }
                return new URL(urlString);
            }

            @Override
            protected String parseResponse(String httpResponse) throws JSONException {
                JSONObject data;
                JSONObject jsonObject = new JSONObject(httpResponse);
                if (jsonObject.has("data") && (data = jsonObject.getJSONObject("data")).has("url")) {
                    return data.getString("url");
                }
                return "";
            }
        }.executeRequest(accessToken);
    }

    public void revokeToken(String accessToken) {
        try {
            String urlString = "https://graph.facebook.com/me" + "/permissions?access_token=" + URLEncoder.encode(accessToken, "UTF-8") + "&method=delete";
            URL revokeUrl = new URL(urlString);
            HttpResponseContext revokeContent = OAuthUtils.readUrlContent(revokeUrl.openConnection());
            if (revokeContent.getResponseCode() != 200) {
                throw new OAuthException(OAuthExceptionCode.TOKEN_REVOCATION_FAILED, "Error when revoking token. Http response code: " + revokeContent.getResponseCode() + ", Error details: " + revokeContent.getResponse());
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("Successfully revoked facebook accessToken " + accessToken + ", revokeContent=" + String.valueOf(revokeContent)));
            }
        }
        catch (IOException ioe) {
            throw new OAuthException(OAuthExceptionCode.TOKEN_REVOCATION_FAILED, "Error when revoking token", (Throwable)ioe);
        }
    }

    private void handleCodeRequestError(HttpServletRequest request, HttpServletResponse response) {
        StringBuilder errorBuilder = new StringBuilder();
        Enumeration paramNames = request.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            if (!paramName.startsWith("error")) continue;
            errorBuilder.append(paramName + ": " + request.getParameter(paramName) + System.getProperty("line.separator"));
        }
        String errorMessage = errorBuilder.toString();
        String error = request.getParameter("error");
        if (error != null && "access_denied".equals(error)) {
            throw new OAuthException(OAuthExceptionCode.USER_DENIED_SCOPE, errorMessage);
        }
        throw new OAuthException(OAuthExceptionCode.FACEBOOK_ERROR, errorMessage);
    }
}

