/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.oauth.filter;

import io.meeds.oauth.spi.OAuthProviderTypeRegistry;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.organization.User;
import org.exoplatform.web.filter.Filter;
import org.exoplatform.web.security.AuthenticationRegistry;

public abstract class OAuthAbstractFilter
implements Filter {
    private Boolean oauthEnable = null;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        if (req.getRemoteUser() != null) {
            chain.doFilter(request, response);
            return;
        }
        if (!this.isOauthEnable()) {
            chain.doFilter((ServletRequest)req, (ServletResponse)res);
            return;
        }
        AuthenticationRegistry authReg = this.getService(AuthenticationRegistry.class);
        User authenticated = (User)authReg.getAttributeOfClient(req, "_authenticatedPortalUserForJaas");
        if (authenticated != null) {
            chain.doFilter((ServletRequest)req, (ServletResponse)res);
            return;
        }
        User oauthAuthenticatedUser = (User)authReg.getAttributeOfClient(req, "_authenticatedPortalUser");
        if (oauthAuthenticatedUser == null) {
            chain.doFilter((ServletRequest)req, (ServletResponse)res);
            return;
        }
        this.executeFilter(req, res, chain);
    }

    protected abstract void executeFilter(HttpServletRequest var1, HttpServletResponse var2, FilterChain var3) throws IOException, ServletException;

    protected boolean isOauthEnable() {
        if (this.oauthEnable == null) {
            OAuthProviderTypeRegistry registry = this.getService(OAuthProviderTypeRegistry.class);
            this.oauthEnable = registry.isOAuthEnabled();
        }
        return this.oauthEnable;
    }

    protected <T> T getService(Class<T> clazz) {
        return (T)PortalContainer.getInstance().getComponentInstanceOfType(clazz);
    }

    protected ServletContext getContext() {
        return PortalContainer.getInstance().getPortalContext();
    }
}

