/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.oauth.test;

import com.github.scribejava.core.model.OAuth2AccessToken;
import io.meeds.oauth.openid.OpenIdAccessTokenContext;
import io.meeds.oauth.spi.OAuthPrincipal;
import io.meeds.oauth.utils.OAuthUtils;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Test;

public class TestOauthUtils {
    @Test
    public void testConvertOpenIdInfoToOAuthPrincipalWithUserInfo() throws JSONException {
        JSONObject userInfo = new JSONObject();
        userInfo.put("email", (Object)"usertest@acme.com");
        userInfo.put("given_name", (Object)"User");
        userInfo.put("family_name", (Object)"Test");
        userInfo.put("name", (Object)"User Test");
        userInfo.put("picture", (Object)"https://www.test.com/avatar");
        OAuth2AccessToken token = new OAuth2AccessToken("token", "raw");
        OpenIdAccessTokenContext openIdAccessTokenContext = new OpenIdAccessTokenContext(token, "openid");
        OAuthPrincipal principal = OAuthUtils.convertOpenIdInfoToOAuthPrincipal((JSONObject)userInfo, (OpenIdAccessTokenContext)openIdAccessTokenContext, null);
        Assert.assertNull((Object)principal.getName());
        Assert.assertEquals((Object)"usertest@acme.com", (Object)principal.getEmail());
        Assert.assertEquals((Object)"User", (Object)principal.getFirstName());
        Assert.assertEquals((Object)"Test", (Object)principal.getLastName());
        Assert.assertEquals((Object)"User Test", (Object)principal.getDisplayName());
        Assert.assertEquals((Object)"https://www.test.com/avatar", (Object)principal.getAvatar());
    }

    @Test
    public void testConvertOpenIdInfoToOAuthPrincipalWithCustomClaims() throws JSONException {
        JSONObject userInfo = new JSONObject();
        OAuth2AccessToken token = new OAuth2AccessToken("token", "raw");
        OpenIdAccessTokenContext openIdAccessTokenContext = new OpenIdAccessTokenContext(token, "openid");
        HashMap<String, String> customClaims = new HashMap<String, String>();
        customClaims.put("email", "usertest@acme.com");
        customClaims.put("given_name", "User");
        customClaims.put("family_name", "Test");
        customClaims.put("name", "User Test");
        openIdAccessTokenContext.addCustomClaims(customClaims);
        OAuthPrincipal principal = OAuthUtils.convertOpenIdInfoToOAuthPrincipal((JSONObject)userInfo, (OpenIdAccessTokenContext)openIdAccessTokenContext, null);
        Assert.assertNull((Object)principal.getName());
        Assert.assertEquals((Object)"usertest@acme.com", (Object)principal.getEmail());
        Assert.assertEquals((Object)"User", (Object)principal.getFirstName());
        Assert.assertEquals((Object)"Test", (Object)principal.getLastName());
        Assert.assertEquals((Object)"User Test", (Object)principal.getDisplayName());
        Assert.assertNull((Object)principal.getAvatar());
    }
}

