/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.impl.identity;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.profileproperty.ProfilePropertyService;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.rest.api.EntityBuilder;
import org.exoplatform.social.rest.api.IdentityRestResources;
import org.exoplatform.social.rest.api.RestUtils;
import org.exoplatform.social.rest.entity.CollectionEntity;
import org.exoplatform.social.rest.entity.DataEntity;
import org.exoplatform.social.rest.entity.IdentityEntity;
import org.exoplatform.social.rest.entity.ProfileEntity;

@Path(value="v1/social/identities")
@Tag(name="v1/social/identities", description="Managing identities")
public class IdentityRestResourcesV1
implements IdentityRestResources {
    private IdentityManager identityManager;
    private final ProfilePropertyService profilePropertyService;

    public IdentityRestResourcesV1(IdentityManager identityManager, ProfilePropertyService profilePropertyService) {
        this.identityManager = identityManager;
        this.profilePropertyService = profilePropertyService;
    }

    @Override
    @GET
    @RolesAllowed(value={"users"})
    @Operation(summary="Gets all identities", method="GET", description="This returns a list of identities in the following cases: <br/><ul><li>the authenticated user has permissions to view the object linked to these identities</li><li>the authenticated user is in the group /platform/administrators</li></ul>")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response getIdentities(@Context UriInfo uriInfo, @Parameter(description="Provider type: space or organization", required=false) @Schema(defaultValue="organization") @QueryParam(value="type") String type, @Parameter(description="Offset", required=false) @Schema(defaultValue="0") @QueryParam(value="offset") int offset, @Parameter(description="Limit", required=false) @Schema(defaultValue="20") @QueryParam(value="limit") int limit, @Parameter(description="Returning the number of identities or not") @Schema(defaultValue="false") @QueryParam(value="returnSize") boolean returnSize, @Parameter(description="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand) throws Exception {
        try {
            offset = offset > 0 ? offset : RestUtils.getOffset(uriInfo);
            limit = limit > 0 ? limit : RestUtils.getLimit(uriInfo);
            IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
            String providerId = type != null && type.equals("space") ? "space" : "organization";
            ListAccess listAccess = identityManager.getIdentitiesByProfileFilter(providerId, new ProfileFilter(), true);
            org.exoplatform.social.core.identity.model.Identity[] identities = (org.exoplatform.social.core.identity.model.Identity[])listAccess.load(offset, limit);
            ArrayList<DataEntity> identityEntities = new ArrayList<DataEntity>();
            for (org.exoplatform.social.core.identity.model.Identity identity : identities) {
                identityEntities.add(EntityBuilder.buildEntityIdentity(identity, uriInfo.getPath(), expand).getDataEntity());
            }
            CollectionEntity collectionIdentity = new CollectionEntity(identityEntities, "identities", offset, limit);
            if (returnSize) {
                collectionIdentity.setSize(listAccess.getSize());
            }
            return EntityBuilder.getResponse(collectionIdentity, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
        }
        catch (Exception e) {
            return EntityBuilder.getResponse(new CollectionEntity(new ArrayList(), "identities", offset, limit), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
        }
    }

    @Override
    @GET
    @Path(value="{id}")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @Operation(summary="Gets an identity by id", method="GET", description="This returns the identity if the authenticated user has permissions to view the object linked to this identity.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response getIdentityById(@Context UriInfo uriInfo, @Context Request request, @Parameter(description="Identity id which is a UUID such as 40487b7e7f00010104499b339f056aa4", required=true) @PathParam(value="id") String id, @Parameter(description="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand) throws Exception {
        long cacheTime;
        String eTagValue;
        EntityTag eTag;
        Response.ResponseBuilder builder;
        org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getIdentity(id);
        if (identity == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        Identity authenticatedUserIdentity = ConversationState.getCurrent().getIdentity();
        String authenticatedUser = authenticatedUserIdentity.getUserId();
        String expandedSettings = expand;
        if (expand != null && expand.contains("settings") && identity.isUser()) {
            expandedSettings = String.valueOf(Objects.hash(EntityBuilder.buildEntityProfilePropertySettingList(this.profilePropertyService.getPropertySettings(), this.profilePropertyService, "profileProperty", Long.parseLong(identity.getId()))));
        }
        if ((builder = request.evaluatePreconditions(eTag = new EntityTag(eTagValue = String.valueOf(Objects.hash(cacheTime = identity.getCacheTime(), authenticatedUser, expandedSettings)), true))) == null) {
            IdentityEntity profileInfo = EntityBuilder.buildEntityIdentity(identity, uriInfo.getPath(), expand);
            builder = Response.ok((Object)profileInfo, (String)"application/json");
            builder.tag(eTag);
            builder.lastModified(new Date(cacheTime));
            builder.expires(new Date(cacheTime));
        }
        return builder.build();
    }

    @GET
    @Path(value="byParams")
    @RolesAllowed(value={"users"})
    @Operation(summary="Gets an identity by id", method="GET", description="This returns the identity if the authenticated user has permissions to view the object linked to this identity.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    @Produces(value={"application/json"})
    public Response getIdentityByProviderIdAndRemoteIdInQuery(@Context UriInfo uriInfo, @Context Request request, @Parameter(description="Identity provider id which can be of type 'space' or 'organization' for example", required=true) @QueryParam(value="providerId") String providerId, @Parameter(description="Identity id which is the unique name (remote id) of identity", required=true) @QueryParam(value="remoteId") String remoteId, @Parameter(description="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand) {
        return this.getIdentityByProviderIdAndRemoteId(uriInfo, request, providerId, remoteId, expand);
    }

    @Override
    @GET
    @Path(value="{providerId}/{remoteId}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Gets an identity by id", method="GET", description="This returns the identity if the authenticated user has permissions to view the object linked to this identity.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    @Produces(value={"application/json"})
    public Response getIdentityByProviderIdAndRemoteId(@Context UriInfo uriInfo, @Context Request request, @Parameter(description="Identity provider id which can be of type 'space' or 'organization' for example", required=true) @PathParam(value="providerId") String providerId, @Parameter(description="Identity id which is the unique name (remote id) of identity", required=true) @PathParam(value="remoteId") String remoteId, @Parameter(description="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand) {
        org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getOrCreateIdentity(providerId, remoteId);
        if (identity == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        Identity authenticatedUserIdentity = ConversationState.getCurrent().getIdentity();
        String authenticatedUser = authenticatedUserIdentity.getUserId();
        long cacheTime = identity.getCacheTime();
        String eTagValue = String.valueOf(Objects.hash(cacheTime, authenticatedUser, expand));
        EntityTag eTag = new EntityTag(eTagValue, true);
        Response.ResponseBuilder builder = request.evaluatePreconditions(eTag);
        if (builder == null) {
            IdentityEntity profileInfo = EntityBuilder.buildEntityIdentity(identity, uriInfo.getPath(), expand);
            builder = Response.ok((Object)profileInfo.getDataEntity(), (String)"application/json");
            builder.tag(eTag);
            builder.lastModified(new Date(cacheTime));
            builder.expires(new Date(cacheTime));
        }
        return builder.build();
    }

    @GET
    @Path(value="{id}/avatar")
    @RolesAllowed(value={"users"})
    @Operation(summary="Gets an identity avatar by id", method="GET", description="Gets an identity avatar by id, This can only be done by the logged in user.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response getIdentityAvatarById(@Context UriInfo uriInfo, @Context Request request, @Parameter(description="Identity id which is a UUID", required=true) @PathParam(value="id") String id) throws IOException {
        Response.ResponseBuilder builder;
        org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getIdentity(id, true);
        if (identity == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        Profile profile = identity.getProfile();
        Long lastUpdated = null;
        if (profile != null) {
            lastUpdated = profile.getAvatarLastUpdated();
        }
        EntityTag eTag = null;
        if (lastUpdated != null) {
            eTag = new EntityTag(Integer.toString(lastUpdated.hashCode()));
        }
        Response.ResponseBuilder responseBuilder = builder = eTag == null ? null : request.evaluatePreconditions(eTag);
        if (builder == null) {
            InputStream stream = this.identityManager.getAvatarInputStream(identity);
            if (stream == null) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            builder = Response.ok((Object)stream, (String)"image/png");
            builder.tag(eTag);
        }
        CacheControl cc = new CacheControl();
        cc.setMaxAge(86400);
        builder.cacheControl(cc);
        return builder.cacheControl(cc).build();
    }

    @GET
    @Path(value="{id}/banner")
    @RolesAllowed(value={"users"})
    @Operation(summary="Gets an identity banner by id", method="GET", description="This can only be done by the logged in user.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response getIdentityBannerById(@Context UriInfo uriInfo, @Context Request request, @Parameter(description="Identity id which is a UUID", required=true) @PathParam(value="id") String id) throws IOException {
        Response.ResponseBuilder builder;
        org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getIdentity(id, true);
        if (identity == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        Profile profile = identity.getProfile();
        Long lastUpdated = null;
        if (profile != null) {
            lastUpdated = profile.getBannerLastUpdated();
        }
        EntityTag eTag = null;
        if (lastUpdated != null) {
            eTag = new EntityTag(Integer.toString(lastUpdated.hashCode()));
        }
        Response.ResponseBuilder responseBuilder = builder = eTag == null ? null : request.evaluatePreconditions(eTag);
        if (builder == null) {
            InputStream stream = this.identityManager.getBannerInputStream(identity);
            if (stream == null) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            builder = Response.ok((Object)stream, (String)"image/png");
            builder.tag(eTag);
        }
        CacheControl cc = new CacheControl();
        cc.setMaxAge(86400);
        builder.cacheControl(cc);
        return builder.cacheControl(cc).build();
    }

    private Profile fillProfileFromEntity(ProfileEntity model, org.exoplatform.social.core.identity.model.Identity identity) {
        Profile profile = identity.getProfile();
        this.setProperty(profile, "firstName", model.getFirstname());
        this.setProperty(profile, "lastName", model.getLastname());
        this.setProperty(profile, "email", model.getEmail());
        this.setProperty(profile, "position", model.getPosition());
        this.setProperty(profile, "gender", model.getGender());
        this.setProperty(profile, "deleted", model.getDeleted());
        return profile;
    }

    private Profile setProperty(Profile profile, String key, Object value) {
        if (value != null) {
            profile.setProperty(key, value);
        }
        return profile;
    }

    @Override
    @GET
    @Path(value="{id}/relationships")
    @RolesAllowed(value={"users"})
    @Operation(summary="Gets relationships of a specific identity", method="GET", description="This returns a list of relationships if the authenticated user can view the object linked to the identity.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response getRelationshipsOfIdentity(@Context UriInfo uriInfo, @Parameter(description="The given identity id", required=true) @PathParam(value="id") String id, @Parameter(description="The other identity id to get the relationship with the given one") @QueryParam(value="with") String with, @Parameter(description="Returning the number of relationships or not") @Schema(defaultValue="false") @QueryParam(value="returnSize") boolean returnSize, @Parameter(description="Offset", required=false) @Schema(defaultValue="0") @QueryParam(value="offset") int offset, @Parameter(description="Limit", required=false) @Schema(defaultValue="20") @QueryParam(value="limit") int limit, @Parameter(description="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand) throws Exception {
        offset = offset > 0 ? offset : RestUtils.getOffset(uriInfo);
        limit = limit > 0 ? limit : RestUtils.getLimit(uriInfo);
        IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        org.exoplatform.social.core.identity.model.Identity identity = identityManager.getIdentity(id, true);
        if (identity == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        RelationshipManager relationshipManager = (RelationshipManager)CommonsUtils.getService(RelationshipManager.class);
        if (with != null && with.length() > 0) {
            org.exoplatform.social.core.identity.model.Identity withUser = identityManager.getIdentity(with, true);
            if (withUser == null) {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            Relationship relationship = relationshipManager.get(identity, withUser);
            if (relationship == null) {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            return EntityBuilder.getResponse(EntityBuilder.buildEntityRelationship(relationship, uriInfo.getPath(), expand, false), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
        }
        List relationships = relationshipManager.getRelationshipsByStatus(identity, Relationship.Type.ALL, offset, limit);
        List<DataEntity> relationshipEntities = EntityBuilder.buildRelationshipEntities(relationships, uriInfo);
        CollectionEntity collectionRelationship = new CollectionEntity(relationshipEntities, "relationships", offset, limit);
        if (returnSize) {
            collectionRelationship.setSize(relationshipManager.getRelationshipsCountByStatus(identity, Relationship.Type.ALL));
        }
        return EntityBuilder.getResponse(collectionRelationship, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @GET
    @Path(value="{id}/commonConnections")
    @RolesAllowed(value={"users"})
    @Operation(summary="Gets common connections with identity", method="GET", description="This returns the common connections between a the authenticated user and a given identity.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response getCommonConnectionsWithIdentity(@Context UriInfo uriInfo, @Parameter(description="The given identity id", required=true) @PathParam(value="id") String id, @Parameter(description="Offset", required=false) @Schema(defaultValue="0") @QueryParam(value="offset") int offset, @Parameter(description="Limit", required=false) @Schema(defaultValue="20") @QueryParam(value="limit") int limit, @Parameter(description="Returning the number of common connections or not") @Schema(defaultValue="false") @QueryParam(value="returnSize") boolean returnSize, @Parameter(description="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand) throws Exception {
        RelationshipManager relationshipManager = (RelationshipManager)CommonsUtils.getService(RelationshipManager.class);
        org.exoplatform.social.core.identity.model.Identity authenticatedUser = ((IdentityManager)CommonsUtils.getService(IdentityManager.class)).getOrCreateIdentity("organization", ConversationState.getCurrent().getIdentity().getUserId());
        List<org.exoplatform.social.core.identity.model.Identity> currentUserConnections = Arrays.asList((org.exoplatform.social.core.identity.model.Identity[])relationshipManager.getConnections(authenticatedUser).load(0, 0));
        org.exoplatform.social.core.identity.model.Identity withIdentity = ((IdentityManager)CommonsUtils.getService(IdentityManager.class)).getIdentity(id, true);
        List<org.exoplatform.social.core.identity.model.Identity> withConnections = Arrays.asList((org.exoplatform.social.core.identity.model.Identity[])relationshipManager.getConnections(withIdentity).load(0, 0));
        List commonConnections = currentUserConnections.stream().filter(withConnections::contains).collect(Collectors.toList());
        ArrayList<DataEntity> identityEntities = new ArrayList<DataEntity>();
        for (org.exoplatform.social.core.identity.model.Identity identity : commonConnections) {
            identityEntities.add(EntityBuilder.buildEntityIdentity(identity, uriInfo.getPath(), expand).getDataEntity());
        }
        CollectionEntity collectionIdentity = new CollectionEntity(identityEntities, "identities", offset, limit);
        if (returnSize) {
            collectionIdentity.setSize(commonConnections.size());
        }
        return EntityBuilder.getResponse(collectionIdentity, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }
}

