/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.rest;

import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.rest.ContainerResponseWriter;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.tools.ByteArrayContainerResponseWriter;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.service.rest.IdentityRestService;
import org.exoplatform.social.service.test.AbstractResourceTest;

public class IdentityRestServiceTest
extends AbstractResourceTest {
    private static PortalContainer container;
    private static IdentityManager identityManager;
    private static String rootId;
    private static String johnId;
    private static final String PROVIDER_ID = "organization";

    @Override
    public void setUp() throws Exception {
        super.setUp();
        container = PortalContainer.getInstance();
        identityManager = (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class);
        this.addResource(IdentityRestService.class, null);
        rootId = identityManager.getOrCreateIdentity(PROVIDER_ID, "root").getId();
        johnId = identityManager.getOrCreateIdentity(PROVIDER_ID, "john").getId();
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        this.removeResource(IdentityRestService.class);
    }

    public void testGetRootId() throws Exception {
        ByteArrayContainerResponseWriter writer = new ByteArrayContainerResponseWriter();
        ContainerResponse response = this.service("GET", "/portal/social/identity/root/id/show.json", "", null, null, (ContainerResponseWriter)writer);
        IdentityRestService.UserId returnedUserId = (IdentityRestService.UserId)response.getEntity();
        IdentityRestServiceTest.assertEquals((int)200, (int)response.getStatus());
        IdentityRestServiceTest.assertEquals((String)"application/json;charset=utf-8", (String)response.getContentType().toString());
        IdentityRestServiceTest.assertEquals((String)rootId, (String)returnedUserId.getId());
    }

    public void testGetJohnId() throws Exception {
        ByteArrayContainerResponseWriter writer = new ByteArrayContainerResponseWriter();
        ContainerResponse response = this.service("GET", "/portal/social/identity/john/id/show.json", "", null, null, (ContainerResponseWriter)writer);
        IdentityRestService.UserId returnedUserId = (IdentityRestService.UserId)response.getEntity();
        IdentityRestServiceTest.assertEquals((int)200, (int)response.getStatus());
        IdentityRestServiceTest.assertEquals((String)"application/json;charset=utf-8", (String)response.getContentType().toString());
        IdentityRestServiceTest.assertEquals((String)johnId, (String)returnedUserId.getId());
    }
}

