/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.api;

import io.meeds.social.translation.service.TranslationService;
import jakarta.servlet.http.HttpServletRequest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.exoplatform.commons.api.notification.model.UserSetting;
import org.exoplatform.commons.api.notification.service.setting.UserSettingService;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.application.localization.LocalizationFilter;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.Visibility;
import org.exoplatform.portal.mop.rest.model.UserNodeRestEntity;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserNodeFilterConfig;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.services.rest.ApplicationContext;
import org.exoplatform.services.rest.impl.ApplicationContextImpl;
import org.exoplatform.services.rest.impl.provider.JsonEntityProvider;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.common.RealtimeListAccess;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.binding.model.GroupSpaceBinding;
import org.exoplatform.social.core.binding.model.GroupSpaceBindingOperationReport;
import org.exoplatform.social.core.binding.spi.GroupSpaceBindingService;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.processor.I18NActivityProcessor;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.profilelabel.ProfileLabelService;
import org.exoplatform.social.core.profileproperty.ProfilePropertyService;
import org.exoplatform.social.core.profileproperty.model.ProfilePropertySetting;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.utils.MentionUtils;
import org.exoplatform.social.metadata.favorite.FavoriteService;
import org.exoplatform.social.metadata.favorite.model.Favorite;
import org.exoplatform.social.notification.service.SpaceWebNotificationService;
import org.exoplatform.social.rest.api.RestUtils;
import org.exoplatform.social.rest.entity.ActivityEntity;
import org.exoplatform.social.rest.entity.BaseEntity;
import org.exoplatform.social.rest.entity.CollectionEntity;
import org.exoplatform.social.rest.entity.CommentEntity;
import org.exoplatform.social.rest.entity.DataEntity;
import org.exoplatform.social.rest.entity.ExperienceEntity;
import org.exoplatform.social.rest.entity.GroupNodeEntity;
import org.exoplatform.social.rest.entity.GroupSpaceBindingEntity;
import org.exoplatform.social.rest.entity.GroupSpaceBindingOperationReportEntity;
import org.exoplatform.social.rest.entity.IMEntity;
import org.exoplatform.social.rest.entity.IdentityEntity;
import org.exoplatform.social.rest.entity.LinkEntity;
import org.exoplatform.social.rest.entity.MetadataItemEntity;
import org.exoplatform.social.rest.entity.PhoneEntity;
import org.exoplatform.social.rest.entity.ProfileEntity;
import org.exoplatform.social.rest.entity.ProfilePropertySettingEntity;
import org.exoplatform.social.rest.entity.RelationshipEntity;
import org.exoplatform.social.rest.entity.SiteEntity;
import org.exoplatform.social.rest.entity.SpaceEntity;
import org.exoplatform.social.rest.entity.SpaceMembershipEntity;
import org.exoplatform.social.rest.entity.URLEntity;
import org.exoplatform.social.rest.impl.spacemembership.SpaceMembershipRest;
import org.exoplatform.social.service.rest.Util;
import org.exoplatform.ws.frameworks.json.JsonHandler;
import org.exoplatform.ws.frameworks.json.impl.JsonDefaultHandler;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.exoplatform.ws.frameworks.json.impl.JsonParserImpl;
import org.exoplatform.ws.frameworks.json.impl.ObjectBuilder;
import org.exoplatform.ws.frameworks.json.value.JsonValue;

public class EntityBuilder {
    private static final int DEFAULT_LIKERS_LIMIT = 4;
    private static final Log LOG = ExoLogger.getLogger(EntityBuilder.class);
    public static final String GROUP_SPACE_BINDING_REPORT_OPERATIONS_TYPE = "groupSpaceBindingReportOperations";
    public static final String USERS_TYPE = "users";
    public static final String USERS_RELATIONSHIP_TYPE = "usersRelationships";
    public static final String USER_ACTIVITY_TYPE = "user";
    public static final String IDENTITIES_TYPE = "identities";
    public static final String SPACES_TYPE = "spaces";
    public static final String CREATED_DATE = "createdDate";
    public static final String SPACES_MEMBERSHIP_TYPE = "spacesMemberships";
    public static final String SPACE_ACTIVITY_TYPE = "space";
    public static final String ACTIVITIES_TYPE = "activities";
    public static final String ACTIVITY_IDS_TYPE = "activityIds";
    public static final String COMMENTS_TYPE = "comments";
    public static final String COMMENTS_PREVIEW_TYPE = "commentsPreview";
    public static final int COMMENTS_PREVIEW_LIMIT = 2;
    public static final String LIKES_TYPE = "likes";
    public static final String LIKES_COUNT_TYPE = "likesCount";
    public static final String COMMENTS_COUNT_TYPE = "commentsCount";
    public static final String KEY = "key";
    public static final String VALUE = "value";
    private static final String NEXT_ACTION = "next";
    private static final String PREV_ACTION = "prev";
    private static final String FIRST_ACTION = "first";
    private static final String LAST_ACTION = "last";
    private static final String LINK = "Link";
    public static final String GROUP_SPACE_BINDING_TYPE = "groupSpaceBindings";
    public static final String ORGANIZATION_GROUP_TYPE = "childGroups";
    public static final String MANAGER = "manager";
    public static final String REDACTOR_MEMBERSHIP = "redactor";
    public static final String PUBLISHER_MEMBERSHIP = "publisher";
    public static final CacheControl NO_CACHE_CC = new CacheControl();
    public static final String GROUP = "group";
    private static final JsonEntityProvider JSON_ENTITY_PROVIDER = new JsonEntityProvider();
    public static final String SETTINGS = "settings";
    public static final String USER_CARD_SETTINGS = "UserCardSettings";
    private static UserPortalConfigService userPortalConfigService;
    private static LayoutService layoutService;
    private static SettingService settingService;
    private static UserACL userACL;
    private static ProfilePropertyService profilePropertyService;
    private static SpaceService spaceService;
    private static OrganizationService organizationService;
    private static RelationshipManager relationshipManager;
    private static IdentityManager identityManager;
    private static ActivityManager activityManager;
    private static TranslationService translationService;

    private EntityBuilder() {
    }

    public static IdentityEntity buildEntityIdentity(org.exoplatform.social.core.identity.model.Identity identity, String restPath, String expand) {
        IdentityEntity identityEntity = new IdentityEntity(identity.getId());
        identityEntity.setHref(RestUtils.getRestUrl(IDENTITIES_TYPE, identity.getId(), restPath));
        identityEntity.setProviderId(identity.getProviderId());
        identityEntity.setGlobalId(identity.getGlobalId());
        identityEntity.setRemoteId(identity.getRemoteId());
        identityEntity.setDeleted(identity.isDeleted());
        if (SPACE_ACTIVITY_TYPE.equals(identity.getProviderId())) {
            Space space = EntityBuilder.getSpaceService().getSpaceByPrettyName(identity.getRemoteId());
            identityEntity.setSpace(EntityBuilder.buildEntityFromSpace(space, EntityBuilder.getCurrentUserName(), restPath, expand));
        } else {
            identityEntity.setProfile(EntityBuilder.buildEntityProfile(identity.getProfile(), restPath, expand));
        }
        EntityBuilder.updateCachedEtagValue(EntityBuilder.getEtagValue(identity.getId()));
        return identityEntity;
    }

    public static IdentityEntity buildEntityIdentity(String userName, String restPath, String expand) {
        IdentityManager identityManager = EntityBuilder.getIdentityManager();
        org.exoplatform.social.core.identity.model.Identity userIdentity = identityManager.getOrCreateIdentity("organization", userName);
        return EntityBuilder.buildEntityIdentity(userIdentity, restPath, expand);
    }

    public static ProfileEntity buildEntityProfile(Space space, Profile profile, String path, String expand) {
        List<Object> expandAttributes;
        ProfileEntity entity = EntityBuilder.buildEntityProfile(profile, path, expand);
        String userId = profile.getIdentity().getRemoteId();
        entity.setIsManager(EntityBuilder.getSpaceService().isManager(space, userId));
        entity.setIsSpaceRedactor(EntityBuilder.getSpaceService().isRedactor(space, userId));
        entity.setIsSpacePublisher(EntityBuilder.getSpaceService().isPublisher(space, userId));
        entity.setIsMember(EntityBuilder.getSpaceService().isMember(space, userId));
        entity.setIsInvited(EntityBuilder.getSpaceService().isInvitedUser(space, userId));
        entity.setIsPending(EntityBuilder.getSpaceService().isPendingUser(space, userId));
        String[] expandArray = StringUtils.split((String)expand, (String)",");
        List<Object> list = expandAttributes = expandArray == null ? Collections.emptyList() : Arrays.asList(expandArray);
        if (expandAttributes.contains("binding") || expandAttributes.contains("all")) {
            GroupSpaceBindingService spaceBindingService = (GroupSpaceBindingService)CommonsUtils.getService(GroupSpaceBindingService.class);
            entity.setIsGroupBound(spaceBindingService.countUserBindings(space.getId(), userId) > 0L);
        }
        return entity;
    }

    public static ProfileEntity buildEntityProfile(Profile profile, String expand) {
        return EntityBuilder.buildEntityProfile(profile, null, expand);
    }

    public static ProfileEntity buildEntityProfile(Profile profile, String restPath, String expand) {
        ProfilePropertySetting propertySetting;
        String propertyName;
        org.exoplatform.social.core.identity.model.Identity currentUserIdentity;
        String currentUser;
        ConversationState conversationState;
        String[] expandArray;
        List<Object> expandAttributes;
        boolean canViewProperties;
        ProfileEntity userEntity = new ProfileEntity(profile.getId());
        userEntity.setHref(RestUtils.getRestUrl(USERS_TYPE, profile.getIdentity().getRemoteId(), restPath));
        userEntity.setIdentity(RestUtils.getRestUrl(IDENTITIES_TYPE, profile.getIdentity().getId(), restPath));
        userEntity.setUsername(profile.getIdentity().getRemoteId());
        userEntity.getDataEntity().put("userName", profile.getIdentity().getRemoteId());
        boolean isAdmin = EntityBuilder.getUserACL().isAdministrator(EntityBuilder.getCurrentUserIdentity());
        boolean isCurrentUser = StringUtils.equals((CharSequence)EntityBuilder.getCurrentUserName(), (CharSequence)profile.getIdentity().getRemoteId());
        boolean bl = canViewProperties = isAdmin || isCurrentUser;
        if (canViewProperties || EntityBuilder.isProfilePropertyVisible("firstName")) {
            userEntity.setFirstname((String)profile.getProperty("firstName"));
        }
        if (canViewProperties || EntityBuilder.isProfilePropertyVisible("lastName")) {
            userEntity.setLastname((String)profile.getProperty("lastName"));
        }
        if (canViewProperties || EntityBuilder.isProfilePropertyVisible("fullName")) {
            userEntity.setFullname(profile.getFullName());
        }
        if (canViewProperties || EntityBuilder.isProfilePropertyVisible("position")) {
            userEntity.setPosition(profile.getPosition());
        }
        if (canViewProperties || EntityBuilder.isProfilePropertyVisible("email")) {
            userEntity.setEmail(profile.getEmail());
        }
        userEntity.setAboutMe((String)profile.getProperty("aboutMe"));
        userEntity.setAvatar(profile.getAvatarUrl());
        userEntity.setBanner(profile.getBannerUrl());
        userEntity.setDefaultAvatar(profile.isDefaultAvatar());
        userEntity.setIsAdmin(isAdmin);
        if (isAdmin) {
            if (profile.getProperty("enrollmentDate") != null) {
                userEntity.setEnrollmentDate(profile.getProperty("enrollmentDate").toString());
            }
            if (profile.getProperty("synchronizedDate") != null) {
                userEntity.setSynchronizedDate((String)profile.getProperty("synchronizedDate"));
            }
            try {
                OrganizationService organizationService = EntityBuilder.getOrganizationService();
                User user = organizationService.getUserHandler().findUserByName(userEntity.getUsername(), UserStatus.ANY);
                if (user != null) {
                    userEntity.setIsInternal(user.isInternalStore());
                    if (user.getCreatedDate() != null) {
                        userEntity.setCreatedDate(String.valueOf(user.getCreatedDate().getTime()));
                    }
                    if (user.getLastLoginTime() != null && !user.getCreatedDate().equals(user.getLastLoginTime())) {
                        userEntity.setLastLoginTime(String.valueOf(user.getLastLoginTime().getTime()));
                    }
                }
            }
            catch (Exception e) {
                LOG.warn("Error when searching user {}", new Object[]{userEntity.getUsername(), e});
            }
        }
        if (canViewProperties || EntityBuilder.isProfilePropertyVisible("phones")) {
            EntityBuilder.buildPhoneEntities(profile, userEntity, canViewProperties);
        }
        if (canViewProperties || EntityBuilder.isProfilePropertyVisible("ims")) {
            EntityBuilder.buildImEntities(profile, userEntity, canViewProperties);
        }
        if (canViewProperties || EntityBuilder.isProfilePropertyVisible("urls")) {
            EntityBuilder.buildUrlEntities(profile, userEntity);
        }
        EntityBuilder.buildExperienceEntities(profile, userEntity);
        userEntity.setDeleted(profile.getIdentity().isDeleted());
        userEntity.setEnabled(profile.getIdentity().isEnable());
        if (profile.getProperty("external") != null) {
            userEntity.setIsExternal((String)profile.getProperty("external"));
        } else {
            userEntity.setIsExternal("false");
        }
        if (canViewProperties || EntityBuilder.isProfilePropertyVisible("company")) {
            userEntity.setCompany((String)profile.getProperty("company"));
        }
        if (canViewProperties || EntityBuilder.isProfilePropertyVisible("location")) {
            userEntity.setLocation((String)profile.getProperty("location"));
        }
        if (canViewProperties || EntityBuilder.isProfilePropertyVisible("department")) {
            userEntity.setDepartment((String)profile.getProperty("department"));
        }
        if (canViewProperties || EntityBuilder.isProfilePropertyVisible("team")) {
            userEntity.setTeam((String)profile.getProperty("team"));
        }
        if (canViewProperties || EntityBuilder.isProfilePropertyVisible("profession")) {
            userEntity.setProfession((String)profile.getProperty("profession"));
        }
        if (canViewProperties || EntityBuilder.isProfilePropertyVisible("country")) {
            userEntity.setCountry((String)profile.getProperty("country"));
        }
        if (canViewProperties || EntityBuilder.isProfilePropertyVisible("city")) {
            userEntity.setCity((String)profile.getProperty("city"));
        }
        List<Object> list = expandAttributes = (expandArray = StringUtils.split((String)expand, (String)",")) == null ? Collections.emptyList() : Arrays.asList(expandArray);
        if (expandAttributes.contains("connectionsCount")) {
            ListAccess connections = EntityBuilder.getRelationshipManager().getConnections(profile.getIdentity());
            try {
                userEntity.setConnectionsCount(String.valueOf(connections.getSize()));
            }
            catch (Exception e) {
                LOG.warn((Object)"Error while getting connections count of user", (Throwable)e);
            }
        }
        if (expandAttributes.contains("spacesCount")) {
            ListAccess spaces = EntityBuilder.getSpaceService().getMemberSpaces(profile.getIdentity().getRemoteId());
            try {
                userEntity.setSpacesCount(String.valueOf(spaces.getSize()));
            }
            catch (Exception e) {
                LOG.warn((Object)"Error while getting spaces count of user", (Throwable)e);
            }
        }
        if (expandAttributes.contains("connectionsInCommonCount") && (conversationState = ConversationState.getCurrent()) != null) {
            currentUser = conversationState.getIdentity().getUserId();
            if (!StringUtils.equals((CharSequence)profile.getIdentity().getRemoteId(), (CharSequence)currentUser)) {
                currentUserIdentity = EntityBuilder.getIdentityManager().getOrCreateIdentity("organization", currentUser);
                try {
                    userEntity.setConnectionsInCommonCount(String.valueOf(EntityBuilder.getRelationshipManager().getConnectionsInCommonCount(currentUserIdentity, profile.getIdentity())));
                }
                catch (Exception e) {
                    LOG.warn((Object)"Error while getting spaces count of user", (Throwable)e);
                }
            }
        }
        if (expandAttributes.contains("relationshipStatus") && (conversationState = ConversationState.getCurrent()) != null) {
            currentUser = conversationState.getIdentity().getUserId();
            currentUserIdentity = EntityBuilder.getIdentityManager().getOrCreateIdentity("organization", currentUser);
            try {
                Relationship relationship = EntityBuilder.getRelationshipManager().get(currentUserIdentity, profile.getIdentity());
                if (relationship != null) {
                    Relationship.Type status = relationship.getStatus();
                    if (status == Relationship.Type.PENDING) {
                        Relationship.Type relationshipStatus = StringUtils.equals((CharSequence)relationship.getSender().getRemoteId(), (CharSequence)currentUser) ? Relationship.Type.OUTGOING : Relationship.Type.INCOMING;
                        userEntity.setRelationshipStatus(relationshipStatus.name());
                    } else {
                        userEntity.setRelationshipStatus(relationship.getStatus().name());
                    }
                }
            }
            catch (Exception e) {
                LOG.warn((Object)"Error while getting spaces count of user", (Throwable)e);
            }
        }
        if (expandAttributes.contains(SETTINGS)) {
            userEntity.setProperties(EntityBuilder.buildProperties(profile, canViewProperties));
        }
        if (expandAttributes.contains(MANAGER) && profile.getProperty(MANAGER) != null) {
            EntityBuilder.buildListManagers(userEntity, profile, restPath);
        }
        if (expandAttributes.contains("managedUsersCount")) {
            EntityBuilder.buildManagedUsersCount(userEntity);
        }
        SettingValue userCardFirstFieldSetting = EntityBuilder.getSettingService().get(Context.GLOBAL, new Scope(Scope.GLOBAL.getName(), USER_CARD_SETTINGS), "UserCardFirstFieldSetting");
        SettingValue userCardSecondFieldSetting = EntityBuilder.getSettingService().get(Context.GLOBAL, new Scope(Scope.GLOBAL.getName(), USER_CARD_SETTINGS), "UserCardSecondFieldSetting");
        SettingValue userCardThirdFieldSetting = EntityBuilder.getSettingService().get(Context.GLOBAL, new Scope(Scope.GLOBAL.getName(), USER_CARD_SETTINGS), "UserCardThirdFieldSetting");
        if (userCardFirstFieldSetting != null) {
            propertyName = String.valueOf(userCardFirstFieldSetting.getValue());
            propertySetting = EntityBuilder.getProfilePropertyService().getProfileSettingByName(propertyName);
            if (propertySetting != null && propertySetting.isVisible() && !EntityBuilder.getProfilePropertyService().getHiddenProfilePropertyIds(Long.parseLong(userEntity.getId())).contains(propertySetting.getId())) {
                userEntity.setPrimaryProperty((String)profile.getProperty(propertyName));
            } else {
                userEntity.setPrimaryProperty("");
            }
        } else if (StringUtils.isNotBlank((CharSequence)userEntity.getPosition())) {
            userEntity.setPrimaryProperty(userEntity.getPosition());
        } else {
            userEntity.setPrimaryProperty("");
        }
        if (userCardSecondFieldSetting != null) {
            propertyName = String.valueOf(userCardSecondFieldSetting.getValue());
            propertySetting = EntityBuilder.getProfilePropertyService().getProfileSettingByName(propertyName);
            if (propertySetting != null && propertySetting.isVisible() && !EntityBuilder.getProfilePropertyService().getHiddenProfilePropertyIds(Long.parseLong(userEntity.getId())).contains(propertySetting.getId())) {
                userEntity.setSecondaryProperty((String)profile.getProperty(propertyName));
            } else {
                userEntity.setSecondaryProperty("");
            }
        } else if (StringUtils.isNotBlank((CharSequence)userEntity.getTeam())) {
            userEntity.setSecondaryProperty(userEntity.getTeam());
        } else {
            userEntity.setSecondaryProperty("");
        }
        if (userCardThirdFieldSetting != null) {
            propertyName = String.valueOf(userCardThirdFieldSetting.getValue());
            propertySetting = EntityBuilder.getProfilePropertyService().getProfileSettingByName(propertyName);
            if (propertySetting != null && propertySetting.isVisible() && !EntityBuilder.getProfilePropertyService().getHiddenProfilePropertyIds(Long.parseLong(userEntity.getId())).contains(propertySetting.getId())) {
                userEntity.setTertiaryProperty((String)profile.getProperty(propertyName));
            } else {
                userEntity.setTertiaryProperty("");
            }
        } else if (StringUtils.isNotBlank((CharSequence)userEntity.getCity())) {
            userEntity.setTertiaryProperty(userEntity.getCity());
        } else {
            userEntity.setTertiaryProperty("");
        }
        return userEntity;
    }

    private static void buildManagedUsersCount(ProfileEntity userEntity) {
        ProfileFilter filter = new ProfileFilter();
        filter.setEnabled(true);
        filter.setUserType("internal");
        filter.setProfileSettings(Map.of(MANAGER, userEntity.getUsername()));
        ListAccess managedUsers = EntityBuilder.getIdentityManager().getIdentitiesByProfileFilter("organization", filter, true);
        try {
            userEntity.setManagedUsersCount(managedUsers.getSize());
        }
        catch (Exception e) {
            LOG.error("Error while building managed users count for user: {}", new Object[]{userEntity.getUsername(), e});
        }
    }

    private static void buildListManagers(ProfileEntity userEntity, Profile profile, String restPath) {
        ArrayList userNames = new ArrayList();
        if (profile.getProperty(MANAGER) instanceof List) {
            userNames = (ArrayList)profile.getProperty(MANAGER);
        } else {
            HashMap<String, String> value = new HashMap<String, String>();
            value.put(VALUE, (String)profile.getProperty(MANAGER));
            userNames.add(value);
        }
        ArrayList<DataEntity> managers = new ArrayList<DataEntity>();
        userNames.forEach(property -> {
            org.exoplatform.social.core.identity.model.Identity identity = EntityBuilder.getIdentityManager().getOrCreateIdentity("organization", (String)property.get(VALUE));
            if (identity != null) {
                ProfileEntity manager = EntityBuilder.buildEntityProfile(identity.getProfile(), restPath, SETTINGS);
                EntityBuilder.buildManagedUsersCount(manager);
                managers.add(manager.getDataEntity());
            }
        });
        userEntity.setManagers(managers);
    }

    private static ProfilePropertyService getProfilePropertyService() {
        if (profilePropertyService == null) {
            profilePropertyService = (ProfilePropertyService)CommonsUtils.getService(ProfilePropertyService.class);
        }
        return profilePropertyService;
    }

    public static List<ProfilePropertySettingEntity> buildProperties(Profile profile, boolean canViewProperties) {
        ProfilePropertySettingEntity profilePropertySettingEntity;
        ProfilePropertyService profilePropertyService = EntityBuilder.getProfilePropertyService();
        List hiddenProfileProperties = profilePropertyService.getHiddenProfilePropertyIds(Long.parseLong(profile.getIdentity().getId()));
        HashMap<Long, ProfilePropertySettingEntity> properties = new HashMap<Long, ProfilePropertySettingEntity>();
        List<ProfilePropertySetting> settings = profilePropertyService.getPropertySettings().stream().filter(prop -> prop.isVisible() || prop.isEditable() && canViewProperties).toList();
        ArrayList<ProfilePropertySetting> subProperties = new ArrayList<ProfilePropertySetting>();
        ArrayList<Long> parents = new ArrayList<Long>();
        boolean internal = false;
        try {
            OrganizationService organizationService = EntityBuilder.getOrganizationService();
            User user = organizationService.getUserHandler().findUserByName(profile.getIdentity().getRemoteId(), UserStatus.ANY);
            if (user != null) {
                internal = user.isInternalStore();
            }
        }
        catch (Exception e) {
            LOG.warn("Error when getting user {}", new Object[]{profile.getIdentity().getRemoteId(), e});
        }
        for (ProfilePropertySetting property : settings) {
            if (property.getParentId() != null && property.getParentId() != 0L) {
                subProperties.add(property);
                continue;
            }
            profilePropertySettingEntity = EntityBuilder.buildEntityProfilePropertySetting(property, profilePropertyService, "profileProperty");
            boolean isHidden = hiddenProfileProperties.contains(profilePropertySettingEntity.getId());
            if (isHidden && !canViewProperties) continue;
            profilePropertySettingEntity.setHidden(isHidden);
            if (profile.getProperty(property.getPropertyName()) != null) {
                Object object = profile.getProperty(property.getPropertyName());
                if (object instanceof String) {
                    String propertyValue = (String)object;
                    if (StringUtils.isNotEmpty((CharSequence)propertyValue)) {
                        if (!profilePropertySettingEntity.isMultiValued()) {
                            profilePropertySettingEntity.setValue(propertyValue);
                        } else {
                            String[] childrenValues;
                            ArrayList<ProfilePropertySettingEntity> children = new ArrayList<ProfilePropertySettingEntity>();
                            for (String value : childrenValues = StringUtils.split((String)propertyValue, (char)',')) {
                                ProfilePropertySettingEntity subProfilePropertySettingEntity = new ProfilePropertySettingEntity();
                                subProfilePropertySettingEntity.setValue(value);
                                children.add(subProfilePropertySettingEntity);
                            }
                            profilePropertySettingEntity.setChildren(children);
                        }
                    }
                } else {
                    List multiValues = (List)profile.getProperty(property.getPropertyName());
                    if (!multiValues.isEmpty()) {
                        ArrayList<ProfilePropertySettingEntity> children = new ArrayList<ProfilePropertySettingEntity>();
                        for (Map subProperty : multiValues) {
                            if (!StringUtils.isNotEmpty((CharSequence)((CharSequence)subProperty.get(VALUE)))) continue;
                            ProfilePropertySettingEntity subProfilePropertySettingEntity = new ProfilePropertySettingEntity();
                            if (StringUtils.isNotEmpty((CharSequence)((CharSequence)subProperty.get(KEY)))) {
                                ProfilePropertySetting propertySetting = profilePropertyService.getProfileSettingByName(property.getPropertyName() + "." + (String)subProperty.get(KEY));
                                if (propertySetting == null) {
                                    propertySetting = profilePropertyService.getProfileSettingByName((String)subProperty.get(KEY));
                                }
                                if (propertySetting != null) {
                                    subProfilePropertySettingEntity = EntityBuilder.buildEntityProfilePropertySetting(propertySetting, profilePropertyService, "profileProperty");
                                    isHidden = hiddenProfileProperties.contains(profilePropertySettingEntity.getId());
                                    if (isHidden && !canViewProperties) continue;
                                    subProfilePropertySettingEntity.setHidden(hiddenProfileProperties.contains(subProfilePropertySettingEntity.getId()));
                                } else {
                                    subProfilePropertySettingEntity.setPropertyName((String)subProperty.get(KEY));
                                }
                            }
                            subProfilePropertySettingEntity.setValue((String)subProperty.get(VALUE));
                            children.add(subProfilePropertySettingEntity);
                        }
                        profilePropertySettingEntity.setChildren(children);
                        parents.add(profilePropertySettingEntity.getId());
                    }
                }
            }
            profilePropertySettingEntity.setInternal(internal);
            properties.put(profilePropertySettingEntity.getId(), profilePropertySettingEntity);
        }
        for (ProfilePropertySetting property : subProperties) {
            List<ProfilePropertySettingEntity> children;
            if (!parents.contains(property.getParentId())) {
                profilePropertySettingEntity = EntityBuilder.buildEntityProfilePropertySetting(property, profilePropertyService, "profileProperty");
                profilePropertySettingEntity.setValue((String)profile.getProperty(property.getPropertyName()));
                profilePropertySettingEntity.setInternal(internal);
                ProfilePropertySettingEntity parentProperty = (ProfilePropertySettingEntity)properties.get(property.getParentId());
                if (parentProperty == null || (children = parentProperty.getChildren()) == null) continue;
                children.add(profilePropertySettingEntity);
                parentProperty.setChildren(children);
                properties.put(parentProperty.getId(), parentProperty);
                continue;
            }
            ProfilePropertySettingEntity parent = (ProfilePropertySettingEntity)properties.get(property.getParentId());
            ProfilePropertySettingEntity profilePropertySettingEntity2 = parent.getChildren().stream().filter(child -> property.getPropertyName().equals(child.getPropertyName())).findAny().orElse(null);
            if (profilePropertySettingEntity2 != null || parent == null) continue;
            profilePropertySettingEntity2 = EntityBuilder.buildEntityProfilePropertySetting(property, profilePropertyService, "profileProperty");
            profilePropertySettingEntity2.setValue((String)profile.getProperty(property.getPropertyName()));
            profilePropertySettingEntity2.setInternal(internal);
            children = parent.getChildren();
            children.add(profilePropertySettingEntity2);
            parent.setChildren(children);
            properties.put(parent.getId(), parent);
        }
        return new ArrayList<ProfilePropertySettingEntity>(properties.values());
    }

    public static void buildPhoneEntities(Profile profile, ProfileEntity userEntity, boolean canViewProperties) {
        List phones = profile.getPhones();
        if (phones != null && !phones.isEmpty()) {
            ArrayList<PhoneEntity> phoneEntities = new ArrayList<PhoneEntity>();
            for (Map phone : phones) {
                String phoneType = (String)phone.get(KEY);
                if (!canViewProperties && !EntityBuilder.isProfilePropertyVisible(phoneType)) continue;
                phoneEntities.add(new PhoneEntity(phoneType, (String)phone.get(VALUE)));
            }
            userEntity.setPhones(phoneEntities);
        }
    }

    public static void buildImEntities(Profile profile, ProfileEntity userEntity, boolean canViewProperties) {
        List ims = (List)profile.getProperty("ims");
        if (ims != null && !ims.isEmpty()) {
            ArrayList<IMEntity> imEntities = new ArrayList<IMEntity>();
            for (Map im : ims) {
                String imType = (String)im.get(KEY);
                if (!canViewProperties && !EntityBuilder.isProfilePropertyVisible(imType)) continue;
                imEntities.add(new IMEntity(imType, (String)im.get(VALUE)));
            }
            userEntity.setIms(imEntities);
        }
    }

    public static void buildUrlEntities(Profile profile, ProfileEntity userEntity) {
        List urls = (List)profile.getProperty("urls");
        if (urls != null && !urls.isEmpty()) {
            ArrayList<URLEntity> urlEntities = new ArrayList<URLEntity>();
            for (Map url : urls) {
                urlEntities.add(new URLEntity((String)url.get(VALUE)));
            }
            userEntity.setUrls(urlEntities);
        }
    }

    public static void buildExperienceEntities(Profile profile, ProfileEntity userEntity) {
        List experiences = (List)profile.getProperty("experiences");
        if (experiences != null && !experiences.isEmpty()) {
            ArrayList<ExperienceEntity> experienceEntities = new ArrayList<ExperienceEntity>();
            for (Map experience : experiences) {
                String id = (String)experience.get("id");
                String company = (String)experience.get("company");
                String description = (String)experience.get("description");
                String position = (String)experience.get("position");
                String skills = (String)experience.get("skills");
                Boolean isCurrent = (Boolean)experience.get("isCurrent");
                String startDate = (String)experience.get("startDate");
                String endDate = (String)experience.get("endDate");
                if ((isCurrent == null || !isCurrent.booleanValue()) && StringUtils.isBlank((CharSequence)endDate)) {
                    isCurrent = true;
                }
                experienceEntities.add(new ExperienceEntity(id, company, description, position, skills, isCurrent, startDate, endDate));
            }
            userEntity.setExperiences(experienceEntities);
        }
    }

    public static ProfileEntity buildEntityProfile(String userName, String restPath, String expand) {
        IdentityManager identityManager = EntityBuilder.getIdentityManager();
        org.exoplatform.social.core.identity.model.Identity userIdentity = identityManager.getOrCreateIdentity("organization", userName);
        return EntityBuilder.buildEntityProfile(userIdentity.getProfile(), restPath, expand);
    }

    public static List<DataEntity> buildEntityProfiles(String[] userNames, String restPath, String expand) {
        if (userNames == null || userNames.length == 0) {
            return new ArrayList<DataEntity>();
        }
        ArrayList<DataEntity> userEntities = new ArrayList<DataEntity>();
        for (int i = 0; i < userNames.length; ++i) {
            userEntities.add(EntityBuilder.buildEntityProfile(userNames[i], restPath, expand).getDataEntity());
        }
        return userEntities;
    }

    public static CollectionEntity buildEntityFromSpaces(List<Space> spaces, String username, int offset, int limit, String expand, UriInfo uriInfo) {
        Map<Long, Long> unreadItemsPerSpace = EntityBuilder.buildSpacesUnread(username, expand);
        List<DataEntity> spaceInfos = spaces.stream().map(space -> {
            SpaceEntity spaceInfo = EntityBuilder.buildEntityFromSpace(space, username, uriInfo.getPath(), expand);
            DataEntity dataEntity = spaceInfo.getDataEntity();
            if (unreadItemsPerSpace.containsKey(space.getSpaceId())) {
                dataEntity.put("unread", unreadItemsPerSpace.get(space.getSpaceId()));
            }
            return dataEntity;
        }).toList();
        CollectionEntity collectionSpace = new CollectionEntity(spaceInfos, SPACES_TYPE, offset, limit);
        if (MapUtils.isNotEmpty(unreadItemsPerSpace)) {
            collectionSpace.setUnreadPerSpace(unreadItemsPerSpace.entrySet().stream().collect(Collectors.toMap(e -> ((Long)e.getKey()).toString(), Map.Entry::getValue)));
        }
        return collectionSpace;
    }

    public static SpaceEntity buildEntityFromSpace(Space space, String userId, String restPath, String expand) {
        SpaceEntity spaceEntity = new SpaceEntity(space.getId());
        SpaceService spaceService = EntityBuilder.getSpaceService();
        boolean canEdit = spaceService.canManageSpace(space, userId);
        if (StringUtils.isNotBlank((CharSequence)userId)) {
            IdentityManager identityManager = EntityBuilder.getIdentityManager();
            GroupSpaceBindingService groupSpaceBindingService = (GroupSpaceBindingService)CommonsUtils.getService(GroupSpaceBindingService.class);
            if (spaceService.canViewSpace(space, userId)) {
                spaceEntity.setHref(RestUtils.getRestUrl(SPACES_TYPE, space.getId(), restPath));
                org.exoplatform.social.core.identity.model.Identity spaceIdentity = identityManager.getOrCreateIdentity(SPACE_ACTIVITY_TYPE, space.getPrettyName());
                List<Object> expandFields = StringUtils.isBlank((CharSequence)expand) ? Collections.emptyList() : Arrays.asList(expand.split(","));
                LinkEntity identity = expandFields.contains("identity") ? new LinkEntity(EntityBuilder.buildEntityIdentity(spaceIdentity, restPath, null)) : new LinkEntity(RestUtils.getRestUrl(IDENTITIES_TYPE, spaceIdentity.getId(), restPath));
                spaceEntity.setIdentity(identity);
                spaceEntity.setIdentityId(spaceIdentity.getId());
                if (expandFields.contains("groupBinding") && spaceService.canViewSpace(space, userId)) {
                    spaceEntity.setTotalBoundUsers(groupSpaceBindingService.countBoundUsers(space.getId()));
                    boolean hasBindings = groupSpaceBindingService.isBoundSpace(space.getId());
                    spaceEntity.setHasBindings(hasBindings);
                    if (hasBindings) {
                        spaceEntity.setIsUserBound(groupSpaceBindingService.countUserBindings(space.getId(), userId) > 0L);
                    }
                }
                LinkEntity managers = expandFields.contains("managers") ? new LinkEntity(EntityBuilder.buildEntityProfiles(space.getManagers(), restPath, expand)) : new LinkEntity(Util.getMembersSpaceRestUrl(space.getId(), MANAGER, restPath));
                spaceEntity.setManagers(managers);
                LinkEntity redactors = expandFields.contains("redactors") ? new LinkEntity(EntityBuilder.buildEntityProfiles(space.getRedactors(), restPath, expand)) : new LinkEntity(Util.getMembersSpaceRestUrl(space.getId(), REDACTOR_MEMBERSHIP, restPath));
                spaceEntity.setRedactors(redactors);
                LinkEntity publishers = expandFields.contains("publishers") ? new LinkEntity(EntityBuilder.buildEntityProfiles(space.getPublishers(), restPath, expand)) : new LinkEntity(Util.getMembersSpaceRestUrl(space.getId(), PUBLISHER_MEMBERSHIP, restPath));
                spaceEntity.setPublishers(publishers);
                LinkEntity members = expandFields.contains("members") ? new LinkEntity(EntityBuilder.buildEntityProfiles(space.getMembers(), restPath, expand)) : new LinkEntity(Util.getMembersSpaceRestUrl(space.getId(), null, restPath));
                spaceEntity.setMembers(members);
                if ("membersCount".equals(expand)) {
                    spaceEntity.setMembersCount(space.getMembers().length);
                }
                if (expandFields.contains("pending")) {
                    LinkEntity pending = new LinkEntity(EntityBuilder.buildEntityProfiles(space.getPendingUsers(), restPath, expand));
                    spaceEntity.setPending(pending);
                }
                if (expandFields.contains("favorite")) {
                    org.exoplatform.social.core.identity.model.Identity userIdentity = identityManager.getOrCreateUserIdentity(userId);
                    FavoriteService favoriteService = (FavoriteService)ExoContainerContext.getService(FavoriteService.class);
                    boolean isFavorite = favoriteService.isFavorite(new Favorite(SPACE_ACTIVITY_TYPE, space.getId(), null, Long.parseLong(userIdentity.getId())));
                    spaceEntity.setIsFavorite(String.valueOf(isFavorite));
                }
                if (expandFields.contains("muted")) {
                    UserSettingService userSettingService = (UserSettingService)ExoContainerContext.getService(UserSettingService.class);
                    UserSetting userSetting = userSettingService.get(userId);
                    spaceEntity.setIsMuted(String.valueOf(userSetting.isSpaceMuted(Long.parseLong(space.getId()))));
                }
                if (expandFields.contains("navigations_permission")) {
                    UserPortalConfigService service = (UserPortalConfigService)ExoContainerContext.getService(UserPortalConfigService.class);
                    PortalConfig sitePortalConfig = service.getDataStorage().getPortalConfig(new SiteKey(SiteType.GROUP, space.getGroupId()));
                    spaceEntity.setCanEditNavigations(service.getUserACL().hasAccessPermission(sitePortalConfig, EntityBuilder.getCurrentUserIdentity()));
                }
            }
            boolean isManager = spaceService.isManager(space, userId);
            spaceEntity.setIsPending(spaceService.isPendingUser(space, userId));
            spaceEntity.setIsInvited(spaceService.isInvitedUser(space, userId));
            spaceEntity.setIsMember(spaceService.isMember(space, userId));
            spaceEntity.setCanEdit(canEdit);
            spaceEntity.setCanDelete(spaceService.canDeleteSpace(space, userId));
            spaceEntity.setCanManagePublicSite(spaceService.canManageSpacePublicSite(space, userId));
            spaceEntity.setCanRedactOnSpace(spaceService.canRedactOnSpace(space, EntityBuilder.getCurrentUserIdentity()));
            spaceEntity.setIsManager(isManager);
            spaceEntity.setIsRedactor(spaceService.isRedactor(space, userId));
            spaceEntity.setIsPublisher(spaceService.isPublisher(space, userId));
        } else if (space != null && StringUtils.isNotBlank((CharSequence)space.getId())) {
            org.exoplatform.social.core.identity.model.Identity currentUserIdentity = RestUtils.getCurrentUserIdentity();
            spaceEntity.setIsMember(spaceService.isMember(space, currentUserIdentity.getRemoteId()));
        }
        PortalConfig portalConfig = EntityBuilder.getLayoutService().getPortalConfig(new SiteKey(PortalConfig.GROUP_TYPE, space.getGroupId()));
        if (portalConfig != null) {
            spaceEntity.setSiteId(portalConfig.getStorageId().split("_")[1]);
        }
        spaceEntity.setDisplayName(space.getDisplayName());
        spaceEntity.setLastUpdatedTime(space.getLastUpdatedTime());
        spaceEntity.setCreatedTime(String.valueOf(space.getCreatedTime()));
        spaceEntity.setPrettyName(space.getPrettyName());
        spaceEntity.setGroupId(space.getGroupId());
        spaceEntity.setTemplateId(space.getTemplateId());
        spaceEntity.setDescription(StringEscapeUtils.unescapeHtml4((String)space.getDescription()));
        spaceEntity.setUrl(LinkProvider.getSpaceUri((String)space.getPrettyName()));
        spaceEntity.setAvatarUrl(space.getAvatarUrl());
        spaceEntity.setBannerUrl(space.getBannerUrl());
        spaceEntity.setVisibility(space.getVisibility());
        if (space.getPublicSiteId() > 0L) {
            PortalConfig publicPortalConfig = EntityBuilder.getLayoutService().getPortalConfig(space.getPublicSiteId());
            if (publicPortalConfig == null || !EntityBuilder.getUserACL().hasAccessPermission(publicPortalConfig, EntityBuilder.getCurrentUserIdentity())) {
                spaceEntity.setPublicSiteId(0L);
            } else {
                spaceEntity.setPublicSiteId(space.getPublicSiteId());
                spaceEntity.setPublicSiteVisibility(space.getPublicSiteVisibility());
                spaceEntity.setPublicSiteName(publicPortalConfig.getName());
            }
        } else {
            spaceEntity.setPublicSiteId(0L);
        }
        spaceEntity.setSubscription(space.getRegistration());
        spaceEntity.setMembersCount(space.getMembers() == null ? 0 : EntityBuilder.countUsers(space.getMembers()));
        spaceEntity.setManagersCount(space.getManagers() == null ? 0 : EntityBuilder.countUsers(space.getManagers()));
        spaceEntity.setRedactorsCount(space.getRedactors() == null ? 0 : EntityBuilder.countUsers(space.getRedactors()));
        spaceEntity.setPublishersCount(space.getPublishers() == null ? 0 : EntityBuilder.countUsers(space.getPublishers()));
        if (canEdit) {
            spaceEntity.setPendingUsersCount(space.getPendingUsers() == null ? 0 : EntityBuilder.countUsers(space.getPendingUsers()));
            spaceEntity.setInvitedUsersCount(space.getInvitedUsers() == null ? 0 : EntityBuilder.countUsers(space.getInvitedUsers()));
        }
        return spaceEntity;
    }

    public static void buildSpaceUnread(SpaceEntity spaceEntity, String username, String expand) {
        SpaceWebNotificationService spaceWebNotificationService;
        long unreadBadge;
        if (StringUtils.isNotBlank((CharSequence)expand) && Arrays.asList(StringUtils.split((String)expand, (String)",")).contains("unread") && (unreadBadge = (spaceWebNotificationService = (SpaceWebNotificationService)ExoContainerContext.getService(SpaceWebNotificationService.class)).countUnreadActivitiesBySpace(username, Long.parseLong(spaceEntity.getId()))) > 0L) {
            spaceEntity.getDataEntity().put("unread", unreadBadge);
        }
    }

    public static List<DataEntity> buildSpaceMemberships(SpaceService spaceService, List<Space> spaces, String userId, SpaceMembershipRest.MembershipType membershipType, int offset, String path, String expand) {
        if (StringUtils.isNotBlank((CharSequence)userId)) {
            return spaces.stream().map(space -> EntityBuilder.buildSpaceMembership(spaceService, space, userId, membershipType, path, expand)).skip(offset).filter(Objects::nonNull).toList();
        }
        return spaces.stream().map(space -> EntityBuilder.buildSpaceMemberships(space, membershipType, path, expand)).filter(CollectionUtils::isNotEmpty).flatMap(Collection::stream).skip(offset).toList();
    }

    public static List<DataEntity> buildSpaceMemberships(SpaceService spaceService, Space space, List<org.exoplatform.social.core.identity.model.Identity> identities, SpaceMembershipRest.MembershipType membershipType, UriInfo uriInfo, String expand) {
        return identities.stream().filter(Objects::nonNull).filter(org.exoplatform.social.core.identity.model.Identity::isUser).map(identity -> EntityBuilder.buildSpaceMembership(spaceService, space, identity.getRemoteId(), membershipType, uriInfo.getPath(), expand)).toList();
    }

    private static DataEntity buildSpaceMembership(SpaceService spaceService, Space space, String userId, SpaceMembershipRest.MembershipType membershipType, String restPath, String expand) {
        if (EntityBuilder.getMembershipTypePredicate(spaceService, membershipType).test(space, userId)) {
            return EntityBuilder.buildSpaceMembershipEntity(space, userId, membershipType.getRole(), restPath, expand);
        }
        return null;
    }

    private static List<DataEntity> buildSpaceMemberships(Space space, SpaceMembershipRest.MembershipType membershipType, String restPath, String expand) {
        return Arrays.stream(EntityBuilder.getUsersSupplier(space, membershipType).get()).map(user -> EntityBuilder.buildSpaceMembershipEntity(space, user, membershipType.getRole(), restPath, expand)).toList();
    }

    private static DataEntity buildSpaceMembershipEntity(Space space, String user, String role, String restPath, String expand) {
        SpaceMembershipEntity membershipEntity = EntityBuilder.buildEntityFromSpaceMembership(space, user, role, restPath, expand);
        return membershipEntity.getDataEntity();
    }

    private static Supplier<String[]> getUsersSupplier(Space space, SpaceMembershipRest.MembershipType membershipType) {
        return switch (membershipType) {
            case SpaceMembershipRest.MembershipType.MEMBER, SpaceMembershipRest.MembershipType.APPROVED -> () -> ((Space)space).getMembers();
            case SpaceMembershipRest.MembershipType.MANAGER -> () -> ((Space)space).getManagers();
            case SpaceMembershipRest.MembershipType.PUBLISHER -> () -> ((Space)space).getPublishers();
            case SpaceMembershipRest.MembershipType.REDACTOR -> () -> ((Space)space).getRedactors();
            case SpaceMembershipRest.MembershipType.INVITED -> () -> ((Space)space).getInvitedUsers();
            case SpaceMembershipRest.MembershipType.PENDING -> () -> ((Space)space).getPendingUsers();
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)membershipType));
        };
    }

    private static BiPredicate<Space, String> getMembershipTypePredicate(SpaceService spaceService, SpaceMembershipRest.MembershipType membershipType) {
        return switch (membershipType) {
            case SpaceMembershipRest.MembershipType.MEMBER, SpaceMembershipRest.MembershipType.APPROVED -> (arg_0, arg_1) -> ((SpaceService)spaceService).isMember(arg_0, arg_1);
            case SpaceMembershipRest.MembershipType.MANAGER -> (arg_0, arg_1) -> ((SpaceService)spaceService).isManager(arg_0, arg_1);
            case SpaceMembershipRest.MembershipType.PUBLISHER -> (arg_0, arg_1) -> ((SpaceService)spaceService).isPublisher(arg_0, arg_1);
            case SpaceMembershipRest.MembershipType.REDACTOR -> (arg_0, arg_1) -> ((SpaceService)spaceService).isRedactor(arg_0, arg_1);
            case SpaceMembershipRest.MembershipType.INVITED -> (arg_0, arg_1) -> ((SpaceService)spaceService).isInvitedUser(arg_0, arg_1);
            case SpaceMembershipRest.MembershipType.PENDING -> (arg_0, arg_1) -> ((SpaceService)spaceService).isPendingUser(arg_0, arg_1);
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)membershipType));
        };
    }

    public static SpaceMembershipEntity buildEntityFromSpaceMembership(Space space, String username, String type, String restPath, String expand) {
        Instant createdDate;
        LinkEntity userEntity;
        EntityBuilder.updateCachedEtagValue(EntityBuilder.getEtagValue(type));
        String id = space.getPrettyName() + ":" + username + ":" + type;
        SpaceMembershipEntity spaceMembership = new SpaceMembershipEntity(id);
        spaceMembership.setHref(RestUtils.getRestUrl(SPACES_MEMBERSHIP_TYPE, id, restPath));
        List<Object> expandFields = StringUtils.isBlank((CharSequence)expand) ? Collections.emptyList() : Arrays.asList(expand.split(","));
        if (expandFields.contains(USERS_TYPE)) {
            org.exoplatform.social.core.identity.model.Identity identity = EntityBuilder.getIdentityManager().getOrCreateUserIdentity(username);
            Profile profile = identity == null ? null : identity.getProfile();
            userEntity = profile == null ? null : new LinkEntity(EntityBuilder.buildEntityProfile(space, profile, restPath, expand));
        } else {
            userEntity = new LinkEntity(RestUtils.getRestUrl(USERS_TYPE, username, restPath));
        }
        spaceMembership.setDataUser(userEntity);
        spaceMembership.setUsername(username);
        if (expandFields.contains(CREATED_DATE) && (createdDate = EntityBuilder.getSpaceService().getSpaceMembershipDate(Long.parseLong(space.getId()), username)) != null && EntityBuilder.getSpaceService().canManageSpace(space, EntityBuilder.getCurrentUserName())) {
            spaceMembership.getDataEntity().put(CREATED_DATE, createdDate.toEpochMilli());
        }
        LinkEntity spaceEntity = expandFields.contains(SPACES_TYPE) ? new LinkEntity(EntityBuilder.buildEntityFromSpace(space, username, restPath, expand)) : new LinkEntity(RestUtils.getRestUrl(SPACES_TYPE, space.getId(), restPath));
        spaceMembership.setDataSpace(spaceEntity);
        spaceMembership.setSpaceId(space.getId());
        spaceMembership.setRole(type);
        switch (type) {
            case "invited": {
                spaceMembership.setStatus("invited");
                break;
            }
            case "pending": {
                spaceMembership.setStatus("pending");
                break;
            }
            case "ignored": {
                spaceMembership.setStatus("ignored");
                break;
            }
            default: {
                spaceMembership.setStatus("approved");
            }
        }
        return spaceMembership;
    }

    public static ActivityEntity buildEntityFromActivity(ExoSocialActivity activity, org.exoplatform.social.core.identity.model.Identity authentiatedUser, String restPath, String expand) {
        Map<String, List<MetadataItemEntity>> activityMetadatasToPublish;
        ExoSocialActivity originalActivity;
        String originalActivityId;
        LinkEntity commentLink;
        if (activity.isComment() || activity.getParentId() != null) {
            CommentEntity commentEntity = EntityBuilder.buildEntityFromComment(activity, authentiatedUser, restPath, expand, false);
            DataEntity as = EntityBuilder.getActivityStream(EntityBuilder.getActivityManager().getParentActivity(activity), restPath, authentiatedUser);
            commentEntity.setActivityStream(as);
            return commentEntity;
        }
        Locale userLocale = LocalizationFilter.getCurrentLocale();
        MentionUtils.substituteRoleWithLocale((ExoSocialActivity)activity, (Locale)userLocale);
        List<Object> expandFields = StringUtils.isBlank((CharSequence)expand) ? Collections.emptyList() : Arrays.asList(expand.split(","));
        if (activity.getTitleId() != null) {
            I18NActivityProcessor i18NActivityProcessor = (I18NActivityProcessor)ExoContainerContext.getService(I18NActivityProcessor.class);
            activity = i18NActivityProcessor.process(activity, userLocale);
        }
        org.exoplatform.social.core.identity.model.Identity poster = EntityBuilder.getIdentityManager().getIdentity(activity.getPosterId());
        ActivityEntity activityEntity = new ActivityEntity(activity);
        activityEntity.setHref(RestUtils.getRestUrl(ACTIVITIES_TYPE, activity.getId(), restPath));
        LinkEntity identityLink = expandFields.contains("identity") ? new LinkEntity(EntityBuilder.buildEntityIdentity(poster, restPath, expand)) : new LinkEntity(RestUtils.getRestUrl(IDENTITIES_TYPE, activity.getPosterId(), restPath));
        activityEntity.setIdentity(identityLink);
        activityEntity.setOwner(EntityBuilder.getActivityOwner(poster, restPath, activity.getSpaceId()));
        activityEntity.setMentions(EntityBuilder.getActivityMentions(activity, restPath));
        activityEntity.setAttachments(new ArrayList<DataEntity>());
        boolean canEdit = EntityBuilder.getActivityManager().isActivityEditable(activity, EntityBuilder.getCurrentUserIdentity());
        activityEntity.setCanEdit(canEdit);
        boolean canDelete = EntityBuilder.getActivityManager().isActivityDeletable(activity, EntityBuilder.getCurrentUserIdentity());
        activityEntity.setCanDelete(canDelete);
        boolean canPin = EntityBuilder.getActivityManager().canPinActivity(activity, authentiatedUser);
        activityEntity.setCanPin(canPin);
        if (expandFields.contains(COMMENTS_TYPE)) {
            commentsEntity = EntityBuilder.buildEntityFromComment(activity, authentiatedUser, restPath, "", false, 0, 20);
            listAccess = EntityBuilder.getActivityManager().getCommentsWithListAccess(activity, true);
            commentLink = new LinkEntity(commentsEntity);
            activityEntity.setCommentsCount(listAccess.getSize());
        } else if (expandFields.contains(COMMENTS_PREVIEW_TYPE)) {
            commentsEntity = EntityBuilder.buildEntityFromComment(activity, authentiatedUser, restPath, expand, true, 0, 2);
            listAccess = EntityBuilder.getActivityManager().getCommentsWithListAccess(activity, true);
            commentLink = new LinkEntity(commentsEntity);
            activityEntity.setCommentsCount(listAccess.getSize());
        } else {
            commentLink = new LinkEntity(EntityBuilder.getCommentsActivityRestUrl(activity.getId(), restPath));
            activityEntity.setCommentsCount(activity.getCommentedIds() == null ? 0 : activity.getCommentedIds().length);
        }
        activityEntity.setComments(commentLink);
        if (expandFields.contains(LIKES_TYPE)) {
            List<DataEntity> likesEntity = EntityBuilder.buildEntityFromLike(activity, restPath, "", 0, 4);
            activityEntity.setLikes(new LinkEntity(likesEntity));
        } else {
            activityEntity.setLikes(new LinkEntity(EntityBuilder.getLikesActivityRestUrl(activity.getId(), restPath)));
        }
        activityEntity.setLikesCount(activity.getLikeIdentityIds() == null ? 0 : activity.getLikeIdentityIds().length);
        activityEntity.setHasLiked(ArrayUtils.contains((Object[])activity.getLikeIdentityIds(), (Object)authentiatedUser.getId()));
        activityEntity.setHasCommented(ArrayUtils.contains((Object[])activity.getCommentedIds(), (Object)authentiatedUser.getId()));
        activityEntity.setCreateDate(RestUtils.formatISO8601(new Date(activity.getPostedTime())));
        activityEntity.setUpdateDate(RestUtils.formatISO8601(activity.getUpdated()));
        activityEntity.setPinned(activity.isPinned());
        activityEntity.setPinDate(activity.getPinDate());
        activityEntity.setPinAuthorId(activity.getPinAuthorId());
        DataEntity as = EntityBuilder.getActivityStream(activity, restPath, authentiatedUser);
        activityEntity.setActivityStream(as);
        EntityBuilder.updateCachedLastModifiedValue(activity.getUpdated());
        if (expandFields.contains("shared") && activity.getTemplateParams() != null && activity.getTemplateParams().containsKey("originalActivityId") && StringUtils.isNotBlank((CharSequence)(originalActivityId = (String)activity.getTemplateParams().get("originalActivityId"))) && (originalActivity = EntityBuilder.getActivityManager().getActivity(originalActivityId)) != null) {
            ActivityEntity originalActivityEntity = EntityBuilder.buildEntityFromActivity(originalActivity, authentiatedUser, restPath, expand.replace("shared", ""));
            activityEntity.setOriginalActivity(originalActivityEntity.getDataEntity());
        }
        if (activity.getLinkedProcessedEntities() != null) {
            activityEntity.getDataEntity().putAll(activity.getLinkedProcessedEntities());
        }
        if (MapUtils.isNotEmpty(activityMetadatasToPublish = EntityBuilder.retrieveMetadataItems(activity, authentiatedUser))) {
            activityEntity.setMetadatas(activityMetadatasToPublish);
        }
        return activityEntity;
    }

    public static Map<String, List<MetadataItemEntity>> retrieveMetadataItems(ExoSocialActivity activity, org.exoplatform.social.core.identity.model.Identity authentiatedUser) {
        Map activityMetadatas = activity.getMetadatas();
        if (MapUtils.isEmpty((Map)activityMetadatas)) {
            return null;
        }
        long authentiatedUserId = Long.parseLong(authentiatedUser.getId());
        org.exoplatform.social.core.identity.model.Identity owner = EntityBuilder.getStreamOwnerIdentity(activity);
        long streamOwnerId = owner == null ? 0L : Long.parseLong(owner.getId());
        HashMap<String, List<MetadataItemEntity>> activityMetadatasToPublish = new HashMap<String, List<MetadataItemEntity>>();
        Set metadataEntries = activityMetadatas.entrySet();
        for (Map.Entry metadataEntry : metadataEntries) {
            List<MetadataItemEntity> activityMetadataEntities;
            String metadataType = (String)metadataEntry.getKey();
            List metadataItems = (List)metadataEntry.getValue();
            if (!MapUtils.isNotEmpty((Map)activityMetadatas) || !CollectionUtils.isNotEmpty(activityMetadataEntities = metadataItems.stream().filter(metadataItem -> metadataItem.getMetadata().getAudienceId() == 0L || metadataItem.getMetadata().getAudienceId() == streamOwnerId || metadataItem.getMetadata().getAudienceId() == authentiatedUserId).map(metadataItem -> new MetadataItemEntity(metadataItem.getId(), metadataItem.getMetadata().getName(), metadataItem.getObjectType(), metadataItem.getObjectId(), metadataItem.getParentObjectId(), metadataItem.getCreatorId(), metadataItem.getMetadata().getAudienceId(), metadataItem.getProperties())).toList())) continue;
            activityMetadatasToPublish.put(metadataType, activityMetadataEntities);
        }
        return activityMetadatasToPublish;
    }

    public static void buildActivityFromEntity(ActivityEntity model, ExoSocialActivity activity) {
        if (model.getTitle() != null && !model.getTitle().equals(activity.getTitle())) {
            activity.setTitle(model.getTitle());
        }
        if (model.getBody() != null && !model.getBody().equals(activity.getBody())) {
            activity.setBody(model.getBody());
        }
        if (StringUtils.isNotBlank((CharSequence)model.getType())) {
            activity.setType(model.getType());
        }
        DataEntity templateParams = model.getTemplateParams();
        EntityBuilder.buildActivityParamsFromEntity(activity, templateParams);
    }

    public static void buildActivityParamsFromEntity(ExoSocialActivity activity, Map<String, ?> templateParams) {
        HashMap currentTemplateParams;
        HashMap hashMap = currentTemplateParams = activity.getTemplateParams() == null ? new HashMap() : new HashMap(activity.getTemplateParams());
        if (templateParams != null) {
            templateParams.forEach((name, value) -> currentTemplateParams.put(name, (String)value));
        }
        for (Map.Entry entry : currentTemplateParams.entrySet()) {
            if (entry == null) continue;
            if (StringUtils.isBlank((CharSequence)((CharSequence)entry.getValue()))) {
                entry.setValue("");
                continue;
            }
            if (!StringUtils.equals((CharSequence)((CharSequence)entry.getValue()), (CharSequence)"-")) continue;
            entry.setValue(null);
        }
        activity.setTemplateParams(currentTemplateParams);
    }

    public static boolean expandSubComments(String expand) {
        if (StringUtils.isNotEmpty((CharSequence)expand)) {
            List<String> expandFields = Arrays.asList(expand.split(","));
            return expandFields.contains("subComments");
        }
        return false;
    }

    public static CommentEntity buildEntityFromComment(ExoSocialActivity comment, org.exoplatform.social.core.identity.model.Identity authentiatedUser, String restPath, String expand, boolean isBuildList) {
        org.exoplatform.social.core.identity.model.Identity poster = EntityBuilder.getIdentityManager().getIdentity(comment.getPosterId());
        Locale userLocale = LocalizationFilter.getCurrentLocale();
        if (comment.getTitleId() != null) {
            I18NActivityProcessor i18NActivityProcessor = (I18NActivityProcessor)ExoContainerContext.getService(I18NActivityProcessor.class);
            comment = i18NActivityProcessor.process(comment, userLocale);
        }
        MentionUtils.substituteRoleWithLocale((ExoSocialActivity)comment, (Locale)userLocale);
        CommentEntity commentEntity = new CommentEntity(comment);
        commentEntity.setHref(RestUtils.getRestUrl(ACTIVITIES_TYPE, comment.getId(), restPath));
        List<Object> expandFields = new ArrayList();
        if (StringUtils.isNotEmpty((CharSequence)expand)) {
            expandFields = Arrays.asList(expand.split(","));
        }
        LinkEntity identityLink = expandFields.contains("identity") ? new LinkEntity(EntityBuilder.buildEntityIdentity(poster, restPath, null)) : new LinkEntity(RestUtils.getRestUrl(IDENTITIES_TYPE, comment.getPosterId(), restPath));
        commentEntity.setIdentity(identityLink);
        if (poster != null) {
            commentEntity.setPoster(poster.getRemoteId());
            commentEntity.setOwner(EntityBuilder.getActivityOwner(poster, restPath, EntityBuilder.getActivityManager().getParentActivity(comment).getSpaceId()));
        }
        if (comment.getBody() == null) {
            commentEntity.setBody(comment.getTitle());
        }
        commentEntity.setParentCommentId(comment.getParentCommentId());
        commentEntity.setMentions(EntityBuilder.getActivityMentions(comment, restPath));
        if (expandFields.contains(LIKES_TYPE)) {
            commentEntity.setLikes(new LinkEntity(EntityBuilder.buildEntityFromLike(comment, restPath, null, 0, 500)));
        } else {
            commentEntity.setLikes(new LinkEntity(RestUtils.getBaseRestUrl() + "/v1/social/activities/" + comment.getId() + "/likes"));
        }
        commentEntity.setCreateDate(RestUtils.formatISO8601(new Date(comment.getPostedTime())));
        commentEntity.setUpdateDate(RestUtils.formatISO8601(comment.getUpdated()));
        commentEntity.setActivity(RestUtils.getRestUrl(ACTIVITIES_TYPE, comment.getParentId(), restPath));
        commentEntity.setActivityId(comment.getParentId());
        boolean canEdit = EntityBuilder.getActivityManager().isActivityEditable(comment, EntityBuilder.getCurrentUserIdentity());
        commentEntity.setCanEdit(canEdit);
        boolean canDelete = EntityBuilder.getActivityManager().isActivityDeletable(comment, EntityBuilder.getCurrentUserIdentity());
        commentEntity.setCanDelete(canDelete);
        commentEntity.setLikesCount(comment.getLikeIdentityIds() == null ? 0 : comment.getLikeIdentityIds().length);
        commentEntity.setCommentsCount(comment.getCommentedIds() == null ? 0 : comment.getCommentedIds().length);
        commentEntity.setHasCommented(ArrayUtils.contains((Object[])comment.getCommentedIds(), (Object)authentiatedUser.getId()));
        commentEntity.setHasLiked(ArrayUtils.contains((Object[])comment.getLikeIdentityIds(), (Object)authentiatedUser.getId()));
        Map<String, List<MetadataItemEntity>> activityMetadatasToPublish = EntityBuilder.retrieveMetadataItems(comment, authentiatedUser);
        if (MapUtils.isNotEmpty(activityMetadatasToPublish)) {
            commentEntity.setMetadatas(activityMetadatasToPublish);
        }
        if (!isBuildList) {
            EntityBuilder.updateCachedLastModifiedValue(comment.getUpdated());
        }
        return commentEntity;
    }

    public static List<DataEntity> buildEntityFromComment(ExoSocialActivity activity, org.exoplatform.social.core.identity.model.Identity authentiatedUser, String restPath, String expand, boolean sortDescending, int offset, int limit) {
        ArrayList<DataEntity> commentsEntity = new ArrayList<DataEntity>();
        boolean expandSubComments = EntityBuilder.expandSubComments(expand);
        RealtimeListAccess listAccess = EntityBuilder.getActivityManager().getCommentsWithListAccess(activity, expandSubComments, sortDescending);
        List comments = listAccess.loadAsList(offset, limit);
        if (expandSubComments) {
            for (ExoSocialActivity comment : comments) {
                if (!StringUtils.isBlank((CharSequence)comment.getParentCommentId())) continue;
                Set<String> commenters = comments.stream().filter(tmpComment -> StringUtils.equals((CharSequence)tmpComment.getParentCommentId(), (CharSequence)comment.getId())).map(ExoSocialActivity::getPosterId).collect(Collectors.toSet());
                comment.setCommentedIds(commenters.toArray(new String[commenters.size()]));
            }
        }
        for (ExoSocialActivity comment : comments) {
            CommentEntity commentInfo = EntityBuilder.buildEntityFromComment(comment, authentiatedUser, restPath, expand, true);
            commentsEntity.add(commentInfo.getDataEntity());
        }
        return commentsEntity;
    }

    public static List<DataEntity> buildEntityFromLike(ExoSocialActivity activity, String restPath, String expand, int offset, int limit) {
        int toIndex;
        ArrayList<DataEntity> likesEntity = new ArrayList<DataEntity>();
        List<String> likerIds = Arrays.asList(activity.getLikeIdentityIds());
        int startIndex = offset;
        if (offset >= likerIds.size()) {
            int n = startIndex = likerIds.isEmpty() ? 0 : likerIds.size() - 1;
        }
        if ((toIndex = startIndex + limit) > likerIds.size()) {
            toIndex = likerIds.size();
        }
        if (toIndex > startIndex) {
            likerIds = likerIds.subList(startIndex, toIndex);
        }
        IdentityManager identityManager = EntityBuilder.getIdentityManager();
        for (String likerId : likerIds) {
            ProfileEntity likerInfo = EntityBuilder.buildEntityProfile(identityManager.getIdentity(likerId).getRemoteId(), restPath, expand);
            likesEntity.add(likerInfo.getDataEntity());
        }
        return likesEntity;
    }

    public static RelationshipEntity buildEntityRelationship(Relationship relationship, String restPath, String expand, boolean isSymetric) {
        if (relationship == null) {
            return new RelationshipEntity();
        }
        RelationshipEntity relationshipEntity = new RelationshipEntity(relationship.getId());
        relationshipEntity.setHref(RestUtils.getRestUrl(USERS_RELATIONSHIP_TYPE, relationship.getId(), restPath));
        List<Object> expandFields = new ArrayList();
        if (StringUtils.isNotEmpty((CharSequence)expand)) {
            expandFields = Arrays.asList(expand.split(","));
        }
        LinkEntity sender = expandFields.contains("sender") ? new LinkEntity(EntityBuilder.buildEntityProfile(relationship.getSender().getProfile(), restPath, expand)) : new LinkEntity(RestUtils.getRestUrl(USERS_TYPE, relationship.getSender().getRemoteId(), restPath));
        relationshipEntity.setDataSender(sender);
        LinkEntity receiver = expandFields.contains("receiver") ? new LinkEntity(EntityBuilder.buildEntityProfile(relationship.getReceiver().getProfile(), restPath, expand)) : new LinkEntity(RestUtils.getRestUrl(USERS_TYPE, relationship.getReceiver().getRemoteId(), restPath));
        relationshipEntity.setDataReceiver(receiver);
        relationshipEntity.setStatus(relationship.getStatus().name());
        if (isSymetric) {
            relationshipEntity.setSymetric(relationship.isSymetric());
        }
        EntityBuilder.updateCachedEtagValue(EntityBuilder.getEtagValue(relationship.getId()));
        return relationshipEntity;
    }

    public static List<DataEntity> buildRelationshipEntities(List<Relationship> relationships, UriInfo uriInfo) {
        ArrayList<DataEntity> infos = new ArrayList<DataEntity>();
        for (Relationship relationship : relationships) {
            infos.add(EntityBuilder.buildEntityRelationship(relationship, uriInfo.getPath(), RestUtils.getQueryParam(uriInfo, "expand"), true).getDataEntity());
        }
        return infos;
    }

    public static SpaceMembershipEntity createSpaceMembershipForIgnoredStatus(Space space, String userId, String type, String restPath, String expand) {
        String id = space.getPrettyName() + ":" + userId + ":" + type;
        SpaceMembershipEntity spaceMembership = new SpaceMembershipEntity(id);
        spaceMembership.setHref(RestUtils.getRestUrl(SPACES_MEMBERSHIP_TYPE, id, restPath));
        List<Object> expandFields = StringUtils.isBlank((CharSequence)expand) ? Collections.emptyList() : Arrays.asList(expand.split(","));
        LinkEntity userEntity = expandFields.contains(USERS_TYPE) ? new LinkEntity(EntityBuilder.buildEntityProfile(userId, restPath, expand)) : new LinkEntity(RestUtils.getRestUrl(USERS_TYPE, userId, restPath));
        spaceMembership.setDataUser(userEntity);
        LinkEntity spaceEntity = expandFields.contains(SPACES_TYPE) ? new LinkEntity(EntityBuilder.buildEntityProfile(userId, restPath, expand)) : new LinkEntity(RestUtils.getRestUrl(SPACES_TYPE, space.getId(), restPath));
        spaceMembership.setDataSpace(spaceEntity);
        spaceMembership.setRole(type);
        spaceMembership.setStatus("ignored");
        return spaceMembership;
    }

    private static DataEntity getActivityOwner(org.exoplatform.social.core.identity.model.Identity owner, String restPath, String spaceId) {
        BaseEntity mentionEntity = new BaseEntity(owner.getId());
        mentionEntity.setHref(RestUtils.getRestUrl(EntityBuilder.getIdentityType(owner), EntityBuilder.getIdentityId(owner), restPath));
        if (spaceId != null && !spaceId.isEmpty()) {
            SpaceService spaceService = EntityBuilder.getSpaceService();
            Space space = spaceService.getSpaceById(spaceId);
            boolean isMember = spaceService.isMember(space, owner.getRemoteId());
            mentionEntity.setProperty("isMember", isMember);
        }
        return mentionEntity.getDataEntity();
    }

    private static String getIdentityType(org.exoplatform.social.core.identity.model.Identity owner) {
        return "organization".equals(owner.getProviderId()) ? USERS_TYPE : SPACES_TYPE;
    }

    private static String getIdentityId(org.exoplatform.social.core.identity.model.Identity identity) {
        if ("organization".equals(identity.getProviderId())) {
            return identity.getRemoteId();
        }
        String spacePrettyName = identity.getRemoteId();
        SpaceService spaceService = EntityBuilder.getSpaceService();
        Space space = spaceService.getSpaceByPrettyName(spacePrettyName);
        return space.getId();
    }

    private static List<DataEntity> getActivityMentions(ExoSocialActivity activity, String restPath) {
        ArrayList<DataEntity> mentions = new ArrayList<DataEntity>();
        IdentityManager identityManager = EntityBuilder.getIdentityManager();
        for (String mentionner : activity.getMentionedIds()) {
            String mentionnerId = mentionner.split("@")[0];
            mentions.add(EntityBuilder.getActivityOwner(identityManager.getIdentity(mentionnerId), restPath, null));
        }
        return mentions;
    }

    private static DataEntity getActivityStream(ExoSocialActivity activity, String restPath, org.exoplatform.social.core.identity.model.Identity authentiatedUser) {
        if (activity.isComment() || activity.getParentId() != null) {
            activity = EntityBuilder.getActivityManager().getParentActivity(activity);
        }
        DataEntity as = new DataEntity();
        org.exoplatform.social.core.identity.model.Identity owner = EntityBuilder.getStreamOwnerIdentity(activity);
        if (owner != null) {
            if (owner.isUser()) {
                as.put("type", USER_ACTIVITY_TYPE);
            } else if (owner.isSpace()) {
                as.put("type", SPACE_ACTIVITY_TYPE);
                Space space = EntityBuilder.getSpaceService().getSpaceByPrettyName(owner.getRemoteId());
                as.put(SPACE_ACTIVITY_TYPE, EntityBuilder.buildEntityFromSpace(space, authentiatedUser.getRemoteId(), restPath, "favorite,muted"));
            }
            as.put("id", owner.getRemoteId());
        }
        return as;
    }

    private static org.exoplatform.social.core.identity.model.Identity getStreamOwnerIdentity(ExoSocialActivity activity) {
        if (activity.isComment() || activity.getParentId() != null) {
            activity = EntityBuilder.getActivityManager().getParentActivity(activity);
        }
        String streamOwner = activity.getStreamOwner();
        org.exoplatform.social.core.identity.model.Identity owner = EntityBuilder.getIdentityManager().getOrCreateUserIdentity(streamOwner);
        if (owner == null) {
            owner = identityManager.getOrCreateSpaceIdentity(activity.getStreamOwner());
        }
        return owner;
    }

    private static void updateCachedEtagValue(int etagValue) {
        ApplicationContext ac = ApplicationContextImpl.getCurrent();
        Map properties = ac.getProperties();
        ConcurrentHashMap props = new ConcurrentHashMap(properties);
        if (props.containsKey("ETag")) {
            props.remove("ETag");
        }
        if (props.containsKey("updateDate")) {
            props.remove("updateDate");
        }
        ac.setProperty("ETag", String.valueOf(etagValue));
        ApplicationContextImpl.setCurrent((ApplicationContext)ac);
    }

    private static void updateCachedLastModifiedValue(Date lastModifiedDate) {
        ApplicationContext ac = ApplicationContextImpl.getCurrent();
        Map properties = ac.getProperties();
        ConcurrentHashMap props = new ConcurrentHashMap(properties);
        if (props.containsKey("updateDate")) {
            props.remove("updateDate");
        }
        if (props.containsKey("ETag")) {
            props.remove("ETag");
        }
        ac.setProperty("updateDate", String.valueOf(lastModifiedDate.getTime()));
        ApplicationContextImpl.setCurrent((ApplicationContext)ac);
    }

    private static int getEtagValue(String ... properties) {
        int prime = 31;
        int result = 0;
        for (String prop : properties) {
            if (prop == null) continue;
            result = 31 * result + prop.hashCode();
        }
        return result;
    }

    public static String getCommentsActivityRestUrl(String activityId, String restPath) {
        return new StringBuffer(RestUtils.getRestUrl(ACTIVITIES_TYPE, activityId, restPath)).append("/").append(COMMENTS_TYPE).toString();
    }

    public static String getLikesActivityRestUrl(String activityId, String restPath) {
        return new StringBuffer(RestUtils.getRestUrl(ACTIVITIES_TYPE, activityId, restPath)).append("/").append(LIKES_TYPE).toString();
    }

    public static Response.ResponseBuilder getResponseBuilder(Object entity, UriInfo uriInfo, MediaType mediaType, Response.Status status) {
        if (entity instanceof BaseEntity) {
            BaseEntity baseEntity = (BaseEntity)entity;
            entity = baseEntity.getDataEntity();
        }
        Response.ResponseBuilder responseBuilder = Response.created((URI)uriInfo.getAbsolutePath()).entity(entity).type(mediaType.toString() + "; charset=utf-8").status(status).cacheControl(NO_CACHE_CC);
        if (EntityBuilder.hasPaging(entity)) {
            responseBuilder.header(LINK, EntityBuilder.buildLinkForHeader(entity, uriInfo.getAbsolutePath().toString()));
        }
        return responseBuilder;
    }

    public static Response getResponse(Object entity, UriInfo uriInfo, MediaType mediaType, Response.Status status) {
        Response.ResponseBuilder responseBuilder = EntityBuilder.getResponseBuilder(entity, uriInfo, mediaType, status);
        return responseBuilder.build();
    }

    private static boolean hasPaging(Object entity) {
        if (!(entity instanceof CollectionEntity)) {
            return false;
        }
        CollectionEntity rc = (CollectionEntity)entity;
        int size = rc.getSize();
        int offset = rc.getOffset();
        int limit = rc.getLimit();
        return size > 0 && limit != 0 && offset <= size && size > limit;
    }

    public static Object buildLinkForHeader(Object entity, String requestPath) {
        CollectionEntity rc = (CollectionEntity)entity;
        int size = rc.getSize();
        int offset = rc.getOffset();
        int limit = rc.getLimit();
        StringBuilder linkHeader = new StringBuilder();
        if (EntityBuilder.hasNext(size, offset, limit)) {
            int nextOS = offset + limit;
            linkHeader.append(EntityBuilder.createLinkHeader(requestPath, nextOS, limit, NEXT_ACTION));
        }
        if (EntityBuilder.hasPrevious(offset, limit)) {
            int preOS = offset - limit;
            EntityBuilder.appendCommaIfNecessary(linkHeader);
            linkHeader.append(EntityBuilder.createLinkHeader(requestPath, preOS, limit, PREV_ACTION));
        }
        if (EntityBuilder.hasFirst(offset, limit)) {
            EntityBuilder.appendCommaIfNecessary(linkHeader);
            linkHeader.append(EntityBuilder.createLinkHeader(requestPath, 0, limit, FIRST_ACTION));
        }
        if (EntityBuilder.hasLast(size, offset, limit)) {
            int pages = (int)Math.ceil((double)size / (double)limit);
            int lastOS = (pages - 1) * limit;
            EntityBuilder.appendCommaIfNecessary(linkHeader);
            linkHeader.append(EntityBuilder.createLinkHeader(requestPath, lastOS, limit, LAST_ACTION));
        }
        return linkHeader.toString();
    }

    private static boolean hasNext(int size, int offset, int limit) {
        return size > offset + limit;
    }

    private static boolean hasPrevious(int offset, int limit) {
        if (offset == 0) {
            return false;
        }
        return offset >= limit;
    }

    private static boolean hasFirst(int offset, int limit) {
        return EntityBuilder.hasPrevious(offset, limit);
    }

    private static boolean hasLast(int size, int offset, int limit) {
        if (offset + limit == size) {
            return false;
        }
        return EntityBuilder.hasNext(size, offset, limit);
    }

    private static void appendCommaIfNecessary(StringBuilder linkHeader) {
        if (linkHeader.length() > 0) {
            linkHeader.append(", ");
        }
    }

    private static String createLinkHeader(String uri, int offset, int limit, String rel) {
        return "<" + uri + "?offset=" + offset + "&limit=" + limit + ">; rel=\"" + rel + "\"";
    }

    public static GroupSpaceBindingEntity buildEntityFromGroupSpaceBinding(GroupSpaceBinding binding) {
        GroupSpaceBindingEntity groupSpaceBindingEntity = new GroupSpaceBindingEntity();
        groupSpaceBindingEntity.setId(Long.toString(binding.getId()));
        groupSpaceBindingEntity.setSpaceId(binding.getSpaceId());
        groupSpaceBindingEntity.setGroup(binding.getGroup());
        return groupSpaceBindingEntity;
    }

    public static GroupNodeEntity buildEntityFromGroup(Group group) {
        GroupNodeEntity groupNodeEntity = new GroupNodeEntity();
        groupNodeEntity.setId(group.getId());
        String groupName = group.getLabel() != null ? group.getLabel() : group.getGroupName();
        groupNodeEntity.setGroupName(groupName);
        String parentId = group.getParentId() == null ? "root" : group.getParentId();
        groupNodeEntity.setParentId(parentId);
        groupNodeEntity.setBound(false);
        groupNodeEntity.setChildGroupNodesEntities(new ArrayList<DataEntity>());
        return groupNodeEntity;
    }

    public static GroupNodeEntity buildEntityFromGroupId(String group) {
        GroupNodeEntity groupNodeEntity = new GroupNodeEntity();
        groupNodeEntity.setId(group);
        groupNodeEntity.setGroupName(group);
        groupNodeEntity.setParentId("");
        groupNodeEntity.setChildGroupNodesEntities(new ArrayList<DataEntity>());
        return groupNodeEntity;
    }

    public static GroupSpaceBindingOperationReportEntity buildEntityFromGroupSpaceBindingOperationReport(GroupSpaceBindingOperationReport bindingOperationReport) {
        GroupSpaceBindingOperationReportEntity operationReportEntity = new GroupSpaceBindingOperationReportEntity();
        operationReportEntity.setOperationType(bindingOperationReport.getAction());
        operationReportEntity.setBindingId(Long.toString(bindingOperationReport.getGroupSpaceBindingId()));
        operationReportEntity.setAddedUsersCount(Long.toString(bindingOperationReport.getAddedUsers()));
        operationReportEntity.setRemovedUsersCount(Long.toString(bindingOperationReport.getRemovedUsers()));
        Date startDate = bindingOperationReport.getStartDate();
        Date endDate = bindingOperationReport.getEndDate();
        operationReportEntity.setStartDate(startDate != null ? RestUtils.formatISO8601(startDate) : "null");
        operationReportEntity.setEndDate(endDate != null ? RestUtils.formatISO8601(endDate) : "null");
        return operationReportEntity;
    }

    public static ProfilePropertySettingEntity buildEntityProfilePropertySetting(ProfilePropertySetting profilePropertySetting, ProfilePropertyService profilePropertyService, String objectType) {
        if (profilePropertySetting == null) {
            return null;
        }
        ProfileLabelService profileLabelService = (ProfileLabelService)CommonsUtils.getService(ProfileLabelService.class);
        ProfilePropertySettingEntity profilePropertySettingEntity = new ProfilePropertySettingEntity();
        profilePropertySettingEntity.setId(profilePropertySetting.getId());
        profilePropertySettingEntity.setActive(profilePropertySetting.isActive());
        profilePropertySettingEntity.setEditable(profilePropertySetting.isEditable());
        profilePropertySettingEntity.setVisible(profilePropertySetting.isVisible());
        profilePropertySettingEntity.setPropertyName(profilePropertySetting.getPropertyName());
        profilePropertySettingEntity.setParentId(profilePropertySetting.getParentId());
        profilePropertySettingEntity.setGroupSynchronized(profilePropertySetting.isGroupSynchronized());
        profilePropertySettingEntity.setRequired(profilePropertySetting.isRequired());
        profilePropertySettingEntity.setOrder(profilePropertySetting.getOrder());
        profilePropertySettingEntity.setUpdated(profilePropertySetting.getUpdated());
        profilePropertySettingEntity.setMultiValued(profilePropertySetting.isMultiValued());
        profilePropertySettingEntity.setGroupSynchronizationEnabled(profilePropertyService.isGroupSynchronizedEnabledProperty(profilePropertySetting));
        profilePropertySettingEntity.setHiddenable(profilePropertyService.isPropertySettingHiddenable(profilePropertySetting));
        profilePropertySettingEntity.setPropertyType(profilePropertySetting.getPropertyType());
        profilePropertySettingEntity.setLabels(profileLabelService.findLabelByObjectTypeAndObjectId(objectType, String.valueOf(profilePropertySetting.getId())));
        profilePropertySettingEntity.setDefault(profilePropertyService.isDefaultProperties(profilePropertySetting));
        return profilePropertySettingEntity;
    }

    public static List<ProfilePropertySettingEntity> buildEntityProfilePropertySettingList(List<ProfilePropertySetting> profilePropertySettingList, ProfilePropertyService profilePropertyService, String objectType, long userIdentityId) {
        if (profilePropertySettingList.isEmpty()) {
            return new ArrayList<ProfilePropertySettingEntity>();
        }
        List hiddenPropertyIds = profilePropertyService.getHiddenProfilePropertyIds(userIdentityId);
        ArrayList<ProfilePropertySettingEntity> profilePropertySettingsList = new ArrayList<ProfilePropertySettingEntity>();
        for (ProfilePropertySetting propertySetting : profilePropertySettingList) {
            ProfilePropertySettingEntity profilePropertySettingEntity = EntityBuilder.buildEntityProfilePropertySetting(propertySetting, profilePropertyService, objectType);
            if (profilePropertySettingEntity == null) continue;
            profilePropertySettingEntity.setHidden(hiddenPropertyIds.contains(profilePropertySettingEntity.getId()));
            profilePropertySettingsList.add(profilePropertySettingEntity);
        }
        for (int i = 0; i < profilePropertySettingsList.size(); ++i) {
            ProfilePropertySettingEntity entity = (ProfilePropertySettingEntity)profilePropertySettingsList.get(i);
            entity.setChildren(profilePropertySettingsList.stream().filter(element -> element.getParentId() != null && element.getParentId().equals(entity.getId())).toList());
            profilePropertySettingsList.set(i, entity);
        }
        return profilePropertySettingsList;
    }

    public static ProfilePropertySetting buildProfilePropertySettingFromEntity(ProfilePropertySettingEntity profilePropertySettingEntity, ProfilePropertyService profilePropertyService) {
        if (profilePropertySettingEntity == null) {
            return null;
        }
        ProfilePropertySetting profilePropertySetting = new ProfilePropertySetting();
        profilePropertySetting.setId(profilePropertySettingEntity.getId());
        profilePropertySetting.setActive(profilePropertySettingEntity.isActive());
        profilePropertySetting.setEditable(profilePropertySettingEntity.isEditable());
        profilePropertySetting.setVisible(profilePropertySettingEntity.isVisible());
        profilePropertySetting.setPropertyName(profilePropertySettingEntity.getPropertyName());
        if (profilePropertySettingEntity.getParentId() == null || profilePropertySettingEntity.getParentId() == 0L) {
            profilePropertySetting.setParentId(null);
        } else {
            profilePropertySetting.setParentId(profilePropertySettingEntity.getParentId());
        }
        profilePropertySetting.setGroupSynchronized(profilePropertySettingEntity.isGroupSynchronized());
        profilePropertySetting.setRequired(profilePropertySettingEntity.isRequired());
        profilePropertySetting.setOrder(profilePropertySettingEntity.getOrder());
        profilePropertySetting.setMultiValued(profilePropertySettingEntity.isMultiValued());
        profilePropertySetting.setHiddenbale(profilePropertySettingEntity.isHiddenable());
        profilePropertySetting.setPropertyType(profilePropertySettingEntity.getPropertyType());
        profilePropertySetting.setUpdated(profilePropertySettingEntity.getUpdated());
        return profilePropertySetting;
    }

    public static final <T> T fromJsonString(String value, Class<T> resultClass) {
        try {
            if (StringUtils.isBlank((CharSequence)value)) {
                return null;
            }
            JsonDefaultHandler jsonDefaultHandler = new JsonDefaultHandler();
            new JsonParserImpl().parse((InputStream)new ByteArrayInputStream(value.getBytes()), (JsonHandler)jsonDefaultHandler);
            return (T)ObjectBuilder.createObject(resultClass, (JsonValue)jsonDefaultHandler.getJsonObject());
        }
        catch (JsonException e) {
            throw new IllegalStateException("Error creating object from string : " + value, e);
        }
    }

    public static String toJsonString(Object object) {
        if (object == null) {
            return "{}";
        }
        try {
            ByteArrayOutputStream entityStream = new ByteArrayOutputStream();
            JSON_ENTITY_PROVIDER.writeTo(object, object.getClass(), object.getClass(), null, MediaType.APPLICATION_JSON_TYPE, null, (OutputStream)entityStream);
            return entityStream.toString(Charset.defaultCharset().name());
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to transform object " + String.valueOf(object), e);
        }
    }

    public static ActivityManager getActivityManager() {
        if (activityManager == null) {
            activityManager = (ActivityManager)ExoContainerContext.getService(ActivityManager.class);
        }
        return activityManager;
    }

    public static IdentityManager getIdentityManager() {
        if (identityManager == null) {
            identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        }
        return identityManager;
    }

    public static SpaceService getSpaceService() {
        if (spaceService == null) {
            spaceService = (SpaceService)ExoContainerContext.getService(SpaceService.class);
        }
        return spaceService;
    }

    public static OrganizationService getOrganizationService() {
        if (organizationService == null) {
            organizationService = (OrganizationService)ExoContainerContext.getService(OrganizationService.class);
        }
        return organizationService;
    }

    public static RelationshipManager getRelationshipManager() {
        if (relationshipManager == null) {
            relationshipManager = (RelationshipManager)ExoContainerContext.getService(RelationshipManager.class);
        }
        return relationshipManager;
    }

    public static List<SiteEntity> buildSiteEntities(List<PortalConfig> sites, HttpServletRequest request, boolean expandNavigations, List<String> visibilityNames, boolean excludeEmptyNavigationSites, boolean temporalCheck, boolean excludeGroupNodesWithoutPageChildNodes, boolean filterByPermission, boolean sortByDisplayOrder, Locale locale) throws Exception {
        List<PortalConfig> filteredByPermissionSites = sites;
        if (filterByPermission) {
            filteredByPermissionSites = sites.stream().filter(portalConfig -> EntityBuilder.getUserACL().hasAccessPermission(portalConfig, EntityBuilder.getCurrentUserIdentity())).toList();
        }
        List<Object> siteEntities = new ArrayList<SiteEntity>();
        for (PortalConfig site : filteredByPermissionSites) {
            siteEntities.add(EntityBuilder.buildSiteEntity(site, request, expandNavigations, visibilityNames, excludeEmptyNavigationSites, temporalCheck, excludeGroupNodesWithoutPageChildNodes, locale));
        }
        siteEntities = siteEntities.stream().filter(Objects::nonNull).toList();
        return sortByDisplayOrder ? siteEntities : siteEntities.stream().sorted(Comparator.comparing(SiteEntity::getDisplayName, String.CASE_INSENSITIVE_ORDER)).toList();
    }

    public static SiteEntity buildSiteEntity(PortalConfig site, HttpServletRequest request, boolean expandNavigations, List<String> visibilityNames, boolean excludeEmptyNavigationSites, boolean temporalCheck, boolean excludeGroupNodesWithoutPageChildNodes, Locale locale) throws Exception {
        if (site == null) {
            return null;
        }
        SiteType siteType = SiteType.valueOf((String)site.getType().toUpperCase());
        String siteName = site.getName();
        SiteKey siteKey = new SiteKey(siteType, siteName);
        UserPortalConfig userPortalConfig = EntityBuilder.getUserPortalConfig(request, site, siteType);
        UserNode rootNode = null;
        UserPortal userPortal = null;
        List<UserNodeRestEntity> siteNavigations = null;
        if (userPortalConfig != null) {
            userPortal = userPortalConfig.getUserPortal();
            rootNode = EntityBuilder.getRootNode(userPortal, siteKey, visibilityNames, temporalCheck);
            if (excludeEmptyNavigationSites && (rootNode == null || CollectionUtils.isEmpty((Collection)rootNode.getChildren()))) {
                return null;
            }
            siteNavigations = EntityBuilder.getSiteNavigations(userPortal, rootNode, expandNavigations, excludeGroupNodesWithoutPageChildNodes);
        } else if (excludeEmptyNavigationSites) {
            return null;
        }
        long siteId = Long.parseLong(site.getStorageId().split("_")[1]);
        String translatedSiteLabel = EntityBuilder.getTranslatedLabel("label", siteId, locale);
        String siteLabel = StringUtils.isBlank((CharSequence)translatedSiteLabel) ? EntityBuilder.getSiteLabel(siteKey, userPortal) : translatedSiteLabel;
        String translateSiteDescription = EntityBuilder.getTranslatedLabel("description", siteId, locale);
        String siteDescription = StringUtils.isBlank((CharSequence)translateSiteDescription) ? EntityBuilder.getSiteDescription(siteKey, userPortal) : translateSiteDescription;
        List<Map<String, Object>> accessPermissions = EntityBuilder.computePermissions(site.getAccessPermissions());
        Map<String, Object> editPermission = EntityBuilder.computePermission(site.getEditPermission());
        return new SiteEntity(siteId, siteType, siteName, siteLabel, siteDescription, rootNode == null ? null : new UserNodeRestEntity(rootNode), accessPermissions, editPermission, site.isDisplayed(), site.getDisplayOrder(), EntityBuilder.isMetaSite(siteName), siteNavigations, EntityBuilder.getUserACL().hasEditPermission(site, ConversationState.getCurrent().getIdentity()), site.getBannerFileId(), LinkProvider.buildSiteBannerUrl((String)siteName, (long)site.getBannerFileId()), (Map<String, String>)site.getProperties());
    }

    private static String getSiteDescription(SiteKey siteKey, UserPortal userPortal) {
        return userPortal == null ? null : userPortal.getPortalDescription(siteKey);
    }

    private static String getSiteLabel(SiteKey siteKey, UserPortal userPortal) {
        return userPortal == null ? siteKey.getName() : userPortal.getPortalLabel(siteKey);
    }

    private static UserPortalConfig getUserPortalConfig(HttpServletRequest request, PortalConfig portalConfig, SiteType siteType) {
        String portalName = siteType == SiteType.PORTAL ? portalConfig.getName() : EntityBuilder.getUserPortalConfigService().getMetaPortal();
        return EntityBuilder.getUserPortalConfigService().getUserPortalConfig(portalName, request.getRemoteUser());
    }

    private static Map<Long, Long> buildSpacesUnread(String username, String expand) {
        if (StringUtils.isNotBlank((CharSequence)expand) && Arrays.asList(StringUtils.split((String)expand, (String)",")).contains("unread")) {
            SpaceWebNotificationService spaceWebNotificationService = (SpaceWebNotificationService)ExoContainerContext.getService(SpaceWebNotificationService.class);
            return spaceWebNotificationService.countUnreadItemsBySpace(username);
        }
        return Collections.emptyMap();
    }

    private static List<UserNodeRestEntity> getSiteNavigations(UserPortal userPortal, UserNode rootNode, boolean expandNavigations, boolean excludeGroupNodesWithoutPageChildNodes) {
        if (expandNavigations && rootNode != null) {
            List siteNavigations = org.exoplatform.portal.mop.rest.EntityBuilder.toUserNodeRestEntity((Collection)rootNode.getChildren(), (boolean)true, (OrganizationService)EntityBuilder.getOrganizationService(), (LayoutService)EntityBuilder.getLayoutService(), (UserACL)EntityBuilder.getUserACL(), (UserPortal)userPortal, (boolean)false);
            if (excludeGroupNodesWithoutPageChildNodes) {
                EntityBuilder.removeGroupNodesWithoutPageChildNodes(siteNavigations);
            }
            return siteNavigations;
        }
        return Collections.emptyList();
    }

    private static UserNode getRootNode(UserPortal userPortal, SiteKey siteKey, List<String> visibilityNames, boolean temporalCheck) {
        UserNavigation navigation = userPortal.getNavigation(siteKey);
        if (navigation != null) {
            UserNodeFilterConfig.Builder builder = UserNodeFilterConfig.builder();
            builder.withReadWriteCheck().withVisibility(EntityBuilder.convertVisibilities(visibilityNames));
            if (temporalCheck) {
                builder.withTemporalCheck();
            }
            return userPortal.getNode(navigation, org.exoplatform.portal.mop.navigation.Scope.ALL, builder.build(), null);
        }
        return null;
    }

    private static List<Map<String, Object>> computePermissions(String[] permissions) {
        return permissions != null ? Arrays.stream(permissions).map(EntityBuilder::computePermission).toList() : new ArrayList<Map<String, Object>>();
    }

    private static Map<String, Object> computePermission(String permission) {
        HashMap<String, Object> sitePermission = new HashMap<String, Object>();
        try {
            if (permission != null) {
                Object sitePermissionGroupId;
                String[] permissionParts = permission.split(":");
                if (permissionParts.length == 1) {
                    if (permission.equals("Everyone")) {
                        sitePermission.put("membershipType", permission);
                        return sitePermission;
                    }
                    sitePermissionGroupId = permission;
                } else if (permissionParts.length == 2) {
                    sitePermission.put("membershipType", permissionParts[0]);
                    sitePermissionGroupId = permissionParts[1];
                } else {
                    return sitePermission;
                }
                if (!((String)sitePermissionGroupId).startsWith("/")) {
                    sitePermissionGroupId = "/" + (String)sitePermissionGroupId;
                }
                sitePermission.put(GROUP, EntityBuilder.getOrganizationService().getGroupHandler().findGroupById((String)sitePermissionGroupId));
            }
        }
        catch (Exception e) {
            LOG.error("Error while computing user permission {}", new Object[]{permission, e});
        }
        return sitePermission;
    }

    private static UserPortalConfigService getUserPortalConfigService() {
        if (userPortalConfigService == null) {
            userPortalConfigService = (UserPortalConfigService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(UserPortalConfigService.class);
        }
        return userPortalConfigService;
    }

    private static UserACL getUserACL() {
        if (userACL == null) {
            userACL = (UserACL)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(UserACL.class);
        }
        return userACL;
    }

    private static LayoutService getLayoutService() {
        if (layoutService == null) {
            layoutService = (LayoutService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(LayoutService.class);
        }
        return layoutService;
    }

    private static SettingService getSettingService() {
        if (settingService == null) {
            settingService = (SettingService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(SettingService.class);
        }
        return settingService;
    }

    private static TranslationService getTranslationService() {
        if (translationService == null) {
            translationService = (TranslationService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(TranslationService.class);
        }
        return translationService;
    }

    private static boolean isMetaSite(String siteName) {
        return EntityBuilder.getUserPortalConfigService().getMetaPortal().equals(siteName);
    }

    public static String getTranslatedLabel(String fieldName, long siteId, Locale locale) {
        return EntityBuilder.getTranslationService().getTranslationLabel("site", siteId, fieldName, locale);
    }

    private static Visibility[] convertVisibilities(List<String> visibilityNames) {
        if (visibilityNames == null) {
            return Visibility.DEFAULT_VISIBILITIES;
        }
        return visibilityNames.stream().map(visibilityName -> Visibility.valueOf((String)StringUtils.upperCase((String)visibilityName))).toList().toArray(new Visibility[0]);
    }

    private static void removeGroupNodesWithoutPageChildNodes(List<UserNodeRestEntity> userNodeList) {
        Iterator<UserNodeRestEntity> i = userNodeList.iterator();
        while (i.hasNext()) {
            UserNodeRestEntity userNode = i.next();
            if (userNode.getPageKey() == null && !EntityBuilder.hasPageChildNode(userNode)) {
                i.remove();
                continue;
            }
            EntityBuilder.removeGroupNodesWithoutPageChildNodes(userNode.getChildren());
        }
    }

    private static boolean hasPageChildNode(UserNodeRestEntity userNode) {
        if (userNode.getChildren() == null || userNode.getChildren().isEmpty()) {
            return false;
        }
        boolean hasPageChildNode = false;
        for (UserNodeRestEntity node : userNode.getChildren()) {
            if (node.getPageKey() != null) {
                hasPageChildNode = true;
            } else if (node.getChildren() != null && !userNode.getChildren().isEmpty()) {
                hasPageChildNode = EntityBuilder.hasPageChildNode(node);
            }
            if (!hasPageChildNode) continue;
            break;
        }
        return hasPageChildNode;
    }

    private static boolean isProfilePropertyVisible(String propertyName) {
        ProfilePropertySetting profilePropertySetting = EntityBuilder.getProfilePropertyService().getProfileSettingByName(propertyName);
        return profilePropertySetting != null && (profilePropertySetting.isVisible() || !EntityBuilder.getProfilePropertyService().isPropertySettingHiddenable(profilePropertySetting));
    }

    private static Identity getCurrentUserIdentity() {
        return ConversationState.getCurrent().getIdentity();
    }

    private static String getCurrentUserName() {
        ConversationState conversationState = ConversationState.getCurrent();
        return conversationState == null || conversationState.getIdentity() == null ? null : conversationState.getIdentity().getUserId();
    }

    private static int countUsers(String[] users) {
        return Arrays.stream(users).collect(Collectors.toSet()).size();
    }

    static {
        NO_CACHE_CC.setNoCache(true);
        NO_CACHE_CC.setNoStore(true);
    }
}

