/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.impl.identity;

import java.util.List;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.profileproperty.ProfilePropertyService;
import org.exoplatform.social.core.profileproperty.model.ProfilePropertySetting;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.rest.entity.CollectionEntity;
import org.exoplatform.social.rest.entity.DataEntity;
import org.exoplatform.social.rest.entity.IdentityEntity;
import org.exoplatform.social.rest.impl.identity.IdentityRestResourcesV1;
import org.exoplatform.social.service.test.AbstractResourceTest;

public class IdentityRestResourcesTest
extends AbstractResourceTest {
    private IdentityManager identityManager;
    private RelationshipManager relationshipManager;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        System.setProperty("gatein.email.domain.url", "localhost:8080");
        this.identityManager = (IdentityManager)this.getContainer().getComponentInstanceOfType(IdentityManager.class);
        this.relationshipManager = (RelationshipManager)this.getContainer().getComponentInstanceOfType(RelationshipManager.class);
        this.addResource(IdentityRestResourcesV1.class, null);
        this.createIdentity("root");
        this.createIdentity("john");
        this.createIdentity("mary");
        this.createIdentity("demo");
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        this.removeResource(IdentityRestResourcesV1.class);
    }

    public void testGetIdentities() throws Exception {
        this.startSessionAs("root");
        ContainerResponse response = this.service("GET", "/v1/social/identities?limit=5&offset=0", "", null, null);
        IdentityRestResourcesTest.assertNotNull((Object)response);
        IdentityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CollectionEntity collections = (CollectionEntity)response.getEntity();
        IdentityRestResourcesTest.assertEquals((int)4, (int)collections.getEntities().size());
    }

    public void testGetIdentityByProviderIdAndRemoteId() throws Exception {
        this.startSessionAs("root");
        ContainerResponse response = this.service("GET", "/v1/social/identities/organization/root", "", null, null);
        IdentityRestResourcesTest.assertNotNull((Object)response);
        IdentityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        DataEntity identityEntity = (DataEntity)response.getEntity();
        IdentityRestResourcesTest.assertNotNull((Object)identityEntity);
        IdentityRestResourcesTest.assertEquals((Object)"root", (Object)identityEntity.get((Object)"remoteId"));
        IdentityRestResourcesTest.assertEquals((Object)"organization", (Object)identityEntity.get((Object)"providerId"));
        IdentityRestResourcesTest.assertNotNull((Object)identityEntity.get((Object)"id"));
    }

    public void testGetCommonConnectionsWithIdentity() throws Exception {
        this.startSessionAs("root");
        Identity rootIdentity = this.identityManager.getOrCreateIdentity("organization", "root");
        Identity johnIdentity = this.identityManager.getOrCreateIdentity("organization", "john");
        Identity maryIdentity = this.identityManager.getOrCreateIdentity("organization", "mary");
        this.relationshipManager.inviteToConnect(rootIdentity, johnIdentity);
        this.relationshipManager.inviteToConnect(johnIdentity, maryIdentity);
        this.relationshipManager.confirm(maryIdentity, johnIdentity);
        this.relationshipManager.confirm(johnIdentity, rootIdentity);
        ContainerResponse response = this.service("GET", "/v1/social/identities/" + maryIdentity.getId() + "/commonConnections?returnSize=true", "", null, null);
        IdentityRestResourcesTest.assertNotNull((Object)response);
        IdentityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CollectionEntity collections = (CollectionEntity)response.getEntity();
        IdentityRestResourcesTest.assertEquals((int)1, (int)collections.getEntities().size());
    }

    public void testGetIdentityById() throws Exception {
        this.startSessionAs("root");
        Identity rootIdentity = this.identityManager.getOrCreateIdentity("organization", "root");
        Identity johnIdentity = this.identityManager.getOrCreateIdentity("organization", "john");
        ContainerResponse response = this.service("GET", "/v1/social/identities/" + johnIdentity.getId(), "", null, null);
        IdentityRestResourcesTest.assertNotNull((Object)response);
        IdentityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        EntityTag eTag = (EntityTag)response.getHttpHeaders().getFirst((Object)"ETAG");
        IdentityRestResourcesTest.assertNotNull((Object)eTag);
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.putSingle((Object)"If-None-Match", (Object)("\"" + eTag.getValue() + "\""));
        response = this.service("GET", "/v1/social/identities/" + johnIdentity.getId(), "", (MultivaluedMap<String, String>)headers, null);
        IdentityRestResourcesTest.assertNotNull((Object)response);
        IdentityRestResourcesTest.assertEquals((int)304, (int)response.getStatus());
        this.relationshipManager.inviteToConnect(rootIdentity, johnIdentity);
        this.relationshipManager.confirm(johnIdentity, rootIdentity);
        headers = new MultivaluedMapImpl();
        headers.putSingle((Object)"If-None-Match", (Object)("\"" + eTag.getValue() + "\""));
        response = this.service("GET", "/v1/social/identities/" + johnIdentity.getId(), "", (MultivaluedMap<String, String>)headers, null);
        IdentityRestResourcesTest.assertNotNull((Object)response);
        IdentityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        Relationship relationship = this.relationshipManager.get(rootIdentity, johnIdentity);
        this.relationshipManager.delete(relationship);
        headers = new MultivaluedMapImpl();
        headers.putSingle((Object)"If-None-Match", (Object)("\"" + eTag.getValue() + "\""));
        response = this.service("GET", "/v1/social/identities/" + johnIdentity.getId() + "?expand=settings", "", (MultivaluedMap<String, String>)headers, null);
        IdentityRestResourcesTest.assertNotNull((Object)response);
        IdentityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetIdentityByIdWhenHiddenProperties() throws Exception {
        ProfilePropertyService profileSettingsService = (ProfilePropertyService)this.getContainer().getComponentInstanceOfType(ProfilePropertyService.class);
        Identity johnIdentity = this.identityManager.getOrCreateUserIdentity("john");
        this.startSessionAs("mary");
        ContainerResponse response = this.service("GET", "/v1/social/identities/" + johnIdentity.getId() + "?expand=settings", "", null, null);
        IdentityRestResourcesTest.assertNotNull((Object)response);
        IdentityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        IdentityEntity identityEntity = (IdentityEntity)response.getEntity();
        IdentityRestResourcesTest.assertNotNull((Object)identityEntity.getProfile().getFullname());
        IdentityRestResourcesTest.assertNotNull((Object)identityEntity.getProfile().getFirstname());
        IdentityRestResourcesTest.assertNotNull((Object)identityEntity.getProfile().getLastname());
        IdentityRestResourcesTest.assertNull((Object)identityEntity.getProfile().getCreatedDate());
        IdentityRestResourcesTest.assertNotNull((Object)identityEntity.getProfile().getEmail());
        List properties = identityEntity.getProfile().getProperties();
        IdentityRestResourcesTest.assertTrue((boolean)properties.stream().anyMatch(p -> StringUtils.equals((CharSequence)"email", (CharSequence)p.getPropertyName())));
        ProfilePropertySetting emailPropertySetting = profileSettingsService.getProfileSettingByName("email");
        profileSettingsService.hidePropertySetting(Long.parseLong(identityEntity.getId()), emailPropertySetting.getId().longValue());
        response = this.service("GET", "/v1/social/identities/" + johnIdentity.getId() + "?expand=settings", "", null, null);
        IdentityRestResourcesTest.assertNotNull((Object)response);
        IdentityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        identityEntity = (IdentityEntity)response.getEntity();
        properties = identityEntity.getProfile().getProperties();
        IdentityRestResourcesTest.assertTrue((boolean)properties.stream().noneMatch(p -> StringUtils.equals((CharSequence)"email", (CharSequence)p.getPropertyName())));
        profileSettingsService.showPropertySetting(Long.parseLong(identityEntity.getId()), emailPropertySetting.getId().longValue());
        response = this.service("GET", "/v1/social/identities/" + johnIdentity.getId() + "?expand=settings", "", null, null);
        IdentityRestResourcesTest.assertNotNull((Object)response);
        IdentityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        identityEntity = (IdentityEntity)response.getEntity();
        properties = identityEntity.getProfile().getProperties();
        IdentityRestResourcesTest.assertTrue((boolean)properties.stream().anyMatch(p -> StringUtils.equals((CharSequence)"email", (CharSequence)p.getPropertyName())));
        emailPropertySetting.setVisible(false);
        profileSettingsService.updatePropertySetting(emailPropertySetting);
        ProfilePropertySetting profilePropertySetting = profileSettingsService.getProfileSettingByName("lastName");
        profilePropertySetting.setVisible(false);
        profileSettingsService.updatePropertySetting(profilePropertySetting);
        try {
            response = this.service("GET", "/v1/social/identities/" + johnIdentity.getId() + "?expand=settings", "", null, null);
            IdentityRestResourcesTest.assertNotNull((Object)response);
            IdentityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
            identityEntity = (IdentityEntity)response.getEntity();
            IdentityRestResourcesTest.assertNotNull((Object)identityEntity.getProfile().getFullname());
            IdentityRestResourcesTest.assertNotNull((Object)identityEntity.getProfile().getFirstname());
            IdentityRestResourcesTest.assertNotNull((Object)identityEntity.getProfile().getLastname());
            IdentityRestResourcesTest.assertNull((Object)identityEntity.getProfile().getCreatedDate());
            IdentityRestResourcesTest.assertNull((Object)identityEntity.getProfile().getEmail());
            properties = identityEntity.getProfile().getProperties();
            IdentityRestResourcesTest.assertTrue((boolean)properties.stream().noneMatch(p -> StringUtils.equals((CharSequence)"email", (CharSequence)p.getPropertyName())));
            this.startSessionAs("root");
            response = this.service("GET", "/v1/social/identities/" + johnIdentity.getId() + "?expand=settings", "", null, null);
            IdentityRestResourcesTest.assertNotNull((Object)response);
            IdentityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
            identityEntity = (IdentityEntity)response.getEntity();
            IdentityRestResourcesTest.assertNotNull((Object)identityEntity.getProfile().getFullname());
            IdentityRestResourcesTest.assertNotNull((Object)identityEntity.getProfile().getFirstname());
            IdentityRestResourcesTest.assertNotNull((Object)identityEntity.getProfile().getLastname());
            IdentityRestResourcesTest.assertNotNull((Object)identityEntity.getProfile().getCreatedDate());
            IdentityRestResourcesTest.assertNotNull((Object)identityEntity.getProfile().getEmail());
            properties = identityEntity.getProfile().getProperties();
            IdentityRestResourcesTest.assertTrue((boolean)properties.stream().anyMatch(p -> StringUtils.equals((CharSequence)"email", (CharSequence)p.getPropertyName())));
        }
        finally {
            profilePropertySetting = profileSettingsService.getProfileSettingByName("email");
            profilePropertySetting.setVisible(true);
            profileSettingsService.updatePropertySetting(profilePropertySetting);
            profilePropertySetting = profileSettingsService.getProfileSettingByName("lastName");
            profilePropertySetting.setVisible(true);
            profileSettingsService.updatePropertySetting(profilePropertySetting);
        }
    }

    public void testGetIdentityCache() throws Exception {
        this.startSessionAs("root");
        Identity johnIdentity = this.identityManager.getOrCreateIdentity("organization", "john");
        ContainerResponse response = this.service("GET", "/v1/social/identities/" + johnIdentity.getId(), "", null, null);
        IdentityRestResourcesTest.assertNotNull((Object)response);
        IdentityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        EntityTag eTagRoot = (EntityTag)response.getHttpHeaders().getFirst((Object)"ETAG");
        IdentityRestResourcesTest.assertNotNull((Object)eTagRoot);
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.putSingle((Object)"If-None-Match", (Object)("\"" + eTagRoot.getValue() + "\""));
        response = this.service("GET", "/v1/social/identities/" + johnIdentity.getId(), "", (MultivaluedMap<String, String>)headers, null);
        IdentityRestResourcesTest.assertNotNull((Object)response);
        IdentityRestResourcesTest.assertEquals((int)304, (int)response.getStatus());
        this.startSessionAs("john");
        headers.putSingle((Object)"If-None-Match", (Object)("\"" + eTagRoot.getValue() + "\""));
        response = this.service("GET", "/v1/social/identities/" + johnIdentity.getId(), "", (MultivaluedMap<String, String>)headers, null);
        IdentityRestResourcesTest.assertNotNull((Object)response);
        IdentityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        EntityTag eTagJohn = (EntityTag)response.getHttpHeaders().getFirst((Object)"ETAG");
        IdentityRestResourcesTest.assertNotNull((Object)eTagJohn);
        headers.putSingle((Object)"If-None-Match", (Object)("\"" + eTagJohn.getValue() + "\""));
        response = this.service("GET", "/v1/social/identities/" + johnIdentity.getId(), "", (MultivaluedMap<String, String>)headers, null);
        IdentityRestResourcesTest.assertNotNull((Object)response);
        IdentityRestResourcesTest.assertEquals((int)304, (int)response.getStatus());
        this.startSessionAs("root");
        headers.putSingle((Object)"If-None-Match", (Object)("\"" + eTagJohn.getValue() + "\""));
        response = this.service("GET", "/v1/social/identities/" + johnIdentity.getId(), "", (MultivaluedMap<String, String>)headers, null);
        IdentityRestResourcesTest.assertNotNull((Object)response);
        IdentityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        headers.putSingle((Object)"If-None-Match", (Object)("\"" + eTagRoot.getValue() + "\""));
        response = this.service("GET", "/v1/social/identities/" + johnIdentity.getId(), "", (MultivaluedMap<String, String>)headers, null);
        IdentityRestResourcesTest.assertNotNull((Object)response);
        IdentityRestResourcesTest.assertEquals((int)304, (int)response.getStatus());
        headers.putSingle((Object)"If-None-Match", (Object)("\"" + eTagJohn.getValue() + "\""));
        response = this.service("GET", "/v1/social/identities/" + johnIdentity.getId() + "?expand=settings", "", (MultivaluedMap<String, String>)headers, null);
        IdentityRestResourcesTest.assertNotNull((Object)response);
        IdentityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        eTagJohn = (EntityTag)response.getHttpHeaders().getFirst((Object)"ETAG");
        headers.putSingle((Object)"If-None-Match", (Object)("\"" + eTagJohn.getValue() + "\""));
        response = this.service("GET", "/v1/social/identities/" + johnIdentity.getId() + "?expand=settings", "", (MultivaluedMap<String, String>)headers, null);
        IdentityRestResourcesTest.assertNotNull((Object)response);
        IdentityRestResourcesTest.assertEquals((int)304, (int)response.getStatus());
        Profile profile = johnIdentity.getProfile();
        profile.setProperty("position", (Object)"Developer");
        this.identityManager.updateProfile(profile, true);
        response = this.service("GET", "/v1/social/identities/" + johnIdentity.getId() + "?expand=settings", "", (MultivaluedMap<String, String>)headers, null);
        IdentityRestResourcesTest.assertNotNull((Object)response);
        IdentityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
    }

    public void testCacheWhenUserJoinsSpace() throws Exception {
        this.startSessionAs("root");
        Identity johnIdentity = this.identityManager.getOrCreateIdentity("organization", "john");
        ContainerResponse response = this.service("GET", "/v1/social/identities/" + johnIdentity.getId(), "", null, null);
        IdentityRestResourcesTest.assertNotNull((Object)response);
        IdentityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        EntityTag eTag = (EntityTag)response.getHttpHeaders().getFirst((Object)"ETAG");
        IdentityRestResourcesTest.assertNotNull((Object)eTag);
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.putSingle((Object)"If-None-Match", (Object)("\"" + eTag.getValue() + "\""));
        response = this.service("GET", "/v1/social/identities/" + johnIdentity.getId(), "", (MultivaluedMap<String, String>)headers, null);
        IdentityRestResourcesTest.assertNotNull((Object)response);
        IdentityRestResourcesTest.assertEquals((int)304, (int)response.getStatus());
        SpaceService spaceService = (SpaceService)this.getContainer().getComponentInstanceOfType(SpaceService.class);
        Space newSpace = new Space();
        newSpace.setDisplayName("space");
        newSpace.setPrettyName("space");
        newSpace.setManagers(new String[]{"root"});
        newSpace.setRegistration("open");
        newSpace.setVisibility("private");
        spaceService.createSpace(newSpace, "root");
        spaceService.addMember(newSpace, johnIdentity.getRemoteId());
        response = this.service("GET", "/v1/social/identities/" + johnIdentity.getId(), "", (MultivaluedMap<String, String>)headers, null);
        IdentityRestResourcesTest.assertNotNull((Object)response);
        IdentityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
    }
}

