/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.impl.space;

import io.meeds.portal.security.constant.UserRegistrationType;
import io.meeds.portal.security.service.SecuritySettingService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.deprecation.DeprecatedAPI;
import org.exoplatform.deprecation.DeprecatedAPIAspect;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.mop.PageType;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.thumbnail.ImageThumbnailService;
import org.exoplatform.social.common.Utils;
import org.exoplatform.social.core.identity.SpaceMemberFilterListAccess;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.model.AvatarAttachment;
import org.exoplatform.social.core.model.BannerAttachment;
import org.exoplatform.social.core.model.SpaceExternalInvitation;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.search.Sorting;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.SpaceFilter;
import org.exoplatform.social.core.space.SpaceListAccess;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.notification.service.SpaceWebNotificationService;
import org.exoplatform.social.rest.api.EntityBuilder;
import org.exoplatform.social.rest.api.RestUtils;
import org.exoplatform.social.rest.entity.ActivityEntity;
import org.exoplatform.social.rest.entity.BaseEntity;
import org.exoplatform.social.rest.entity.CollectionEntity;
import org.exoplatform.social.rest.entity.DataEntity;
import org.exoplatform.social.rest.entity.SpaceEntity;
import org.exoplatform.social.rest.impl.activity.ActivityRest;
import org.exoplatform.social.rest.impl.space.SpaceRest$AjcClosure1;
import org.exoplatform.social.rest.impl.space.SpaceRest$AjcClosure3;
import org.exoplatform.social.rest.impl.space.SpaceRest$AjcClosure5;
import org.exoplatform.social.rest.impl.space.SpaceRest$AjcClosure7;
import org.exoplatform.social.rest.impl.space.SpaceRest$AjcClosure9;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;
import org.exoplatform.web.login.recovery.PasswordRecoveryService;

@Path(value="v1/social/spaces")
@Tag(name="v1/social/spaces", description="Operations on spaces with their activities and users")
public class SpaceRest
implements ResourceContainer {
    private static final Log LOG;
    private static final String SPACE_FILTER_TYPE_ALL = "all";
    private static final String SPACE_FILTER_TYPE_MEMBER = "member";
    private static final String SPACE_FILTER_TYPE_MANAGER = "manager";
    private static final String SPACE_FILTER_TYPE_PENDING = "pending";
    private static final String SPACE_FILTER_TYPE_INVITED = "invited";
    private static final String SPACE_FILTER_TYPE_REQUESTS = "requests";
    private static final String SPACE_FILTER_TYPE_FAVORITE = "favorite";
    private static final String LAST_VISITED_SPACES = "lastVisited";
    private static final CacheControl CACHE_CONTROL;
    private static final CacheControl CACHE_REVALIDATE_CONTROL;
    private static final Date DEFAULT_IMAGES_LAST_MODIFED;
    private static final int CACHE_IN_SECONDS = 604800;
    private static final int CACHE_IN_MILLI_SECONDS = 604800000;
    private final ActivityRest activityRestResourcesV1;
    private final IdentityManager identityManager;
    private final UploadService uploadService;
    private final SpaceService spaceService;
    private final SecuritySettingService securitySettingService;
    private final ImageThumbnailService imageThumbnailService;
    private byte[] defaultSpaceAvatar = null;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    public SpaceRest(ActivityRest activityRestResourcesV1, SpaceService spaceService, IdentityManager identityManager, UploadService uploadService, ImageThumbnailService imageThumbnailService, SecuritySettingService securitySettingService) {
        this.activityRestResourcesV1 = activityRestResourcesV1;
        this.spaceService = spaceService;
        this.identityManager = identityManager;
        this.uploadService = uploadService;
        this.imageThumbnailService = imageThumbnailService;
        this.securitySettingService = securitySettingService;
        CACHE_CONTROL.setMaxAge(604800);
        CACHE_REVALIDATE_CONTROL.setMaxAge(604800);
        CACHE_REVALIDATE_CONTROL.setMustRevalidate(true);
    }

    @GET
    @RolesAllowed(value={"users"})
    @Operation(summary="Gets spaces of user", method="GET", description="This returns a list of spaces switch request parameters")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response getSpaces(@Context UriInfo uriInfo, @Context Request request, @Parameter(description="Space name search information", required=false) @QueryParam(value="q") String q, @Parameter(description="Type of spaces to retrieve: all, userSpaces, invited, pending or requests", required=false) @Schema(defaultValue="all") @QueryParam(value="filterType") String filterType, @Parameter(description="Offset", required=false) @Schema(defaultValue="0") @QueryParam(value="offset") int offset, @Parameter(description="Limit, if equals to 0, it will not retrieve spaces", required=false) @Schema(defaultValue="20") @QueryParam(value="limit") int limit, @Parameter(description="Sort", required=false) @QueryParam(value="sort") String sort, @Parameter(description="Order", required=false) @QueryParam(value="order") String order, @Parameter(description="Returning the number of spaces found or not") @Schema(defaultValue="false") @QueryParam(value="returnSize") boolean returnSize, @Parameter(description="Returning the favorite spaces of current user not not") @Schema(defaultValue="false") @QueryParam(value="favorites") boolean favorites, @Parameter(description="Asking for a full representation of a specific subresource, ex: members or managers", required=false) @QueryParam(value="expand") String expand) throws Exception {
        EntityTag entityTag;
        Response.ResponseBuilder builder;
        SpaceWebNotificationService spaceWebNotificationService;
        Map unreadItemsPerSpace;
        offset = offset > 0 ? offset : RestUtils.getOffset(uriInfo);
        int n = limit = limit >= 0 ? limit : RestUtils.getLimit(uriInfo);
        if (StringUtils.isBlank((CharSequence)filterType)) {
            filterType = SPACE_FILTER_TYPE_ALL;
        }
        SpaceListAccess listAccess = null;
        SpaceFilter spaceFilter = new SpaceFilter();
        if (StringUtils.isNotBlank((CharSequence)q)) {
            spaceFilter.setSpaceNameSearchCondition(StringUtils.trim((String)q));
        }
        if (StringUtils.isNotBlank((CharSequence)sort)) {
            Sorting.SortBy sortBy = Sorting.SortBy.valueOf((String)sort.toUpperCase());
            Sorting.OrderBy orderBy = Sorting.OrderBy.ASC;
            if (StringUtils.isNotBlank((CharSequence)order)) {
                orderBy = Sorting.OrderBy.valueOf((String)order.toUpperCase());
            }
            spaceFilter.setSorting(new Sorting(sortBy, orderBy));
        }
        spaceFilter.setIsFavorite(favorites);
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        if (StringUtils.equalsIgnoreCase((CharSequence)SPACE_FILTER_TYPE_ALL, (CharSequence)filterType)) {
            listAccess = this.spaceService.getVisibleSpacesWithListAccess(authenticatedUser, spaceFilter);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)SPACE_FILTER_TYPE_MEMBER, (CharSequence)filterType)) {
            listAccess = this.spaceService.getMemberSpacesByFilter(authenticatedUser, spaceFilter);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)SPACE_FILTER_TYPE_MANAGER, (CharSequence)filterType)) {
            listAccess = this.spaceService.getManagerSpacesByFilter(authenticatedUser, spaceFilter);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)SPACE_FILTER_TYPE_PENDING, (CharSequence)filterType)) {
            listAccess = this.spaceService.getPendingSpacesByFilter(authenticatedUser, spaceFilter);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)SPACE_FILTER_TYPE_INVITED, (CharSequence)filterType)) {
            listAccess = this.spaceService.getInvitedSpacesByFilter(authenticatedUser, spaceFilter);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)SPACE_FILTER_TYPE_REQUESTS, (CharSequence)filterType)) {
            listAccess = this.spaceService.getPendingSpaceRequestsToManage(authenticatedUser);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)SPACE_FILTER_TYPE_FAVORITE, (CharSequence)filterType)) {
            listAccess = this.spaceService.getFavoriteSpacesByFilter(authenticatedUser, spaceFilter);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)LAST_VISITED_SPACES, (CharSequence)filterType)) {
            listAccess = this.spaceService.getLastAccessedSpace(authenticatedUser, null);
        } else {
            return Response.status((int)400).entity((Object)"Unrecognized space filter type").build();
        }
        List<Object> spaces = limit > 0 ? Arrays.asList((Space[])listAccess.load(offset, limit)) : Collections.emptyList();
        ArrayList<DataEntity> spaceInfos = new ArrayList<DataEntity>();
        for (Space space : spaces) {
            SpaceEntity spaceInfo = EntityBuilder.buildEntityFromSpace(space, authenticatedUser, uriInfo.getPath(), expand);
            spaceInfos.add(spaceInfo.getDataEntity());
        }
        CollectionEntity collectionSpace = new CollectionEntity(spaceInfos, "spaces", offset, limit);
        if (returnSize) {
            collectionSpace.setSize(listAccess.getSize());
        }
        if (StringUtils.isNotBlank((CharSequence)expand) && Arrays.asList(StringUtils.split((String)expand, (String)",")).contains("unread") && MapUtils.isNotEmpty((Map)(unreadItemsPerSpace = (spaceWebNotificationService = (SpaceWebNotificationService)ExoContainerContext.getService(SpaceWebNotificationService.class)).countUnreadItemsBySpace(authenticatedUser)))) {
            collectionSpace.setUnreadPerSpace(unreadItemsPerSpace.entrySet().stream().collect(Collectors.toMap(e -> ((Long)e.getKey()).toString(), Map.Entry::getValue)));
        }
        if ((builder = request.evaluatePreconditions(entityTag = new EntityTag(String.valueOf(Objects.hash(spaceInfos, spaceFilter, filterType, offset, limit, returnSize, expand, authenticatedUser))))) == null) {
            builder = EntityBuilder.getResponseBuilder(collectionSpace, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
            builder.tag(entityTag);
            builder.lastModified(new Date());
            builder.cacheControl(CACHE_REVALIDATE_CONTROL);
        }
        return builder.build();
    }

    @POST
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Creates a space", method="POST", description="This can only be done by the logged in user.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response createSpace(@Context UriInfo uriInfo, @Parameter(description="Asking for a full representation of a specific subresource, ex: members or managers", required=false) @QueryParam(value="expand") String expand, @RequestBody(description="Space object to be created, ex:<br />{<br />\"displayName\": \"My space\",<br />\"description\": \"This is my space\",<br />\"groupId\": \"/spaces/my_space\",<br />\"visibility\": \"private\",<br />\"subscription\": \"validation\"<br />}", required=true) SpaceEntity model) throws Exception {
        if (model == null || model.getDisplayName() == null || model.getDisplayName().length() < 3 || model.getDisplayName().length() > 200) {
            throw new SpaceException(SpaceException.Code.INVALID_SPACE_NAME);
        }
        if (this.spaceService.getSpaceByDisplayName(model.getDisplayName()) != null) {
            throw new SpaceException(SpaceException.Code.SPACE_ALREADY_EXIST);
        }
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        Space space = new Space();
        this.fillSpaceFromModel(space, model);
        space.setEditor(authenticatedUser);
        String[] managers = new String[]{authenticatedUser};
        String[] members = new String[]{authenticatedUser};
        space.setManagers(managers);
        space.setMembers(members);
        this.spaceService.createSpace(space, authenticatedUser, model.getInvitedMembers());
        return EntityBuilder.getResponse(EntityBuilder.buildEntityFromSpace(space, authenticatedUser, uriInfo.getPath(), expand), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="{spaceId}/checkExternals")
    @RolesAllowed(value={"users"})
    @Operation(summary="Checks if a specific a space contains an external members", method="GET", description="This returns the space if it contains external members")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="404", description="Resource not found"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response isSpaceContainsExternals(@Context UriInfo uriInfo, @Context Request request, @Parameter(description="Space Id", required=true) @PathParam(value="spaceId") String spaceId) {
        boolean hasExternals;
        if (spaceId == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"space Id is mandatory").build();
        }
        Space space = this.spaceService.getSpaceById(spaceId);
        if (space == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"space not found").build();
        }
        try {
            hasExternals = this.spaceService.isSpaceContainsExternals(Long.valueOf(spaceId));
        }
        catch (Exception e) {
            LOG.error("Error while checking external members on space {}", new Object[]{space.getGroupId(), e});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"server internal error occurred").build();
        }
        return Response.ok((Object)String.valueOf(hasExternals)).type("text/plain").build();
    }

    @GET
    @Path(value="{id}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Gets a specific space by id", method="GET", description="This returns the space in the following cases: <br/><ul><li>the authenticated user is a member of the space</li><li>the space is \"public\"</li><li>the authenticated user is a spaces super manager</li></ul>")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response getSpaceById(@Context UriInfo uriInfo, @Context Request request, @Parameter(description="Space id", required=true) @PathParam(value="id") String id, @Parameter(description="Asking for a full representation of a specific subresource, ex: members or managers", required=false) @QueryParam(value="expand") String expand) throws Exception {
        Space space = this.spaceService.getSpaceById(id);
        return this.buildSpaceResponse(space, expand, uriInfo, request);
    }

    @GET
    @Path(value="byPrettyName/{prettyName}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Gets a specific space by pretty name", method="GET", description="This returns the space in the following cases: <br/><ul><li>the authenticated user is a member of the space</li><li>the space is \"public\"</li><li>the authenticated user is a spaces super manager</li></ul>")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response getSpaceByPrettyName(@Context UriInfo uriInfo, @Context Request request, @Parameter(description="Space id", required=true) @PathParam(value="prettyName") String prettyName, @Parameter(description="Asking for a full representation of a specific subresource, ex: members or managers", required=false) @QueryParam(value="expand") String expand) throws Exception {
        Space space = this.spaceService.getSpaceByPrettyName(prettyName);
        return this.buildSpaceResponse(space, expand, uriInfo, request);
    }

    @GET
    @Path(value="byGroupSuffix/{groupSuffix}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Gets a specific space by its group id without /spaces/ prefix", method="GET", description="This returns the space in the following cases: <br/><ul><li>the authenticated user is a member of the space</li><li>the space is \"public\"</li><li>the authenticated user is a spaces super manager</li></ul>")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response getSpaceByGroupSuffix(@Context UriInfo uriInfo, @Context Request request, @Parameter(description="Space id", required=true) @PathParam(value="groupSuffix") String groupSuffix, @Parameter(description="Asking for a full representation of a specific subresource, ex: members or managers", required=false) @QueryParam(value="expand") String expand) {
        Space space = this.spaceService.getSpaceByGroupId("/spaces/" + groupSuffix);
        return this.buildSpaceResponse(space, expand, uriInfo, request);
    }

    @GET
    @Path(value="byDisplayName/{displayName}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Gets a specific space by display name", method="GET", description="This returns the space in the following cases: <br/><ul><li>the authenticated user is a member of the space</li><li>the space is \"public\"</li><li>the authenticated user is a spaces super manager</li></ul>")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response getSpaceByDisplayName(@Context UriInfo uriInfo, @Context Request request, @Parameter(description="Space id", required=true) @PathParam(value="displayName") String displayName, @Parameter(description="Asking for a full representation of a specific subresource, ex: members or managers", required=false) @QueryParam(value="expand") String expand) throws Exception {
        Space space = this.spaceService.getSpaceByDisplayName(displayName);
        return this.buildSpaceResponse(space, expand, uriInfo, request);
    }

    @GET
    @Path(value="{id}/avatar")
    @Operation(summary="Gets a space avatar by pretty name", method="GET", description="This can only be done by the logged in user.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response getSpaceAvatarById(@Context UriInfo uriInfo, @Context Request request, @Parameter(description="The value of lastModified parameter will determine whether the query should be cached by browser or not. If not set, no 'expires HTTP Header will be sent'") @QueryParam(value="lastModified") String lastModified, @Parameter(description="Space pretty name or space id", required=true) @PathParam(value="id") String id, @Parameter(description="Whether to retrieve avatar by id or pretty name", required=false) @DefaultValue(value="false") @QueryParam(value="byId") boolean byId, @Parameter(description="Resized avatar size. Use 0x0 for original size.") @DefaultValue(value="100x100") @QueryParam(value="size") String size, @Parameter(description="A mandatory valid token that is used to authorize anonymous request", required=false) @QueryParam(value="r") String token) throws IOException {
        boolean isDefault = StringUtils.equals((CharSequence)"default-image", (CharSequence)id);
        Response.ResponseBuilder builder = null;
        Long lastUpdated = null;
        EntityTag eTag = null;
        if (!isDefault) {
            Space space;
            if (RestUtils.isAnonymous() && !LinkProvider.isAttachmentTokenValid((String)token, (String)"space", (String)id, (String)"avatar", (String)lastModified)) {
                LOG.warn("An anonymous user attempts to access avatar of space {} without a valid access token", new Object[]{id});
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            String authenticatedUser = RestUtils.getCurrentUser();
            Space space2 = space = byId ? this.spaceService.getSpaceById(id) : this.spaceService.getSpaceByPrettyName(id);
            if (space == null || "hidden".equals(space.getVisibility()) && !this.spaceService.canViewSpace(space, authenticatedUser)) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            Identity identity = this.identityManager.getOrCreateIdentity("space", space.getPrettyName());
            Profile profile = identity.getProfile();
            if (profile != null) {
                lastUpdated = profile.getAvatarLastUpdated();
            }
            if (lastUpdated != null) {
                eTag = new EntityTag(lastUpdated.hashCode() + "-" + size);
            }
            Response.ResponseBuilder responseBuilder = builder = eTag == null ? null : request.evaluatePreconditions(eTag);
            if (builder == null) {
                int[] dimension = Utils.parseDimension((String)size);
                try {
                    byte[] avatarContent = null;
                    if (this.identityManager.getAvatarFile(identity) != null) {
                        avatarContent = this.imageThumbnailService.getOrCreateThumbnail(this.identityManager.getAvatarFile(identity), dimension[0], dimension[1]).getAsByte();
                    }
                    if (avatarContent != null) {
                        builder = Response.ok(avatarContent, (String)"image/png");
                    }
                }
                catch (Exception e) {
                    LOG.error("Error while resizing avatar of space identity with Id {}, original Image will be returned", new Object[]{identity.getId(), e});
                }
            }
        }
        if (builder == null) {
            builder = this.getDefaultAvatarBuilder();
        }
        builder.cacheControl(CACHE_CONTROL);
        builder.lastModified(lastUpdated == null ? DEFAULT_IMAGES_LAST_MODIFED : new Date(lastUpdated));
        if (eTag != null) {
            builder.tag(eTag);
        }
        if (StringUtils.isNotBlank((CharSequence)lastModified)) {
            builder.expires(new Date(System.currentTimeMillis() + 604800000L));
        }
        return builder.build();
    }

    @GET
    @Path(value="{id}/banner")
    @Operation(summary="Gets a space banner by id", method="GET", description="This can only be done by the logged in user.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response getSpaceBannerById(@Context UriInfo uriInfo, @Context Request request, @Parameter(description="The value of lastModified parameter will determine whether the query should be cached by browser or not. If not set, no 'expires HTTP Header will be sent'") @QueryParam(value="lastModified") String lastModified, @Parameter(description="Space id", required=true) @PathParam(value="id") String id, @Parameter(description="Whether to retrieve banner by id or pretty name", required=false) @DefaultValue(value="false") @QueryParam(value="byId") boolean byId, @Parameter(description="A mandatory valid token that is used to authorize anonymous request", required=false) @QueryParam(value="r") String token) throws IOException {
        Response.ResponseBuilder builder;
        Space space;
        boolean isDefault = StringUtils.equals((CharSequence)"default-image", (CharSequence)id);
        if (isDefault) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (RestUtils.isAnonymous() && !LinkProvider.isAttachmentTokenValid((String)token, (String)"space", (String)id, (String)"banner", (String)lastModified)) {
            LOG.warn("An anonymous user attempts to access banner of space {} without a valid access token", new Object[]{id});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        String authenticatedUser = RestUtils.getCurrentUser();
        Space space2 = space = byId ? this.spaceService.getSpaceById(id) : this.spaceService.getSpaceByPrettyName(id);
        if (space == null || "hidden".equals(space.getVisibility()) && !this.spaceService.canViewSpace(space, authenticatedUser)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Identity identity = this.identityManager.getOrCreateIdentity("space", space.getPrettyName());
        Profile profile = identity.getProfile();
        Long lastUpdated = null;
        if (profile != null) {
            lastUpdated = profile.getBannerLastUpdated();
        }
        EntityTag eTag = null;
        if (lastUpdated != null) {
            eTag = new EntityTag(Integer.toString(lastUpdated.hashCode()));
        }
        Response.ResponseBuilder responseBuilder = builder = eTag == null ? null : request.evaluatePreconditions(eTag);
        if (builder == null) {
            InputStream stream = this.identityManager.getBannerInputStream(identity);
            if (stream == null) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            builder = Response.ok((Object)stream, (String)"image/png");
            builder.tag(eTag);
        }
        builder.cacheControl(CACHE_CONTROL);
        builder.lastModified(lastUpdated == null ? DEFAULT_IMAGES_LAST_MODIFED : new Date(lastUpdated));
        if (StringUtils.isNotBlank((CharSequence)lastModified)) {
            builder.expires(new Date(System.currentTimeMillis() + 604800000L));
        }
        return builder.build();
    }

    @PUT
    @Path(value="{id}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Updates a specific space by id", method="PUT", description="This updates the space in the following cases: <br/><ul><li>the authenticated user is a manager of the space</li><li>the authenticated user is the owner of the space</li><li>the authenticated user is a spaces super manager</li></ul>")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response updateSpaceById(@Context UriInfo uriInfo, @Parameter(description="Space id", required=true) @PathParam(value="id") String id, @Parameter(description="Asking for a full representation of a specific subresource, ex: members or managers", required=false) @QueryParam(value="expand") String expand, @RequestBody(description="Space object to be updated", required=true) SpaceEntity model) throws Exception {
        if (model == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        Space space = this.spaceService.getSpaceById(id);
        if (!this.spaceService.canManageSpace(space, authenticatedUser)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        if (model.getDisplayName() != null && (model.getDisplayName().length() < 3 || model.getDisplayName().length() > 200)) {
            throw new SpaceException(SpaceException.Code.INVALID_SPACE_NAME);
        }
        if (StringUtils.isNotBlank((CharSequence)model.getPublicSiteVisibility())) {
            this.spaceService.saveSpacePublicSite(id, model.getPublicSiteVisibility(), authenticatedUser);
            space = this.spaceService.getSpaceById(id);
        }
        if (StringUtils.isNotBlank((CharSequence)model.getDisplayName()) && !StringUtils.equals((CharSequence)space.getDisplayName(), (CharSequence)model.getDisplayName())) {
            this.spaceService.renameSpace(space, model.getDisplayName(), authenticatedUser);
        }
        if (model.getExternalInvitedUsers() != null && (this.securitySettingService.getRegistrationType() == UserRegistrationType.OPEN || this.securitySettingService.isRegistrationExternalUser())) {
            String uri = uriInfo.getBaseUri().toString().substring(0, uriInfo.getBaseUri().toString().lastIndexOf("/"));
            StringBuilder url = new StringBuilder(uri);
            PasswordRecoveryService passwordRecoveryService = (PasswordRecoveryService)CommonsUtils.getService(PasswordRecoveryService.class);
            LocaleConfigService localeConfigService = (LocaleConfigService)CommonsUtils.getService(LocaleConfigService.class);
            Locale locale = null;
            try {
                String defaultLanguage = localeConfigService.getDefaultLocaleConfig().getLocale().toLanguageTag();
                locale = new Locale(defaultLanguage);
            }
            catch (Exception e) {
                LOG.error((Object)"Failure to retrieve portal config", (Throwable)e);
            }
            for (String externalInvitedUser : model.getExternalInvitedUsers()) {
                String tokenId = passwordRecoveryService.sendExternalRegisterEmail(authenticatedUser, externalInvitedUser, locale, space.getDisplayName(), url);
                this.spaceService.saveSpaceExternalInvitation(space.getId(), externalInvitedUser, tokenId);
            }
        }
        this.fillSpaceFromModel(space, model);
        space.setEditor(authenticatedUser);
        this.spaceService.updateSpace(space, model.getInvitedMembers());
        return EntityBuilder.getResponse(EntityBuilder.buildEntityFromSpace(this.spaceService.getSpaceById(id), authenticatedUser, uriInfo.getPath(), expand), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @DELETE
    @Path(value="{id}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Deletes a specific space by id", method="DELETE", description="This deletes the space in the following cases: <br/><ul><li>the authenticated user is a manager of the space</li><li>the authenticated user is the owner of the space</li><li>the authenticated user is a spaces super manager</li></ul>")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response deleteSpaceById(@Context UriInfo uriInfo, @Parameter(description="Space id", required=true) @PathParam(value="id") String id, @Parameter(description="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand) throws Exception {
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        Space space = this.spaceService.getSpaceById(id);
        if (!this.spaceService.canManageSpace(space, authenticatedUser)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        space.setEditor(authenticatedUser);
        this.spaceService.deleteSpace(space);
        return Response.ok().build();
    }

    @GET
    @Path(value="{id}/users")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @Operation(summary="Gets users of a specific space", method="GET", description="This returns a list of users if the authenticated user is a member or manager of the space or a spaces super manager.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    @Deprecated(forRemoval=true, since="7.0")
    @DeprecatedAPI(value="Use SpaceMembershipRest.getSpacesMemberships instead", insist=true)
    public Response getSpaceMembers(@Context UriInfo uriInfo, @Context Request request, @Parameter(description="Space id", required=true) @PathParam(value="id") String id, @Parameter(description="User name search information", required=false) @QueryParam(value="q") String q, @Parameter(description="Role of the target user in this space: manager, member, invited and pending", required=false) @Schema(defaultValue="member") @QueryParam(value="role") String role, @Parameter(description="Offset", required=false) @Schema(defaultValue="0") @QueryParam(value="offset") int offset, @Parameter(description="Limit", required=false) @Schema(defaultValue="20") @QueryParam(value="limit") int limit, @Parameter(description="Returning the number of users or not") @Schema(defaultValue="false") @QueryParam(value="returnSize") boolean returnSize, @Parameter(description="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand) throws Exception {
        UriInfo uriInfo2 = uriInfo;
        Request request2 = request;
        String string = id;
        String string2 = q;
        String string3 = role;
        int n = offset;
        int n2 = limit;
        boolean bl = returnSize;
        String string4 = expand;
        Object[] objectArray = new Object[]{uriInfo2, request2, string, string2, string3, Conversions.intObject((int)n), Conversions.intObject((int)n2), Conversions.booleanObject((boolean)bl), string4};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, uriInfo2, request2, string, string2, string3, Conversions.intObject((int)n), Conversions.intObject((int)n2), Conversions.booleanObject((boolean)bl), string4, joinPoint};
        SpaceRest$AjcClosure1 spaceRest$AjcClosure1 = new SpaceRest$AjcClosure1(objectArray2);
        return (Response)DeprecatedAPIAspect.aspectOf().around(spaceRest$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{id}/users/{userId}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Checks if the given user is a member of a specific space or not", method="GET", description="This Checks if user is a member of a specific spacer o not.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    @Deprecated(forRemoval=true, since="7.0")
    @DeprecatedAPI(value="Use SpaceMembershipRest.getSpacesMemberships instead", insist=true)
    public Response isSpaceMember(@Context UriInfo uriInfo, @Parameter(description="Space id", required=true) @PathParam(value="id") String id, @Parameter(description="User id", required=true) @PathParam(value="userId") String userId) {
        UriInfo uriInfo2 = uriInfo;
        String string = id;
        String string2 = userId;
        Object[] objectArray = new Object[]{uriInfo2, string, string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, uriInfo2, string, string2, joinPoint};
        SpaceRest$AjcClosure3 spaceRest$AjcClosure3 = new SpaceRest$AjcClosure3(objectArray2);
        return (Response)DeprecatedAPIAspect.aspectOf().around(spaceRest$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    @GET
    @Path(value="{id}/navigations")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @Operation(summary="Return list of navigations of a space", method="GET", description="Return list of navigations of a space")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="401", description="Unauthorized")})
    @Deprecated(forRemoval=true, since="7.0")
    @DeprecatedAPI(value="Use NavigationRest.getSiteTypeNavigations instead", insist=true)
    public Response getSpaceNavigations(@Context HttpServletRequest httpRequest, @Context Request request, @Parameter(description="Space id", required=true) @PathParam(value="id") String spaceId) {
        HttpServletRequest httpServletRequest = httpRequest;
        Request request2 = request;
        String string = spaceId;
        Object[] objectArray = new Object[]{httpServletRequest, request2, string};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, httpServletRequest, request2, string, joinPoint};
        SpaceRest$AjcClosure5 spaceRest$AjcClosure5 = new SpaceRest$AjcClosure5(objectArray2);
        return (Response)DeprecatedAPIAspect.aspectOf().around(spaceRest$AjcClosure5.linkClosureAndJoinPoint(69648));
    }

    @PUT
    @Path(value="layout/{appId}/{spaceId}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Restores space Page Layout switch associated space template", method="PUT", description="This operation will restores the default page layout of a designated space switch its space template as if it was a new space creation.The applications data will not be change, only the layout definition and structure of the page.This endpoint is accessible only for spaces managers.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="401", description="User not authorized to call this endpoint"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response restoreSpacePageLayout(@Context UriInfo uriInfo, @Parameter(description="Space application identifier to reset. Can be 'home' or any page name.", required=true) @PathParam(value="appId") String appId, @Parameter(description="Space technical identifier", required=true) @PathParam(value="spaceId") String spaceId) {
        try {
            this.spaceService.restoreSpacePageLayout(spaceId, appId, ConversationState.getCurrent().getIdentity());
            return Response.ok().build();
        }
        catch (IllegalAccessException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (SpaceException e) {
            return Response.serverError().entity((Object)e.getLocalizedMessage()).build();
        }
    }

    @GET
    @Path(value="{id}/activities")
    @RolesAllowed(value={"users"})
    @Operation(summary="Gets space activities by space id", method="GET", description="This returns the space's activities if the authenticated user is a member of the space or a spaces super manager.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    @Deprecated
    @DeprecatedAPI(value="Use activityRestResourcesV1.getActivities instead", insist=true)
    public Response getSpaceActivitiesById(@Context UriInfo uriInfo, @Parameter(description="Space id", required=true) @PathParam(value="id") String id, @Parameter(description="Offset") @Schema(defaultValue="0") @QueryParam(value="offset") int offset, @Parameter(description="Limit") @Schema(defaultValue="20") @QueryParam(value="limit") int limit, @Parameter(description="Base time to load older activities (yyyy-MM-dd HH:mm:ss)") @QueryParam(value="before") String before, @Parameter(description="Base time to load newer activities (yyyy-MM-dd HH:mm:ss)") @QueryParam(value="after") String after, @Parameter(description="Returning the number of activities or not") @Schema(defaultValue="false") @QueryParam(value="returnSize") boolean returnSize, @Parameter(description="Asking for a full representation of a specific subresource, ex: comments or likes") @QueryParam(value="expand") String expand) {
        UriInfo uriInfo2 = uriInfo;
        String string = id;
        int n = offset;
        int n2 = limit;
        String string2 = before;
        String string3 = after;
        boolean bl = returnSize;
        String string4 = expand;
        Object[] objectArray = new Object[]{uriInfo2, string, Conversions.intObject((int)n), Conversions.intObject((int)n2), string2, string3, Conversions.booleanObject((boolean)bl), string4};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, uriInfo2, string, Conversions.intObject((int)n), Conversions.intObject((int)n2), string2, string3, Conversions.booleanObject((boolean)bl), string4, joinPoint};
        SpaceRest$AjcClosure7 spaceRest$AjcClosure7 = new SpaceRest$AjcClosure7(objectArray2);
        return (Response)DeprecatedAPIAspect.aspectOf().around(spaceRest$AjcClosure7.linkClosureAndJoinPoint(69648));
    }

    @POST
    @Path(value="{id}/activities")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Posts an activity to a specific space", method="POST", description="This posts the activity if the authenticated user is a member of the space or a spaces super manager.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    @Deprecated
    @DeprecatedAPI(value="Use activityRestResourcesV1.postActivity instead", insist=true)
    public Response postActivityOnSpace(@Context UriInfo uriInfo, @Parameter(description="Space id", required=true) @PathParam(value="id") String id, @Parameter(description="Asking for a full representation of a specific subresource, ex: comments or likes", required=false) @QueryParam(value="expand") String expand, @Parameter(description="Activity object to be created", required=true) ActivityEntity model) {
        UriInfo uriInfo2 = uriInfo;
        String string = id;
        String string2 = expand;
        ActivityEntity activityEntity = model;
        Object[] objectArray = new Object[]{uriInfo2, string, string2, activityEntity};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, uriInfo2, string, string2, activityEntity, joinPoint};
        SpaceRest$AjcClosure9 spaceRest$AjcClosure9 = new SpaceRest$AjcClosure9(objectArray2);
        return (Response)DeprecatedAPIAspect.aspectOf().around(spaceRest$AjcClosure9.linkClosureAndJoinPoint(69648));
    }

    private void fillSpaceFromModel(Space space, SpaceEntity model) throws IOException {
        space.setPriority("2");
        if (StringUtils.isNotBlank((CharSequence)model.getDisplayName())) {
            space.setDisplayName(model.getDisplayName());
            space.setDescription(model.getDescription());
            if (StringUtils.isBlank((CharSequence)space.getPrettyName())) {
                space.setPrettyName(model.getDisplayName());
            }
        } else if (StringUtils.isNotBlank((CharSequence)model.getPrettyName())) {
            space.setPrettyName(model.getPrettyName());
            space.setDescription(model.getDescription());
            if (StringUtils.isBlank((CharSequence)space.getDisplayName())) {
                space.setDisplayName(model.getPrettyName());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)model.getTemplate())) {
            space.setTemplate(model.getTemplate());
        }
        if (StringUtils.isNotBlank((CharSequence)model.getBannerId())) {
            this.updateProfileField(space, "banner", model.getBannerId());
        }
        if (StringUtils.isNotBlank((CharSequence)model.getAvatarId())) {
            this.updateProfileField(space, "avatar", model.getAvatarId());
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)"hidden", (CharSequence)model.getVisibility())) {
            space.setVisibility("hidden");
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"private", (CharSequence)model.getVisibility())) {
            space.setVisibility("private");
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"public", (CharSequence)model.getVisibility())) {
            space.setVisibility("public");
        } else if (StringUtils.isBlank((CharSequence)model.getVisibility()) && space.getId() == null) {
            space.setVisibility("private");
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)"open", (CharSequence)model.getSubscription())) {
            space.setRegistration("open");
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"closed", (CharSequence)model.getSubscription())) {
            space.setRegistration("closed");
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"validation", (CharSequence)model.getSubscription())) {
            space.setRegistration("validation");
        } else if (StringUtils.isBlank((CharSequence)model.getSubscription()) && space.getId() == null) {
            space.setRegistration("validation");
        }
    }

    @GET
    @Path(value="{id}/externalInvitations")
    @RolesAllowed(value={"users"})
    @Operation(summary="Gets external invitations of a specific space", method="GET", description="This returns a list of external invitations if the authenticated user is a member or manager of the space or a spaces super manager.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response getSpaceExternalInvitations(@Context UriInfo uriInfo, @Parameter(description="Space id", required=true) @PathParam(value="id") String id) {
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        Space space = this.spaceService.getSpaceById(id);
        if (!this.spaceService.canManageSpace(space, authenticatedUser)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        List spaceExternalInvitations = this.spaceService.findSpaceExternalInvitationsBySpaceId(id);
        return EntityBuilder.getResponseBuilder(spaceExternalInvitations, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK).build();
    }

    @DELETE
    @Path(value="externalInvitations/{invitationId}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Delete a specific external invitation from a specific space", method="DELETE", description="This Delete a specific external invitation from a specific space if the authenticated user is a member or manager of the space or a spaces super manager.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response declineExternalInvitations(@Context UriInfo uriInfo, @Parameter(description="invitation id", required=true) @PathParam(value="invitationId") String invitationId) {
        SpaceExternalInvitation spaceExternalInvitation = this.spaceService.getSpaceExternalInvitationById(invitationId);
        if (spaceExternalInvitation == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        Space space = this.spaceService.getSpaceById(spaceExternalInvitation.getSpaceId());
        if (space == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        if (!this.spaceService.canManageSpace(space, authenticatedUser)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        try {
            this.spaceService.deleteSpaceExternalInvitation(invitationId);
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while deleting invitation", (Throwable)e);
            return Response.serverError().build();
        }
        return Response.noContent().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateProfileField(Space space, String name, String value) throws IOException {
        if ("banner".equals(name) && StringUtils.equals((CharSequence)value, (CharSequence)"DEFAULT_BANNER")) {
            space.setBannerAttachment(null);
            this.spaceService.updateSpaceBanner(space, RestUtils.getCurrentUser());
        } else if ("avatar".equals(name) || "banner".equals(name)) {
            UploadResource uploadResource = this.uploadService.getUploadResource(value);
            if (uploadResource == null) {
                throw new IllegalStateException("No uploaded resource found with uploadId = " + value);
            }
            String storeLocation = uploadResource.getStoreLocation();
            try (FileInputStream inputStream = new FileInputStream(storeLocation);){
                if ("avatar".equals(name)) {
                    AvatarAttachment attachment = new AvatarAttachment(null, uploadResource.getFileName(), uploadResource.getMimeType(), (InputStream)inputStream, System.currentTimeMillis());
                    space.setAvatarAttachment(attachment);
                    this.spaceService.updateSpaceAvatar(space, RestUtils.getCurrentUser());
                } else {
                    BannerAttachment attachment = new BannerAttachment(null, uploadResource.getFileName(), uploadResource.getMimeType(), (InputStream)inputStream, System.currentTimeMillis());
                    space.setBannerAttachment(attachment);
                    this.spaceService.updateSpaceBanner(space, RestUtils.getCurrentUser());
                }
            }
            finally {
                this.uploadService.removeUploadResource(value);
            }
        }
    }

    private Response.ResponseBuilder getDefaultAvatarBuilder() throws IOException {
        if (this.defaultSpaceAvatar == null) {
            InputStream is = PortalContainer.getInstance().getPortalContext().getResourceAsStream("/skin/images/avatar/DefaultSpaceAvatar.png");
            this.defaultSpaceAvatar = is == null ? new byte[0] : IOUtil.getStreamContentAsBytes((InputStream)is);
        }
        return Response.ok((Object)new ByteArrayInputStream(this.defaultSpaceAvatar), (String)"image/png");
    }

    private Response buildSpaceResponse(Space space, String expand, UriInfo uriInfo, Request request) {
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        if (space == null || "hidden".equals(space.getVisibility()) && !this.spaceService.canViewSpace(space, authenticatedUser)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        long cacheTime = space.getCacheTime();
        String eTagValue = String.valueOf(Objects.hash(cacheTime, authenticatedUser, expand));
        EntityTag eTag = new EntityTag(eTagValue, true);
        Response.ResponseBuilder builder = request.evaluatePreconditions(eTag);
        if (builder == null) {
            SpaceEntity spaceEntity = EntityBuilder.buildEntityFromSpace(space, authenticatedUser, uriInfo.getPath(), expand);
            builder = Response.ok((Object)spaceEntity.getDataEntity(), (String)"application/json");
            builder.tag(eTag);
            builder.lastModified(new Date(cacheTime));
            builder.expires(new Date(cacheTime));
        }
        return builder.build();
    }

    static {
        SpaceRest.ajc$preClinit();
        LOG = ExoLogger.getLogger(SpaceRest.class);
        CACHE_CONTROL = new CacheControl();
        CACHE_REVALIDATE_CONTROL = new CacheControl();
        DEFAULT_IMAGES_LAST_MODIFED = new Date();
    }

    static final /* synthetic */ Response getSpaceMembers_aroundBody0(SpaceRest ajc$this, UriInfo uriInfo, Request request, String id, String q, String role, int offset, int limit, boolean returnSize, String expand, JoinPoint joinPoint) {
        String eTagValue;
        EntityTag eTag;
        Response.ResponseBuilder builder;
        offset = offset > 0 ? offset : RestUtils.getOffset(uriInfo);
        limit = limit > 0 ? limit : RestUtils.getLimit(uriInfo);
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        Space space = ajc$this.spaceService.getSpaceById(id);
        if (!ajc$this.spaceService.canViewSpace(space, authenticatedUser)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        long cacheTime = space.getCacheTime();
        if (StringUtils.isBlank((CharSequence)role)) {
            role = SpaceMemberFilterListAccess.Type.MEMBER.name();
        }
        SpaceMemberFilterListAccess.Type type = SpaceMemberFilterListAccess.Type.valueOf((String)role.toUpperCase());
        ProfileFilter profileFilter = new ProfileFilter();
        profileFilter.setName(q);
        ListAccess spaceIdentitiesListAccess = ajc$this.identityManager.getSpaceIdentityByProfileFilter(space, profileFilter, type, true);
        Identity[] spaceIdentities = (Identity[])spaceIdentitiesListAccess.load(offset, limit);
        List<Object> profileInfos = null;
        profileInfos = spaceIdentities == null || spaceIdentities.length == 0 ? Collections.emptyList() : Arrays.stream(spaceIdentities).map(identity -> EntityBuilder.buildEntityProfile(space, identity.getProfile(), uriInfo.getPath(), expand).getDataEntity()).toList();
        CollectionEntity collectionUser = new CollectionEntity(profileInfos, "users", offset, limit);
        if (returnSize) {
            collectionUser.setSize(spaceIdentitiesListAccess.getSize());
        }
        if ((builder = request.evaluatePreconditions(eTag = new EntityTag(eTagValue = String.valueOf(Objects.hash(collectionUser.hashCode(), authenticatedUser, expand))))) == null) {
            builder = Response.ok((Object)collectionUser, (String)"application/json");
            builder.tag(eTag);
            builder.lastModified(new Date(cacheTime));
            builder.expires(new Date(cacheTime));
        }
        return builder.build();
    }

    static final /* synthetic */ Response isSpaceMember_aroundBody2(SpaceRest ajc$this, UriInfo uriInfo, String id, String userId, JoinPoint joinPoint) {
        Space space = ajc$this.spaceService.getSpaceById(id);
        if (space == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        boolean isMember = ajc$this.spaceService.isMember(space, userId);
        return Response.ok().entity((Object)("{\"isMember\":\"" + isMember + "\"}")).build();
    }

    static final /* synthetic */ Response getSpaceNavigations_aroundBody4(SpaceRest ajc$this, HttpServletRequest httpRequest, Request request, String spaceId, JoinPoint joinPoint) {
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        Space space = ajc$this.spaceService.getSpaceById(spaceId);
        if (!ajc$this.spaceService.canViewSpace(space, authenticatedUser)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        List navigations = SpaceUtils.getSpaceNavigations((Space)space, (Locale)httpRequest.getLocale(), (String)authenticatedUser);
        if (CollectionUtils.isEmpty((Collection)navigations)) {
            return Response.ok(Collections.emptyList()).build();
        }
        List<DataEntity> spaceNavigations = navigations.stream().map(node -> {
            Page navigationNodePage;
            BaseEntity app = new BaseEntity(node.getId());
            app.setProperty("label", node.getResolvedLabel());
            app.setProperty("icon", node.getIcon());
            app.setProperty("uri", node.getURI());
            app.setProperty("target", node.getTarget());
            if (node.getPageRef() != null && PageType.LINK.equals((Object)PageType.valueOf((String)(navigationNodePage = SpaceUtils.getLayoutService().getPage(node.getPageRef())).getType()))) {
                app.setProperty("link", navigationNodePage.getLink());
            }
            return app.getDataEntity();
        }).toList();
        return Response.ok(spaceNavigations, (String)"application/json").build();
    }

    static final /* synthetic */ Response getSpaceActivitiesById_aroundBody6(SpaceRest ajc$this, UriInfo uriInfo, String id, int offset, int limit, String before, String after, boolean returnSize, String expand, JoinPoint joinPoint) {
        return ajc$this.activityRestResourcesV1.getActivities(uriInfo, id, before, after, offset, limit, returnSize, expand, null);
    }

    static final /* synthetic */ Response postActivityOnSpace_aroundBody8(SpaceRest ajc$this, UriInfo uriInfo, String id, String expand, ActivityEntity model, JoinPoint joinPoint) {
        return ajc$this.activityRestResourcesV1.postActivity(uriInfo, id, expand, model);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SpaceRest.java", SpaceRest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSpaceMembers", "org.exoplatform.social.rest.impl.space.SpaceRest", "javax.ws.rs.core.UriInfo:javax.ws.rs.core.Request:java.lang.String:java.lang.String:java.lang.String:int:int:boolean:java.lang.String", "uriInfo:request:id:q:role:offset:limit:returnSize:expand", "java.lang.Exception", "javax.ws.rs.core.Response"), 912);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isSpaceMember", "org.exoplatform.social.rest.impl.space.SpaceRest", "javax.ws.rs.core.UriInfo:java.lang.String:java.lang.String", "uriInfo:id:userId", "", "javax.ws.rs.core.Response"), 998);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSpaceNavigations", "org.exoplatform.social.rest.impl.space.SpaceRest", "jakarta.servlet.http.HttpServletRequest:javax.ws.rs.core.Request:java.lang.String", "httpRequest:request:spaceId", "", "javax.ws.rs.core.Response"), 1025);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSpaceActivitiesById", "org.exoplatform.social.rest.impl.space.SpaceRest", "javax.ws.rs.core.UriInfo:java.lang.String:int:int:java.lang.String:java.lang.String:boolean:java.lang.String", "uriInfo:id:offset:limit:before:after:returnSize:expand", "", "javax.ws.rs.core.Response"), 1127);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "postActivityOnSpace", "org.exoplatform.social.rest.impl.space.SpaceRest", "javax.ws.rs.core.UriInfo:java.lang.String:java.lang.String:org.exoplatform.social.rest.entity.ActivityEntity", "uriInfo:id:expand:model", "", "javax.ws.rs.core.Response"), 1159);
    }
}

