/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.impl.favorite;

import java.util.List;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.jpa.storage.dao.jpa.MetadataDAO;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.metadata.storage.MetadataStorage;
import org.exoplatform.social.core.plugin.ActivityFavoriteACLPlugin;
import org.exoplatform.social.core.plugin.SpaceFavoriteACLPlugin;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.metadata.FavoriteACLPlugin;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.MetadataTypePlugin;
import org.exoplatform.social.metadata.favorite.FavoriteService;
import org.exoplatform.social.metadata.favorite.model.Favorite;
import org.exoplatform.social.metadata.model.MetadataItem;
import org.exoplatform.social.metadata.model.MetadataKey;
import org.exoplatform.social.metadata.model.MetadataObject;
import org.exoplatform.social.metadata.model.MetadataType;
import org.exoplatform.social.rest.impl.favorite.FavoriteEntity;
import org.exoplatform.social.rest.impl.favorite.FavoriteRest;
import org.exoplatform.social.service.test.AbstractResourceTest;

public class FavoriteRestTest
extends AbstractResourceTest {
    private Identity johnIdentity;
    private Identity maryIdentity;
    private MetadataService metadataService;
    private FavoriteService favoriteService;
    private SpaceService spaceService;
    private ActivityManager activityManager;
    private MetadataDAO metadataDAO;
    private MetadataType favoriteMetadataType;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.identityManager = (IdentityManager)this.getContainer().getComponentInstanceOfType(IdentityManager.class);
        this.metadataService = (MetadataService)this.getContainer().getComponentInstanceOfType(MetadataService.class);
        this.favoriteService = (FavoriteService)this.getContainer().getComponentInstanceOfType(FavoriteService.class);
        this.metadataDAO = (MetadataDAO)this.getContainer().getComponentInstanceOfType(MetadataDAO.class);
        this.spaceService = (SpaceService)this.getContainer().getComponentInstanceOfType(SpaceService.class);
        this.activityManager = (ActivityManager)this.getContainer().getComponentInstanceOfType(ActivityManager.class);
        this.favoriteMetadataType = new MetadataType(1L, "favorites");
        ((MetadataStorage)this.getContainer().getComponentInstanceOfType(MetadataStorage.class)).clearCaches();
        try {
            InitParams params = new InitParams();
            ObjectParameter parameter = new ObjectParameter();
            parameter.setName("metadataType");
            parameter.setObject((Object)FavoriteService.METADATA_TYPE);
            params.addParameter((Parameter)parameter);
            this.metadataService.addMetadataTypePlugin(new MetadataTypePlugin(params));
            SpaceFavoriteACLPlugin favoriteACLPlugin = new SpaceFavoriteACLPlugin(this.spaceService, this.identityManager);
            ActivityFavoriteACLPlugin favoriteACLPlugin1 = new ActivityFavoriteACLPlugin(this.activityManager);
            this.favoriteService.addFavoriteACLPlugin((FavoriteACLPlugin)favoriteACLPlugin);
            this.favoriteService.addFavoriteACLPlugin((FavoriteACLPlugin)favoriteACLPlugin1);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.registry(new FavoriteRest(this.favoriteService));
        this.johnIdentity = this.identityManager.getOrCreateUserIdentity("john");
        this.maryIdentity = this.identityManager.getOrCreateUserIdentity("mary");
    }

    @Override
    public void tearDown() throws Exception {
        this.restartTransaction();
        this.identityManager.hardDeleteIdentity(this.johnIdentity);
        this.metadataDAO.deleteAll();
        super.tearDown();
    }

    public void testCreateFavorites() throws Exception {
        String objectType = "objectType";
        String objectId = "objectId";
        String parentObjectId = "parentObjectId";
        long userIdentityId = Long.parseLong(this.johnIdentity.getId());
        this.startSessionAs(this.johnIdentity.getRemoteId());
        ContainerResponse response = this.getResponse("POST", this.getURLResource("favorites/" + objectType + "/" + objectId) + "?parentObjectId=" + parentObjectId, null);
        FavoriteRestTest.assertEquals((int)204, (int)response.getStatus());
        response = this.getResponse("POST", this.getURLResource("favorites/" + objectType + "/" + objectId), null);
        FavoriteRestTest.assertEquals((int)409, (int)response.getStatus());
        response = this.getResponse("POST", this.getURLResource("favorites/" + objectType + "/" + objectId) + "?ignoreWhenExisting=true", null);
        FavoriteRestTest.assertEquals((int)204, (int)response.getStatus());
        response = this.getResponse("POST", this.getURLResource("favorites/" + objectType + "/" + objectId) + "?parentObjectId=" + parentObjectId + "&ignoreWhenExisting=true", null);
        FavoriteRestTest.assertEquals((int)204, (int)response.getStatus());
        List metadataItemsByObject = this.metadataService.getMetadataItemsByObject(new MetadataObject(objectType, objectId));
        FavoriteRestTest.assertEquals((int)1, (int)metadataItemsByObject.size());
        MetadataItem metadataItem = (MetadataItem)metadataItemsByObject.get(0);
        FavoriteRestTest.assertEquals((long)userIdentityId, (long)metadataItem.getCreatorId());
        FavoriteRestTest.assertEquals((String)objectId, (String)metadataItem.getObjectId());
        FavoriteRestTest.assertEquals((String)objectType, (String)metadataItem.getObjectType());
        FavoriteRestTest.assertEquals((String)parentObjectId, (String)metadataItem.getParentObjectId());
    }

    public void testCreateFavoritesACL() throws Exception {
        Space space1 = new Space();
        space1.setDisplayName("space1");
        space1.setRegistration("validation");
        space1.setVisibility("public");
        space1 = this.spaceService.createSpace(space1, this.johnIdentity.getRemoteId());
        Space createdSpace = this.spaceService.getSpaceByPrettyName(space1.getPrettyName());
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setUserId(this.johnIdentity.getId());
        activity.setTitle("activity 1");
        Identity spaceIdentity = this.identityManager.getOrCreateSpaceIdentity(space1.getPrettyName());
        this.activityManager.saveActivityNoReturn(spaceIdentity, (ExoSocialActivity)activity);
        this.startSessionAs(this.maryIdentity.getRemoteId());
        ContainerResponse response = this.getResponse("POST", this.getURLResource("favorites/space/" + createdSpace.getId()) + "?parentObjectId=parentObjectId", null);
        FavoriteRestTest.assertEquals((int)401, (int)response.getStatus());
        response = this.getResponse("POST", this.getURLResource("favorites/activity/" + activity.getId()) + "?parentObjectId=parentObjectId", null);
        FavoriteRestTest.assertEquals((int)401, (int)response.getStatus());
        this.spaceService.addMember(space1, this.maryIdentity.getRemoteId());
        response = this.getResponse("POST", this.getURLResource("favorites/space/" + createdSpace.getId()) + "?parentObjectId=parentObjectId", null);
        FavoriteRestTest.assertEquals((int)204, (int)response.getStatus());
        response = this.getResponse("POST", this.getURLResource("favorites/activity/" + activity.getId()) + "?parentObjectId=parentObjectId", null);
        FavoriteRestTest.assertEquals((int)204, (int)response.getStatus());
    }

    public void testDeleteFavorite() throws Exception {
        String objectType = "objectType";
        String objectId = "objectId";
        this.startSessionAs(this.johnIdentity.getRemoteId());
        ContainerResponse response = this.getResponse("POST", this.getURLResource("favorites/" + objectType + "/" + objectId), null);
        FavoriteRestTest.assertEquals((int)204, (int)response.getStatus());
        this.startSessionAs(this.johnIdentity.getRemoteId());
        response = this.getResponse("DELETE", this.getURLResource("favorites/" + objectType + "/" + objectId), null);
        FavoriteRestTest.assertEquals((int)204, (int)response.getStatus());
        response = this.getResponse("DELETE", this.getURLResource("favorites/user/name"), null);
        FavoriteRestTest.assertEquals((int)404, (int)response.getStatus());
        response = this.getResponse("DELETE", this.getURLResource("favorites/user/name") + "?ignoreNotExisting=true", null);
        FavoriteRestTest.assertEquals((int)204, (int)response.getStatus());
    }

    public void testGetFavoriteItemsByCreator() throws Exception {
        long userIdentityId;
        this.startSessionAs(this.johnIdentity.getRemoteId());
        long audienceId = userIdentityId = Long.parseLong(this.johnIdentity.getId());
        String favoriteType = this.favoriteMetadataType.getName();
        String objectType = "objectType1";
        this.createNewMetadataItem(favoriteType, "testMetadata1", objectType, "objectId1", "parentObjectId1", userIdentityId, audienceId);
        this.createNewMetadataItem(favoriteType, "testMetadata3", objectType, "objectId1", "parentObjectId1", userIdentityId, audienceId);
        this.createNewMetadataItem(favoriteType, "testMetadata5", objectType, "objectId1", "parentObjectId1", userIdentityId, audienceId);
        ContainerResponse response = this.getResponse("GET", this.getURLResource("favorites?offset=0&limit=5&returnSize=true"), null);
        FavoriteRestTest.assertEquals((int)200, (int)response.getStatus());
        FavoriteEntity favoriteEntity = (FavoriteEntity)response.getEntity();
        List favoritesList = favoriteEntity.getFavoritesItem();
        FavoriteRestTest.assertEquals((int)3, (int)favoritesList.size());
        FavoriteRestTest.assertEquals((int)3, (int)favoriteEntity.getSize());
        FavoriteRestTest.assertEquals((int)3, (int)this.favoriteService.getFavoriteItemsSize(userIdentityId));
        FavoriteRestTest.assertEquals((int)3, (int)this.favoriteService.getFavoriteItemsSize(objectType, userIdentityId));
    }

    public void testGetFavoriteItemsByCreatorAndType() throws Exception {
        this.startSessionAs(this.johnIdentity.getRemoteId());
        long userIdentityId = Long.parseLong(this.johnIdentity.getId());
        String objectType = "space";
        String otherObjectType = "activity";
        Favorite favorite1 = new Favorite(objectType, "objectId1", null, userIdentityId);
        this.favoriteService.createFavorite(favorite1);
        Thread.sleep(10L);
        Favorite favorite2 = new Favorite(objectType, "objectId2", null, userIdentityId);
        this.favoriteService.createFavorite(favorite2);
        Thread.sleep(10L);
        Favorite favorite3 = new Favorite(otherObjectType, "objectId3", null, userIdentityId);
        this.favoriteService.createFavorite(favorite3);
        Thread.sleep(10L);
        Favorite favorite4 = new Favorite(otherObjectType, "objectId4", null, userIdentityId + 1L);
        this.favoriteService.createFavorite(favorite4);
        ContainerResponse response = this.getResponse("GET", this.getURLResource("favorites?offset=0&limit=5&returnSize=true&type=" + objectType), null);
        FavoriteRestTest.assertEquals((int)200, (int)response.getStatus());
        FavoriteEntity favoriteEntity = (FavoriteEntity)response.getEntity();
        List favoritesList = favoriteEntity.getFavoritesItem();
        FavoriteRestTest.assertEquals((int)2, (int)favoritesList.size());
        FavoriteRestTest.assertEquals((int)2, (int)favoriteEntity.getSize());
        FavoriteRestTest.assertEquals((String)favorite2.getObjectId(), (String)((MetadataItem)favoritesList.get(0)).getObjectId());
        FavoriteRestTest.assertEquals((String)favorite1.getObjectId(), (String)((MetadataItem)favoritesList.get(1)).getObjectId());
        response = this.getResponse("GET", this.getURLResource("favorites?offset=0&limit=5&returnSize=true&type=test"), null);
        favoriteEntity = (FavoriteEntity)response.getEntity();
        favoritesList = favoriteEntity.getFavoritesItem();
        FavoriteRestTest.assertEquals((int)0, (int)favoritesList.size());
        FavoriteRestTest.assertEquals((int)0, (int)favoriteEntity.getSize());
    }

    public void testSetFavoriteAsLastAccessed() throws Exception {
        this.startSessionAs(this.johnIdentity.getRemoteId());
        long userIdentityId = Long.parseLong(this.johnIdentity.getId());
        String objectType = "space";
        Favorite favorite1 = new Favorite(objectType, "objectId1", null, userIdentityId);
        this.favoriteService.createFavorite(favorite1);
        Thread.sleep(10L);
        Favorite favorite2 = new Favorite(objectType, "objectId2", null, userIdentityId);
        this.favoriteService.createFavorite(favorite2);
        Thread.sleep(10L);
        Favorite favorite3 = new Favorite(objectType, "objectId3", null, userIdentityId);
        this.favoriteService.createFavorite(favorite3);
        Thread.sleep(10L);
        Favorite favorite4 = new Favorite(objectType, "objectId4", null, userIdentityId);
        this.favoriteService.createFavorite(favorite4);
        ContainerResponse response = this.getResponse("GET", this.getURLResource("favorites?offset=0&limit=5&returnSize=true&type=" + objectType), null);
        FavoriteRestTest.assertEquals((int)200, (int)response.getStatus());
        FavoriteEntity favoriteEntity = (FavoriteEntity)response.getEntity();
        List favoritesList = favoriteEntity.getFavoritesItem();
        FavoriteRestTest.assertEquals((int)4, (int)favoritesList.size());
        FavoriteRestTest.assertEquals((String)favorite4.getObjectId(), (String)((MetadataItem)favoritesList.get(0)).getObjectId());
        FavoriteRestTest.assertEquals((String)favorite3.getObjectId(), (String)((MetadataItem)favoritesList.get(1)).getObjectId());
        FavoriteRestTest.assertEquals((String)favorite2.getObjectId(), (String)((MetadataItem)favoritesList.get(2)).getObjectId());
        FavoriteRestTest.assertEquals((String)favorite1.getObjectId(), (String)((MetadataItem)favoritesList.get(3)).getObjectId());
        response = this.getResponse("PATCH", this.getURLResource("favorites/" + objectType + "/" + favorite4.getObjectId() + "/view"), null);
        FavoriteRestTest.assertEquals((int)204, (int)response.getStatus());
        Thread.sleep(10L);
        response = this.getResponse("PATCH", this.getURLResource("favorites/" + objectType + "/" + favorite3.getObjectId() + "/view"), null);
        FavoriteRestTest.assertEquals((int)204, (int)response.getStatus());
        Thread.sleep(10L);
        response = this.getResponse("PATCH", this.getURLResource("favorites/" + objectType + "/" + favorite2.getObjectId() + "/view"), null);
        FavoriteRestTest.assertEquals((int)204, (int)response.getStatus());
        Thread.sleep(10L);
        response = this.getResponse("PATCH", this.getURLResource("favorites/" + objectType + "/" + favorite1.getObjectId() + "/view"), null);
        FavoriteRestTest.assertEquals((int)204, (int)response.getStatus());
        Thread.sleep(10L);
        response = this.getResponse("GET", this.getURLResource("favorites?offset=0&limit=5&returnSize=true&type=" + objectType), null);
        favoriteEntity = (FavoriteEntity)response.getEntity();
        favoritesList = favoriteEntity.getFavoritesItem();
        FavoriteRestTest.assertEquals((int)4, (int)favoritesList.size());
        FavoriteRestTest.assertEquals((String)favorite4.getObjectId(), (String)((MetadataItem)favoritesList.get(3)).getObjectId());
        FavoriteRestTest.assertEquals((String)favorite3.getObjectId(), (String)((MetadataItem)favoritesList.get(2)).getObjectId());
        FavoriteRestTest.assertEquals((String)favorite2.getObjectId(), (String)((MetadataItem)favoritesList.get(1)).getObjectId());
        FavoriteRestTest.assertEquals((String)favorite1.getObjectId(), (String)((MetadataItem)favoritesList.get(0)).getObjectId());
    }

    private MetadataItem createNewMetadataItem(String type, String name, String objectType, String objectId, String parentObjectId, long creatorId, long audienceId) throws Exception {
        MetadataItem metadataItem = new MetadataItem();
        metadataItem.setObjectId(objectId);
        metadataItem.setObjectType(objectType);
        metadataItem.setParentObjectId(parentObjectId);
        return this.metadataService.createMetadataItem(metadataItem.getObject(), new MetadataKey(type, name, audienceId), creatorId);
    }
}

