/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.category.rest;

import io.meeds.social.category.model.CategoryObject;
import io.meeds.social.category.rest.CategoryLinkRest;
import io.meeds.social.category.service.CategoryLinkService;
import io.meeds.social.util.JsonUtils;
import io.meeds.spring.web.security.PortalAuthenticationManager;
import io.meeds.spring.web.security.WebSecurityConfiguration;
import jakarta.servlet.Filter;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureWebMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.http.MediaType;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.test.web.servlet.request.SecurityMockMvcRequestPostProcessors;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.DefaultMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

@SpringBootTest(classes={CategoryLinkRest.class, PortalAuthenticationManager.class})
@ContextConfiguration(classes={WebSecurityConfiguration.class})
@AutoConfigureWebMvc
@AutoConfigureMockMvc(addFilters=false)
@RunWith(value=SpringRunner.class)
public class CategoryLinkRestTest {
    private static final String CATEGORIES_PATH = "/category/links/1";
    private static final String SIMPLE_USER = "simple";
    private static final String TEST_PASSWORD = "testPassword";
    @Autowired
    private SecurityFilterChain filterChain;
    @Autowired
    private WebApplicationContext context;
    @MockBean
    private CategoryLinkService categoryLinkService;
    private MockMvc mockMvc;

    @Before
    public void setup() {
        this.mockMvc = ((DefaultMockMvcBuilder)MockMvcBuilders.webAppContextSetup((WebApplicationContext)this.context).addFilters(this.filterChain.getFilters().toArray(new Filter[0]))).build();
    }

    @Test
    public void link() throws Exception {
        CategoryObject object = new CategoryObject();
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)CATEGORIES_PATH, (Object[])new Object[0]).content(JsonUtils.toJsonString((Object)object)).contentType(MediaType.APPLICATION_JSON).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        ((CategoryLinkService)Mockito.verify((Object)this.categoryLinkService)).link(1L, object, SIMPLE_USER);
    }

    @Test
    public void linkWhenThrowIllegalArgumentException() throws Exception {
        CategoryObject object = new CategoryObject();
        ((CategoryLinkService)Mockito.doThrow(IllegalArgumentException.class).when((Object)this.categoryLinkService)).link(1L, object, SIMPLE_USER);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)CATEGORIES_PATH, (Object[])new Object[0]).content(JsonUtils.toJsonString((Object)object)).contentType(MediaType.APPLICATION_JSON).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void linkWhenThrowObjectNotFoundException() throws Exception {
        CategoryObject object = new CategoryObject();
        ((CategoryLinkService)Mockito.doThrow(ObjectNotFoundException.class).when((Object)this.categoryLinkService)).link(1L, object, SIMPLE_USER);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)CATEGORIES_PATH, (Object[])new Object[0]).content(JsonUtils.toJsonString((Object)object)).contentType(MediaType.APPLICATION_JSON).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void linkWhenThrowIllegalAccessException() throws Exception {
        CategoryObject object = new CategoryObject();
        ((CategoryLinkService)Mockito.doThrow(IllegalAccessException.class).when((Object)this.categoryLinkService)).link(1L, object, SIMPLE_USER);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)CATEGORIES_PATH, (Object[])new Object[0]).content(JsonUtils.toJsonString((Object)object)).contentType(MediaType.APPLICATION_JSON).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void linkWhenThrowObjectAlreadyExistsException() throws Exception {
        CategoryObject object = new CategoryObject();
        ((CategoryLinkService)Mockito.doThrow(ObjectAlreadyExistsException.class).when((Object)this.categoryLinkService)).link(1L, object, SIMPLE_USER);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)CATEGORIES_PATH, (Object[])new Object[0]).content(JsonUtils.toJsonString((Object)object)).contentType(MediaType.APPLICATION_JSON).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isConflict());
    }

    @Test
    public void unlink() throws Exception {
        CategoryObject object = new CategoryObject();
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)CATEGORIES_PATH, (Object[])new Object[0]).content(JsonUtils.toJsonString((Object)object)).contentType(MediaType.APPLICATION_JSON).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        ((CategoryLinkService)Mockito.verify((Object)this.categoryLinkService)).unlink(1L, object, SIMPLE_USER);
    }

    @Test
    public void unlinkWhenThrowIllegalArgumentException() throws Exception {
        CategoryObject object = new CategoryObject();
        ((CategoryLinkService)Mockito.doThrow(IllegalArgumentException.class).when((Object)this.categoryLinkService)).unlink(1L, object, SIMPLE_USER);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)CATEGORIES_PATH, (Object[])new Object[0]).content(JsonUtils.toJsonString((Object)object)).contentType(MediaType.APPLICATION_JSON).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void unlinkWhenThrowObjectNotFoundException() throws Exception {
        CategoryObject object = new CategoryObject();
        ((CategoryLinkService)Mockito.doThrow(ObjectNotFoundException.class).when((Object)this.categoryLinkService)).unlink(1L, object, SIMPLE_USER);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)CATEGORIES_PATH, (Object[])new Object[0]).content(JsonUtils.toJsonString((Object)object)).contentType(MediaType.APPLICATION_JSON).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void unlinkWhenThrowIllegalAccessException() throws Exception {
        CategoryObject object = new CategoryObject();
        ((CategoryLinkService)Mockito.doThrow(IllegalAccessException.class).when((Object)this.categoryLinkService)).unlink(1L, object, SIMPLE_USER);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)CATEGORIES_PATH, (Object[])new Object[0]).content(JsonUtils.toJsonString((Object)object)).contentType(MediaType.APPLICATION_JSON).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    private RequestPostProcessor testSimpleUser() {
        return SecurityMockMvcRequestPostProcessors.user((String)SIMPLE_USER).password(TEST_PASSWORD).authorities(new GrantedAuthority[]{new SimpleGrantedAuthority("users")});
    }
}

