/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.portlet;

import io.meeds.portal.permlink.model.PermanentLinkObject;
import io.meeds.portal.permlink.service.PermanentLinkService;
import jakarta.servlet.ServletConfig;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.WebRequestHandler;
import org.exoplatform.web.controller.QualifiedName;

public class SpacePermanentLinkHandler
extends WebRequestHandler {
    public static final QualifiedName REQUEST_SPACE_ID = QualifiedName.create((String)"spaceId");
    public static final QualifiedName REQUEST_PATH = QualifiedName.create((String)"path");
    private SpaceService spaceService;
    private UserPortalConfigService portalConfigService;
    private PermanentLinkService permanentLinkService;

    public void onInit(WebAppController controller, ServletConfig sConfig) throws Exception {
        super.onInit(controller, sConfig);
        PortalContainer container = PortalContainer.getInstance();
        this.spaceService = (SpaceService)container.getComponentInstanceOfType(SpaceService.class);
        this.portalConfigService = (UserPortalConfigService)container.getComponentInstanceOfType(UserPortalConfigService.class);
        this.permanentLinkService = (PermanentLinkService)container.getComponentInstanceOfType(PermanentLinkService.class);
    }

    public String getHandlerName() {
        return "spaces";
    }

    protected boolean getRequiresLifeCycle() {
        return true;
    }

    public boolean execute(ControllerContext controllerContext) throws Exception {
        String username = controllerContext.getRequest().getRemoteUser();
        String spaceId = controllerContext.getParameter(REQUEST_SPACE_ID);
        String path = controllerContext.getParameter(REQUEST_PATH);
        Space space = this.spaceService.getSpaceById(spaceId);
        if (StringUtils.isBlank((CharSequence)username) || space == null || this.isHiddenSpace(space, username)) {
            String pageNotFoundUrl = "/portal/" + this.getPageNotFoundSite(username) + "/page-not-found";
            controllerContext.getResponse().sendRedirect(pageNotFoundUrl);
        } else {
            String uri = this.permanentLinkService.getLink(this.getPermanentLinkObject(spaceId, path));
            controllerContext.getResponse().sendRedirect(uri);
        }
        return true;
    }

    private String getPageNotFoundSite(String username) {
        return StringUtils.isBlank((CharSequence)username) ? "public" : this.portalConfigService.getMetaPortal();
    }

    private boolean isHiddenSpace(Space space, String username) {
        return !this.spaceService.canViewSpace(space, username) && "hidden".equals(space.getVisibility());
    }

    private PermanentLinkObject getPermanentLinkObject(String spaceId, String path) {
        return new PermanentLinkObject("space", spaceId, Collections.singletonMap("applicationUri", path));
    }
}

