/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.handler;

import io.meeds.social.space.service.SpaceLayoutService;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.application.PortalRequestHandler;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.url.PortalURLContext;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.SpaceAccessType;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.WebRequestHandler;
import org.exoplatform.web.url.URLContext;
import org.exoplatform.web.url.URLFactoryService;
import org.exoplatform.web.url.navigation.NavigationResource;
import org.exoplatform.web.url.navigation.NodeURL;

public class SpaceAccessHandler
extends WebRequestHandler {
    private static final String SPACES_GROUP_PREFIX = "/spaces/";
    public static final String PAGE_URI = "space-access";
    private IdentityManager identityManager;
    private SpaceService spaceService;
    private SpaceLayoutService spaceLayoutService;
    private URLFactoryService urlFactoryService;
    private UserPortalConfigService userPortalConfigService;
    private LayoutService layoutService;
    private UserACL userAcl;

    public void onInit(WebAppController controller, ServletConfig sConfig) throws Exception {
        super.onInit(controller, sConfig);
        PortalContainer container = PortalContainer.getInstance();
        this.spaceService = (SpaceService)container.getComponentInstanceOfType(SpaceService.class);
        this.identityManager = (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class);
        this.urlFactoryService = (URLFactoryService)container.getComponentInstanceOfType(URLFactoryService.class);
        this.userPortalConfigService = (UserPortalConfigService)container.getComponentInstanceOfType(UserPortalConfigService.class);
        this.layoutService = (LayoutService)container.getComponentInstanceOfType(LayoutService.class);
        this.spaceLayoutService = (SpaceLayoutService)container.getComponentInstanceOfType(SpaceLayoutService.class);
        this.userAcl = (UserACL)container.getComponentInstanceOfType(UserACL.class);
    }

    public String getHandlerName() {
        return PAGE_URI;
    }

    protected boolean getRequiresLifeCycle() {
        return true;
    }

    public boolean execute(ControllerContext controllerContext) throws Exception {
        String username = controllerContext.getRequest().getRemoteUser();
        String requestSiteType = controllerContext.getParameter(PortalRequestHandler.REQUEST_SITE_TYPE);
        String requestSiteName = controllerContext.getParameter(PortalRequestHandler.REQUEST_SITE_NAME);
        if (!SiteType.GROUP.name().equalsIgnoreCase(requestSiteType) || !requestSiteName.startsWith(SPACES_GROUP_PREFIX)) {
            return false;
        }
        Space space = this.spaceService.getSpaceByGroupId(requestSiteName);
        if (this.canAccessSpace(space, username)) {
            if (this.spaceService.isMember(space, username)) {
                HttpSession session = controllerContext.getRequest().getSession();
                String lastAccessedSpaceId = (String)session.getAttribute("social.accessed.space.id.key");
                if (!StringUtils.equals((CharSequence)lastAccessedSpaceId, (CharSequence)space.getId())) {
                    this.spaceService.updateSpaceAccessed(username, space);
                }
                this.cleanupSession(controllerContext);
                session.setAttribute("social.accessed.space.id.key", (Object)space.getId());
            }
            return false;
        }
        if (space == null || "hidden".equals(space.getVisibility())) {
            controllerContext.getResponse().sendRedirect(String.format("%s/%s/page-not-found", controllerContext.getRequest().getContextPath(), this.getPageNotFoundSite(username)));
            return true;
        }
        if (this.canAccessSpacePublicSite(space, username)) {
            controllerContext.getResponse().sendRedirect(String.format("%s/%s", controllerContext.getRequest().getContextPath(), this.spaceLayoutService.getSpacePublicSiteName(space)));
            return true;
        }
        if (username == null) {
            return false;
        }
        this.processSpaceAccess(controllerContext, username, space);
        return true;
    }

    private boolean canAccessSpacePublicSite(Space space, String username) {
        return this.spaceService.canAccessSpacePublicSite(space, username) && this.userAcl.hasAccessPermission(this.layoutService.getPortalConfig(space.getPublicSiteId()), this.userAcl.getUserIdentity(username));
    }

    private boolean canAccessSpace(Space space, String username) {
        Identity identity = this.userAcl.getUserIdentity(username);
        if (identity == null || space == null) {
            return false;
        }
        if (this.spaceService.isMember(space, username)) {
            return true;
        }
        if (this.spaceService.canViewSpace(space, username)) {
            Collection memberships = identity.getMemberships();
            MembershipEntry memberMembership = new MembershipEntry(space.getGroupId(), "member");
            memberships.add(memberMembership);
            return true;
        }
        return false;
    }

    private void processSpaceAccess(ControllerContext controllerContext, String remoteId, Space space) throws IOException {
        org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getOrCreateUserIdentity(remoteId);
        if (identity.isExternal() && (space == null || !this.spaceService.isInvitedUser(space, remoteId))) {
            controllerContext.getResponse().sendRedirect("/");
            return;
        }
        SpaceAccessType spaceAccessType = Arrays.stream(SpaceAccessType.values()).filter(accessType -> accessType.doCheck(remoteId, space)).findFirst().orElse(null);
        this.sendRedirect(controllerContext, spaceAccessType, space);
    }

    private void sendRedirect(ControllerContext controllerContext, SpaceAccessType type, Space space) throws IOException {
        HttpServletRequest request = controllerContext.getRequest();
        HttpSession session = request.getSession();
        session.setAttribute("social.accessed.space.type.key", (Object)type);
        if (space == null) {
            session.removeAttribute("social.accessed.space.prettyName.key");
            session.removeAttribute("social.accessed.space.displayName.key");
        } else {
            session.setAttribute("social.accessed.space.id.key", (Object)space.getId());
            session.setAttribute("social.accessed.space.prettyName.key", (Object)space.getDisplayName());
            session.setAttribute("social.accessed.space.displayName.key", (Object)space.getPrettyName());
            session.setAttribute("social.accessed.space.request.path.key", (Object)request.getRequestURI());
        }
        controllerContext.getResponse().sendRedirect(this.getURI(controllerContext, PAGE_URI));
    }

    private void cleanupSession(ControllerContext controllerContext) {
        this.removeAttributeFromSession(controllerContext, "social.accessed.space.type.key");
        this.removeAttributeFromSession(controllerContext, "social.accessed.space.id.key");
        this.removeAttributeFromSession(controllerContext, "social.accessed.space.prettyName.key");
        this.removeAttributeFromSession(controllerContext, "social.accessed.space.request.path.key");
    }

    private void removeAttributeFromSession(ControllerContext controllerContext, String key) {
        if (controllerContext.getRequest().getAttribute(key) != null) {
            controllerContext.getRequest().getSession().removeAttribute(key);
        }
    }

    private String getURI(ControllerContext controllerContext, String uri) {
        String portalName = this.userPortalConfigService.getMetaPortal();
        SiteKey siteKey = SiteKey.portal((String)portalName);
        NavigationResource resource = new NavigationResource(siteKey.getType(), siteKey.getName(), uri);
        NodeURL url = (NodeURL)this.urlFactoryService.newURL(NodeURL.TYPE, (URLContext)new PortalURLContext(controllerContext, siteKey));
        url.setAjax(Boolean.valueOf(false));
        url.setResource(resource);
        return url.toString();
    }

    private String getPageNotFoundSite(String username) {
        return StringUtils.isBlank((CharSequence)username) ? "public" : this.userPortalConfigService.getMetaPortal();
    }
}

