/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.portlet;

import io.meeds.social.portlet.CMSPortlet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.attachment.AttachmentService;
import org.exoplatform.social.attachment.model.ObjectAttachmentList;
import org.exoplatform.social.attachment.model.UploadedAttachmentDetail;
import org.exoplatform.social.rest.api.RestUtils;
import org.exoplatform.upload.UploadResource;

/*
 * Exception performing whole class analysis ignored.
 */
public class ImagePortlet
extends CMSPortlet {
    private static final Log LOG = ExoLogger.getLogger(ImagePortlet.class);
    public static final String IMAGE_PATH_PREF = "image-path";
    private static final Random RANDOM = new Random();
    private static AttachmentService attachmentService;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.contentType = "imagePortlet";
    }

    protected void setViewRequestAttributes(String name, RenderRequest request, RenderResponse response) {
        ObjectAttachmentList attachmentList = ImagePortlet.getAttachmentService().getAttachments("imagePortlet", name);
        List files = attachmentList == null || attachmentList.getAttachments() == null ? Collections.emptyList() : attachmentList.getAttachments();
        request.setAttribute("files", (Object)files);
    }

    protected void preSettingInit(PortletPreferences preferences, String name) {
        String imagePath = preferences.getValue("image-path", null);
        if (StringUtils.isNotBlank((CharSequence)imagePath)) {
            this.initImageWithAttachmentPath(name, imagePath);
            this.savePreference("image-path", null);
        } else {
            String imageContent = preferences.getValue("data.init", null);
            if (StringUtils.isNotBlank((CharSequence)imageContent)) {
                this.initImageAttachmentContent(name, imageContent);
                this.savePreference("data.init", null);
            }
        }
    }

    private void initImageWithAttachmentPath(String name, String imagePath) {
        try {
            URL resource = ((ConfigurationManager)ExoContainerContext.getService(ConfigurationManager.class)).getResource(imagePath);
            String resourcePath = resource.getPath();
            this.initImageWithAttachmentFullPath(name, resourcePath);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Error while saving Image '%s' as attachment of portlet '%s'", imagePath, name), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initImageAttachmentContent(String name, String imageContent) {
        File tempFile = File.createTempFile("image", ".png");
        try {
            try (FileOutputStream outputStream = new FileOutputStream(tempFile);){
                IOUtils.write((byte[])Base64.decodeBase64((String)imageContent), (OutputStream)outputStream);
            }
            this.initImageWithAttachmentFullPath(name, tempFile.getAbsolutePath());
        }
        catch (Throwable throwable) {
            try {
                Files.delete(tempFile.toPath());
            }
            catch (Exception e) {
                LOG.warn("Error deleting temporary file {}", new Object[]{tempFile.getAbsoluteFile(), e});
            }
            throw throwable;
        }
        try {
            Files.delete(tempFile.toPath());
        }
        catch (Exception e) {
            LOG.warn("Error deleting temporary file {}", new Object[]{tempFile.getAbsoluteFile(), e});
        }
    }

    private void initImageWithAttachmentFullPath(String name, String resourcePath) {
        String uploadId = "ImagePortlet" + RANDOM.nextLong();
        UploadResource uploadResource = new UploadResource(uploadId);
        uploadResource.setFileName(new File(resourcePath).getName());
        uploadResource.setMimeType("image/png");
        uploadResource.setStatus(1);
        uploadResource.setStoreLocation(resourcePath);
        UploadedAttachmentDetail uploadedAttachmentDetail = new UploadedAttachmentDetail(uploadResource);
        ImagePortlet.getAttachmentService().saveAttachment(uploadedAttachmentDetail, "imagePortlet", name, null, RestUtils.getCurrentUserIdentityId());
    }

    private static AttachmentService getAttachmentService() {
        if (attachmentService == null) {
            attachmentService = (AttachmentService)ExoContainerContext.getService(AttachmentService.class);
        }
        return attachmentService;
    }
}

