/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.portlet;

import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.exoplatform.commons.api.portlet.GenericDispatchedViewPortlet;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.security.ConversationState;

public class SpacesListPortlet
extends GenericDispatchedViewPortlet {
    private UserACL userAcl;

    public void processAction(ActionRequest request, ActionResponse response) throws IOException, PortletException {
        if (!this.canModifySettings()) {
            throw new PortletException("User is not allowed to save settings");
        }
        PortletPreferences preferences = request.getPreferences();
        String settings = request.getParameter("settings");
        preferences.setValue("settings", settings);
        preferences.store();
        response.setPortletMode(PortletMode.VIEW);
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        request.setAttribute("canEdit", (Object)this.canModifySettings());
        super.doView(request, response);
    }

    private boolean canModifySettings() {
        PortalRequestContext requestContext = PortalRequestContext.getCurrentInstance();
        if (requestContext == null || requestContext.getPage() == null) {
            return false;
        }
        return this.getUserAcl().hasEditPermission(requestContext.getPage(), ConversationState.getCurrent().getIdentity());
    }

    private UserACL getUserAcl() {
        if (this.userAcl == null) {
            this.userAcl = (UserACL)ExoContainerContext.getService(UserACL.class);
        }
        return this.userAcl;
    }
}

