/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.portlet;

import io.meeds.social.portlet.CMSPortlet;
import io.meeds.social.translation.model.TranslationField;
import io.meeds.social.translation.service.TranslationService;
import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.social.attachment.AttachmentService;
import org.exoplatform.social.rest.api.RestUtils;

public class CmsPortletWithMetadata
extends CMSPortlet {
    public static final String OBJECT_TYPE = "cmsPortlet";
    private TranslationService translationService;
    private AttachmentService attachmentService;

    protected void setViewRequestAttributes(String name, RenderRequest request, RenderResponse response) {
        PortletPreferences preferences = request.getPreferences();
        String initTranslationIdentifier = preferences.getValue("data.init", null);
        if (initTranslationIdentifier != null) {
            try {
                Map translations = this.getTranslationService().getAllTranslationFields(OBJECT_TYPE, initTranslationIdentifier);
                translations.entrySet().forEach(entry -> {
                    String translationKey = (String)entry.getKey();
                    TranslationField translationField = (TranslationField)entry.getValue();
                    if (!translationField.getLabels().isEmpty()) {
                        try {
                            this.getTranslationService().saveTranslationLabels(OBJECT_TYPE, name, translationKey, translationField.getLabels());
                        }
                        catch (ObjectNotFoundException objectNotFoundException) {
                            // empty catch block
                        }
                    }
                });
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                // empty catch block
            }
            this.getAttachmentService().copyAttachments(OBJECT_TYPE, initTranslationIdentifier, OBJECT_TYPE, name, null, RestUtils.getCurrentUserIdentityId());
            this.savePreference("data.init", null);
        }
    }

    private TranslationService getTranslationService() {
        if (this.translationService == null) {
            this.translationService = (TranslationService)ExoContainerContext.getService(TranslationService.class);
        }
        return this.translationService;
    }

    private AttachmentService getAttachmentService() {
        if (this.attachmentService == null) {
            this.attachmentService = (AttachmentService)ExoContainerContext.getService(AttachmentService.class);
        }
        return this.attachmentService;
    }
}

