/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.portlet;

import io.meeds.social.portlet.CMSPortlet;
import io.meeds.social.translation.model.TranslationField;
import io.meeds.social.translation.service.TranslationService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.attachment.AttachmentService;
import org.exoplatform.social.attachment.model.UploadedAttachmentDetail;
import org.exoplatform.social.rest.api.RestUtils;
import org.exoplatform.upload.UploadResource;
import org.json.JSONObject;

public class CmsPortletWithMetadata
extends CMSPortlet {
    private static final Log LOG = ExoLogger.getLogger(CmsPortletWithMetadata.class);
    public static final String OBJECT_TYPE = "cmsPortlet";
    private static final String EXPORT_DATA_INIT_PREFERENCE_NAME = "export.data.init";
    private static final String EXPORT_DATA_ALT_INIT_PREFERENCE_NAME = "export.data.alt.init";
    private static final String EXPORT_DATA_TRANSLATIONS_INIT_PREFERENCE_NAME = "export.data.translation.init";
    private TranslationService translationService;
    private AttachmentService attachmentService;

    protected void setViewRequestAttributes(String name, RenderRequest request, RenderResponse response) {
        PortletPreferences preferences = request.getPreferences();
        String initTranslationIdentifier = preferences.getValue("data.init", null);
        if (initTranslationIdentifier != null) {
            try {
                Map translations = this.getTranslationService().getAllTranslationFields(OBJECT_TYPE, initTranslationIdentifier);
                translations.entrySet().forEach(entry -> {
                    String translationKey = (String)entry.getKey();
                    TranslationField translationField = (TranslationField)entry.getValue();
                    if (!translationField.getLabels().isEmpty()) {
                        try {
                            this.getTranslationService().saveTranslationLabels(OBJECT_TYPE, name, translationKey, translationField.getLabels(), false);
                        }
                        catch (ObjectNotFoundException objectNotFoundException) {
                            // empty catch block
                        }
                    }
                });
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                // empty catch block
            }
            this.getAttachmentService().copyAttachments(OBJECT_TYPE, initTranslationIdentifier, OBJECT_TYPE, name, null, RestUtils.getCurrentUserIdentityId());
            this.savePreference("data.init", null);
        }
    }

    protected void preSettingInit(PortletPreferences preferences, String name) {
        String translations;
        String imageContent = preferences.getValue(EXPORT_DATA_INIT_PREFERENCE_NAME, null);
        String imageAlt = preferences.getValue(EXPORT_DATA_ALT_INIT_PREFERENCE_NAME, null);
        if (StringUtils.isNotBlank((CharSequence)imageContent)) {
            this.initImageAttachmentContent(name, imageContent, imageAlt);
            this.savePreference(EXPORT_DATA_INIT_PREFERENCE_NAME, null);
        }
        if (StringUtils.isNotBlank((CharSequence)(translations = preferences.getValue(EXPORT_DATA_TRANSLATIONS_INIT_PREFERENCE_NAME, null)))) {
            this.initTranslations(name, translations);
            this.savePreference(EXPORT_DATA_TRANSLATIONS_INIT_PREFERENCE_NAME, null);
        }
    }

    private TranslationService getTranslationService() {
        if (this.translationService == null) {
            this.translationService = (TranslationService)ExoContainerContext.getService(TranslationService.class);
        }
        return this.translationService;
    }

    private AttachmentService getAttachmentService() {
        if (this.attachmentService == null) {
            this.attachmentService = (AttachmentService)ExoContainerContext.getService(AttachmentService.class);
        }
        return this.attachmentService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initImageAttachmentContent(String name, String imageContent, String imageAlt) {
        File tempFile = File.createTempFile("image", ".png");
        try {
            try (FileOutputStream outputStream = new FileOutputStream(tempFile);){
                IOUtils.write((byte[])Base64.decodeBase64((String)imageContent), (OutputStream)outputStream);
            }
            this.initImageWithAttachmentFullPath(name, tempFile.getAbsolutePath(), imageAlt);
        }
        catch (Throwable throwable) {
            try {
                Files.delete(tempFile.toPath());
            }
            catch (Exception e) {
                LOG.warn("Error deleting temporary file {}", new Object[]{tempFile.getAbsoluteFile(), e});
            }
            throw throwable;
        }
        try {
            Files.delete(tempFile.toPath());
        }
        catch (Exception e) {
            LOG.warn("Error deleting temporary file {}", new Object[]{tempFile.getAbsoluteFile(), e});
        }
    }

    private void initImageWithAttachmentFullPath(String name, String resourcePath, String imageAlt) {
        String uploadId = "CmsPortletWithMetadata-" + name;
        UploadResource uploadResource = new UploadResource(uploadId);
        uploadResource.setFileName(new File(resourcePath).getName());
        uploadResource.setMimeType("image/png");
        uploadResource.setStatus(1);
        uploadResource.setStoreLocation(resourcePath);
        UploadedAttachmentDetail uploadedAttachmentDetail = new UploadedAttachmentDetail(uploadResource);
        uploadedAttachmentDetail.setAltText(imageAlt);
        this.getAttachmentService().saveAttachment(uploadedAttachmentDetail, OBJECT_TYPE, name, null, RestUtils.getCurrentUserIdentityId());
    }

    private void initTranslations(String name, String translations) {
        JSONObject translationJson = new JSONObject(translations);
        translationJson.keySet().forEach(key -> {
            JSONObject translation = translationJson.getJSONObject(key);
            HashMap translationsLabel = new HashMap();
            translation.keySet().forEach(localeKey -> {
                Locale locale = Locale.forLanguageTag(localeKey);
                String value = translation.getString(localeKey);
                translationsLabel.put(locale, value);
            });
            if (!translationsLabel.isEmpty()) {
                try {
                    this.getTranslationService().saveTranslationLabels(OBJECT_TYPE, name, key, translationsLabel, false);
                }
                catch (ObjectNotFoundException objectNotFoundException) {
                    // empty catch block
                }
            }
        });
    }
}

