/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.task.listener;

import io.meeds.social.html.model.HtmlProcessorContext;
import io.meeds.social.html.utils.HtmlUtils;
import jakarta.annotation.PostConstruct;
import java.util.Arrays;
import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerBase;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.task.service.TaskPayload;
import org.exoplatform.task.service.TaskService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskContentLinkListener
extends Listener<TaskService, TaskPayload> {
    private static final List<String> SUPPORTED_EVENTS = Arrays.asList("exo.task.taskCreation", "exo.task.taskUpdate", "exo.task.taskDeleted");
    @Autowired
    private PortalContainer container;

    @PostConstruct
    public void init() {
        ListenerService listenerService = (ListenerService)this.container.getComponentInstanceOfType(ListenerService.class);
        SUPPORTED_EVENTS.forEach(name -> listenerService.addListener(name, (ListenerBase)this));
    }

    public void onEvent(Event<TaskService, TaskPayload> event) throws Exception {
        String content = switch (event.getEventName()) {
            case "exo.task.taskDeleted" -> "";
            default -> ((TaskPayload)event.getData()).after().getDescription();
        };
        HtmlUtils.process((String)content, (HtmlProcessorContext)new HtmlProcessorContext("task", String.valueOf(((TaskPayload)event.getData()).after().getId()), null));
    }
}

