/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task;

import java.util.Date;
import java.util.HashSet;
import org.exoplatform.task.domain.Priority;
import org.exoplatform.task.dto.CommentDto;
import org.exoplatform.task.dto.ProjectDto;
import org.exoplatform.task.dto.StatusDto;
import org.exoplatform.task.dto.TaskDto;

public class TestDtoUtils {
    public static long EXISTING_TASK_ID = 1L;
    public static long UNEXISTING_TASK_ID = 2L;
    public static long EXISTING_PROJECT_ID = 1L;
    public static long UNEXISTING_PROJECT_ID = 2L;
    public static long EXISTING_STATUS_ID = 1L;
    public static long UNEXISTING_STATUS_ID = 2L;
    public static long EXISTING_COMMENT_ID = 1L;
    public static long UNEXISTING_COMMENT_ID = 2L;

    public static TaskDto getDefaultTask() {
        return TestDtoUtils.getDefaultTaskWithId(EXISTING_TASK_ID);
    }

    public static TaskDto getDefaultTaskWithId(long id) {
        TaskDto task = new TaskDto();
        task.setId(id);
        task.setTitle("Default task");
        task.setAssignee("root");
        task.setCreatedBy("root");
        task.setPriority(Priority.NORMAL);
        task.setCreatedTime(new Date());
        HashSet coworker = new HashSet();
        task.setCoworker(coworker);
        return task;
    }

    public static CommentDto getDefaultComment() {
        CommentDto comment = new CommentDto();
        comment.setId(EXISTING_COMMENT_ID);
        comment.setComment("Bla bla");
        comment.setAuthor("Tib");
        comment.setCreatedTime(new Date());
        return comment;
    }

    public static StatusDto getDefaultStatus() {
        StatusDto status = new StatusDto();
        status.setId(Long.valueOf(EXISTING_STATUS_ID));
        status.setName("TODO");
        status.setRank(Integer.valueOf(1));
        return status;
    }

    public static ProjectDto getDefaultProject() {
        ProjectDto project = new ProjectDto();
        project.setId(EXISTING_PROJECT_ID);
        project.setName("Default project");
        project.setDescription("The default project");
        project.setDueDate(new Date());
        project.setLastModifiedDate(Long.valueOf(System.currentTimeMillis()));
        HashSet<String> participator = new HashSet<String>();
        participator.add("Tib");
        project.setParticipator(participator);
        HashSet<String> managers = new HashSet<String>();
        managers.add("Tib");
        project.setManager(managers);
        return project;
    }

    public static ProjectDto getParentProject() {
        ProjectDto project = new ProjectDto();
        project.setId(EXISTING_PROJECT_ID);
        project.setName("Default project");
        project.setDescription("The default project");
        project.setDueDate(new Date());
        HashSet<String> participator = new HashSet<String>();
        participator.add("Tib");
        project.setParticipator(participator);
        HashSet<String> managers = new HashSet<String>();
        managers.add("Tib");
        project.setManager(managers);
        return project;
    }
}

