/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.dao.jpa;

import jakarta.persistence.Tuple;
import jakarta.persistence.TypedQuery;
import java.lang.reflect.Array;
import java.util.List;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.task.dao.jpa.DAOHandlerJPAImpl;

public class JPAQueryListAccess<E>
implements ListAccess<E> {
    private final Class<E> clazz;
    private final TypedQuery<Long> countQuery;
    private final TypedQuery<?> selectQuery;
    private long size = -1L;

    public JPAQueryListAccess(Class<E> clazz, TypedQuery<Long> countQuery, TypedQuery<?> selectQuery) {
        this.clazz = clazz;
        this.countQuery = countQuery;
        this.selectQuery = selectQuery;
    }

    public E[] load(int index, int length) throws Exception, IllegalArgumentException {
        if (length > 0) {
            this.selectQuery.setFirstResult(index).setMaxResults(length);
        } else {
            this.selectQuery.setFirstResult(0).setMaxResults(Integer.MAX_VALUE);
        }
        List list = this.selectQuery.getResultList();
        Object[] e = (Object[])Array.newInstance(this.clazz, list.size());
        for (int i = 0; i < e.length; ++i) {
            Object obj = list.get(i);
            Object entity = null;
            if (this.clazz.isInstance(obj)) {
                entity = obj;
            } else if (obj instanceof Tuple) {
                Tuple tuple = (Tuple)obj;
                entity = tuple.get(0);
            } else if (obj instanceof Object[]) {
                for (Object o : (Object[])obj) {
                    if (!this.clazz.isInstance(o)) continue;
                    entity = o;
                    break;
                }
            }
            Object clone = DAOHandlerJPAImpl.clone(entity);
            e[i] = clone != null ? clone : entity;
        }
        return e;
    }

    public int getSize() throws Exception {
        if (this.size == -1L) {
            this.size = (Long)this.countQuery.getSingleResult();
        }
        return (int)this.size;
    }
}

