/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.integration;

import java.util.HashSet;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.task.dto.ProjectDto;
import org.exoplatform.task.dto.StatusDto;
import org.exoplatform.task.dto.TaskDto;
import org.exoplatform.task.exception.EntityNotFoundException;
import org.exoplatform.task.integration.TaskAttachmentPlugin;
import org.exoplatform.task.service.ProjectService;
import org.exoplatform.task.service.TaskService;
import org.exoplatform.task.util.TaskUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TaskAttachmentPluginTest {
    private static MockedStatic<TaskUtil> TASK_UTIL;
    @Mock
    private TaskService taskService;
    @Mock
    private ProjectService projectService;
    @Mock
    private SpaceService spaceService;
    private TaskAttachmentPlugin taskAttachmentPlugin;

    @BeforeClass
    public static void initClassContext() {
        TASK_UTIL = Mockito.mockStatic(TaskUtil.class);
    }

    @AfterClass
    public static void cleanClassContext() {
        TASK_UTIL.close();
    }

    @Before
    public void setUp() throws Exception {
        this.taskAttachmentPlugin = new TaskAttachmentPlugin(this.taskService, this.projectService, this.spaceService);
    }

    @Test
    public void testHasAccessPermission() throws EntityNotFoundException, ObjectNotFoundException {
        long taskId = 1L;
        String userId = "2";
        Identity userIdentity = (Identity)Mockito.mock(Identity.class);
        TaskDto task = (TaskDto)Mockito.mock(TaskDto.class);
        Mockito.when((Object)this.taskService.getTask(taskId)).thenReturn((Object)task);
        TASK_UTIL.when(() -> TaskUtil.hasViewPermission((TaskService)this.taskService, (TaskDto)task, (Identity)userIdentity)).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.taskAttachmentPlugin.hasAccessPermission(userIdentity, String.valueOf(taskId)));
    }

    @Test
    public void testHasEditPermission() throws EntityNotFoundException, ObjectNotFoundException {
        long taskId = 1L;
        Identity userIdentity = (Identity)Mockito.mock(Identity.class);
        TaskDto task = (TaskDto)Mockito.mock(TaskDto.class);
        Mockito.when((Object)this.taskService.getTask(taskId)).thenReturn((Object)task);
        TASK_UTIL.when(() -> TaskUtil.hasEditPermission((TaskService)this.taskService, (TaskDto)task, (Identity)userIdentity)).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.taskAttachmentPlugin.hasEditPermission(userIdentity, String.valueOf(taskId)));
    }

    @Test
    public void testGetSpaceId() throws EntityNotFoundException, ObjectNotFoundException {
        long taskId = 1L;
        long projectId = 12L;
        HashSet<String> permissions = new HashSet<String>();
        String groupId = "space_test";
        permissions.add("spaces:space_test");
        long spaceId = 5L;
        TaskDto task = (TaskDto)Mockito.mock(TaskDto.class);
        Mockito.when((Object)this.taskService.getTask(taskId)).thenReturn((Object)task);
        StatusDto taskStatus = (StatusDto)Mockito.mock(StatusDto.class);
        Mockito.when((Object)task.getStatus()).thenReturn((Object)taskStatus);
        ProjectDto project = (ProjectDto)Mockito.mock(ProjectDto.class);
        Mockito.when((Object)taskStatus.getProject()).thenReturn((Object)project);
        Mockito.when((Object)project.getId()).thenReturn((Object)projectId);
        Space space = (Space)Mockito.mock(Space.class);
        Mockito.when((Object)this.projectService.getManager(projectId)).thenReturn(permissions);
        Mockito.when((Object)this.spaceService.getSpaceByGroupId(groupId)).thenReturn((Object)space);
        Assert.assertNotNull((Object)space);
        Mockito.when((Object)space.getId()).thenReturn((Object)String.valueOf(spaceId));
        Assert.assertEquals((long)this.taskAttachmentPlugin.getSpaceId(String.valueOf(taskId)), (long)spaceId);
    }
}

