/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.integration.notification;

import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import junit.framework.TestCase;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.task.integration.notification.MailTemplateProvider;
import org.exoplatform.task.service.UserService;
import org.mockito.Mockito;

public class MailTemplateProviderTest
extends TestCase {
    private static final Log LOG = ExoLogger.getLogger(MailTemplateProviderTest.class);

    public void testMakeDigest() {
        NotificationInfo notificationInfo1 = this.createNotification();
        NotificationInfo notificationInfo2 = this.createNotification();
        NotificationInfo notificationInfo3 = this.createNotification();
        MailTemplateProviderTest.assertNotNull((Object)notificationInfo1);
        MailTemplateProviderTest.assertNotNull((Object)notificationInfo2);
        MailTemplateProviderTest.assertNotNull((Object)notificationInfo3);
        UserService userService = (UserService)Mockito.mock(UserService.class);
        InitParams initParams = new InitParams();
        Writer writer = null;
        NotificationContext context = NotificationContextImpl.cloneInstance();
        ArrayList<NotificationInfo> list = new ArrayList<NotificationInfo>();
        NotificationContext newCtx = NotificationContextImpl.cloneInstance();
        HashMap<String, String> ownerParameter = new HashMap<String, String>();
        MailTemplateProvider mailTemplateProvider = new MailTemplateProvider(initParams, userService);
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        notificationInfo1.setTo("root");
        notificationInfo1.setId("TaskCoworkerPlugin");
        notificationInfo1.key("TaskCoworkerPlugin");
        ownerParameter.put("taskCreator", "user1");
        ownerParameter.put("taskAssignee", "user2");
        ownerParameter.put("addedCoworker", "user3");
        notificationInfo1.setOwnerParameter(ownerParameter);
        list.add(notificationInfo1);
        context.setNotificationInfos(list);
        MailTemplateProviderTest.assertFalse((boolean)((AbstractTemplateBuilder)mailTemplateProvider.getTemplateBuilder().get(PluginKey.key((String)"TaskCoworkerPlugin"))).buildDigest(context, writer));
        list.remove(notificationInfo1);
        notificationInfo2.setTo("root");
        notificationInfo2.setId("TaskAssignPlugin");
        notificationInfo2.key("TaskAssignPlugin");
        ownerParameter.put("taskCreator", "user1");
        ownerParameter.put("taskAssignee", "user2");
        ownerParameter.put("addedCoworker", "user3");
        notificationInfo2.setOwnerParameter(ownerParameter);
        list.add(notificationInfo2);
        ctx.setNotificationInfos(list);
        MailTemplateProviderTest.assertFalse((boolean)((AbstractTemplateBuilder)mailTemplateProvider.getTemplateBuilder().get(PluginKey.key((String)"TaskAssignPlugin"))).buildDigest(ctx, writer));
        list.remove(notificationInfo2);
        notificationInfo3.setTo("root");
        notificationInfo3.setId("TaskCompletedPlugin");
        notificationInfo3.key("TaskCompletedPlugin");
        ownerParameter.put("taskCreator", "user1");
        ownerParameter.put("taskCoworkers", "user2");
        ownerParameter.put("taskAssignee", "user3");
        ownerParameter.put("addedCoworker", "user4");
        notificationInfo3.setOwnerParameter(ownerParameter);
        list.add(notificationInfo3);
        newCtx.setNotificationInfos(list);
        MailTemplateProviderTest.assertFalse((boolean)((AbstractTemplateBuilder)mailTemplateProvider.getTemplateBuilder().get(PluginKey.key((String)"TaskCompletedPlugin"))).buildDigest(newCtx, writer));
    }

    private NotificationInfo createNotification() {
        try {
            return NotificationInfo.instance();
        }
        catch (Exception e) {
            LOG.error((Object)"Error getting notification", (Throwable)e);
            MailTemplateProviderTest.fail((String)("Error getting notification instance: " + e.getMessage()));
            return null;
        }
    }
}

