/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.dao;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.task.AbstractTest;
import org.exoplatform.task.dao.CommentHandler;
import org.exoplatform.task.dao.DAOHandler;
import org.exoplatform.task.dao.TaskHandler;
import org.exoplatform.task.domain.Comment;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.util.ListUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestCommentDAO
extends AbstractTest {
    private CommentHandler commentDAO;
    private TaskHandler taskDAO;
    private final String username = "root";
    private DAOHandler daoHandler;

    @Before
    public void initDAOs() {
        PortalContainer container = PortalContainer.getInstance();
        ExoContainerContext.setCurrentContainer((ExoContainer)container);
        this.daoHandler = (DAOHandler)container.getComponentInstanceOfType(DAOHandler.class);
        this.taskDAO = this.daoHandler.getTaskHandler();
        this.commentDAO = this.daoHandler.getCommentHandler();
    }

    @After
    public void cleanData() {
        this.deleteAll();
    }

    @Test
    public void testCreateComment() {
        Task task = this.newDefaultSimpleTask();
        this.taskDAO.create((Object)task);
        List tasks = this.taskDAO.findAll();
        task = (Task)tasks.get(0);
        Comment comment = this.newDefaultSimpleComment(task);
        this.commentDAO.create((Object)comment);
        ListAccess listComments = this.commentDAO.findComments(task.getId().longValue());
        Comment[] comments = (Comment[])ListUtil.load((ListAccess)listComments, (int)0, (int)-1);
        Assert.assertEquals((long)1L, (long)comments.length);
        comment = comments[0];
        Assert.assertEquals((Object)"root", (Object)comment.getAuthor());
        this.taskDAO.update((Object)task);
        listComments = this.commentDAO.findComments(task.getId().longValue());
        comments = (Comment[])ListUtil.load((ListAccess)listComments, (int)0, (int)-1);
        Assert.assertEquals((long)1L, (long)comments.length);
        comment = comments[0];
        Assert.assertEquals((Object)"root", (Object)comment.getAuthor());
    }

    @Test
    public void testCreateSubComment() {
        Task task = this.newDefaultSimpleTask();
        task = (Task)this.taskDAO.create((Object)task);
        Comment comment = this.newDefaultSimpleComment(task);
        comment = (Comment)this.commentDAO.create((Object)comment);
        Comment subComment = this.newDefaultSimpleComment(task);
        subComment.setParentComment(comment);
        subComment = (Comment)this.commentDAO.create((Object)subComment);
        ListAccess listComments = this.commentDAO.findComments(task.getId().longValue());
        Comment[] comments = (Comment[])ListUtil.load((ListAccess)listComments, (int)0, (int)-1);
        Assert.assertEquals((long)1L, (long)comments.length);
        List subComments = this.commentDAO.getSubComments(Arrays.asList(comments));
        Assert.assertEquals((long)1L, (long)subComments.size());
        subComment = (Comment)subComments.get(0);
        Assert.assertEquals((Object)"root", (Object)comment.getAuthor());
    }

    @Test
    public void testDeleteSubComment() {
        Task task = this.newDefaultSimpleTask();
        this.taskDAO.create((Object)task);
        List tasks = this.taskDAO.findAll();
        task = (Task)tasks.get(0);
        Comment comment = this.newDefaultSimpleComment(task);
        comment = (Comment)this.commentDAO.create((Object)comment);
        Comment subComment1 = this.newDefaultSimpleComment(task);
        subComment1.setParentComment(comment);
        subComment1 = (Comment)this.commentDAO.create((Object)subComment1);
        Comment subComment2 = this.newDefaultSimpleComment(task);
        subComment2.setParentComment(comment);
        subComment2 = (Comment)this.commentDAO.create((Object)subComment2);
        ListAccess listComments = this.commentDAO.findComments(task.getId().longValue());
        Comment[] comments = (Comment[])ListUtil.load((ListAccess)listComments, (int)0, (int)-1);
        List subComments = this.commentDAO.getSubComments(Arrays.asList(comments));
        Assert.assertEquals((long)2L, (long)subComments.size());
        subComment2 = (Comment)subComments.get(0);
        this.commentDAO.delete((Object)subComment2);
        Assert.assertEquals((long)2L, (long)this.commentDAO.findAll().size());
        Assert.assertNotNull((Object)((Comment)subComments.get(0)).getParentComment());
        Assert.assertNotNull((Object)((Comment)subComments.get(1)).getParentComment());
        subComments = this.commentDAO.getSubComments(Arrays.asList(comments));
        Assert.assertEquals((long)1L, (long)subComments.size());
        Assert.assertNotNull((Object)((Comment)subComments.get(0)).getParentComment());
        comment = (Comment)this.commentDAO.find((Serializable)comment.getId());
        Assert.assertNotNull((Object)comment);
        this.commentDAO.delete((Object)comment);
        Assert.assertEquals((long)0L, (long)this.commentDAO.findAll().size());
    }

    @Test
    public void testUpdateComment() {
        Task task = this.newDefaultSimpleTask();
        this.taskDAO.create((Object)task);
        List tasks = this.taskDAO.findAll();
        task = (Task)tasks.get(0);
        Comment comment = this.newDefaultSimpleComment(task);
        this.commentDAO.create((Object)comment);
        ListAccess listComments = this.commentDAO.findComments(task.getId().longValue());
        Comment[] comments = (Comment[])ListUtil.load((ListAccess)listComments, (int)0, (int)-1);
        Assert.assertEquals((long)1L, (long)comments.length);
        comment = comments[0];
        long id = comment.getId();
        comment.setComment("New comment content");
        this.commentDAO.update((Object)comment);
        comment = (Comment)this.commentDAO.find((Serializable)Long.valueOf(id));
        Assert.assertEquals((Object)"New comment content", (Object)comment.getComment());
    }

    @Test
    public void testDeleteComment() {
        Task task = this.newDefaultSimpleTask();
        this.taskDAO.create((Object)task);
        List tasks = this.taskDAO.findAll();
        task = (Task)tasks.get(0);
        Comment comment = this.newDefaultSimpleComment(task);
        this.commentDAO.create((Object)comment);
        ListAccess listComments = this.commentDAO.findComments(task.getId().longValue());
        Comment[] comments = (Comment[])ListUtil.load((ListAccess)listComments, (int)0, (int)-1);
        Assert.assertEquals((long)1L, (long)comments.length);
        comment = comments[0];
        long id = comment.getId();
        this.commentDAO.delete((Object)comment);
        comment = (Comment)this.commentDAO.find((Serializable)Long.valueOf(id));
        Assert.assertNull((Object)comment);
    }

    @Test
    public void testCountComments() {
        Task task = this.newDefaultSimpleTask();
        this.taskDAO.create((Object)task);
        List tasks = this.taskDAO.findAll();
        task = (Task)tasks.get(0);
        int number = 10;
        for (int i = 0; i < 10; ++i) {
            Comment comment = this.newDefaultSimpleComment(task);
            comment.setComment("Comment number " + i);
            this.commentDAO.create((Object)comment);
        }
        ListAccess listComments = this.commentDAO.findComments(task.getId().longValue());
        long count = ListUtil.getSize((ListAccess)listComments);
        Assert.assertEquals((long)10L, (long)count);
    }

    @Test
    public void testLoadCommentWithLimit() {
        Task task = this.newDefaultSimpleTask();
        this.taskDAO.create((Object)task);
        List tasks = this.taskDAO.findAll();
        task = (Task)tasks.get(0);
        int number = 10;
        for (int i = 0; i < 10; ++i) {
            Comment comment = this.newDefaultSimpleComment(task);
            comment.setComment("Comment number " + i);
            this.commentDAO.create((Object)comment);
        }
        ListAccess listComments = this.commentDAO.findComments(task.getId().longValue());
        Comment[] comments = (Comment[])ListUtil.load((ListAccess)listComments, (int)0, (int)5);
        Assert.assertEquals((long)5L, (long)comments.length);
        comments = (Comment[])ListUtil.load((ListAccess)listComments, (int)2, (int)5);
        Assert.assertEquals((long)5L, (long)comments.length);
        comments = (Comment[])ListUtil.load((ListAccess)listComments, (int)2, (int)-1);
        Assert.assertEquals((long)10L, (long)comments.length);
        comments = (Comment[])ListUtil.load((ListAccess)listComments, (int)8, (int)5);
        Assert.assertEquals((long)2L, (long)comments.length);
    }

    @Test
    public void testMentionedUsers() {
        Task task = this.newDefaultSimpleTask();
        this.taskDAO.create((Object)task);
        List tasks = this.taskDAO.findAll();
        task = (Task)tasks.get(0);
        Comment comment1 = this.newDefaultSimpleComment(task);
        comment1.setComment("test1 @userA test2 @userB test3 @ test4");
        this.commentDAO.create((Object)comment1);
        Set mentionedUsers = this.commentDAO.findMentionedUsersOfTask(task.getId().longValue());
        Assert.assertEquals((long)0L, (long)mentionedUsers.size());
    }

    private Task newDefaultSimpleTask() {
        Task task = new Task();
        task.setTitle("Default task");
        task.setAssignee("root");
        task.setCreatedBy("root");
        task.setCreatedTime(new Date());
        return task;
    }

    private Comment newDefaultSimpleComment(Task task) {
        Comment comment = new Comment();
        comment.setAuthor("root");
        comment.setComment("Default comment");
        comment.setCreatedTime(new Date());
        comment.setTask(task);
        return comment;
    }
}

