/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.dao;

import java.io.Serializable;
import java.util.HashSet;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.task.AbstractTest;
import org.exoplatform.task.dao.DAOHandler;
import org.exoplatform.task.dao.ProjectHandler;
import org.exoplatform.task.dao.StatusHandler;
import org.exoplatform.task.dao.TaskHandler;
import org.exoplatform.task.domain.Project;
import org.exoplatform.task.domain.Status;
import org.exoplatform.task.domain.Task;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestStatusDAO
extends AbstractTest {
    private StatusHandler sDAO;
    private ProjectHandler pDAO;
    private TaskHandler tDAO;
    private DAOHandler daoHandler;

    @Before
    public void setup() {
        PortalContainer container = PortalContainer.getInstance();
        this.daoHandler = (DAOHandler)container.getComponentInstanceOfType(DAOHandler.class);
        this.sDAO = this.daoHandler.getStatusHandler();
        this.pDAO = this.daoHandler.getProjectHandler();
        this.tDAO = this.daoHandler.getTaskHandler();
    }

    @After
    public void tearDown() {
        this.deleteAll();
    }

    @Test
    public void testFindHighestRank() {
        Status s1 = this.createStatus("s1");
        s1.setRank(Integer.valueOf(0));
        Status s2 = this.createStatus("s2");
        s2.setRank(Integer.valueOf(1));
        Project p = this.createProject("p", s1, s2);
        p = (Project)this.pDAO.create((Object)p);
        s1.setProject(p);
        s2.setProject(p);
        this.sDAO.create((Object)s1);
        this.sDAO.create((Object)s2);
        Status s = this.sDAO.findHighestRankStatusByProject(p.getId());
        Assert.assertEquals((long)s2.getId(), (long)s.getId());
    }

    @Test
    public void testFindByName() {
        Status s1 = this.createStatus("s1");
        Project p = this.createProject("p", s1);
        p = (Project)this.pDAO.create((Object)p);
        s1.setProject(p);
        this.sDAO.create((Object)s1);
        Status s = this.sDAO.findByName(s1.getName(), p.getId());
        Assert.assertEquals((long)s1.getId(), (long)s.getId());
    }

    @Test
    public void testRemoveStatus() {
        Status s1 = this.createStatus("s1");
        Status s2 = this.createStatus("s2");
        Project p = this.createProject("p", s1, s2);
        p = (Project)this.pDAO.create((Object)p);
        s1.setProject(p);
        s2.setProject(p);
        this.sDAO.create((Object)s1);
        this.sDAO.create((Object)s2);
        Task t = new Task();
        t.setTitle("testTitle");
        t.setStatus(s2);
        this.tDAO.create((Object)t);
        RequestLifeCycle.restartTransaction();
        StatusHandler handler = this.daoHandler.getStatusHandler();
        Status st = (Status)handler.find((Serializable)Long.valueOf(s2.getId()));
        this.daoHandler.getTaskHandler().updateStatus(st, s1);
        RequestLifeCycle.restartTransaction();
        st = (Status)handler.find((Serializable)Long.valueOf(s2.getId()));
        st.setProject(null);
        handler.delete((Object)st);
        RequestLifeCycle.restartTransaction();
        t = (Task)this.tDAO.find((Serializable)t.getId());
        Assert.assertNotNull((Object)t);
        Assert.assertEquals((Object)s1.getName(), (Object)t.getStatus().getName());
    }

    private Project createProject(String name, Status ... status) {
        HashSet<String> managers = new HashSet<String>();
        managers.add("root");
        HashSet<String> participators = new HashSet<String>();
        participators.add("demo");
        HashSet<Status> tmp = new HashSet<Status>();
        Project project = new Project(name, "des", tmp, managers, participators);
        if (status != null) {
            for (Status st : status) {
                st.setProject(project);
                tmp.add(st);
            }
        }
        return project;
    }

    private Status createStatus(String name) {
        Status st = new Status();
        st.setName(name);
        st.setRank(Integer.valueOf(1));
        return st;
    }
}

