/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.domain;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.exoplatform.task.domain.LabelTaskMapping;
import org.exoplatform.task.domain.Project;

@Entity(name="TaskLabel")
@Table(name="TASK_LABELS")
@NamedQueries(value={@NamedQuery(name="Label.findLabelsByTask", query="SELECT lbl FROM TaskLabel lbl inner join lbl.tasks m WHERE lbl.project.id = :projectId AND m.task.id = :taskid ORDER BY lbl.id"), @NamedQuery(name="Label.findLabelsByTaskCount", query="SELECT count(*) FROM TaskLabel lbl inner join lbl.tasks m WHERE lbl.project.id = :projectId AND m.task.id = :taskid"), @NamedQuery(name="Label.findLabelsByProject", query="SELECT lbl FROM TaskLabel lbl WHERE lbl.project.id = :projectId ORDER BY lbl.id"), @NamedQuery(name="Label.findLabelsByProjectCount", query="SELECT count(*) FROM TaskLabel lbl WHERE lbl.project.id = :projectId ORDER BY lbl.id")})
public class Label
implements Serializable {
    private static final long serialVersionUID = 806731692361018042L;
    @Id
    @SequenceGenerator(name="SEQ_TASK_LABELS_LABEL_ID", sequenceName="SEQ_TASK_LABELS_LABEL_ID", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_TASK_LABELS_LABEL_ID")
    @Column(name="LABEL_ID")
    private long id;
    @Column(name="USERNAME", nullable=false)
    private String username;
    private String name;
    private String color;
    private boolean hidden;
    @ManyToOne(optional=true, fetch=FetchType.LAZY)
    @JoinColumn(name="PARENT_LABEL_ID", nullable=true)
    private Label parent;
    @OneToMany(mappedBy="parent", fetch=FetchType.LAZY)
    private List<Label> children = new LinkedList<Label>();
    @OneToMany(mappedBy="label", fetch=FetchType.LAZY)
    private Set<LabelTaskMapping> tasks = new HashSet<LabelTaskMapping>();
    @ManyToOne
    @JoinColumn(name="PROJECT_ID")
    private Project project;

    public Label() {
    }

    public Label(String name, String username, Project project) {
        this.name = name;
        this.username = username;
        this.project = project;
    }

    @Generated
    public long getId() {
        return this.id;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getColor() {
        return this.color;
    }

    @Generated
    public boolean isHidden() {
        return this.hidden;
    }

    @Generated
    public Label getParent() {
        return this.parent;
    }

    @Generated
    public List<Label> getChildren() {
        return this.children;
    }

    @Generated
    public Set<LabelTaskMapping> getTasks() {
        return this.tasks;
    }

    @Generated
    public Project getProject() {
        return this.project;
    }

    @Generated
    public void setId(long id) {
        this.id = id;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setColor(String color) {
        this.color = color;
    }

    @Generated
    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    @Generated
    public void setParent(Label parent) {
        this.parent = parent;
    }

    @Generated
    public void setChildren(List<Label> children) {
        this.children = children;
    }

    @Generated
    public void setTasks(Set<LabelTaskMapping> tasks) {
        this.tasks = tasks;
    }

    @Generated
    public void setProject(Project project) {
        this.project = project;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Label)) {
            return false;
        }
        Label other = (Label)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.isHidden() != other.isHidden()) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$color = this.getColor();
        String other$color = other.getColor();
        return !(this$color == null ? other$color != null : !this$color.equals(other$color));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Label;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        result = result * 59 + (this.isHidden() ? 79 : 97);
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $color = this.getColor();
        result = result * 59 + ($color == null ? 43 : $color.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Label(id=" + this.getId() + ", username=" + this.getUsername() + ", name=" + this.getName() + ", color=" + this.getColor() + ", hidden=" + this.isHidden() + ", parent=" + String.valueOf(this.getParent()) + ", children=" + String.valueOf(this.getChildren()) + ", tasks=" + String.valueOf(this.getTasks()) + ", project=" + String.valueOf(this.getProject()) + ")";
    }
}

