/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.domain;

import jakarta.persistence.CascadeType;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.task.domain.Label;
import org.exoplatform.task.domain.Status;
import org.exoplatform.task.domain.UserSetting;

@Entity(name="TaskProject")
@Table(name="TASK_PROJECTS")
@NamedQueries(value={@NamedQuery(name="TaskProject.findAllProjects", query="SELECT DISTINCT p FROM TaskProject p ORDER BY p.lastModifiedDate DESC"), @NamedQuery(name="TaskProject.countAllProjects", query="SELECT count(p) FROM TaskProject p"), @NamedQuery(name="TaskProject.findProjectsByKeyword", query="SELECT DISTINCT p FROM TaskProject p WHERE LOWER(p.name) LIKE LOWER(CONCAT('%', :name, '%')) order by p.lastModifiedDate desc"), @NamedQuery(name="TaskProject.findProjectsByIDs", query="SELECT DISTINCT p FROM TaskProject p WHERE p.id in (:ids) order by p.lastModifiedDate desc"), @NamedQuery(name="TaskProject.countProjectsByKeyword", query="SELECT count(p) FROM TaskProject p WHERE LOWER(p.name) LIKE LOWER(CONCAT('%', :name, '%'))"), @NamedQuery(name="TaskProject.findProjectsByMemberships", query="SELECT DISTINCT p FROM TaskProject p LEFT JOIN p.manager manager  LEFT JOIN p.participator participator  WHERE manager IN (:memberships) OR participator IN (:memberships) order by p.lastModifiedDate desc"), @NamedQuery(name="TaskProject.countProjectsByMemberships", query="SELECT count(p) FROM TaskProject p LEFT JOIN p.manager manager  LEFT JOIN p.participator participator  WHERE manager IN (:memberships) OR participator IN (:memberships)"), @NamedQuery(name="TaskProject.findProjectsByMembershipsByKeyword", query="SELECT DISTINCT p FROM TaskProject p  LEFT JOIN p.manager manager  LEFT JOIN p.participator participator  WHERE (manager IN (:memberships) OR participator IN (:memberships)) AND LOWER(p.name) LIKE LOWER(CONCAT('%', :name, '%')) ORDER BY p.lastModifiedDate DESC"), @NamedQuery(name="TaskProject.countProjectsByMembershipsByKeyword", query="SELECT count(p) FROM TaskProject p  LEFT JOIN p.manager manager  LEFT JOIN p.participator participator  WHERE (manager IN (:memberships) OR participator IN (:memberships)) AND LOWER(p.name) LIKE LOWER(CONCAT('%', :name, '%'))")})
public class Project
implements Serializable {
    private static final long serialVersionUID = -5595949787344061794L;
    public static final String PREFIX_CLONE = "Copy of ";
    @Id
    @SequenceGenerator(name="SEQ_TASK_PROJECTS_PROJECT_ID", sequenceName="SEQ_TASK_PROJECTS_PROJECT_ID", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_TASK_PROJECTS_PROJECT_ID")
    @Column(name="PROJECT_ID")
    private long id;
    private String name;
    private String description;
    private String color;
    @OneToMany(mappedBy="project", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    private Set<Status> status;
    @ElementCollection
    @CollectionTable(name="TASK_PROJECT_MANAGERS", joinColumns={@JoinColumn(name="PROJECT_ID")})
    private Set<String> manager;
    @ElementCollection
    @CollectionTable(name="TASK_PROJECT_PARTICIPATORS", joinColumns={@JoinColumn(name="PROJECT_ID")})
    private Set<String> participator;
    @Temporal(value=TemporalType.DATE)
    @Column(name="DUE_DATE")
    private Date dueDate;
    @ManyToOne(optional=true, fetch=FetchType.LAZY)
    @JoinColumn(name="PARENT_PROJECT_ID", nullable=true)
    private Project parent;
    @OneToMany(mappedBy="parent", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    private List<Project> children;
    @ManyToMany(mappedBy="hiddenProjects", fetch=FetchType.LAZY)
    private Set<UserSetting> hiddenOn;
    @ManyToMany(mappedBy="project", fetch=FetchType.LAZY)
    private Set<Label> labels;
    @Column(name="LAST_MODIFIED_DATE")
    private Long lastModifiedDate;

    public Project() {
    }

    public Project(String name, String description, Set<Status> status, Set<String> manager, Set<String> participator) {
        this.name = name;
        this.description = description;
        this.status = status;
        this.manager = manager;
        this.participator = participator;
    }

    public Project clone() {
        Project project = new Project(this.getName(), this.getDescription(), new HashSet<Status>(), null, null);
        project.setId(this.getId());
        project.setColor(this.getColor());
        project.setDueDate(this.getDueDate());
        if (this.getParent() != null) {
            project.setParent(this.getParent().clone());
        }
        project.status = new HashSet<Status>();
        project.children = new LinkedList<Project>();
        return project;
    }

    public boolean canView(Identity user) {
        HashSet<String> permissions = new HashSet<String>(this.getParticipator());
        permissions.addAll(this.getManager());
        return this.hasPermission(user, permissions);
    }

    public boolean canEdit(Identity user) {
        return this.hasPermission(user, this.getManager());
    }

    private boolean hasPermission(Identity user, Set<String> permissions) {
        if (permissions.contains(user.getUserId())) {
            return true;
        }
        HashSet<MembershipEntry> memberships = new HashSet<MembershipEntry>();
        for (String per : permissions) {
            MembershipEntry entry = MembershipEntry.parse((String)per);
            if (entry == null) continue;
            memberships.add(entry);
        }
        for (MembershipEntry entry : user.getMemberships()) {
            if (!memberships.contains(entry)) continue;
            return true;
        }
        return false;
    }

    @Generated
    public long getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getColor() {
        return this.color;
    }

    @Generated
    public Set<Status> getStatus() {
        return this.status;
    }

    @Generated
    public Set<String> getManager() {
        return this.manager;
    }

    @Generated
    public Set<String> getParticipator() {
        return this.participator;
    }

    @Generated
    public Date getDueDate() {
        return this.dueDate;
    }

    @Generated
    public Project getParent() {
        return this.parent;
    }

    @Generated
    public List<Project> getChildren() {
        return this.children;
    }

    @Generated
    public Set<UserSetting> getHiddenOn() {
        return this.hiddenOn;
    }

    @Generated
    public Set<Label> getLabels() {
        return this.labels;
    }

    @Generated
    public Long getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    @Generated
    public void setId(long id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setColor(String color) {
        this.color = color;
    }

    @Generated
    public void setStatus(Set<Status> status) {
        this.status = status;
    }

    @Generated
    public void setManager(Set<String> manager) {
        this.manager = manager;
    }

    @Generated
    public void setParticipator(Set<String> participator) {
        this.participator = participator;
    }

    @Generated
    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    @Generated
    public void setParent(Project parent) {
        this.parent = parent;
    }

    @Generated
    public void setChildren(List<Project> children) {
        this.children = children;
    }

    @Generated
    public void setHiddenOn(Set<UserSetting> hiddenOn) {
        this.hiddenOn = hiddenOn;
    }

    @Generated
    public void setLabels(Set<Label> labels) {
        this.labels = labels;
    }

    @Generated
    public void setLastModifiedDate(Long lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Project)) {
            return false;
        }
        Project other = (Project)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        Long this$lastModifiedDate = this.getLastModifiedDate();
        Long other$lastModifiedDate = other.getLastModifiedDate();
        if (this$lastModifiedDate == null ? other$lastModifiedDate != null : !((Object)this$lastModifiedDate).equals(other$lastModifiedDate)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$color = this.getColor();
        String other$color = other.getColor();
        if (this$color == null ? other$color != null : !this$color.equals(other$color)) {
            return false;
        }
        Set<String> this$manager = this.getManager();
        Set<String> other$manager = other.getManager();
        if (this$manager == null ? other$manager != null : !((Object)this$manager).equals(other$manager)) {
            return false;
        }
        Set<String> this$participator = this.getParticipator();
        Set<String> other$participator = other.getParticipator();
        if (this$participator == null ? other$participator != null : !((Object)this$participator).equals(other$participator)) {
            return false;
        }
        Date this$dueDate = this.getDueDate();
        Date other$dueDate = other.getDueDate();
        return !(this$dueDate == null ? other$dueDate != null : !((Object)this$dueDate).equals(other$dueDate));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Project;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        Long $lastModifiedDate = this.getLastModifiedDate();
        result = result * 59 + ($lastModifiedDate == null ? 43 : ((Object)$lastModifiedDate).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $color = this.getColor();
        result = result * 59 + ($color == null ? 43 : $color.hashCode());
        Set<String> $manager = this.getManager();
        result = result * 59 + ($manager == null ? 43 : ((Object)$manager).hashCode());
        Set<String> $participator = this.getParticipator();
        result = result * 59 + ($participator == null ? 43 : ((Object)$participator).hashCode());
        Date $dueDate = this.getDueDate();
        result = result * 59 + ($dueDate == null ? 43 : ((Object)$dueDate).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Project(id=" + this.getId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", color=" + this.getColor() + ", status=" + String.valueOf(this.getStatus()) + ", manager=" + String.valueOf(this.getManager()) + ", participator=" + String.valueOf(this.getParticipator()) + ", dueDate=" + String.valueOf(this.getDueDate()) + ", parent=" + String.valueOf(this.getParent()) + ", children=" + String.valueOf(this.getChildren()) + ", hiddenOn=" + String.valueOf(this.getHiddenOn()) + ", labels=" + String.valueOf(this.getLabels()) + ", lastModifiedDate=" + this.getLastModifiedDate() + ")";
    }
}

