/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.domain;

import jakarta.persistence.CascadeType;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.exoplatform.task.domain.ChangeLog;
import org.exoplatform.task.domain.Comment;
import org.exoplatform.task.domain.LabelTaskMapping;
import org.exoplatform.task.domain.Priority;
import org.exoplatform.task.domain.Status;

@Entity(name="TaskTask")
@Table(name="TASK_TASKS")
@NamedQueries(value={@NamedQuery(name="Task.findByMemberships", query="  SELECT ta FROM TaskTask ta\n  LEFT JOIN ta.coworker coworkers\n  WHERE ta.assignee = :userName\n  OR ta.createdBy = :userName\n  OR coworkers = :userName\n  OR ta.status.id IN (\n    SELECT st.id FROM TaskStatus st\n    INNER JOIN st.project project\n    WHERE project.id IN (\n      SELECT pr1.id FROM TaskProject pr1\n      LEFT JOIN pr1.manager managers\n      WHERE managers IN :memberships\n    )\n    OR project.id IN (\n      SELECT pr2.id FROM TaskProject pr2\n      LEFT JOIN pr2.participator participators\n      WHERE participators IN :memberships\n    )\n  )\n"), @NamedQuery(name="Task.findTaskByProject", query="SELECT t FROM TaskTask t WHERE t.status.project.id = :projectId"), @NamedQuery(name="Task.findTaskByActivityId", query="SELECT t FROM TaskTask t WHERE t.activityId = :activityId"), @NamedQuery(name="Task.getCoworker", query="SELECT c FROM TaskTask t inner join t.coworker c WHERE t.id = :taskid"), @NamedQuery(name="Task.getWatcher", query="SELECT w FROM TaskTask t inner join t.watcher w WHERE t.id = :taskid"), @NamedQuery(name="Task.updateStatus", query="UPDATE TaskTask t SET t.status = :status_new WHERE t.status = :status_old"), @NamedQuery(name="Task.getTaskWithCoworkers", query="SELECT t FROM TaskTask t LEFT JOIN FETCH t.coworker c WHERE t.id = :taskid"), @NamedQuery(name="Task.getUncompletedTasks", query="SELECT ta FROM TaskTask ta WHERE ta.completed = false AND (ta.assignee = :userName OR :userName in (select co FROM ta.coworker co) )"), @NamedQuery(name="Task.countUncompletedTasks", query="SELECT COUNT(ta) FROM TaskTask ta WHERE ta.completed = false AND (ta.assignee = :userName OR :userName in (select co FROM ta.coworker co) )"), @NamedQuery(name="Task.getCollaboratedTasks", query="SELECT ta FROM TaskTask ta WHERE ta.completed = false AND :userName in (select co FROM ta.coworker co) "), @NamedQuery(name="Task.countCollaboratedTasks", query="SELECT COUNT(ta) FROM TaskTask ta WHERE ta.completed = false AND :userName in (select co FROM ta.coworker co) "), @NamedQuery(name="Task.getAssignedTasks", query="SELECT ta FROM TaskTask ta WHERE ta.completed = false AND ta.assignee = :userName "), @NamedQuery(name="Task.countAssignedTasks", query="SELECT COUNT(ta)  FROM TaskTask ta WHERE ta.completed = false AND ta.assignee = :userName "), @NamedQuery(name="Task.getWatchedTasks", query="SELECT ta FROM TaskTask ta WHERE ta.completed = false AND :userName in (select wa FROM ta.watcher wa) "), @NamedQuery(name="Task.countWatchedTasks", query="SELECT COUNT(ta)  FROM TaskTask ta WHERE ta.completed = false AND :userName in (select wa FROM ta.watcher wa) "), @NamedQuery(name="Task.getOverdueTasks", query="SELECT ta FROM TaskTask ta WHERE ta.completed = false AND ta.dueDate < CURRENT_DATE AND (ta.assignee = :userName OR :userName in (select co FROM ta.coworker co) )"), @NamedQuery(name="Task.countOverdueTasks", query="SELECT COUNT(ta) FROM TaskTask ta WHERE ta.completed = false AND ta.dueDate < CURRENT_DATE AND (ta.assignee = :userName OR :userName in (select co FROM ta.coworker co) )"), @NamedQuery(name="Task.findTasks", query="SELECT ta FROM TaskTask ta WHERE (ta.assignee = :userName OR ta.createdBy = :userName OR :userName in (select co FROM ta.coworker co) OR (SELECT participator FROM TaskProject p LEFT JOIN p.participator participator where p.id = ta.status.project.id) IN (:memberships) ) ORDER BY ta.createdTime DESC"), @NamedQuery(name="Task.countTasks", query="SELECT COUNT(ta) FROM TaskTask ta WHERE (ta.assignee = :userName OR ta.createdBy = :userName OR :userName in (select co FROM ta.coworker co)) "), @NamedQuery(name="Task.countTaskStatusByProject", query="SELECT m.status.name AS name, COUNT(m) AS total FROM TaskTask AS m where m.status.project.id = :projectId and m.completed = false GROUP BY m.status.name ORDER BY m.status.name ASC"), @NamedQuery(name="Task.getByStatus", query="SELECT t FROM TaskTask t  WHERE t.status.id = :statusid"), @NamedQuery(name="Task.getAllIds", query="SELECT t.id FROM TaskTask t ORDER BY id ASC LIMIT :limit OFFSET :offset")})
public class Task
implements Serializable {
    private static final long serialVersionUID = 1945617316471028822L;
    public static final String PREFIX_CLONE = "Copy of ";
    @Id
    @SequenceGenerator(name="SEQ_TASK_TASKS_TASK_ID", sequenceName="SEQ_TASK_TASKS_TASK_ID", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_TASK_TASKS_TASK_ID")
    @Column(name="TASK_ID")
    private Long id;
    private String title;
    private String description;
    @Enumerated(value=EnumType.ORDINAL)
    private Priority priority;
    private String context;
    private String assignee;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="STATUS_ID")
    private Status status;
    @Column(name="TASK_RANK")
    private int rank;
    private boolean completed = false;
    @ElementCollection(fetch=FetchType.LAZY)
    @CollectionTable(name="TASK_TASK_COWORKERS", joinColumns={@JoinColumn(name="TASK_ID")})
    private Set<String> coworker;
    @ElementCollection(fetch=FetchType.LAZY)
    @CollectionTable(name="TASK_TASK_WATCHERS", joinColumns={@JoinColumn(name="TASK_ID")})
    private Set<String> watcher;
    @Column(name="CREATED_BY")
    private String createdBy;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="CREATED_TIME")
    private Date createdTime;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="START_DATE")
    private Date startDate;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="END_DATE")
    private Date endDate;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DUE_DATE")
    private Date dueDate;
    @OneToMany(mappedBy="task", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    private List<Comment> comments;
    @OneToMany(mappedBy="task", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    private List<ChangeLog> logs;
    @OneToMany(mappedBy="task", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    private List<LabelTaskMapping> labels;
    @Column(name="ACTIVITY_ID")
    private String activityId;

    public Task() {
        this.priority = Priority.NORMAL;
    }

    public Task(String title, String description, Priority priority, String context, String assignee, Set<String> coworker, Set<String> watcher, Status status, String createdBy, Date endDate, Date startDate, Date dueDate) {
        this.title = title;
        this.assignee = assignee;
        this.coworker = coworker;
        this.watcher = watcher;
        this.context = context;
        this.createdBy = createdBy;
        this.description = description;
        this.priority = priority;
        this.startDate = startDate;
        this.endDate = endDate;
        this.dueDate = dueDate;
        this.status = status;
    }

    public Task clone() {
        HashSet<String> coworkerClone = new HashSet();
        HashSet<String> watcherClone = new HashSet();
        if (this.getCoworker() != null) {
            coworkerClone = new HashSet<String>(this.getCoworker());
        }
        if (this.getWatcher() != null) {
            watcherClone = new HashSet<String>(this.getWatcher());
        }
        Task newTask = new Task(this.getTitle(), this.getDescription(), this.getPriority(), this.getContext(), this.getAssignee(), coworkerClone, watcherClone, this.getStatus() != null ? this.getStatus().clone() : null, this.getCreatedBy(), this.getEndDate(), this.getStartDate(), this.getDueDate());
        newTask.setCreatedTime(this.getCreatedTime());
        newTask.setActivityId(this.getActivityId());
        newTask.setCompleted(this.isCompleted());
        newTask.setRank(this.getRank());
        newTask.setId(this.getId());
        return newTask;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Priority getPriority() {
        return this.priority;
    }

    @Generated
    public String getContext() {
        return this.context;
    }

    @Generated
    public String getAssignee() {
        return this.assignee;
    }

    @Generated
    public Status getStatus() {
        return this.status;
    }

    @Generated
    public int getRank() {
        return this.rank;
    }

    @Generated
    public boolean isCompleted() {
        return this.completed;
    }

    @Generated
    public Set<String> getCoworker() {
        return this.coworker;
    }

    @Generated
    public Set<String> getWatcher() {
        return this.watcher;
    }

    @Generated
    public String getCreatedBy() {
        return this.createdBy;
    }

    @Generated
    public Date getCreatedTime() {
        return this.createdTime;
    }

    @Generated
    public Date getStartDate() {
        return this.startDate;
    }

    @Generated
    public Date getEndDate() {
        return this.endDate;
    }

    @Generated
    public Date getDueDate() {
        return this.dueDate;
    }

    @Generated
    public List<Comment> getComments() {
        return this.comments;
    }

    @Generated
    public List<ChangeLog> getLogs() {
        return this.logs;
    }

    @Generated
    public List<LabelTaskMapping> getLabels() {
        return this.labels;
    }

    @Generated
    public String getActivityId() {
        return this.activityId;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setPriority(Priority priority) {
        this.priority = priority;
    }

    @Generated
    public void setContext(String context) {
        this.context = context;
    }

    @Generated
    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }

    @Generated
    public void setStatus(Status status) {
        this.status = status;
    }

    @Generated
    public void setRank(int rank) {
        this.rank = rank;
    }

    @Generated
    public void setCompleted(boolean completed) {
        this.completed = completed;
    }

    @Generated
    public void setCoworker(Set<String> coworker) {
        this.coworker = coworker;
    }

    @Generated
    public void setWatcher(Set<String> watcher) {
        this.watcher = watcher;
    }

    @Generated
    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    @Generated
    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    @Generated
    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    @Generated
    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    @Generated
    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    @Generated
    public void setComments(List<Comment> comments) {
        this.comments = comments;
    }

    @Generated
    public void setLogs(List<ChangeLog> logs) {
        this.logs = logs;
    }

    @Generated
    public void setLabels(List<LabelTaskMapping> labels) {
        this.labels = labels;
    }

    @Generated
    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Task)) {
            return false;
        }
        Task other = (Task)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getRank() != other.getRank()) {
            return false;
        }
        if (this.isCompleted() != other.isCompleted()) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Priority this$priority = this.getPriority();
        Priority other$priority = other.getPriority();
        if (this$priority == null ? other$priority != null : !((Object)((Object)this$priority)).equals((Object)other$priority)) {
            return false;
        }
        String this$context = this.getContext();
        String other$context = other.getContext();
        if (this$context == null ? other$context != null : !this$context.equals(other$context)) {
            return false;
        }
        String this$assignee = this.getAssignee();
        String other$assignee = other.getAssignee();
        if (this$assignee == null ? other$assignee != null : !this$assignee.equals(other$assignee)) {
            return false;
        }
        String this$createdBy = this.getCreatedBy();
        String other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) {
            return false;
        }
        Date this$createdTime = this.getCreatedTime();
        Date other$createdTime = other.getCreatedTime();
        if (this$createdTime == null ? other$createdTime != null : !((Object)this$createdTime).equals(other$createdTime)) {
            return false;
        }
        Date this$startDate = this.getStartDate();
        Date other$startDate = other.getStartDate();
        if (this$startDate == null ? other$startDate != null : !((Object)this$startDate).equals(other$startDate)) {
            return false;
        }
        Date this$endDate = this.getEndDate();
        Date other$endDate = other.getEndDate();
        if (this$endDate == null ? other$endDate != null : !((Object)this$endDate).equals(other$endDate)) {
            return false;
        }
        Date this$dueDate = this.getDueDate();
        Date other$dueDate = other.getDueDate();
        if (this$dueDate == null ? other$dueDate != null : !((Object)this$dueDate).equals(other$dueDate)) {
            return false;
        }
        String this$activityId = this.getActivityId();
        String other$activityId = other.getActivityId();
        return !(this$activityId == null ? other$activityId != null : !this$activityId.equals(other$activityId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Task;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getRank();
        result = result * 59 + (this.isCompleted() ? 79 : 97);
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Priority $priority = this.getPriority();
        result = result * 59 + ($priority == null ? 43 : ((Object)((Object)$priority)).hashCode());
        String $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : $context.hashCode());
        String $assignee = this.getAssignee();
        result = result * 59 + ($assignee == null ? 43 : $assignee.hashCode());
        String $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : $createdBy.hashCode());
        Date $createdTime = this.getCreatedTime();
        result = result * 59 + ($createdTime == null ? 43 : ((Object)$createdTime).hashCode());
        Date $startDate = this.getStartDate();
        result = result * 59 + ($startDate == null ? 43 : ((Object)$startDate).hashCode());
        Date $endDate = this.getEndDate();
        result = result * 59 + ($endDate == null ? 43 : ((Object)$endDate).hashCode());
        Date $dueDate = this.getDueDate();
        result = result * 59 + ($dueDate == null ? 43 : ((Object)$dueDate).hashCode());
        String $activityId = this.getActivityId();
        result = result * 59 + ($activityId == null ? 43 : $activityId.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Task(id=" + this.getId() + ", title=" + this.getTitle() + ", description=" + this.getDescription() + ", priority=" + String.valueOf((Object)this.getPriority()) + ", context=" + this.getContext() + ", assignee=" + this.getAssignee() + ", status=" + String.valueOf(this.getStatus()) + ", rank=" + this.getRank() + ", completed=" + this.isCompleted() + ", coworker=" + String.valueOf(this.getCoworker()) + ", watcher=" + String.valueOf(this.getWatcher()) + ", createdBy=" + this.getCreatedBy() + ", createdTime=" + String.valueOf(this.getCreatedTime()) + ", startDate=" + String.valueOf(this.getStartDate()) + ", endDate=" + String.valueOf(this.getEndDate()) + ", dueDate=" + String.valueOf(this.getDueDate()) + ", comments=" + String.valueOf(this.getComments()) + ", logs=" + String.valueOf(this.getLogs()) + ", labels=" + String.valueOf(this.getLabels()) + ", activityId=" + this.getActivityId() + ")";
    }
}

