/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.domain;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.Table;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.exoplatform.task.domain.Project;

@Entity(name="TaskUserSetting")
@Table(name="TASK_USER_SETTINGS")
public class UserSetting
implements Serializable {
    private static final long serialVersionUID = 731610709234552969L;
    @Id
    @Column(name="USERNAME")
    private String username;
    @Column(name="SHOW_HIDDEN_PROJECT")
    private boolean showHiddenProject = false;
    @Column(name="SHOW_HIDDEN_LABEL")
    private boolean showHiddenLabel = false;
    @ManyToMany
    @JoinTable(name="TASK_HIDDEN_PROJECTS", joinColumns={@JoinColumn(name="USERNAME", referencedColumnName="USERNAME")}, inverseJoinColumns={@JoinColumn(name="PROJECT_ID", referencedColumnName="PROJECT_ID")})
    private Set<Project> hiddenProjects = new HashSet<Project>();

    public UserSetting() {
    }

    public UserSetting(String username) {
        this.username = username;
    }

    public UserSetting clone() {
        UserSetting setting = new UserSetting(this.getUsername());
        setting.setShowHiddenProject(this.isShowHiddenProject());
        return setting;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public boolean isShowHiddenProject() {
        return this.showHiddenProject;
    }

    @Generated
    public boolean isShowHiddenLabel() {
        return this.showHiddenLabel;
    }

    @Generated
    public Set<Project> getHiddenProjects() {
        return this.hiddenProjects;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setShowHiddenProject(boolean showHiddenProject) {
        this.showHiddenProject = showHiddenProject;
    }

    @Generated
    public void setShowHiddenLabel(boolean showHiddenLabel) {
        this.showHiddenLabel = showHiddenLabel;
    }

    @Generated
    public void setHiddenProjects(Set<Project> hiddenProjects) {
        this.hiddenProjects = hiddenProjects;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserSetting)) {
            return false;
        }
        UserSetting other = (UserSetting)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isShowHiddenProject() != other.isShowHiddenProject()) {
            return false;
        }
        if (this.isShowHiddenLabel() != other.isShowHiddenLabel()) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        Set<Project> this$hiddenProjects = this.getHiddenProjects();
        Set<Project> other$hiddenProjects = other.getHiddenProjects();
        return !(this$hiddenProjects == null ? other$hiddenProjects != null : !((Object)this$hiddenProjects).equals(other$hiddenProjects));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UserSetting;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isShowHiddenProject() ? 79 : 97);
        result = result * 59 + (this.isShowHiddenLabel() ? 79 : 97);
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        Set<Project> $hiddenProjects = this.getHiddenProjects();
        result = result * 59 + ($hiddenProjects == null ? 43 : ((Object)$hiddenProjects).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "UserSetting(username=" + this.getUsername() + ", showHiddenProject=" + this.isShowHiddenProject() + ", showHiddenLabel=" + this.isShowHiddenLabel() + ", hiddenProjects=" + String.valueOf(this.getHiddenProjects()) + ")";
    }
}

