/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.HTMLSanitizer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.utils.MentionUtils;
import org.exoplatform.task.dao.DAOHandler;
import org.exoplatform.task.domain.ChangeLog;
import org.exoplatform.task.domain.Comment;
import org.exoplatform.task.domain.Label;
import org.exoplatform.task.domain.Project;
import org.exoplatform.task.domain.Status;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.dto.ChangeLogEntry;
import org.exoplatform.task.dto.CommentDto;
import org.exoplatform.task.dto.LabelDto;
import org.exoplatform.task.dto.ProjectDto;
import org.exoplatform.task.dto.StatusDto;
import org.exoplatform.task.dto.TaskDto;
import org.exoplatform.task.service.UserService;
import org.exoplatform.task.storage.ProjectStorage;
import org.exoplatform.task.util.CommentUtil;

public final class StorageUtil {
    private static final Log LOG = ExoLogger.getExoLogger(StorageUtil.class);

    public static ChangeLog changeLogToEntity(ChangeLogEntry changeLogEntry, UserService userService) {
        ChangeLog changeLog = new ChangeLog();
        changeLog.setId(changeLogEntry.getId());
        changeLog.setTask(changeLogEntry.getTask());
        changeLog.setAuthor(changeLogEntry.getAuthor());
        changeLog.setActionName(changeLogEntry.getActionName());
        changeLog.setCreatedTime(changeLogEntry.getCreatedTime());
        changeLog.setTarget(changeLogEntry.getTarget());
        return changeLog;
    }

    public static ChangeLogEntry changeLogToDto(ChangeLog changeLog, UserService userService) {
        ChangeLogEntry changeLogEntry = new ChangeLogEntry();
        changeLogEntry.setId(changeLog.getId());
        changeLogEntry.setTask(changeLog.getTask());
        changeLogEntry.setAuthor(changeLog.getAuthor());
        changeLogEntry.setActionName(changeLog.getActionName());
        changeLogEntry.setCreatedTime(changeLog.getCreatedTime());
        changeLogEntry.setTarget(changeLog.getTarget());
        changeLogEntry.setAuthorFullName(userService.loadUser(changeLog.getAuthor()).getDisplayName());
        changeLogEntry.setAuthorAvatarUrl(userService.loadUser(changeLog.getAuthor()).getAvatar());
        changeLogEntry.setExternal(userService.loadUser(changeLog.getAuthor()).isExternal());
        if (changeLog.getActionName().equals("assign") || changeLog.getActionName().equals("unassign") || changeLog.getActionName().equals("assignCoworker") || changeLog.getActionName().equals("unassignCoworker")) {
            changeLogEntry.setTargetFullName(userService.loadUser(changeLog.getTarget()).getDisplayName());
            changeLogEntry.setIsTargetFullNameExternal(CommentUtil.isExternal(userService.loadUser(changeLog.getTarget()).getUsername()));
        }
        return changeLogEntry;
    }

    public static Task taskToEntity(TaskDto taskDto) {
        Task taskEntity;
        if (taskDto == null) {
            return null;
        }
        Task task = taskEntity = taskDto.getId() == 0L ? null : StorageUtil.getTaskEntityById(taskDto.getId());
        if (taskEntity == null) {
            taskEntity = new Task();
        }
        taskEntity.setTitle(taskDto.getTitle());
        taskEntity.setDescription(taskDto.getDescription());
        taskEntity.setPriority(taskDto.getPriority());
        taskEntity.setContext(taskDto.getContext());
        taskEntity.setAssignee(taskDto.getAssignee());
        taskEntity.setCoworker(taskDto.getCoworker());
        taskEntity.setWatcher(taskDto.getWatcher());
        if (taskDto.getStatus() != null) {
            taskEntity.setStatus(StorageUtil.getStatusEntityById(taskDto.getStatus().getId()));
        }
        taskEntity.setRank(taskDto.getRank());
        taskEntity.setActivityId(taskDto.getActivityId());
        taskEntity.setCompleted(taskDto.isCompleted());
        taskEntity.setCreatedBy(taskDto.getCreatedBy());
        taskEntity.setCreatedTime(taskDto.getCreatedTime());
        taskEntity.setEndDate(taskDto.getEndDate());
        taskEntity.setStartDate(taskDto.getStartDate());
        taskEntity.setDueDate(taskDto.getDueDate());
        return taskEntity;
    }

    public static TaskDto taskToDto(Task taskEntity, ProjectStorage projectStorage) {
        if (taskEntity == null) {
            return null;
        }
        TaskDto task = new TaskDto();
        task.setId(taskEntity.getId() == null ? 0L : taskEntity.getId());
        task.setTitle(taskEntity.getTitle());
        if (taskEntity.getDescription() != null) {
            try {
                task.setDescription(HTMLSanitizer.sanitize((String)taskEntity.getDescription()));
            }
            catch (Exception e) {
                LOG.warn((Object)"Task description cannot be sanitized", (Throwable)e);
            }
        }
        task.setPriority(taskEntity.getPriority());
        task.setContext(taskEntity.getContext());
        task.setAssignee(taskEntity.getAssignee());
        task.setCoworker(taskEntity.getCoworker());
        task.setWatcher(taskEntity.getWatcher());
        task.setStatus(StorageUtil.statusToDTO(taskEntity.getStatus(), projectStorage));
        task.setRank(taskEntity.getRank());
        task.setActivityId(taskEntity.getActivityId());
        task.setCompleted(taskEntity.isCompleted());
        task.setCreatedBy(taskEntity.getCreatedBy());
        task.setCreatedTime(taskEntity.getCreatedTime());
        task.setEndDate(taskEntity.getEndDate());
        task.setStartDate(taskEntity.getStartDate());
        task.setDueDate(taskEntity.getDueDate());
        return task;
    }

    public static Status getStatusEntityById(Long statusId) {
        return (Status)((DAOHandler)ExoContainerContext.getService(DAOHandler.class)).getStatusHandler().find(statusId);
    }

    public static Project getProjectEntityById(Long projectId) {
        return (Project)((DAOHandler)ExoContainerContext.getService(DAOHandler.class)).getProjectHandler().find(projectId);
    }

    public static Label getLabelEntityById(Long labelId) {
        return (Label)((DAOHandler)ExoContainerContext.getService(DAOHandler.class)).getLabelHandler().find(labelId);
    }

    public static Comment getCommentEntityById(Long commentId) {
        return (Comment)((DAOHandler)ExoContainerContext.getService(DAOHandler.class)).getCommentHandler().find(commentId);
    }

    public static Task getTaskEntityById(Long taskId) {
        return (Task)((DAOHandler)ExoContainerContext.getService(DAOHandler.class)).getTaskHandler().find(taskId);
    }

    public static Status statusToEntity(StatusDto statusDto) {
        Status status;
        if (statusDto == null) {
            return null;
        }
        Status status2 = status = statusDto.getId() == 0L ? null : StorageUtil.getStatusEntityById(statusDto.getId());
        if (status == null) {
            status = new Status();
        }
        status.setName(statusDto.getName());
        status.setRank(statusDto.getRank());
        if (statusDto.getProject() != null) {
            status.setProject(StorageUtil.getProjectEntityById(statusDto.getProject().getId()));
        }
        return status;
    }

    public static StatusDto statusToDTO(Status status, ProjectStorage projectStorage) {
        if (status == null) {
            return null;
        }
        StatusDto statusDto = new StatusDto();
        statusDto.setId(status.getId());
        statusDto.setName(status.getName());
        statusDto.setRank(status.getRank());
        statusDto.setProject(StorageUtil.projectToDto(status.getProject(), projectStorage));
        return statusDto;
    }

    public static List<StatusDto> listStatusToDTOs(List<Status> status, ProjectStorage projectStorage) {
        return status.stream().map(status1 -> StorageUtil.statusToDTO(status1, projectStorage)).collect(Collectors.toList());
    }

    public static Project projectToEntity(ProjectDto projectDto) {
        Project project;
        if (projectDto == null) {
            return null;
        }
        long projectId = projectDto.getId();
        Project project2 = project = projectId == 0L ? null : StorageUtil.getProjectEntityById(projectDto.getId());
        if (project == null) {
            project = new Project();
        } else {
            List<Status> statuses = ((DAOHandler)ExoContainerContext.getService(DAOHandler.class)).getStatusHandler().getStatuses(project.getId());
            project.setStatus(new HashSet<Status>(statuses));
        }
        project.setName(projectDto.getName());
        project.setDescription(projectDto.getDescription());
        project.setColor(projectDto.getColor());
        project.setDueDate(projectDto.getDueDate());
        project.setLastModifiedDate(projectDto.getLastModifiedDate());
        project.setParticipator(projectDto.getParticipator());
        project.setManager(projectDto.getManager());
        if (projectDto.getParent() != null) {
            project.setParent(StorageUtil.getProjectEntityById(projectDto.getParent().getId()));
        }
        return project;
    }

    public static ProjectDto projectToDto(Project project, ProjectStorage projectStorage) {
        if (project == null) {
            return null;
        }
        ProjectDto projectDto = new ProjectDto();
        projectDto.setId(project.getId());
        projectDto.setName(project.getName());
        projectDto.setDescription(project.getDescription());
        projectDto.setColor(project.getColor());
        projectDto.setDueDate(project.getDueDate());
        projectDto.setLastModifiedDate(project.getLastModifiedDate());
        projectDto.setParticipator(projectStorage.getParticipator(project.getId()));
        projectDto.setManager(projectStorage.getManager(project.getId()));
        projectDto.setParent(StorageUtil.projectToDto(project.getParent(), projectStorage));
        return projectDto;
    }

    public static ProjectDto projectToDto(Project project) {
        if (project == null) {
            return null;
        }
        ProjectDto projectDto = new ProjectDto();
        projectDto.setId(project.getId());
        projectDto.setName(project.getName());
        projectDto.setDescription(project.getDescription());
        projectDto.setColor(project.getColor());
        projectDto.setDueDate(project.getDueDate());
        projectDto.setLastModifiedDate(project.getLastModifiedDate());
        return projectDto;
    }

    public static Label labelToEntity(LabelDto labelDto) {
        Label label;
        if (labelDto == null) {
            return null;
        }
        Label label2 = label = labelDto.getId() == 0L ? null : StorageUtil.getLabelEntityById(labelDto.getId());
        if (label == null) {
            label = new Label();
        }
        label.setUsername(labelDto.getUsername());
        if (labelDto.getProject() != null) {
            label.setProject(StorageUtil.getProjectEntityById(labelDto.getProject().getId()));
        }
        label.setName(labelDto.getName());
        label.setColor(labelDto.getColor());
        label.setHidden(labelDto.isHidden());
        label.setParent(labelDto.getParent() == null ? null : StorageUtil.getLabelEntityById(labelDto.getParent().getId()));
        return label;
    }

    public static LabelDto labelToDto(Label label, Identity currentUser, ProjectStorage projectStorage) {
        if (label == null) {
            return null;
        }
        LabelDto labelDto = new LabelDto();
        labelDto.setId(label.getId());
        labelDto.setUsername(label.getUsername());
        labelDto.setName(label.getName());
        labelDto.setProject(StorageUtil.projectToDto(label.getProject(), projectStorage));
        labelDto.setColor(label.getColor());
        labelDto.setHidden(label.isHidden());
        labelDto.setCanEdit(labelDto.getProject().canEdit(currentUser) || label.getUsername().equals(currentUser.getUserId()));
        labelDto.setParent(StorageUtil.labelToDto(label.getParent()));
        return labelDto;
    }

    public static LabelDto labelToDto(Label label, TaskDto task, Identity currentUser, ProjectStorage projectStorage) {
        if (label == null) {
            return null;
        }
        LabelDto labelDto = new LabelDto();
        labelDto.setId(label.getId());
        labelDto.setUsername(label.getUsername());
        labelDto.setName(label.getName());
        labelDto.setProject(StorageUtil.projectToDto(label.getProject(), projectStorage));
        labelDto.setColor(label.getColor());
        labelDto.setHidden(label.isHidden());
        labelDto.setCanEdit(labelDto.getProject().canEdit(currentUser) || task.getCreatedBy().equals(currentUser.getUserId()));
        labelDto.setParent(StorageUtil.labelToDto(label.getParent()));
        return labelDto;
    }

    public static LabelDto labelToDto(Label label) {
        if (label == null) {
            return null;
        }
        LabelDto labelDto = new LabelDto();
        labelDto.setId(label.getId());
        labelDto.setUsername(label.getUsername());
        labelDto.setName(label.getName());
        labelDto.setProject(StorageUtil.projectToDto(label.getProject()));
        labelDto.setColor(label.getColor());
        labelDto.setHidden(label.isHidden());
        labelDto.setParent(StorageUtil.labelToDto(label.getParent()));
        return labelDto;
    }

    public static Label mappingLabelToEntity(LabelDto labelDto) {
        Label label;
        if (labelDto == null) {
            return null;
        }
        Label label2 = label = labelDto.getId() == 0L ? null : StorageUtil.getLabelEntityById(labelDto.getId());
        if (label == null) {
            label = new Label();
        }
        label.setUsername(labelDto.getUsername());
        label.setName(labelDto.getName());
        label.setColor(labelDto.getColor());
        label.setHidden(labelDto.isHidden());
        label.setParent(labelDto.getParent() == null ? null : StorageUtil.getLabelEntityById(labelDto.getParent().getId()));
        if (labelDto.getProject() != null) {
            label.setProject(StorageUtil.getProjectEntityById(labelDto.getProject().getId()));
        }
        return label;
    }

    public static Comment commentToEntity(CommentDto commentDto) {
        Comment commentEntity;
        if (commentDto == null) {
            return null;
        }
        Comment comment = commentEntity = commentDto.getId() == 0L ? null : StorageUtil.getCommentEntityById(commentDto.getId());
        if (commentEntity == null) {
            commentEntity = new Comment();
        }
        commentEntity.setAuthor(commentDto.getAuthor());
        commentEntity.setComment(commentDto.getComment());
        if (commentDto.getParentComment() != null) {
            commentEntity.setParentComment(StorageUtil.getCommentEntityById(commentDto.getParentComment().getId()));
        }
        commentEntity.setCreatedTime(commentDto.getCreatedTime());
        commentEntity.setTask(StorageUtil.getTaskEntityById(commentDto.getTask().getId()));
        commentEntity.setMentionedUsers(StorageUtil.processMentions(commentDto.getTask(), commentDto.getComment()));
        return commentEntity;
    }

    public static CommentDto commentToDto(Comment comment, ProjectStorage projectStorage) {
        if (comment == null) {
            return null;
        }
        CommentDto commentDto = new CommentDto();
        commentDto.setId(comment.getId() == null ? 0L : comment.getId());
        commentDto.setAuthor(comment.getAuthor());
        commentDto.setComment(comment.getComment());
        if (comment.getParentComment() != null) {
            commentDto.setParentComment(StorageUtil.commentToDto(comment.getParentComment(), projectStorage));
        }
        commentDto.setCreatedTime(comment.getCreatedTime());
        commentDto.setTask(StorageUtil.taskToDto(comment.getTask(), projectStorage));
        commentDto.setMentionedUsers(comment.getMentionedUsers());
        return commentDto;
    }

    public static List<CommentDto> listCommentsToDtos(List<Comment> comments, ProjectStorage projectStorage) {
        return comments.stream().filter(Objects::nonNull).map(comment -> StorageUtil.commentToDto(comment, projectStorage)).collect(Collectors.toList());
    }

    public static List<Comment> listCommentsToEntitys(List<CommentDto> commentDtos) {
        return commentDtos.stream().filter(Objects::nonNull).map(StorageUtil::commentToEntity).toList();
    }

    private static Set<String> processMentions(TaskDto task, String message) {
        Space space;
        HashSet<String> mentions = new HashSet<String>();
        mentions.addAll(MentionUtils.getMentionedUsernames((String)message));
        if (task != null && task.getStatus() != null && task.getStatus().getProject() != null && (space = StorageUtil.getProjectSpace(task.getStatus().getProject())) != null) {
            org.exoplatform.social.core.identity.model.Identity spaceIdentity = ((IdentityManager)ExoContainerContext.getService(IdentityManager.class)).getOrCreateSpaceIdentity(space.getPrettyName());
            String spaceIdentityId = spaceIdentity == null ? null : spaceIdentity.getId();
            Set mentionedRoles = MentionUtils.getMentionedRoles((String)message, (String)spaceIdentityId);
            mentionedRoles.forEach(role -> {
                if (StringUtils.equals((CharSequence)"member", (CharSequence)role) && space.getMembers() != null) {
                    mentions.addAll(Arrays.asList(space.getMembers()));
                } else if (StringUtils.equals((CharSequence)"manager", (CharSequence)role) && space.getManagers() != null) {
                    mentions.addAll(Arrays.asList(space.getManagers()));
                } else if (StringUtils.equals((CharSequence)"redactor", (CharSequence)role) && space.getRedactors() != null) {
                    mentions.addAll(Arrays.asList(space.getRedactors()));
                } else if (StringUtils.equals((CharSequence)"publisher", (CharSequence)role) && space.getPublishers() != null) {
                    mentions.addAll(Arrays.asList(space.getPublishers()));
                }
            });
        }
        return mentions;
    }

    private static Space getProjectSpace(ProjectDto project) {
        SpaceService spaceService = (SpaceService)ExoContainerContext.getService(SpaceService.class);
        Space space = null;
        for (String permission : project.getManager()) {
            int index = permission.indexOf(58);
            if (index <= -1) continue;
            String groupId = permission.substring(index + 1);
            space = spaceService.getSpaceByGroupId(groupId);
        }
        return space;
    }
}

