/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.dao;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.task.AbstractTest;
import org.exoplatform.task.dao.DAOHandler;
import org.exoplatform.task.dao.ProjectHandler;
import org.exoplatform.task.domain.Project;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestProjectDAO
extends AbstractTest {
    private ProjectHandler pDAO;
    private DAOHandler daoHandler;

    @Before
    public void setup() {
        PortalContainer container = PortalContainer.getInstance();
        this.daoHandler = (DAOHandler)container.getComponentInstanceOfType(DAOHandler.class);
        this.pDAO = this.daoHandler.getProjectHandler();
    }

    @After
    public void tearDown() {
        this.deleteAll();
    }

    @Test
    public void testProjectCreation() {
        Project p1 = new Project("Test project 1", null, null, null, null);
        this.pDAO.create((Object)p1);
        List all = this.pDAO.findAll();
        Assert.assertEquals((long)1L, (long)all.size());
        Assert.assertEquals((Object)"Test project 1", (Object)p1.getName());
        all = this.pDAO.findAll();
        Assert.assertEquals((long)1L, (long)all.size());
        Assert.assertEquals((Object)"Test project 1", (Object)p1.getName());
        Project p2 = new Project("Test project 2", null, null, null, null);
        this.pDAO.create((Object)p2);
        all = this.pDAO.findAll();
        Assert.assertEquals((long)2L, (long)all.size());
        Assert.assertEquals((long)(p1.getId() + 1L), (long)p2.getId());
    }

    @Test
    public void testFindSubProject() throws Exception {
        Project parent = new Project("Parent project", null, null, null, null);
        this.pDAO.create((Object)parent);
        Project child = new Project("Child project", null, null, null, null);
        child.setParent(parent);
        this.pDAO.create((Object)child);
        ListAccess projects = this.pDAO.findSubProjects(parent);
        Assert.assertEquals((long)1L, (long)projects.getSize());
        projects = this.pDAO.findSubProjects(null);
        Assert.assertTrue((projects.getSize() >= 1 ? 1 : 0) != 0);
    }

    @Test
    public void testFindProjectByKeywordWithDifferentCase() throws Exception {
        HashSet<String> manager = new HashSet<String>();
        manager.add("root");
        ListAccess projects = this.pDAO.findAllByMembershipsAndKeyword(Arrays.asList("root"), "test parenT ProJecT", null);
        int initialSize = projects.getSize();
        Project parent = new Project("Test Parent project", null, null, manager, null);
        this.pDAO.create((Object)parent);
        projects = this.pDAO.findAllByMembershipsAndKeyword(Arrays.asList("root"), "test parenT ProJecT", null);
        Assert.assertEquals((long)(initialSize + 1), (long)projects.getSize());
    }

    @Test
    public void testFindProjectByKeywordPartiallyMatching() throws Exception {
        HashSet<String> manager = new HashSet<String>();
        manager.add("root");
        Project parent = new Project("Marketing", null, null, manager, null);
        this.pDAO.create((Object)parent);
        ListAccess projects = this.pDAO.findAllByMembershipsAndKeyword(Arrays.asList("root"), "Mark", null);
        Assert.assertEquals((long)1L, (long)projects.getSize());
        projects = this.pDAO.findAllByMembershipsAndKeyword(Arrays.asList("root"), "arKet", null);
        Assert.assertEquals((long)1L, (long)projects.getSize());
        projects = this.pDAO.findAllByMembershipsAndKeyword(Arrays.asList("root"), "keTING", null);
        Assert.assertEquals((long)1L, (long)projects.getSize());
    }
}

