/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.integration.notification;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.dto.TaskDto;
import org.exoplatform.task.integration.notification.NotificationUtils;
import org.exoplatform.task.integration.notification.TaskCoworkerPlugin;
import org.junit.Assert;
import org.junit.Test;

public class TaskCoworkerPluginTest {
    @Test
    public void shouldReturnAssigneeInReceivers() throws Exception {
        TaskDto task = new TaskDto();
        task.setCoworker(new HashSet<String>(Arrays.asList("user1", "user2")));
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.append(NotificationUtils.COWORKER, (Object)task.getCoworker());
        TaskCoworkerPlugin notificationPlugin = new TaskCoworkerPlugin(new InitParams());
        Set receivers = notificationPlugin.getReceiver(task, ctx);
        Assert.assertNotNull((Object)receivers);
        Assert.assertEquals((long)2L, (long)receivers.size());
        Assert.assertTrue((boolean)receivers.contains("user1"));
        Assert.assertTrue((boolean)receivers.contains("user2"));
    }

    @Test
    public void shouldNotReturnAssigneeInReceiversWhenAssigneeIsCreator() throws Exception {
        TaskDto task = new TaskDto();
        task.setCoworker(new HashSet<String>(Arrays.asList("user1", "user2")));
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.append(NotificationUtils.CREATOR, (Object)"user1");
        ctx.append(NotificationUtils.COWORKER, (Object)task.getCoworker());
        TaskCoworkerPlugin notificationPlugin = new TaskCoworkerPlugin(new InitParams());
        Set receivers = notificationPlugin.getReceiver(task, ctx);
        Assert.assertNotNull((Object)receivers);
        Assert.assertEquals((long)1L, (long)receivers.size());
        Assert.assertTrue((boolean)receivers.contains("user2"));
    }

    @Test
    public void testisValid() {
        TaskCoworkerPlugin notificationPlugin = new TaskCoworkerPlugin(new InitParams());
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        Task task = new Task();
        task.setCoworker(new HashSet<String>(Arrays.asList("user2", "user3")));
        task.setAssignee("user0");
        task.setTitle("task1");
        task.setDescription("Description");
        task.setCreatedBy("user25");
        ctx.append(NotificationUtils.TASK, (Object)task);
        ctx.append(NotificationUtils.COWORKER, (Object)task.getCoworker());
        Assert.assertTrue((boolean)notificationPlugin.isValid(ctx));
    }
}

