/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.service.impl;

import java.util.List;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.utils.MentionUtils;
import org.exoplatform.task.dto.CommentDto;
import org.exoplatform.task.dto.TaskDto;
import org.exoplatform.task.exception.EntityNotFoundException;
import org.exoplatform.task.service.CommentService;
import org.exoplatform.task.storage.CommentStorage;
import org.exoplatform.task.util.TaskUtil;

public class CommentServiceImpl
implements CommentService {
    private static final Log LOG = ExoLogger.getExoLogger(CommentServiceImpl.class);
    private CommentStorage commentStorage;
    private ListenerService listenerService;

    public CommentServiceImpl(CommentStorage commentStorage, ListenerService listenerService) {
        this.commentStorage = commentStorage;
        this.listenerService = listenerService;
    }

    @Override
    public CommentDto getComment(long commentId) {
        return this.commentStorage.getComment(commentId);
    }

    @Override
    public List<CommentDto> getComments(long taskId, int offset, int limit) {
        return this.commentStorage.getComments(taskId, offset, limit);
    }

    @Override
    public List<CommentDto> getCommentsWithSubs(long taskId, int offset, int limit) {
        return this.commentStorage.getCommentsWithSubs(taskId, offset, limit);
    }

    @Override
    public int countComments(long taskId) {
        return this.commentStorage.countComments(taskId);
    }

    @Override
    public List<CommentDto> loadSubComments(List<CommentDto> listComments) {
        if (listComments == null || listComments.isEmpty()) {
            return null;
        }
        listComments.forEach(comment -> comment.setComment(MentionUtils.substituteUsernames((String)comment.getComment())));
        List<CommentDto> subComments = this.commentStorage.loadSubComments(listComments);
        for (CommentDto comment2 : listComments) {
            subComments.forEach(subComment -> subComment.setComment(MentionUtils.substituteUsernames((String)subComment.getComment())));
            comment2.setSubComments(subComments.stream().filter(subComment -> subComment.getParentComment().getId() == comment2.getId()).toList());
        }
        return listComments;
    }

    @Override
    public CommentDto addComment(TaskDto task, long parentCommentId, String username, String comment) throws EntityNotFoundException {
        CommentDto commentDto = this.commentStorage.addComment(task, parentCommentId, username, comment);
        if (commentDto != null) {
            TaskUtil.broadcastEvent(this.listenerService, "exo.task.taskCommentCreation", commentDto.getTask(), commentDto);
            if (commentDto.getTask() != null && commentDto.getTask().getStatus() != null && commentDto.getTask().getStatus().getProject() != null) {
                TaskUtil.broadcastEvent(this.listenerService, "exo.project.projectModified", null, commentDto.getTask().getStatus().getProject());
            }
        }
        return commentDto;
    }

    @Override
    public CommentDto addComment(TaskDto task, String username, String comment) throws EntityNotFoundException {
        return this.addComment(task, 0L, username, comment);
    }

    @Override
    public void removeComment(long commentId) throws EntityNotFoundException {
        CommentDto comment = this.commentStorage.getComment(commentId);
        if (comment == null) {
            LOG.info((Object)("Can not find comment with ID: " + commentId));
            throw new EntityNotFoundException(commentId, (Class<?>)CommentDto.class);
        }
        this.commentStorage.removeComment(commentId);
        TaskUtil.broadcastEvent(this.listenerService, "exo.task.taskCommentDeletion", comment.getTask(), comment);
    }
}

