/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.integration.notification;

import java.util.HashMap;
import junit.framework.TestCase;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.task.integration.notification.PushTemplateProvider;

public class PushTemplateProviderTest
extends TestCase {
    private static final Log LOG = ExoLogger.getLogger(PushTemplateProviderTest.class);

    public void testMakeMessage() {
        NotificationInfo notificationInfo1 = this.createNotification();
        PushTemplateProviderTest.assertNotNull((Object)notificationInfo1);
        InitParams initParams = new InitParams();
        ValueParam channel = new ValueParam();
        channel.setValue("push.channel");
        channel.setName("channel-id");
        initParams.addParam((Object)channel);
        NotificationContext context = NotificationContextImpl.cloneInstance();
        HashMap<String, String> ownerParameter = new HashMap<String, String>();
        PushTemplateProvider pushTemplateProvider = new PushTemplateProvider(initParams);
        notificationInfo1.setTo("root");
        notificationInfo1.setId("TaskMentionedPlugin");
        notificationInfo1.key("TaskMentionedPlugin");
        ownerParameter.put("taskCreator", "user1");
        ownerParameter.put("taskAssignee", "user2");
        ownerParameter.put("addedCoworker", "user3");
        ownerParameter.put("mentionedUsers", "user4");
        notificationInfo1.setOwnerParameter(ownerParameter);
        context.setNotificationInfo(notificationInfo1);
        AbstractTemplateBuilder builder = (AbstractTemplateBuilder)pushTemplateProvider.getTemplateBuilder().get(PluginKey.key((String)"TaskMentionedPlugin"));
        try {
            MessageInfo messageInfo = builder.buildMessage(context);
        }
        catch (StackOverflowError e) {
            LOG.error((Object)"Error when building message", (Throwable)e);
            PushTemplateProviderTest.fail((String)"StackOverflowError when building notification message");
        }
    }

    private NotificationInfo createNotification() {
        try {
            return NotificationInfo.instance();
        }
        catch (Exception e) {
            LOG.error((Object)"Error getting notification", (Throwable)e);
            PushTemplateProviderTest.fail((String)("Error getting notification instance: " + e.getMessage()));
            return null;
        }
    }
}

