/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.task.plugin;

import io.meeds.social.cms.model.ContentLinkExtension;
import io.meeds.social.cms.model.ContentLinkSearchResult;
import io.meeds.social.cms.plugin.ContentLinkPlugin;
import io.meeds.social.cms.service.ContentLinkPluginService;
import jakarta.annotation.PostConstruct;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.security.Identity;
import org.exoplatform.task.dao.OrderBy;
import org.exoplatform.task.dto.ProjectDto;
import org.exoplatform.task.exception.EntityNotFoundException;
import org.exoplatform.task.service.ProjectService;
import org.exoplatform.task.util.UserUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProjectContentLinkPlugin
implements ContentLinkPlugin {
    public static final String OBJECT_TYPE = "project";
    public static final String TITLE_KEY = "contentLink.project";
    public static final String ICON = "fa fa-clipboard-list";
    public static final String COMMAND = "project";
    public static final ContentLinkExtension EXTENSION = new ContentLinkExtension("project", "contentLink.project", "fa fa-clipboard-list", "project");
    @Autowired
    private ProjectService projectService;
    @Autowired
    private PortalContainer container;

    @PostConstruct
    public void init() {
        ((ContentLinkPluginService)this.container.getComponentInstanceOfType(ContentLinkPluginService.class)).addPlugin((ContentLinkPlugin)this);
    }

    public ContentLinkExtension getExtension() {
        return EXTENSION;
    }

    public List<ContentLinkSearchResult> search(String keyword, Identity identity, Locale locale, int offset, int limit) {
        LinkedList<String> memberships = new LinkedList<String>();
        memberships.addAll(UserUtil.getMemberships(identity));
        return this.projectService.findProjects(memberships, keyword, new OrderBy("id", false), offset, limit).stream().map(this::toContentLink).toList();
    }

    public String getContentTitle(String objectId, Locale locale) {
        try {
            ProjectDto project = this.projectService.getProject(Long.parseLong(objectId));
            return project == null ? "" : project.getName();
        }
        catch (EntityNotFoundException e) {
            return "";
        }
    }

    private ContentLinkSearchResult toContentLink(ProjectDto project) {
        return new ContentLinkSearchResult("project", String.valueOf(project.getId()), project.getName(), EXTENSION.getIcon(), EXTENSION.isDrawer());
    }
}

