/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.statistic;

import io.meeds.analytics.model.StatisticData;
import io.meeds.analytics.utils.AnalyticsUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.wallet.model.Wallet;
import org.exoplatform.wallet.utils.WalletUtils;

public class StatisticUtils {
    public static final String LOCAL_SERVICE = "local_service";
    public static final String REMOTE_SERVICE = "remote_service";
    public static final String OPERATION = "operation";
    public static final String STATUS = "status";
    public static final String STATUS_CODE = "status_code";
    public static final String DURATION = "duration_ms";
    public static final String ERROR_MSG = "error_msg";
    public static final String PARAMETERS = "parameters";
    protected static Log log = ExoLogger.getLogger((String)"WalletStatistics");

    private StatisticUtils() {
    }

    public static void addStatisticEntry(Map<String, Object> parameters) {
        StatisticUtils.addStatisticEntry(parameters, StatisticUtils::addAnalyticsEntry);
    }

    protected static void addStatisticEntry(Map<String, Object> parameters, Consumer<StatisticData> analyticsConsumer) {
        if (parameters == null || parameters.isEmpty()) {
            throw new IllegalArgumentException("parameters is mandatory");
        }
        String subModule = (String)(parameters = new HashMap<String, Object>(parameters)).remove(REMOTE_SERVICE);
        if (StringUtils.isBlank((CharSequence)subModule)) {
            subModule = (String)parameters.remove(LOCAL_SERVICE);
        }
        String operation = (String)parameters.remove(OPERATION);
        String status = (String)parameters.remove(STATUS);
        String statusCode = (String)parameters.remove(STATUS_CODE);
        String errorMessage = (String)parameters.remove(ERROR_MSG);
        Long duration = (Long)parameters.remove(DURATION);
        StatisticData statisticData = new StatisticData();
        statisticData.setModule("wallet");
        statisticData.setSubModule(subModule);
        statisticData.setOperation(operation);
        if (ConversationState.getCurrent() != null) {
            statisticData.setUserId(WalletUtils.getCurrentUserIdentityId());
        }
        if (duration != null && duration > 0L) {
            statisticData.setDuration(duration.longValue());
        }
        if (StringUtils.isNotBlank((CharSequence)status)) {
            statisticData.setStatus(StatisticData.StatisticStatus.valueOf((String)status.toUpperCase()));
        }
        if (StringUtils.isNotBlank((CharSequence)statusCode) && !StringUtils.equals((CharSequence)statusCode, (CharSequence)"200")) {
            statisticData.setErrorCode(Long.parseLong(statusCode));
        }
        if (StringUtils.isNotBlank((CharSequence)errorMessage)) {
            statisticData.setErrorMessage(errorMessage);
        }
        Iterator<Map.Entry<String, Object>> parametersIterator = parameters.entrySet().iterator();
        while (parametersIterator.hasNext()) {
            Map.Entry<String, Object> entry = parametersIterator.next();
            String key = entry.getKey();
            Object value = entry.getValue();
            if (!(value instanceof Wallet)) continue;
            Wallet wallet = (Wallet)value;
            parametersIterator.remove();
            String prefix = key.replace("wallet", "").replace("Wallet", "");
            if (StringUtils.isBlank((CharSequence)prefix)) {
                statisticData.addParameter("identityId", (Object)wallet.getTechnicalId());
                statisticData.addParameter("walletAddress", (Object)wallet.getAddress());
                continue;
            }
            String entryKey = prefix + StringUtils.capitalize((String)"identityId");
            statisticData.addParameter(entryKey, (Object)wallet.getTechnicalId());
            statisticData.addParameter(prefix + "WalletAddress", (Object)wallet.getAddress());
        }
        parameters.forEach((arg_0, arg_1) -> ((StatisticData)statisticData).addParameter(arg_0, arg_1));
        analyticsConsumer.accept(statisticData);
    }

    public static final String transformCapitalWithUnderscore(String string) {
        return string.replaceAll("([A-Z])", "_$1").toLowerCase();
    }

    protected static void addAnalyticsEntry(StatisticData statisticData) {
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }

    protected static void logStatistics(String string) {
        log.debug((Object)string);
    }
}

